/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing.policy;

import com.sun.xml.internal.bind.util.Which;
import com.sun.xml.internal.ws.addressing.W3CAddressingMetadataConstants;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.NestedPolicy;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

public class AddressingFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingFeatureConfigurator.class);
    private static final QName[] ADDRESSING_ASSERTIONS = new QName[]{new QName(AddressingVersion.MEMBER.policyNsUri, "UsingAddressing")};

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey policyMapKey, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(policyMapKey, policyMap);
        LinkedList<WebServiceFeature> linkedList = new LinkedList<WebServiceFeature>();
        if (policyMapKey != null && policyMap != null) {
            Policy policy = policyMap.getEndpointEffectivePolicy(policyMapKey);
            for (QName object : ADDRESSING_ASSERTIONS) {
                if (policy == null || !policy.contains(object)) continue;
                for (AssertionSet assertionSet : policy) {
                    for (Object object2 : assertionSet) {
                        if (!((PolicyAssertion)object2).getName().equals(object)) continue;
                        WebServiceFeature webServiceFeature = AddressingVersion.getFeature(object.getNamespaceURI(), true, !((PolicyAssertion)object2).isOptional());
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Added addressing feature \"" + webServiceFeature + "\" for element \"" + policyMapKey + "\"");
                        }
                        linkedList.add(webServiceFeature);
                    }
                }
            }
            if (policy != null && policy.contains(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION)) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion policyAssertion : assertionSet) {
                        Object object2;
                        if (!policyAssertion.getName().equals(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION)) continue;
                        NestedPolicy nestedPolicy = policyAssertion.getNestedPolicy();
                        boolean bl = false;
                        boolean bl2 = false;
                        if (nestedPolicy != null) {
                            bl = nestedPolicy.contains(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION);
                            bl2 = nestedPolicy.contains(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION);
                        }
                        if (bl && bl2) {
                            throw new WebServiceException("Only one among AnonymousResponses and NonAnonymousResponses can be nested in an Addressing assertion");
                        }
                        try {
                            object2 = bl ? new AddressingFeature(true, !policyAssertion.isOptional(), AddressingFeature.Responses.ANONYMOUS) : (bl2 ? new AddressingFeature(true, !policyAssertion.isOptional(), AddressingFeature.Responses.NON_ANONYMOUS) : new AddressingFeature(true, !policyAssertion.isOptional()));
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw LOGGER.logSevereException(new PolicyException(ModelerMessages.RUNTIME_MODELER_ADDRESSING_RESPONSES_NOSUCHMETHOD(AddressingFeatureConfigurator.toJar(Which.which(AddressingFeature.class))), noSuchMethodError));
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Added addressing feature \"" + object2 + "\" for element \"" + policyMapKey + "\"");
                        }
                        linkedList.add((WebServiceFeature)object2);
                    }
                }
            }
        }
        LOGGER.exiting(linkedList);
        return linkedList;
    }

    private static String toJar(String string) {
        if (!string.startsWith("jar:")) {
            return string;
        }
        string = string.substring(4);
        return string.substring(0, string.lastIndexOf(33));
    }
}

