/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.ResourceLoader;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.assembler.MetroConfigName;
import com.sun.xml.internal.ws.resources.TubelineassemblyMessages;
import com.sun.xml.internal.ws.runtime.config.MetroConfig;
import com.sun.xml.internal.ws.runtime.config.TubeFactoryList;
import com.sun.xml.internal.ws.runtime.config.TubelineDefinition;
import com.sun.xml.internal.ws.runtime.config.TubelineMapping;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.ws.WebServiceException;

class MetroConfigLoader {
    private static final Logger LOGGER = Logger.getLogger(MetroConfigLoader.class);
    private MetroConfigName defaultTubesConfigNames;
    private static final TubeFactoryListResolver ENDPOINT_SIDE_RESOLVER = new TubeFactoryListResolver(){

        @Override
        public TubeFactoryList getFactories(TubelineDefinition tubelineDefinition) {
            return tubelineDefinition != null ? tubelineDefinition.getEndpointSide() : null;
        }
    };
    private static final TubeFactoryListResolver CLIENT_SIDE_RESOLVER = new TubeFactoryListResolver(){

        @Override
        public TubeFactoryList getFactories(TubelineDefinition tubelineDefinition) {
            return tubelineDefinition != null ? tubelineDefinition.getClientSide() : null;
        }
    };
    private MetroConfig defaultConfig;
    private URL defaultConfigUrl;
    private MetroConfig appConfig;
    private URL appConfigUrl;

    MetroConfigLoader(Container container, MetroConfigName metroConfigName) {
        this.defaultTubesConfigNames = metroConfigName;
        ResourceLoader resourceLoader = null;
        if (container != null) {
            resourceLoader = container.getSPI(ResourceLoader.class);
        }
        this.init(container, resourceLoader, new MetroConfigUrlLoader(container));
    }

    private void init(Container container, ResourceLoader ... resourceLoaderArray) {
        MetroConfigName metroConfigName;
        String string = null;
        String string2 = null;
        if (container != null && (metroConfigName = container.getSPI(MetroConfigName.class)) != null) {
            string = metroConfigName.getAppFileName();
            string2 = metroConfigName.getDefaultFileName();
        }
        if (string == null) {
            string = this.defaultTubesConfigNames.getAppFileName();
        }
        if (string2 == null) {
            string2 = this.defaultTubesConfigNames.getDefaultFileName();
        }
        this.defaultConfigUrl = MetroConfigLoader.locateResource(string2, resourceLoaderArray);
        if (this.defaultConfigUrl == null) {
            throw LOGGER.logSevereException(new IllegalStateException(TubelineassemblyMessages.MASM_0001_DEFAULT_CFG_FILE_NOT_FOUND(string2)));
        }
        LOGGER.config(TubelineassemblyMessages.MASM_0002_DEFAULT_CFG_FILE_LOCATED(string2, this.defaultConfigUrl));
        this.defaultConfig = MetroConfigLoader.loadMetroConfig(this.defaultConfigUrl);
        if (this.defaultConfig == null) {
            throw LOGGER.logSevereException(new IllegalStateException(TubelineassemblyMessages.MASM_0003_DEFAULT_CFG_FILE_NOT_LOADED(string2)));
        }
        if (this.defaultConfig.getTubelines() == null) {
            throw LOGGER.logSevereException(new IllegalStateException(TubelineassemblyMessages.MASM_0004_NO_TUBELINES_SECTION_IN_DEFAULT_CFG_FILE(string2)));
        }
        if (this.defaultConfig.getTubelines().getDefault() == null) {
            throw LOGGER.logSevereException(new IllegalStateException(TubelineassemblyMessages.MASM_0005_NO_DEFAULT_TUBELINE_IN_DEFAULT_CFG_FILE(string2)));
        }
        this.appConfigUrl = MetroConfigLoader.locateResource(string, resourceLoaderArray);
        if (this.appConfigUrl != null) {
            LOGGER.config(TubelineassemblyMessages.MASM_0006_APP_CFG_FILE_LOCATED(this.appConfigUrl));
            this.appConfig = MetroConfigLoader.loadMetroConfig(this.appConfigUrl);
        } else {
            LOGGER.config(TubelineassemblyMessages.MASM_0007_APP_CFG_FILE_NOT_FOUND());
            this.appConfig = null;
        }
    }

    TubeFactoryList getEndpointSideTubeFactories(URI uRI) {
        return this.getTubeFactories(uRI, ENDPOINT_SIDE_RESOLVER);
    }

    TubeFactoryList getClientSideTubeFactories(URI uRI) {
        return this.getTubeFactories(uRI, CLIENT_SIDE_RESOLVER);
    }

    private TubeFactoryList getTubeFactories(URI uRI, TubeFactoryListResolver tubeFactoryListResolver) {
        TubeFactoryList tubeFactoryList;
        if (this.appConfig != null && this.appConfig.getTubelines() != null) {
            Object object = this.appConfig.getTubelines().getTubelineMappings().iterator();
            while (object.hasNext()) {
                TubelineMapping tubelineMapping = object.next();
                if (!tubelineMapping.getEndpointRef().equals(uRI.toString())) continue;
                tubeFactoryList = tubeFactoryListResolver.getFactories(this.getTubeline(this.appConfig, MetroConfigLoader.resolveReference(tubelineMapping.getTubelineRef())));
                if (tubeFactoryList == null) break;
                return tubeFactoryList;
            }
            if (this.appConfig.getTubelines().getDefault() != null && (object = tubeFactoryListResolver.getFactories(this.getTubeline(this.appConfig, MetroConfigLoader.resolveReference(this.appConfig.getTubelines().getDefault())))) != null) {
                return object;
            }
        }
        for (TubelineMapping tubelineMapping : this.defaultConfig.getTubelines().getTubelineMappings()) {
            if (!tubelineMapping.getEndpointRef().equals(uRI.toString())) continue;
            tubeFactoryList = tubeFactoryListResolver.getFactories(this.getTubeline(this.defaultConfig, MetroConfigLoader.resolveReference(tubelineMapping.getTubelineRef())));
            if (tubeFactoryList == null) break;
            return tubeFactoryList;
        }
        return tubeFactoryListResolver.getFactories(this.getTubeline(this.defaultConfig, MetroConfigLoader.resolveReference(this.defaultConfig.getTubelines().getDefault())));
    }

    TubelineDefinition getTubeline(MetroConfig metroConfig, URI uRI) {
        if (metroConfig != null && metroConfig.getTubelines() != null) {
            for (TubelineDefinition tubelineDefinition : metroConfig.getTubelines().getTubelineDefinitions()) {
                if (!tubelineDefinition.getName().equals(uRI.getFragment())) continue;
                return tubelineDefinition;
            }
        }
        return null;
    }

    private static URI resolveReference(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw LOGGER.logSevereException(new WebServiceException(TubelineassemblyMessages.MASM_0008_INVALID_URI_REFERENCE(string), uRISyntaxException));
        }
    }

    private static URL locateResource(String string, ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            return null;
        }
        try {
            return resourceLoader.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.severe(TubelineassemblyMessages.MASM_0009_CANNOT_FORM_VALID_URL(string), malformedURLException);
            return null;
        }
    }

    private static URL locateResource(String string, ResourceLoader[] resourceLoaderArray) {
        for (ResourceLoader resourceLoader : resourceLoaderArray) {
            URL uRL = MetroConfigLoader.locateResource(string, resourceLoader);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static MetroConfig loadMetroConfig(@NotNull URL uRL) {
        MetroConfig metroConfig = null;
        try {
            JAXBContext jAXBContext = MetroConfigLoader.createJAXBContext();
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            XMLInputFactory xMLInputFactory = XmlUtil.newXMLInputFactory(true);
            JAXBElement<MetroConfig> jAXBElement = unmarshaller.unmarshal(xMLInputFactory.createXMLStreamReader(uRL.openStream()), MetroConfig.class);
            metroConfig = jAXBElement.getValue();
        }
        catch (Exception exception) {
            LOGGER.warning(TubelineassemblyMessages.MASM_0010_ERROR_READING_CFG_FILE_FROM_LOCATION(uRL.toString()), exception);
        }
        return metroConfig;
    }

    private static JAXBContext createJAXBContext() throws Exception {
        if (MetroConfigLoader.isJDKInternal()) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws Exception {
                    return JAXBContext.newInstance(MetroConfig.class.getPackage().getName());
                }
            }, MetroConfigLoader.createSecurityContext());
        }
        return JAXBContext.newInstance(MetroConfig.class.getPackage().getName());
    }

    private static AccessControlContext createSecurityContext() {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.ws.runtime.config"));
        ((PermissionCollection)permissions).add(new ReflectPermission("suppressAccessChecks"));
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static boolean isJDKInternal() {
        return MetroConfigLoader.class.getName().startsWith("com.sun.xml.internal.ws");
    }

    private static class MetroConfigUrlLoader
    extends ResourceLoader {
        Container container;
        ResourceLoader parentLoader;

        MetroConfigUrlLoader(ResourceLoader resourceLoader) {
            this.parentLoader = resourceLoader;
        }

        MetroConfigUrlLoader(Container container) {
            this(container != null ? container.getSPI(ResourceLoader.class) : null);
            this.container = container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String string) throws MalformedURLException {
            LOGGER.entering(string);
            URL uRL = null;
            try {
                if (this.parentLoader != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(TubelineassemblyMessages.MASM_0011_LOADING_RESOURCE(string, this.parentLoader));
                    }
                    uRL = this.parentLoader.getResource(string);
                }
                if (uRL == null) {
                    uRL = MetroConfigUrlLoader.loadViaClassLoaders("com/sun/xml/internal/ws/assembler/" + string);
                }
                if (uRL == null && this.container != null) {
                    uRL = this.loadFromServletContext(string);
                }
                URL uRL2 = uRL;
                LOGGER.exiting(uRL);
                return uRL2;
            }
            catch (Throwable throwable) {
                LOGGER.exiting(uRL);
                throw throwable;
            }
        }

        private static URL loadViaClassLoaders(String string) {
            URL uRL = MetroConfigUrlLoader.tryLoadFromClassLoader(string, Thread.currentThread().getContextClassLoader());
            if (uRL == null && (uRL = MetroConfigUrlLoader.tryLoadFromClassLoader(string, MetroConfigLoader.class.getClassLoader())) == null) {
                return ClassLoader.getSystemResource(string);
            }
            return uRL;
        }

        private static URL tryLoadFromClassLoader(String string, ClassLoader classLoader) {
            return classLoader != null ? classLoader.getResource(string) : null;
        }

        private URL loadFromServletContext(String string) throws RuntimeException {
            block6: {
                Object object = null;
                try {
                    Class<?> clazz = Class.forName("javax.servlet.ServletContext");
                    object = this.container.getSPI(clazz);
                    if (object != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(TubelineassemblyMessages.MASM_0012_LOADING_VIA_SERVLET_CONTEXT(string, object));
                        }
                        try {
                            Method method = object.getClass().getMethod("getResource", String.class);
                            Object object2 = method.invoke(object, "/WEB-INF/" + string);
                            return (URL)URL.class.cast(object2);
                        }
                        catch (Exception exception) {
                            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0013_ERROR_INVOKING_SERVLET_CONTEXT_METHOD("getResource()")), exception);
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.fine(TubelineassemblyMessages.MASM_0014_UNABLE_TO_LOAD_CLASS("javax.servlet.ServletContext"));
                }
            }
            return null;
        }
    }

    private static interface TubeFactoryListResolver {
        public TubeFactoryList getFactories(TubelineDefinition var1);
    }
}

