/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Vector;

public class IniFile2 {
    protected Vector lines;
    protected Vector subjects;
    protected Vector variables;
    protected Vector values;
    protected String fileName;
    protected boolean saveOnChange = false;
    protected Vector checksub;
    protected Vector fastsubjects;

    public IniFile2(String string) {
        this(string, false);
    }

    public IniFile2(String string, boolean bl) {
        this.saveOnChange = bl;
        this.fileName = string;
        if (!new File(string).exists() && !this.createFile()) {
            return;
        }
        this.loadFile();
        this.initSubjects();
    }

    public void loadFile() {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        this.checksub = new Vector();
        this.fastsubjects = new Vector();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(this.fileName))));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.lines.addElement(string.trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IniFile2 load failed: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected boolean createFile() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fileName));
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("IniFile2 create failed: " + iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
    }

    protected void parseLines() {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < this.lines.size()) {
            string = (String)this.lines.elementAt(n);
            if (this.isaSubject(string)) {
                string2 = string.substring(1, string.length() - 1);
                this.subjects.addElement(string.substring(1, string.length() - 1));
                this.variables.addElement(new Vector());
                this.values.addElement(new Vector());
            } else if (this.isanAssignment(string)) {
                String string3 = string;
                this.addAssignment(string2, string3);
            }
            ++n;
        }
    }

    protected void parseSubs(String string) {
        block8: {
            try {
                if (this.checksub.contains(string)) break block8;
                String string2 = "";
                this.checksub.addElement(string);
                String string3 = null;
                String string4 = null;
                boolean bl = false;
                int n = 0;
                while (n < this.lines.size()) {
                    string3 = (String)this.lines.elementAt(n);
                    if (this.isaSubject(string3)) {
                        string4 = string3.substring(1, string3.length() - 1);
                        if (string4.equals(string)) {
                            bl = true;
                            string2 = string;
                        } else {
                            if (string2.equals(string)) break;
                            bl = false;
                        }
                    } else if (this.isanAssignment(string3) && bl) {
                        String string5 = string3;
                        this.addAssignment(string4, string5);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Error in IniFile2 " + exception.toString());
            }
        }
    }

    protected void initSubjects() {
        String string = null;
        int n = 0;
        while (n < this.lines.size()) {
            string = (String)this.lines.elementAt(n);
            if (this.isaSubject(string)) {
                this.fastsubjects.addElement(string.substring(1, string.length() - 1));
            }
            ++n;
        }
    }

    protected boolean addAssignment(String string, String string2) {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        if (string4.length() == 0 || string3.length() == 0) {
            return false;
        }
        return this.addValue(string, string3, string4, true);
    }

    public boolean setValue(String string, String string2, String string3) {
        this.parseSubs(string);
        boolean bl = this.addValue(string, string2, string3, true);
        return bl;
    }

    protected boolean addValue(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(string)) {
            this.subjects.addElement(string);
            this.fastsubjects.addElement(string);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int n = this.subjects.indexOf(string);
        Vector vector = (Vector)this.variables.elementAt(n);
        Vector vector2 = (Vector)this.values.elementAt(n);
        if (!vector.contains(string2)) {
            vector.addElement(string2);
            vector2.addElement(string3);
        }
        int n2 = vector.indexOf(string2);
        vector2.setElementAt(string3, n2);
        if (bl) {
            this.setLine(string, string2, string3);
        }
        return true;
    }

    protected boolean isaSubject(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    protected void setLine(String string, String string2, String string3) {
        int n;
        int n2;
        int n3 = this.findSubjectLine(string);
        if (n3 == -1) {
            this.addSubjectLine(string);
            n3 = this.lines.size() - 1;
        }
        if ((n2 = this.findAssignmentBetween(string2, n3, n = this.endOfSubject(n3))) == -1) {
            this.lines.insertElementAt(string2 + "=" + string3, n);
        } else {
            this.lines.setElementAt(string2 + "=" + string3, n2);
        }
    }

    protected int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (((String)this.lines.elementAt(n3)).startsWith(string + "=")) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void addSubjectLine(String string) {
        this.lines.addElement("[" + string + "]");
    }

    protected int findSubjectLine(String string) {
        String string2 = "[" + string + "]";
        int n = 0;
        while (n < this.lines.size()) {
            String string3 = (String)this.lines.elementAt(n);
            if (string2.equals(string3)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this.lines.size()) {
            return this.lines.size();
        }
        int n3 = n + 1;
        while (n3 < this.lines.size()) {
            if (this.isanAssignment((String)this.lines.elementAt(n3))) {
                n2 = n3 + 1;
            }
            if (this.isaSubject((String)this.lines.elementAt(n3))) {
                return n2;
            }
            ++n3;
        }
        return n2;
    }

    protected boolean isanAssignment(String string) {
        return string.indexOf("=") != -1 && !string.startsWith(";");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String string) {
        this.parseSubs(string);
        int n = this.subjects.indexOf(string);
        if (n != -1) {
            Vector vector = (Vector)this.variables.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this.fastsubjects.size()];
        this.fastsubjects.copyInto(objectArray);
        return objectArray;
    }

    public String getValue(String string, String string2) {
        this.parseSubs(string);
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return "";
        }
        Vector vector = (Vector)this.values.elementAt(n);
        Vector vector2 = (Vector)this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            return (String)vector.elementAt(n2);
        }
        return "";
    }

    public void deleteValue(String string, String string2) {
        this.parseSubs(string);
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        Vector vector = (Vector)this.values.elementAt(n);
        Vector vector2 = (Vector)this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            vector.removeElementAt(n2);
            vector2.removeElementAt(n2);
            int n3 = this.findAssignmentLine(string, string2);
            if (n3 != -1) {
                this.lines.removeElementAt(n3);
            }
            if (vector2.size() == 0) {
                this.deleteSubject(string);
            }
        }
    }

    public void deleteSubject(String string) {
        this.parseSubs(string);
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this.values.removeElementAt(n);
        this.variables.removeElementAt(n);
        this.subjects.removeElementAt(n);
        this.fastsubjects.removeElement(string);
        this.checksub.removeElement(string);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        int n4 = n2;
        while (n4 < n3) {
            this.lines.removeElementAt(n2);
            ++n4;
        }
    }

    public void sortSubjects() {
        String[] stringArray = this.getSubjects();
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement("[" + stringArray[n] + "]");
            String[] stringArray2 = this.getLinesUnderSubject(stringArray[n]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                vector.addElement(stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
        this.lines = vector;
    }

    public void sortEntriesUnderSubject(String string) {
        Vector vector = new Vector();
        int n = this.lines.size();
        int n2 = this.findSubjectLine(string);
        if (n2 == -1) {
            return;
        }
        int n3 = this.endOfSubject(n2);
        Object[] objectArray = this.lines.toArray();
        String string2 = ((String)this.lines.elementAt(n2 + 1)).toUpperCase();
        n2 = string2.indexOf("FORMAT") != -1 ? (n2 += 2) : ++n2;
        Arrays.sort(objectArray, n2, n3);
        this.lines.removeAllElements();
        int n4 = 0;
        while (n4 < objectArray.length) {
            this.lines.addElement(objectArray[n4]);
            ++n4;
        }
    }

    public String[] getLinesUnderSubject(String string) {
        if (this.lines == null) {
            return null;
        }
        int n = this.findSubjectLine(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.endOfSubject(n);
        int n3 = n2 - n - 1;
        String[] stringArray = new String[n3];
        int n4 = 0;
        int n5 = n + 1;
        while (n5 < n2) {
            stringArray[n4] = (String)this.lines.elementAt(n5);
            ++n4;
            ++n5;
        }
        return stringArray;
    }

    public void saveFile() {
        if (!this.saveOnChange) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
            int n = 0;
            while (n < this.lines.size()) {
                dataOutputStream.writeBytes((String)this.lines.elementAt(n) + System.getProperty("line.separator"));
                ++n;
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IniFile2 save failed: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("IniFile2 <filename>");
            System.exit(0);
        } else {
            IniFile2 iniFile2 = new IniFile2(stringArray[0]);
            String[] stringArray2 = iniFile2.getSubjects();
            int n = 0;
            while (n < stringArray2.length) {
                System.out.println(stringArray2[n]);
                String[] stringArray3 = iniFile2.getVariables(stringArray2[n]);
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    System.out.println("  " + stringArray3[n2] + " = " + iniFile2.getValue(stringArray2[n], stringArray3[n2]));
                    ++n2;
                }
                ++n;
            }
        }
    }
}

