/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class CitrixProfileMgmt {
    public static String syncString = new String("CitrixProfileMgmt");
    private static CitrixProfileMgmt citrixProfileMgmtObj = null;
    private static String object = "Citrix Profile Management";
    private static String[] counters = new String[]{"Logon Duration", "Logon Bytes", "Logoff Duration", "Logoff Bytes", "Local Profile Setup Duration", "Delete Local Profile Duration", "Processed Logon Files \u2013 Under 1KB", "Processed Logoff Files \u2013 Under 1KB", "Processed Logon Files \u2013 1KB to 10KB", "Processed Logoff Files \u2013 1KB to 10KB", "Processed Logon Files \u2013 10KB to 100KB", "Processed Logoff Files \u2013 10KB to 100KB", "Processed Logon Files \u2013 100KB to 1MB", "Processed Logoff Files \u2013 100KB to 1MB", "Processed Logon Files \u2013 1MB to 5MB", "Processed Logoff Files \u2013 1MB to 5MB", "Processed Logon Files \u2013 Above 5MB", "Processed Logoff Files \u2013 Above 5MB"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private String[] instances = null;
    private double[][] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();

    private CitrixProfileMgmt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CitrixProfileMgmt getInstance() {
        if (citrixProfileMgmtObj == null) {
            String string = syncString;
            synchronized (string) {
                if (citrixProfileMgmtObj == null) {
                    citrixProfileMgmtObj = new CitrixProfileMgmt();
                }
            }
        }
        return citrixProfileMgmtObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCitrixProfileMgmtData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            this.instances = EgPerfInstrumentation.discoverInstances(object);
            if (this.instances == null || this.instances.length == 0) {
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, this.instances, counters);
            if (this.values == null || this.values.length == 0) {
                this.stopTest();
                this.instances = null;
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            int n = this.instances.length;
            for (int i = 0; i < n; ++i) {
                String string2 = this.instances[i] + "=" + this.values[i][0] + "#" + this.values[i][1] + "#" + this.values[i][2] + "#" + this.values[i][3] + "#" + this.values[i][4] + "#" + this.values[i][5] + "#" + this.values[i][6] + "#" + this.values[i][7] + "#" + this.values[i][8] + "#" + this.values[i][9] + "#" + this.values[i][10] + "#" + this.values[i][11] + "#" + this.values[i][12] + "#" + this.values[i][13] + "#" + this.values[i][14] + "#" + this.values[i][15] + "#" + this.values[i][16] + "#" + this.values[i][17];
                this.outList.add(string2);
            }
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        CitrixProfileMgmt citrixProfileMgmt = CitrixProfileMgmt.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = citrixProfileMgmt.getCitrixProfileMgmtData();
        System.out.println(object);
    }
}

