/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CitrixTeamsInfo {
    private final WbemcliUtil.WmiQuery<Citrix_VirtualChannel_Webrtc_Enum> webRTCQuery = new WbemcliUtil.WmiQuery("Citrix_VirtualChannel_Webrtc_Enum", Citrix_VirtualChannel_Webrtc_Enum.class);
    private WmiQueryHandler wmiQueryHandler;

    public ArrayList getCitrixTeamsInfo() {
        this.wmiQueryHandler = new WmiQueryHandler();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getTeamsInfo();
        if (string == null || string.trim().length() == 0) {
            string = "DisplayVersion:";
            arrayList.add(string);
            return arrayList;
        }
        string = "DisplayVersion:" + string;
        arrayList.add(string);
        if (this.isMSMediaEngineEnabled()) {
            arrayList.add("MediaEngine:Enabled");
        } else {
            arrayList.add("MediaEngine:Disabled");
        }
        try {
            String string2 = "Root\\Citrix\\HDX";
            WbemcliUtil.WmiResult<Citrix_VirtualChannel_Webrtc_Enum> wmiResult = this.wmiQueryHandler.queryWMI(string2, this.webRTCQuery);
            if (wmiResult == null) {
                return arrayList;
            }
            int n = wmiResult.getResultCount();
            if (n == 0) {
                return arrayList;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = WmiQueryHandler.getInt(wmiResult, Citrix_VirtualChannel_Webrtc_Enum.SessionID, i);
                String string3 = WmiQueryHandler.getString(wmiResult, Citrix_VirtualChannel_Webrtc_Enum.Component_VersionTypescript, i);
                String string4 = "WebRTCSessions:" + n2 + ";" + string3;
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private String getTeamsInfo() {
        String string = "";
        String string2 = "SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{731F6BAA-A986-45A4-8936-7C3AAAAA760B}";
        String string3 = "DisplayVersion";
        try {
            String string4 = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)string2, (String)string3);
            if (string4 != null && string4.trim().length() > 0) {
                string = string4.trim();
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    private boolean isMSMediaEngineEnabled() {
        boolean bl = false;
        try {
            String string = "netstat -an | find \"9002\"";
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() < 2) {
                return bl;
            }
            if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
                return bl;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer;
                int n2;
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.trim().length() == 0 || (n2 = (stringTokenizer = new StringTokenizer(string2 = string2.trim())).countTokens()) < 4) continue;
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                if (!string3.startsWith("TCP") || !string5.equalsIgnoreCase("127.0.0.1:9002")) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        CitrixTeamsInfo citrixTeamsInfo = new CitrixTeamsInfo();
        System.out.println("WebRTC " + citrixTeamsInfo.getCitrixTeamsInfo());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Citrix_VirtualChannel_Webrtc_Enum {
        SessionID,
        Component_VersionTypescript;

    }
}

