Set args= WScript.Arguments
If args.Count=0 Then
	strComputer = "."
Else
	strComputer = args(0)
End If

Set objWMIService = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Set colOperatingSystems = objWMIService.ExecQuery _
    ("Select * from Win32_OperatingSystem")

For Each objOperatingSystem in colOperatingSystems
	Wscript.Echo "Caption: " & CheckName(objOperatingSystem.Caption)
    Wscript.Echo "Name: " & CheckName(objOperatingSystem.Name)
    WScript.Echo "CSDVersion: " & CheckNull(objOperatingSystem.CSDVersion)
    Wscript.Echo "Registered User: " & CheckNull(objOperatingSystem.RegisteredUser)
    Wscript.Echo "Version: " & CheckNull(objOperatingSystem.Version)
    WScript.Echo "TotalVisibleMemorySize: " & CheckNull(objOperatingSystem.TotalVisibleMemorySize) & " KB"
    WScript.Echo "InstallDate: " & CheckNull(WMIDateStringToDate(objOperatingSystem.InstallDate))
    WScript.Echo "ServicePackMajorVersion: " & CheckNull(objOperatingSystem.ServicePackMajorVersion)
    WScript.Echo "ServicePackMinorVersion: " & CheckNull(objOperatingSystem.ServicePackMinorVersion)
    WScript.Echo "SystemDirectory: " & CheckNull(objOperatingSystem.SystemDirectory)
    WScript.Echo "WindowsDirectory: " & CheckNull(objOperatingSystem.WindowsDirectory)
    Wscript.Echo "Serial Number: " & CheckNull(objOperatingSystem.SerialNumber)
    
    'GetOsLanguage(objOperatingSystem.OSLanguage)
Next

Set ProcessorsObj = objWMIService.ExecQuery _
    ("Select * from Win32_Processor")
NoOfCores = 0
Architecture = ""
For Each ProcessorObj in ProcessorsObj
	NoOfCores = NoOfCores + ProcessorObj.NumberOfCores
	Architecture = CheckNull(ProcessorObj.Architecture)
Next
Wscript.Echo "NumberOfCores: " & NoOfCores
Wscript.Echo "Architecture: " & Architecture

Set ProcessorsObj = objWMIService.ExecQuery _
    ("Select * from Win32_ComputerSystem")
For Each ProcessorObj in ProcessorsObj
    Wscript.Echo "NumberOfLogicalProcessors: " & CheckNull(ProcessorObj.NumberOfLogicalProcessors)
Next

if Err.Number <> 0 then
	WScript.Echo "#Error#" 
else	
	WScript.Echo "#EG_SCRIPT_DONE#"
end if

Function WMIDateStringToDate(dtmDate)
WScript.Echo dtm: 
	WMIDateStringToDate = CDate(Mid(dtmDate, 5, 2) & "/" & _
	Mid(dtmDate, 7, 2) & "/" & Left(dtmDate, 4) _
	& " " & Mid (dtmDate, 9, 2) & ":" & Mid(dtmDate, 11, 2) & ":" & Mid(dtmDate,13, 2))
End Function


Function GetOsLanguage (ByVal val) 
    Select Case (val)
	Case 0		:WScript.Echo "Os Language:  Language Neutral"
	Case 1024 	:WScript.Echo "Os Language:  Process or User Default Language"
	Case 2048	:WScript.Echo "Os Language:  System Default Language" 
	Case 1078	:WScript.Echo "Os Language:  Afrikaans" 
	Case 1052	:WScript.Echo "Os Language:  Albanian" 
	Case 1025	:WScript.Echo "Os Language:  Arabic (Saudi Arabia)"
	Case 2049	:WScript.Echo "Os Language:  Arabic (Iraq)" 
	Case 3073	:WScript.Echo "Os Language:  Arabic (Egypt)"
	Case 4097	:WScript.Echo "Os Language:  Arabic (Libya)" 
	Case 5121	:WScript.Echo "Os Language:  Arabic (Algeria)"
	Case 6145	:WScript.Echo "Os Language:  Arabic (Morocco)" 
	Case 7169	:WScript.Echo "Os Language:  Arabic (Tunisia)" 
	Case 8193	:WScript.Echo "Os Language:  Arabic (Oman)" 
	Case 9217	:WScript.Echo "Os Language:  Arabic (Yemen)" 
	Case 10241	:WScript.Echo "Os Language:  Arabic (Syria)" 
	Case 11265	:WScript.Echo "Os Language:  Arabic (Jordan)" 
	Case 12289	:WScript.Echo "Os Language:  Arabic (Lebanon)" 
	Case 13313	:WScript.Echo "Os Language:  Arabic (Kuwait)" 
	Case 14337	:WScript.Echo "Os Language:  Arabic (U.A.E.)" 
	Case 15361	:WScript.Echo "Os Language:  Arabic (Bahrain)" 
	Case 16385	:WScript.Echo "Os Language:  Arabic (Qatar)" 
	Case 1067	:WScript.Echo "Os Language:  Windows 2000/XP: Armenian. This is Unicode only." 
	Case 1068	:WScript.Echo "Os Language:  Azeri (Latin)" 
	Case 2092	:WScript.Echo "Os Language:  Azeri (Cyrillic)" 
	Case 1069	:WScript.Echo "Os Language:  Basque" 
	Case 1059	:WScript.Echo "Os Language:  Belarusian" 
	Case 1026	:WScript.Echo "Os Language:  Bulgarian" 
	Case 1109	:WScript.Echo "Os Language:  Burmese" 
	Case 1027	:WScript.Echo "Os Language:  Catalan" 
	Case 1028	:WScript.Echo "Os Language:  Chinese (Taiwan)" 
	Case 2052	:WScript.Echo "Os Language:  Chinese (PRC)" 
	Case 3076	:WScript.Echo "Os Language:  Chinese (Hong Kong SAR, PRC)"
	Case 4100	:WScript.Echo "Os Language:  Chinese (Singapore)" 
	Case 5124	:WScript.Echo "Os Language:  Windows 98/Me, Windows 2000/XP: Chinese (Macau SAR)" 
	Case 1050	:WScript.Echo "Os Language:  Croatian" 
	Case 1029	:WScript.Echo "Os Language:  Czech" 
	Case 1030	:WScript.Echo "Os Language:  Danish" 
	Case 1125	:WScript.Echo "Os Language:  Windows XP: Divehi. This is Unicode only." 
	Case 1043	:WScript.Echo "Os Language:  Dutch (Netherlands)" 
	Case 2067	:WScript.Echo "Os Language:  Dutch (Belgium)"
	Case 1033	:WScript.Echo "Os Language:  English (United States)" 
	Case 2057	:WScript.Echo "Os Language:  English (United Kingdom)" 
	Case 3081	:WScript.Echo "Os Language:  English (Australian)" 
	Case 4105	:WScript.Echo "Os Language:  English (Canadian)" 
	Case 5129	:WScript.Echo "Os Language:  English (New Zealand)" 
	Case 6153	:WScript.Echo "Os Language:  English (Ireland)" 
	Case 7177	:WScript.Echo "Os Language:  English (South Africa)"
	Case 8201	:WScript.Echo "Os Language:  English (Jamaica)" 
	Case 9225	:WScript.Echo "Os Language:  English (Caribbean)" 
	Case 10249	:WScript.Echo "Os Language:  English (Belize)" 
	Case 11273	:WScript.Echo "Os Language:  English (Trinidad)" 
	Case 12297	:WScript.Echo "Os Language:  Windows 98/Me, Windows 2000/XP: English (Zimbabwe)" 
	Case 13321	:WScript.Echo "Os Language:  Windows 98/Me, Windows 2000/XP: English (Philippines)" 
	Case 1061	:WScript.Echo "Os Language:  Estonian" 
	Case 1080	:WScript.Echo "Os Language:  Faeroese" 
	Case 1065	:WScript.Echo "Os Language:  Farsi" 
	Case 1035	:WScript.Echo "Os Language:  Finnish"
	Case 1036	:WScript.Echo "Os Language:  French (Standard)" 
	Case 2060	:WScript.Echo "Os Language:  French (Belgian)" 
	Case 3084	:WScript.Echo "Os Language:  French (Canadian)" 
	Case 4108	:WScript.Echo "Os Language:  French (Switzerland)" 
	Case 5132	:WScript.Echo "Os Language:  French (Luxembourg)" 
	Case 6156	:WScript.Echo "Os Language:  Windows 98/Me, Windows 2000/XP: French (Monaco)" 
	Case 1110	:WScript.Echo "Os Language:  Windows XP: Galician" 
	Case 1079	:WScript.Echo "Os Language:  Windows 2000/XP: Georgian. This is Unicode only." 
	Case 1031	:WScript.Echo "Os Language:  German (Standard)"
	Case 2055	:WScript.Echo "Os Language:  German (Switzerland)"
	Case 3079	:WScript.Echo "Os Language:  German (Austria)" 
	Case 4103	:WScript.Echo "Os Language:  German (Luxembourg)" 
	Case 5127	:WScript.Echo "Os Language:  German (Liechtenstein)"
	Case 1032	:WScript.Echo "Os Language:  Greek" 
	Case 1095	:WScript.Echo "Os Language:  Windows XP: Gujarati. This is Unicode only." 
	Case 1037	:WScript.Echo "Os Language:  Hebrew" 
	Case 1081	:WScript.Echo "Os Language:  Windows 2000/XP: Hindi. This is Unicode only." 
	Case 1038	:WScript.Echo "Os Language:  Hungarian" 
	Case 1039	:WScript.Echo "Os Language:  Icelandic" 
	Case 1057	:WScript.Echo "Os Language:  Indonesian" 
	Case 1040	:WScript.Echo "Os Language:  Italian (Standard)" 
	Case 2064	:WScript.Echo "Os Language:  Italian (Switzerland)" 
	Case 1041	:WScript.Echo "Os Language:  Japanese" 
	Case 1099	:WScript.Echo "Os Language:  Windows XP: Kannada. This is Unicode only." 
	Case 1111	:WScript.Echo "Os Language:  Windows 2000/XP: Konkani. This is Unicode only." 
	Case 1042	:WScript.Echo "Os Language:  Korean" 
	Case 2066	:WScript.Echo "Os Language:  Windows 95, Windows NT 4.0 only: Korean (Johab)" 
	Case 1088	:WScript.Echo "Os Language:  Windows XP: Kyrgyz." 
	Case 1062	:WScript.Echo "Os Language:  Latvian" 
	Case 1063	:WScript.Echo "Os Language:  Lithuanian" 
	Case 2087	:WScript.Echo "Os Language:  Windows 98 only: Lithuanian (Classic)" 
	Case 1071	:WScript.Echo "Os Language:  FYRO Macedonian" 
	Case 1086	:WScript.Echo "Os Language:  Malay (Malaysian)" 
	Case 2110	:WScript.Echo "Os Language:  Malay (Brunei Darussalam)" 
	Case 1102	:WScript.Echo "Os Language:  Windows 2000/XP: Marathi. This is Unicode only." 
	Case 1104	:WScript.Echo "Os Language:  Windows XP: Mongolian" 
	Case 1044	:WScript.Echo "Os Language:  Norwegian (Bokmal)" 
	Case 2068	:WScript.Echo "Os Language:  Norwegian (Nynorsk)" 
	Case 1045	:WScript.Echo "Os Language:  Polish" 
	Case 1046	:WScript.Echo "Os Language:  Portuguese (Brazil)" 
	Case 2070	:WScript.Echo "Os Language:  Portuguese (Portugal)"
	Case 1094	:WScript.Echo "Os Language:  Windows XP: Punjabi. This is Unicode only." 
	Case 1048	:WScript.Echo "Os Language:  Romanian" 
	Case 1049	:WScript.Echo "Os Language:  Russian" 
	Case 1103	:WScript.Echo "Os Language:  Windows 2000/XP: Sanskrit. This is Unicode only." 
	Case 3098	:WScript.Echo "Os Language:  Serbian (Cyrillic)" 
	Case 2074	:WScript.Echo "Os Language:  Serbian (Latin)" 
	Case 1051	:WScript.Echo "Os Language:  Slovak" 
	Case 1060	:WScript.Echo "Os Language:  Slovenian" 
	Case 1034	:WScript.Echo "Os Language:  Spanish (Spain, Traditional Sort)" 
	Case 2058	:WScript.Echo "Os Language:  Spanish (Mexican)" 
	Case 3082	:WScript.Echo "Os Language:  Spanish (Spain, Modern Sort)" 
	Case 4106	:WScript.Echo "Os Language:  Spanish (Guatemala)" 
	Case 5130	:WScript.Echo "Os Language:  Spanish (Costa Rica)" 
	Case 6154	:WScript.Echo "Os Language:  Spanish (Panama)" 
	Case 7178	:WScript.Echo "Os Language:  Spanish (Dominican Republic)" 
	Case 8202	:WScript.Echo "Os Language:  Spanish (Venezuela)" 
	Case 9226	:WScript.Echo "Os Language:  Spanish (Colombia)" 
	Case 10250	:WScript.Echo "Os Language:  Spanish (Peru)" 
	Case 11274	:WScript.Echo "Os Language:  Spanish (Argentina)" 
	Case 12298	:WScript.Echo "Os Language:  Spanish (Ecuador)" 
	Case 13322	:WScript.Echo "Os Language:  Spanish (Chile)" 
	Case 14346	:WScript.Echo "Os Language:  Spanish (Uruguay)" 
	Case 15370	:WScript.Echo "Os Language:  Spanish (Paraguay)" 
	Case 16394	:WScript.Echo "Os Language:  Spanish (Bolivia)" 
	Case 17418	:WScript.Echo "Os Language:  Spanish (El Salvador)" 
	Case 18442	:WScript.Echo "Os Language:  Spanish (Honduras)" 
	Case 19466	:WScript.Echo "Os Language:  Spanish (Nicaragua)" 
	Case 20490	:WScript.Echo "Os Language:  Spanish (Puerto Rico)" 
	Case 1072	:WScript.Echo "Os Language:  Sutu" 
	Case 1089	:WScript.Echo "Os Language:  Swahili (Kenya)" 
	Case 1053	:WScript.Echo "Os Language:  Swedish" 
	Case 2077	:WScript.Echo "Os Language:  Swedish (Finland)" 
	Case 1114	:WScript.Echo "Os Language:  Windows XP: Syriac. This is Unicode only." 
	Case 1097	:WScript.Echo "Os Language:  Windows 2000/XP: Tamil. This is Unicode only."
	Case 1092	:WScript.Echo "Os Language:  Tatar (Tatarstan)" 
	Case 1098	:WScript.Echo "Os Language:  Windows XP: Telugu. This is Unicode only." 
	Case 1054	:WScript.Echo "Os Language:  Thai" 
	Case 1055	:WScript.Echo "Os Language:  Turkish" 
	Case 1058	:WScript.Echo "Os Language:  Ukrainian" 
	Case 1056 	:WScript.Echo "Os Language:  Windows 98/Me, Windows 2000/XP: Urdu (Pakistan)" 
	Case 2080 	:WScript.Echo "Os Language:  Urdu (India)" 
	Case 1091  	:WScript.Echo "Os Language:  Uzbek (Latin)" 
	Case 2115 	:WScript.Echo "Os Language:  Uzbek (Cyrillic)" 
	Case 1066  	:WScript.Echo "Os Language:  Windows 98/Me, Windows NT 4.0 and later: Vietnamese" 
    End Select
    'GetOsLanguage="Return_String"
End Function
Function CheckNull(value)
	If(IsNull(value) or IsEmpty(value) or value="")  then
		CheckNull="-"
	Else
		CheckNull=value
	End If
	value=""
End Function

Function CheckName(value)
If(IsNull(value) or IsEmpty(value) or value="" or value="-")  then
		CheckName="-"
	Else
		CheckName=value
end if
	value=""
End Function


'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLNCfu+j6Kss
'' SIG '' HCWdfvJeSaoS6dyvoIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBSfiGd8vEQ+meTFo0Yvbt0SvSZFHzAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgBdgHxSFeyHNgbgPdN0xp1z
'' SIG '' G0UPa2Y0h2fGmcIeAyX2q1bSNT6MTuKoXVZ+X8C81jF9
'' SIG '' 22z3iA6RO1UzxFN3zzOuB/c/Z80o/xUtP3QlCAblNO0V
'' SIG '' MWu7LZSGSpJyYMxwttSciF5qgxv4nQ17gV1brm4nF+QD
'' SIG '' YdUllSp9X/hWSJF2byRGxCdNSB95Hp74+aDzWap/V4mX
'' SIG '' 70L6/YVaLZ64Gr37ds3e2Gg1WL5HZeKXKYXHBxePfXCE
'' SIG '' +NAG9rdzLhPAwJ97uT9WQXZxdk42Dv/Kj9XHwxcE3akk
'' SIG '' 5Lkj+2PxtlzOVU1s8tU+JaTDxVsOeWefnUjcrPSIXTw1
'' SIG '' JVkVYKEAEFl/rC4BHrYp201n73BozoQdRiWVZqEYzD5i
'' SIG '' VxE4lufeplg+3YHyuOtub32u9FZ44EbnqK3N1qPDPQpB
'' SIG '' 0oxRhFwKrjMYfero/E8Q2m9/b9e6scTlIxRX7u36pLV5
'' SIG '' lnfnLJaVLqrsN5Xm7POK8ujWTacB+C7n/wWdFZAnSQ28
'' SIG '' Sybml/Y+Jalq9duefGhcXVVP3JSm73yhDPzv9iKs8x00
'' SIG '' YMAF3xcy3qIpWeucAUEDRN2lGrbmSU4Q+J84F7sjyhLk
'' SIG '' nhpM5wXX4jjxtSV2RDRMwzbvGOwViwOj3S09hYME116K
'' SIG '' jyL6UAvdsszEkJx1HHQkOLdsqOQkm0KHw+MrNce0/bU6
'' SIG '' VKGCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMTQwOTAwMTJaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCBR8uGgyx88ev8qAhYrriYYwhkUz1NW
'' SIG '' XLbtqVgqV04N6DANBgkqhkiG9w0BAQEFAASCAgB/rbrd
'' SIG '' wjWXvp10r8mz1+v0nQtbkuqyd3uZAwf06tHJhzoREW/O
'' SIG '' 5KhRbAyO8WGglhrXn3IrwP4/CFPG5Zg3w83GQKM3/zpz
'' SIG '' d0upM1K9a4IUKzuoqj97qS13xlsxMfK0VuUFAdDO8JGK
'' SIG '' S0ZlA1159LaLpNrHp6oFJ5SiRNYCLPX58eh+Kq327Wkr
'' SIG '' XqwDHVzpCGIBp+tOUYgdDTXWXkK8NT0mtlfaXyuJFafD
'' SIG '' S0zIzFxR1vy53FQQ300kuaD99QOcypJmgdE2+MWTXi5X
'' SIG '' LB7sFuyFAznvGDjm9fAhJjhB0vV9cx1+CR5zAbbuVbVt
'' SIG '' XhjJrrlFrAOVnNjyoL0a+b5l4j7N8Wqyto6sCM4K/aqH
'' SIG '' qeGMrevDtaWnmi9o9tPVRWjBeLLFlFO7P0CRYoyOApoW
'' SIG '' WTRlHUnW5T7HECoCycwnst97SVRsTDNgo7oD0fLOBL+C
'' SIG '' W6h4T1OHA/f8i9v98RWqldYgbBRzqQxEx7uj/AlJMcIa
'' SIG '' WDBNTiMqzr9HBhLsRrUNIX95EdRMVmbhhUNtElitXhsA
'' SIG '' 0wN30zS2cXQXvuAbsW3VtINchCFHn7LbgPCS9yKbEcmc
'' SIG '' 6DKuVCs+dO9/PC+jLbPSRLDKE/IdAiWlB09OASlwsFNL
'' SIG '' g6qXegOR3np1HhX1Ubuoze/oeOfEbsa36tdKDtKQ90S9
'' SIG '' unGH150LLb24QZk5FQ==
'' SIG '' End signature block
