/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class JvmHelperThread
extends Thread {
    private String entity;
    private Hashtable result;
    private boolean done = false;
    private boolean status = false;
    private int statusCode = 0;
    private String urlStr;
    private String userName;
    private String password;
    private String serverType = "";
    private Object testObject;
    private double leakPercentageLimit;
    private long startTime = -1L;
    private String jvmPID = null;
    private boolean isIBM = false;
    private boolean isAMH = false;

    public JvmHelperThread(String string, Object object, String string2, String string3, String string4) {
        this.entity = string;
        this.testObject = object;
        this.urlStr = string2;
        this.userName = string3;
        this.password = string4;
        this.setName("JvmHelperThread-" + string);
        this.setDaemon(true);
        this.start();
    }

    public JvmHelperThread(String string, Object object, String string2, String string3, String string4, double d) {
        this.entity = string;
        this.testObject = object;
        this.urlStr = string2;
        this.userName = string3;
        this.password = string4;
        this.leakPercentageLimit = d;
        this.setDaemon(true);
        this.setName("JvmHelperThread-" + string);
        this.start();
    }

    public JvmHelperThread(String string, Object object, String string2, String string3, String string4, boolean bl) {
        this.entity = string;
        this.testObject = object;
        this.urlStr = string2;
        this.userName = string3;
        this.password = string4;
        this.isAMH = bl;
        this.setDaemon(true);
        this.setName("JvmHelperThread-" + string);
        this.start();
    }

    public JvmHelperThread(String string, Object object, String string2, String string3, String string4, String string5) {
        this.entity = string;
        this.testObject = object;
        this.urlStr = string2;
        this.userName = string3;
        this.password = string4;
        this.serverType = string5;
        this.leakPercentageLimit = this.leakPercentageLimit;
        this.setDaemon(true);
        this.setName("JvmHelperThread-" + string);
        this.start();
    }

    public Hashtable getResult() {
        return this.result;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.entity == null) {
            return;
        }
        this.result = new Hashtable();
        JVMInstrumentation jVMInstrumentation = (JVMInstrumentation)((Object)this.testObject);
        try {
            if (this.isAMH) {
                AMHBase aMHBase = (AMHBase)((Object)this.testObject);
                if (jVMInstrumentation.connectToJVM(this.urlStr, this.userName, this.password)) {
                    if (this.entity.equals("AMHJMSConnTest")) {
                        this.result = aMHBase.pullJmsConnectionDetails();
                    } else if (this.entity.equals("AMHCrySvcTest")) {
                        this.result = aMHBase.pullCryptoServiceDetails();
                    } else if (this.entity.equals("AMHFileSvcTest")) {
                        this.result = aMHBase.pullFileServiceDetails();
                    } else if (this.entity.equals("AMHInpChnsTest")) {
                        this.result = aMHBase.pullInputChannelDetails();
                    } else if (this.entity.equals("AMHJMSQTest")) {
                        this.result = aMHBase.pullJMSQueueDetails();
                    } else if (this.entity.equals("AMHJMSSvcTest")) {
                        this.result = aMHBase.pullJMSServiceDetails();
                    } else if (this.entity.equals("AMHPQSvcTest")) {
                        this.result = aMHBase.pullProcessQueueDetails();
                    } else if (this.entity.equals("AMHSAGCltSvcTest")) {
                        this.result = aMHBase.pullSAGClusterDetails();
                    } else if (this.entity.equals("AMHSealBlkTest")) {
                        this.result = aMHBase.pullSealQueueDetails();
                    } else if (this.entity.equals("AMHSNFInpChnTest")) {
                        this.result = aMHBase.pullSNFInputChannelDetails();
                    } else if (this.entity.equals("AMHSNFQMsgTest")) {
                        this.result = aMHBase.pullSNFQueueMsgDetails();
                    } else if (this.entity.equals("AMHSNFQSvcTest")) {
                        this.result = aMHBase.pullSNFQueueSrvDetails();
                    } else if (this.entity.equals("AMHSwiftConnTest")) {
                        this.result = aMHBase.pullSwiftConnDetails();
                    }
                    this.done = true;
                    this.status = true;
                    this.statusCode = 100;
                } else {
                    this.done = true;
                    this.status = false;
                    this.statusCode = 50;
                }
                jVMInstrumentation.closeJVMConn();
                return;
            }
            if (this.entity.equals("JmxConnectorTest")) {
                this.startTime = System.currentTimeMillis();
            }
            if (jVMInstrumentation.connectToJVM(this.urlStr, this.userName, this.password)) {
                if (this.entity.equals("JvmUptimeTest")) {
                    this.result = jVMInstrumentation.pullUptimeStatistics("jmx", 0L);
                } else if (this.entity.equals("JvmClassInfoTest")) {
                    this.result = jVMInstrumentation.pullClassLoadingStatistics();
                } else if (this.entity.equals("JvmCpuTest")) {
                    this.result = jVMInstrumentation.pullResourcesStatistics();
                } else if (this.entity.equals("JvmThreadTest")) {
                    this.result = jVMInstrumentation.pullThreadStatistics();
                } else if (this.entity.equals("JvmGCDetailsTest")) {
                    this.result = jVMInstrumentation.pullGCStatistics();
                } else if (this.entity.equals("JvmSummaryTest")) {
                    this.result = jVMInstrumentation.pullJvmSummaryDetails();
                } else if (this.entity.equals("JvmMemoryDetailsTest")) {
                    this.result = jVMInstrumentation.pullMemoryStatistics();
                    this.jvmPID = jVMInstrumentation.getPID();
                    this.isIBM = jVMInstrumentation.isIBMJvmRunning();
                } else if (this.entity.equals("JvmMemPoolGCTest")) {
                    this.result = jVMInstrumentation.pullFullGCStatistics();
                } else if (this.entity.equals("JmxConnectorTest")) {
                    long l = System.currentTimeMillis();
                    String string = jVMInstrumentation.getPID();
                    if (string != null) {
                        this.result.put("PID", string);
                        this.result.put("BEGIN", new Long(this.startTime));
                        this.result.put("END", new Long(l));
                    } else if (this.serverType.equalsIgnoreCase("SAP_BOBI") || this.serverType.equalsIgnoreCase("SAP_BODS")) {
                        this.result.put("PID", "0");
                        this.result.put("BEGIN", new Long(this.startTime));
                        this.result.put("END", new Long(l));
                    }
                } else if (this.entity.equals("JiraEntityTest")) {
                    String string = "com.atlassian.jira:type=entity.*";
                    this.result = jVMInstrumentation.getJiraJMXEntityMetrics(string);
                } else if (this.entity.equals("JvmFileDescriptorTest")) {
                    this.result = jVMInstrumentation.pullFileDescriptorStatistics();
                } else if (this.entity.equals("JVMGCTest")) {
                    this.result = jVMInstrumentation.pullFullGCNotification();
                } else if (this.entity.equals("ConfluIndexTest")) {
                    String string = "Confluence:name=IndexingStatistics";
                    this.result = jVMInstrumentation.confluenceContainerMetrics(string);
                } else if (this.entity.equals("ConfluMTTest")) {
                    String string = "Confluence:name=MailTaskQueue";
                    this.result = jVMInstrumentation.confluenceContainerMetrics(string);
                } else if (this.entity.equals("ConfluSJobsTest")) {
                    String string = "Confluence:name=SchedulingStatistics";
                    this.result = jVMInstrumentation.confluenceContainerMetrics(string);
                } else if (this.entity.equals("ConfluMSTest")) {
                    this.result = jVMInstrumentation.confluenceMailServerMetrics();
                } else if (this.entity.equals("ConfluRStatsTest")) {
                    String string = "Confluence:name=RequestMetrics";
                    String string2 = "Confluence:name=SystemInformation";
                    String string3 = jVMInstrumentation.confluenceDatabaseLatency(string2);
                    this.result = jVMInstrumentation.confluenceContainerMetrics(string);
                    this.result.put("DatabaseExampleLatency", string3);
                } else if (this.entity.equals("JvmConfigInfo_cf")) {
                    this.result = jVMInstrumentation.pullJvmInfoStatistics();
                } else if (this.entity.equals("JvmMemoryPools_cf")) {
                    this.result = jVMInstrumentation.pullMemoryPoolStatistics(false);
                } else if (this.entity.equals("ConfluSystemInfo_cf") || this.entity.equals("ConfluPluginsInfo_cf")) {
                    String string = "Confluence:name=SystemInformation";
                    this.result = jVMInstrumentation.confluenceContainerMetrics(string);
                } else if (this.entity.equals("JvmMemoryLeakTest")) {
                    JvmMemoryLeakTest jvmMemoryLeakTest = (JvmMemoryLeakTest)this.testObject;
                    long l = System.currentTimeMillis();
                    String string = "/";
                    if (jVMInstrumentation.targetJVMOsName.startsWith("win")) {
                        string = "\\";
                    }
                    String string4 = EgInstallInfo.getInstallDir() + string + "agent" + string + "logs" + string + jVMInstrumentation.targetHost + "_" + jVMInstrumentation.portNo + "_" + l + ".hprof";
                    this.result = jvmMemoryLeakTest.topObjectsByRetainedSize(string4, true, 20, this.leakPercentageLimit);
                } else {
                    ActiveMQBase activeMQBase = (ActiveMQBase)this.testObject;
                    boolean bl = this.entity.startsWith("ActiveMQ");
                    if (bl) {
                        if (this.entity.equals("ActiveMQQueueTest")) {
                            String string = "org.apache.activemq:type=Broker,destinationType=Queue,destinationName=*,*";
                            this.result = activeMQBase.serverMetricCollection(string, ActiveMQBase.queueOrTopicAttributeNames);
                        } else if (this.entity.equals("ActiveMQTopicTest")) {
                            String string = "org.apache.activemq:type=Broker,destinationType=Topic,destinationName=*,*";
                            this.result = activeMQBase.serverMetricCollection(string, ActiveMQBase.queueOrTopicAttributeNames);
                        } else if (this.entity.equals("ActiveMQStatusTest")) {
                            String[] stringArray = new String[]{"org.apache.activemq:type=Broker,service=Health,*", "org.apache.activemq:type=Broker,brokerName=*", "org.apache.activemq:type=Broker,brokerName=*,connector=clientConnectors,connectorName=*,*"};
                            String[] stringArray2 = new String[]{"health", "broker", "connector"};
                            this.result = activeMQBase.getActiveMQStatus(stringArray, stringArray2);
                        } else if (this.entity.equals("ActiveMQBrokerTest")) {
                            String string = "org.apache.activemq:type=Broker,brokerName=*";
                            this.result = activeMQBase.serverMetricCollection(string, ActiveMQBase.BrokerAttributeNames);
                        }
                    }
                }
                this.done = true;
                this.status = true;
                this.statusCode = 100;
            } else {
                this.done = true;
                this.status = false;
                this.statusCode = 50;
            }
        }
        catch (Exception exception) {
            this.done = true;
            this.status = false;
            this.statusCode = -100;
            System.out.println(exception.toString() + " in " + this.entity + " JMX mode...");
        }
        finally {
            if (this.entity.equals("JVMGCTest")) {
                if (jVMInstrumentation.isGCNotificationJMXConnectionClose()) {
                    jVMInstrumentation.closeJVMConn();
                }
            } else {
                jVMInstrumentation.closeJVMConn();
            }
        }
    }

    public void closeJVMconnectionWhenInterrupt() {
        if (this.testObject != null) {
            try {
                JVMInstrumentation jVMInstrumentation = (JVMInstrumentation)((Object)this.testObject);
                if (this.entity.equals("JVMGCTest")) {
                    if (jVMInstrumentation.isGCNotificationJMXConnectionClose()) {
                        jVMInstrumentation.closeJVMConn();
                    }
                    return;
                }
                jVMInstrumentation.closeJVMConn();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isIBMJVM() {
        return this.isIBM;
    }

    public String getPID() {
        return this.jvmPID;
    }
}

