/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraRollbackTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private String queryStmt;
    private String queryStmt1;
    private double prevSUH = 0.0;
    private double prevSUB = 0.0;
    private double prevUH = 0.0;
    private double prevUB = 0.0;
    private double prevS = 0.0;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraRollbackTest oraRollbackTest = new OraRollbackTest(stringArray);
        oraRollbackTest.computeMeasures(new Hashtable());
    }

    public OraRollbackTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        this.queryStmt = "select class, count from v$waitstat where class in ('system undo header', 'system undo block', 'undo header', 'undo block')";
        this.queryStmt1 = "SELECT sum(value) FROM V$SYSSTAT WHERE name in ('db block gets', 'consistent gets')";
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        block94: {
            block93: {
                block85: {
                    block92: {
                        block91: {
                            block82: {
                                block90: {
                                    block80: {
                                        block81: {
                                            if (this.isSSLEnabled) {
                                                this.printOut("SSL enabled");
                                                if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                                                    var2_2 = "tcps";
                                                    var3_3 = this.targetHost;
                                                    var4_6 = this.portNo;
                                                    var5_7 = this.oraSid;
                                                    var6_9 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + var2_2 + ")(HOST=" + (String)var3_3 + ")(PORT=" + var4_6 + "))(CONNECT_DATA=(SERVICE_NAME=" + var5_7 + ")))";
                                                    this.sslParametersHT.put("isSSLEnabled", "True");
                                                    this.sslParametersHT.put("urlWithSSL", var6_9);
                                                    this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                                                    this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                                                    this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                                                    this.sslParametersHT.put("egReportName", this.reportingName);
                                                    this.sslParametersHT.put("eGTestName", this.entity);
                                                } else {
                                                    this.printOut("Please provide valid key store details");
                                                }
                                            } else {
                                                this.printOut("SSL is not enabled");
                                            }
                                            if (this.isInitCheckNeeded) {
                                                this.isDataguardEnabled = this.isSSLEnabled != false ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.reportingName);
                                                var2_2 = new ArrayList<E>();
                                                var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                                                if (var2_2 != null && var2_2.size() > 2) {
                                                    var3_4 = (Integer)var2_2.get(0);
                                                    var4_6 = (String)var2_2.get(1);
                                                    if (var4_6.equalsIgnoreCase("true")) {
                                                        this.isCDB = true;
                                                    }
                                                    if (var3_4 >= 12) {
                                                        this.isOracle12c = true;
                                                        var5_7 = (String)var2_2.get(2);
                                                        if (var5_7.equalsIgnoreCase("true")) {
                                                            this.isMultitenantDb = true;
                                                        }
                                                    }
                                                    this.isInitCheckNeeded = false;
                                                } else {
                                                    if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                                                        this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                                        this.msgLogCounter = 0;
                                                    }
                                                    ++this.msgLogCounter;
                                                }
                                            }
                                            if (this.isDataguardEnabled) {
                                                var2_2 = new Hashtable<K, V>();
                                                var2_2 = this.isSSLEnabled != false ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.reportingName);
                                                if (var2_2 == null) return;
                                                if (var2_2.size() == 0) {
                                                    return;
                                                }
                                                var3_3 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
                                                if (var3_3 == null) return;
                                                if (var3_3.size() <= 0) return;
                                                var4_6 = (String)var3_3.get(2);
                                                var5_7 = (String)var3_3.get(3);
                                                if (!var4_6.equalsIgnoreCase("PRIMARY") && var5_7.equalsIgnoreCase("MOUNTED")) {
                                                    return;
                                                }
                                            }
                                            var3_5 = 0.0;
                                            var5_8 = 0.0;
                                            var7_10 = 0.0;
                                            var9_11 = 0.0;
                                            var11_12 = 0.0;
                                            var13_13 = 0.0;
                                            var15_14 = 0.0;
                                            var17_15 = 0.0;
                                            var19_16 = 0.0;
                                            var21_17 = 0.0;
                                            var23_18 = null;
                                            var24_19 = null;
                                            var25_20 = null;
                                            try {
                                                try {
                                                    if (this.isMultitenantDb) {
                                                        if (this.isCDB) {
                                                            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                                                                this.logToErrorFile("INFO", "OraRollbackTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                                                this.msgLogCounter = 0;
                                                            }
                                                            ++this.msgLogCounter;
                                                            var29_21 = null;
                                                            if (var23_18 == null) break block80;
                                                            break block81;
                                                        }
                                                        var25_20 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug);
                                                    } else {
                                                        var25_20 = this.isSSLEnabled != false ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraRollbackTest.debug);
                                                    }
                                                    if (var25_20 == null) {
                                                        this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                                        break block82;
                                                    }
                                                    try {
                                                        var24_19 = var25_20.createStatement();
                                                    }
                                                    catch (Exception var26_33) {
                                                        this.logToErrorFile("Error :", "OraRollbackTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var26_33.toString());
                                                        var26_33.printStackTrace();
                                                        try {
                                                            if (var25_20 != null) {
                                                                var25_20.close();
                                                            }
                                                        }
                                                        catch (Exception var27_36) {
                                                        }
                                                        var29_23 = null;
                                                        if (var23_18 != null) {
                                                            try {
                                                                var23_18.close();
                                                            }
                                                            catch (Exception var30_29) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (var24_19 != null) {
                                                            try {
                                                                var24_19.close();
                                                            }
                                                            catch (Exception var30_29) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (var25_20 == null) return;
                                                        try {
                                                            var25_20.close();
                                                            return;
                                                        }
                                                        catch (Exception var30_29) {
                                                            // empty catch block
                                                        }
                                                        return;
                                                    }
                                                    var23_18 = var24_19.executeQuery(this.queryStmt);
                                                    while (var23_18.next()) {
                                                        var26_34 = var23_18.getString(1);
                                                        if (var26_34.equalsIgnoreCase("system undo header")) {
                                                            var3_5 = var23_18.getDouble(2);
                                                            continue;
                                                        }
                                                        if (var26_34.equalsIgnoreCase("system undo block")) {
                                                            var5_8 = var23_18.getDouble(2);
                                                            continue;
                                                        }
                                                        if (var26_34.equalsIgnoreCase("undo header")) {
                                                            var7_10 = var23_18.getDouble(2);
                                                            continue;
                                                        }
                                                        if (!var26_34.equalsIgnoreCase("undo block")) continue;
                                                        var9_11 = var23_18.getDouble(2);
                                                    }
                                                    var23_18.close();
                                                    var23_18 = var24_19.executeQuery(this.queryStmt1);
                                                    while (var23_18.next()) {
                                                        var11_12 = var23_18.getDouble(1);
                                                    }
                                                    if (this.prevSUH > var3_5 || this.prevSUB > var5_8 || this.prevUH > var7_10 || this.prevUB > var9_11 || this.prevS > var11_12) {
                                                        var13_13 = -1.0;
                                                        var15_14 = -1.0;
                                                    } else {
                                                        var17_15 = var3_5 - this.prevSUH + (var5_8 - this.prevSUB);
                                                        var19_16 = var7_10 - this.prevUH + (var9_11 - this.prevUB);
                                                        var21_17 = var11_12 - this.prevS;
                                                        if (var21_17 == 0.0) {
                                                            var13_13 = 0.0;
                                                            var15_14 = 0.0;
                                                        } else {
                                                            var13_13 = var17_15 * 100.0 / var21_17;
                                                            var15_14 = var19_16 * 100.0 / var21_17;
                                                        }
                                                    }
                                                    var26_34 = new ArrayList<E>();
                                                    var26_34.add(new Double(var13_13));
                                                    var26_34.add(new Double(var15_14));
                                                    this.addNewMeasure((ArrayList)var26_34);
                                                    var23_18.close();
                                                    var24_19.close();
                                                    var25_20.close();
                                                    this.prevS = var11_12;
                                                    this.prevSUH = var3_5;
                                                    this.prevSUB = var5_8;
                                                    this.prevUH = var7_10;
                                                    this.prevUB = var9_11;
                                                    break block85;
                                                }
                                                catch (Exception var26_35) {
                                                    block87: {
                                                        block86: {
                                                            var26_35.printStackTrace();
                                                            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var26_35.toString());
                                                            if (var23_18 != null) {
                                                                try {
                                                                    var23_18.close();
                                                                }
                                                                catch (Exception var27_37) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (var24_19 != null) {
                                                                try {
                                                                    var24_19.close();
                                                                }
                                                                catch (Exception var27_38) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (var25_20 != null) {
                                                                try {
                                                                    var25_20.close();
                                                                }
                                                                catch (Exception var27_39) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            this.errorMsg = new String("Exception while executing  OraRollbackTest for target: " + this.targetHost);
                                                            var29_25 = null;
                                                            if (var23_18 != null) {
                                                                ** try [egrp 7[TRYBLOCK] [15 : 1889->1899)] { 
lbl201:
                                                                // 1 sources

                                                                var23_18.close();
                                                                break block86;
lbl203:
                                                                // 1 sources

                                                                catch (Exception var30_31) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (var24_19 != null) {
                                                            ** try [egrp 8[TRYBLOCK] [16 : 1906->1916)] { 
lbl208:
                                                            // 1 sources

                                                            var24_19.close();
                                                            break block87;
lbl210:
                                                            // 1 sources

                                                            catch (Exception var30_31) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (var25_20 == null) return;
                                                    try {}
                                                    catch (Exception var30_31) {
                                                        return;
                                                    }
                                                    var25_20.close();
                                                    return;
                                                }
                                            }
                                            catch (Throwable var28_40) {
                                                block89: {
                                                    block88: {
                                                        var29_26 = null;
                                                        if (var23_18 != null) {
                                                            ** try [egrp 7[TRYBLOCK] [15 : 1889->1899)] { 
lbl224:
                                                            // 1 sources

                                                            var23_18.close();
                                                            break block88;
lbl226:
                                                            // 1 sources

                                                            catch (Exception var30_32) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (var24_19 != null) {
                                                        ** try [egrp 8[TRYBLOCK] [16 : 1906->1916)] { 
lbl231:
                                                        // 1 sources

                                                        var24_19.close();
                                                        break block89;
lbl233:
                                                        // 1 sources

                                                        catch (Exception var30_32) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (var25_20 == null) throw var28_40;
                                                ** try [egrp 9[TRYBLOCK] [17 : 1923->1933)] { 
lbl238:
                                                // 1 sources

                                                var25_20.close();
                                                throw var28_40;
lbl240:
                                                // 1 sources

                                                catch (Exception var30_32) {
                                                    // empty catch block
                                                }
                                                throw var28_40;
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [15 : 1889->1899)] { 
lbl245:
                                        // 1 sources

                                        var23_18.close();
                                        break block80;
lbl247:
                                        // 1 sources

                                        catch (Exception var30_27) {
                                            // empty catch block
                                        }
                                    }
                                    if (var24_19 != null) {
                                        ** try [egrp 8[TRYBLOCK] [16 : 1906->1916)] { 
lbl252:
                                        // 1 sources

                                        var24_19.close();
                                        break block90;
lbl254:
                                        // 1 sources

                                        catch (Exception var30_27) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var25_20 == null) return;
                                ** try [egrp 9[TRYBLOCK] [17 : 1923->1933)] { 
lbl259:
                                // 1 sources

                                var25_20.close();
                                return;
lbl261:
                                // 1 sources

                                catch (Exception var30_27) {
                                    // empty catch block
                                }
                                return;
                            }
                            var29_22 = null;
                            if (var23_18 != null) {
                                ** try [egrp 7[TRYBLOCK] [15 : 1889->1899)] { 
lbl268:
                                // 1 sources

                                var23_18.close();
                                break block91;
lbl270:
                                // 1 sources

                                catch (Exception var30_28) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var24_19 != null) {
                            ** try [egrp 8[TRYBLOCK] [16 : 1906->1916)] { 
lbl275:
                            // 1 sources

                            var24_19.close();
                            break block92;
lbl277:
                            // 1 sources

                            catch (Exception var30_28) {
                                // empty catch block
                            }
                        }
                    }
                    if (var25_20 == null) return;
                    ** try [egrp 9[TRYBLOCK] [17 : 1923->1933)] { 
lbl282:
                    // 1 sources

                    var25_20.close();
                    return;
lbl284:
                    // 1 sources

                    catch (Exception var30_28) {
                        // empty catch block
                    }
                    return;
                }
                var29_24 = null;
                if (var23_18 != null) {
                    ** try [egrp 7[TRYBLOCK] [15 : 1889->1899)] { 
lbl291:
                    // 1 sources

                    var23_18.close();
                    break block93;
lbl293:
                    // 1 sources

                    catch (Exception var30_30) {
                        // empty catch block
                    }
                }
            }
            if (var24_19 != null) {
                ** try [egrp 8[TRYBLOCK] [16 : 1906->1916)] { 
lbl298:
                // 1 sources

                var24_19.close();
                break block94;
lbl300:
                // 1 sources

                catch (Exception var30_30) {
                    // empty catch block
                }
            }
        }
        if (var25_20 == null) return;
        try {}
        catch (Exception var30_30) {}
        var25_20.close();
        return;
    }
}

