/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraSqlNetTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    public boolean service = true;
    public String serviceName = "";
    public boolean foundVersion = false;
    public boolean isSql9 = false;
    public boolean isSql10 = false;
    public boolean userPrivilege = true;
    public int defValue = -1;
    private boolean isExternal = false;
    public int availability = 0;
    public int dbConnAvailable = 0;
    public double dbConnTime = 0.0;
    public int qryProAvailable = 0;
    public double qryExeTime = 0.0;
    public int noOfRecords = 0;
    public String queryStmt;
    public double prevBytesSent = -1.0;
    public double prevBytesRecvd = -1.0;
    public double responseTime = -1.0;
    double kbytesSentRate;
    double kbytesRecvdRate;
    public boolean isOracle12c = false;
    public boolean isCDB = false;
    public boolean isMultitenantDb = false;
    public ArrayList sqlNetDDList = new ArrayList();
    private String ddLine = "";
    private boolean isInitCheckNeeded = true;
    private boolean isDataguardEnabled = false;
    public boolean isDDNeed;
    public String resQueryStmt = "";
    public boolean isOracleOnCloud = false;
    public String isSSL = "";
    public String trustStorePath = "";
    public String trustStoreType = "";
    public String trustStorePassword = "";
    public boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    public Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraSqlNetTest oraSqlNetTest = new OraSqlNetTest(stringArray);
        oraSqlNetTest.computeMeasures(new Hashtable());
    }

    public OraSqlNetTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oraclesid");
        }
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        if ((string = this.getValueForParam("isCluster")) == null) {
            string = this.getValueForParam("isExternal");
        }
        this.serviceName = this.getValueForParam("servicename");
        this.resQueryStmt = this.getValueForParam("query");
        String string2 = this.getValueForParam("cloud_hosted");
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"))) {
            this.isExternal = true;
        }
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        System.out.println(this.entity + ":Inside the constructor:: targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if (this.isPassive) {
            this.defValue = -5;
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isExternal && this.isOracleOnCloud) {
            this.isExternal = this.isOracleOnCloud;
        }
        if (!this.isExternal) {
            this.setSid(this.oraSid);
        }
        this.queryStmt = "SELECT name,value  FROM v$sysstat  WHERE NAME IN  ('bytes sent via SQL*Net to client','bytes received via SQL*Net from client','SQL*Net roundtrips to/from client')";
        if (this.resQueryStmt == null || this.resQueryStmt.equalsIgnoreCase("NULL") || this.resQueryStmt.equalsIgnoreCase("none")) {
            this.resQueryStmt = this.queryStmt;
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        System.out.println(this.entity + ":End of the constructor:: targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        Cloneable cloneable;
        Object object;
        ArrayList<Double> arrayList;
        String string2;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                string2 = "tcps";
                arrayList = this.targetHost;
                object = this.portNo;
                String string3 = this.oraSid;
                cloneable = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=" + (String)((Object)arrayList) + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string3 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", cloneable);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        System.out.println(this.entity + ":Inside the computeMeasure():: targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        string2 = null;
        this.sqlNetDDList = new ArrayList();
        this.isDDNeed = true;
        if (this.isPassive) {
            this.availability = this.defValue;
            this.responseTime = this.defValue;
            this.qryProAvailable = this.defValue;
            this.noOfRecords = this.defValue;
            this.dbConnAvailable = this.defValue;
            this.dbConnTime = this.defValue;
            this.qryExeTime = this.defValue;
            this.noOfRecords = this.defValue;
            this.kbytesSentRate = this.defValue;
            this.kbytesRecvdRate = this.defValue;
        } else {
            this.availability = 0;
            this.responseTime = -5.0;
            this.qryProAvailable = -5;
            this.noOfRecords = -5;
            this.dbConnAvailable = -5;
            this.dbConnTime = -5.0;
            this.qryExeTime = -5.0;
            this.noOfRecords = -5;
            this.kbytesSentRate = -5.0;
            this.kbytesRecvdRate = -5.0;
        }
        System.out.println(this.entity + ":isInitCheckNeeded::" + this.isInitCheckNeeded + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        arrayList = new ArrayList();
        System.out.println(this.entity + ":Helper class call started targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        object = new OraSqlNetHelper(this);
        boolean bl = this.checkForTimeout((OraSqlNetHelper)object);
        System.out.println(this.entity + ":Helper returned status::" + bl + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        if (this.availability == 100) {
            String string4;
            if (this.isInitCheckNeeded) {
                this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                cloneable = new ArrayList();
                cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                    int n = (Integer)((ArrayList)cloneable).get(0);
                    string4 = (String)((ArrayList)cloneable).get(1);
                    if (string4.equalsIgnoreCase("true")) {
                        this.isCDB = true;
                    }
                    if (n >= 12) {
                        this.isOracle12c = true;
                        string = (String)((ArrayList)cloneable).get(2);
                        if (string.equalsIgnoreCase("true")) {
                            this.isMultitenantDb = true;
                        }
                    }
                    this.isInitCheckNeeded = false;
                }
            }
            if (this.isDataguardEnabled) {
                cloneable = new Hashtable();
                cloneable = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                    return;
                }
                ArrayList arrayList2 = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    string4 = (String)arrayList2.get(2);
                    string = (String)arrayList2.get(3);
                    if (!string4.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                        this.isDDNeed = false;
                    }
                } else {
                    this.isDDNeed = false;
                }
            }
        }
        if (bl) {
            cloneable = ((OraSqlNetHelper)object).names;
            ArrayList arrayList3 = ((OraSqlNetHelper)object).values;
            if (cloneable == null || arrayList3 == null || ((ArrayList)cloneable).size() == 0 || arrayList3.size() == 0) {
                if (!this.isPassive) {
                    this.ddLine = ((OraSqlNetHelper)object).ddString;
                    this.sqlNetDDList.add(this.ddLine);
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
                if (this.measureCount >= 5) {
                    arrayList.add(new Double(this.dbConnAvailable));
                    arrayList.add(new Double(this.dbConnTime));
                    arrayList.add(new Double(this.qryProAvailable));
                    arrayList.add(new Double(this.qryExeTime));
                    arrayList.add(new Double(this.noOfRecords));
                }
            } else {
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    string = (String)((ArrayList)cloneable).get(i);
                    Double d = (Double)arrayList3.get(i);
                    double d2 = d;
                    if (string.startsWith("bytes sent")) {
                        if (this.prevBytesSent < 0.0 || this.prevBytesSent > d2 || this.timeSinceLastTest < 0.0) {
                            this.prevBytesSent = d2;
                            continue;
                        }
                        this.kbytesSentRate = (d2 - this.prevBytesSent) / (1000.0 * this.timeSinceLastTest);
                        this.kbytesSentRate = this.roundDouble(this.kbytesSentRate, 4);
                        if (new Double(this.kbytesSentRate).toString().length() >= 16) {
                            this.logToErrorFile("Error :", "OraSqlNetTest bytes Sent Rate current value", "" + d2 + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.logToErrorFile("Error :", "OraSqlNetTest bytes Sent Rate previous value is ", "" + this.prevBytesSent + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.logToErrorFile("Error :", "OraSqlNetTest bytes Sent Rate calculated value", "" + this.kbytesSentRate + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.logToErrorFile("Error :", "OraSqlNetTest bytes Sent Rate value is too large", " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.kbytesSentRate = -5.0;
                        }
                        this.prevBytesSent = d2;
                        continue;
                    }
                    if (!string.startsWith("bytes rec")) continue;
                    if (this.prevBytesRecvd < 0.0 || this.prevBytesRecvd > d2 || this.timeSinceLastTest < 0.0) {
                        this.prevBytesRecvd = d2;
                        continue;
                    }
                    this.kbytesRecvdRate = (d2 - this.prevBytesRecvd) / (1000.0 * this.timeSinceLastTest);
                    this.kbytesRecvdRate = this.roundDouble(this.kbytesRecvdRate, 4);
                    if (new Double(this.kbytesRecvdRate).toString().length() >= 16) {
                        this.logToErrorFile("Error :", "OraSqlNetTest bytes Recvd Rate current value is ", "" + d2 + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.logToErrorFile("Error :", "OraSqlNetTest bytes Recvd Rate previous value is ", "" + this.prevBytesRecvd + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.logToErrorFile("Error :", "OraSqlNetTest bytes Recvd Rate calculated value", "" + this.kbytesRecvdRate + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.logToErrorFile("Error :", "OraSqlNetTest bytes Recvd Rate value is too large", " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.kbytesRecvdRate = -5.0;
                    }
                    this.prevBytesRecvd = d2;
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
                if (this.measureCount >= 5) {
                    arrayList.add(new Double(this.dbConnAvailable));
                    arrayList.add(new Double(this.dbConnTime));
                    arrayList.add(new Double(this.qryProAvailable));
                    arrayList.add(new Double(this.qryExeTime));
                    arrayList.add(new Double(this.noOfRecords));
                }
            }
        } else {
            if (!this.isPassive) {
                this.sqlNetDDList.add(this.ddLine);
                System.out.println(this.entity + " ddLine::" + this.ddLine);
            }
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.availability));
            arrayList.add(new Double(this.responseTime));
            arrayList.add(new Double(this.kbytesSentRate));
            arrayList.add(new Double(this.kbytesRecvdRate));
            if (this.measureCount >= 5) {
                arrayList.add(new Double(this.dbConnAvailable));
                arrayList.add(new Double(this.dbConnTime));
                arrayList.add(new Double(this.qryProAvailable));
                arrayList.add(new Double(this.qryExeTime));
                arrayList.add(new Double(this.noOfRecords));
            }
            this.errorMsg = new String("Exception while executing OraSqlNetTest for target: " + this.targetHost);
        }
        this.addNewMeasure(arrayList);
        System.out.println(this.entity + ":measureList::" + arrayList + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        System.out.println(this.entity + ":End of the computeMeasure():: targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
    }

    private boolean checkForTimeout(OraSqlNetHelper oraSqlNetHelper) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            long l4 = System.currentTimeMillis();
            this.suspendForPeriod(l3);
            if (oraSqlNetHelper.done) {
                return true;
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            if (l6 < 0L) {
                l6 = l3;
            }
            if ((l2 += l6) >= this.timeout) {
                System.out.println("OraSqlNetTest timeout happened ... targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
                System.err.println("OraSqlNetTest timeout happened ... targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
                this.logToErrorFile(this.entity, "timeout happened ...", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
                double d = this.timeout / 1000L;
                this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
                oraSqlNetHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oraSqlNetHelper.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        double d = this.timeout / 1000L;
        this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
        oraSqlNetHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        oraSqlNetHelper.stop();
        System.out.println("OraSqlNetTest timeout happened ... " + l2 + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        System.err.println("OraSqlNetTest timeout happened ... " + l2 + " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        this.logToErrorFile(this.entity, "timeout happened ... " + l2, " targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + ":Current time::" + new Date());
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < EgAgentCommon.minimumSleep) {
                l = EgAgentCommon.minimumSleep;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private double roundDouble(double d, int n) {
        Object object;
        double d2 = 0.0;
        Object object2 = "";
        if (n <= 0) {
            object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        } else {
            String string;
            object = "";
            if (d < 0.0) {
                object = (String)object + "-";
                d = -d;
            }
            if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                int n2 = (int)d;
                object = (String)object + n2;
                d -= (double)n2;
            } else {
                object = (String)object + "0";
            }
            if (d > 0.0) {
                String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                object = (String)object + "." + string2.substring(1);
            }
            object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
        }
        object = new Double((String)object2);
        d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        return d2;
    }

    public void freeTest() {
        this.sqlNetDDList = new ArrayList();
    }
}

