/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraTimeWorkloadTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private Connection conn = null;
    private double defValue = -1.0;
    private boolean isFirstTime = true;
    double numberOfProcessor = -1.0;
    ArrayList prevList = new ArrayList();
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean agentLessSupport = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private boolean isNumProcFound = false;
    private boolean isOracle10GAndAbove = false;
    public boolean isOracleOnCloud = false;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraTimeWorkloadTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(15);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        this.password = this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.password);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object4 = "tcps";
                object3 = this.targetHost;
                object2 = this.portNo;
                object = this.oraSid;
                string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object4 + ")(HOST=" + (String)object3 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)object + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object4 = new ArrayList();
            object4 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object4 != null && ((ArrayList)object4).size() > 2) {
                int n = (Integer)((ArrayList)object4).get(0);
                object2 = (String)((ArrayList)object4).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 10) {
                    this.isOracle10GAndAbove = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)object4).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object4, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object4 = new Hashtable();
            object4 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object4 == null) return;
            if (((Hashtable)object4).size() == 0) {
                return;
            }
            object3 = (ArrayList)((Hashtable)object4).get(this.reportingName + ":" + this.oraSid);
            if (object3 == null) return;
            if (((ArrayList)object3).size() <= 0) return;
            object2 = (String)((ArrayList)object3).get(2);
            object = (String)((ArrayList)object3).get(3);
            if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        object4 = null;
        object3 = "";
        object2 = new ArrayList();
        object = new ArrayList();
        string = "select value/100 cpu_time_secs from v$sysstat where name='CPU used by this session'";
        String string2 = "select value redo_size_bytes from v$sysstat where name='redo size'";
        String string3 = "select value logical_reads_count from v$sysstat where name='session logical reads'";
        String string4 = "select value block_changes_count from v$sysstat where name='db block changes'";
        String string5 = "select value physical_reads_count from v$sysstat where name='physical reads'";
        String string6 = "select value physical_writes_count from v$sysstat where name='physical writes'";
        String string7 = "select value user_calls_count from v$sysstat where name='user calls'";
        String string8 = "select value parse_count from v$sysstat where name='parse count (total)'";
        String string9 = "select value hard_parse_count from v$sysstat where name ='parse count (hard)'";
        String string10 = "select value/1024 WA_memory_MB from v$sysstat where name='workarea memory allocated'";
        String string11 = "select value as count_in_number from v$sysstat where lower(name) ='logons cumulative'";
        String string12 = "select value execute_count from v$sysstat where name='execute count'";
        String string13 = "select value transaction_rollbacks_count from v$sysstat where name='transaction rollbacks'";
        String string14 = "select sum(value) from v$sysstat where NAME in ('user commits','transaction rollbacks')";
        try {
            try {
                try {
                    if (this.isMultitenantDb && !this.isCDB) {
                        this.conn = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                    } else {
                        System.out.println("OraTimeWorkloadTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                        this.conn = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("[OraTimeWorkloadTest] compute Measure()", "failed to connect databasetargetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                    Object var107_26 = null;
                    this.closeStmt((Statement)object4);
                    this.closeConn(this.conn);
                    return;
                }
                if (this.conn == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    Object var107_27 = null;
                    this.closeStmt((Statement)object4);
                    this.closeConn(this.conn);
                    return;
                }
                try {
                    object4 = this.conn.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", "OraTimeWorkloadTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(this.conn);
                    Object var107_28 = null;
                    this.closeStmt((Statement)object4);
                    this.closeConn(this.conn);
                    return;
                }
                if (!this.isNumProcFound) {
                    String string15 = "";
                    string15 = this.isOracle10GAndAbove ? "select VALUE from v$osstat where stat_name='NUM_CPUS'" : "select value from v$parameter where name='cpu_count'";
                    System.out.println("OraTimeWorkloadTest cpuCountQuery:::" + string15);
                    this.numberOfProcessor = this.executeQry((Statement)object4, string15);
                    if (this.numberOfProcessor > 0.0) {
                        this.isNumProcFound = true;
                    }
                }
                System.out.println("OraTimeWorkloadTest numberOfProcessor:::" + this.numberOfProcessor);
                double d = this.executeQry((Statement)object4, string);
                double d2 = this.executeQry((Statement)object4, string2);
                double d3 = this.executeQry((Statement)object4, string3);
                double d4 = this.executeQry((Statement)object4, string4);
                double d5 = this.executeQry((Statement)object4, string5);
                double d6 = this.executeQry((Statement)object4, string6);
                double d7 = this.executeQry((Statement)object4, string7);
                double d8 = this.executeQry((Statement)object4, string8);
                double d9 = this.executeQry((Statement)object4, string9);
                double d10 = this.executeQry((Statement)object4, string10);
                double d11 = this.executeQry((Statement)object4, string11);
                double d12 = this.executeQry((Statement)object4, string12);
                double d13 = this.executeQry((Statement)object4, string13);
                double d14 = this.executeQry((Statement)object4, string14);
                if (this.isFirstTime) {
                    this.isFirstTime = false;
                    object2 = new ArrayList<Double>();
                    for (int i = 0; i < this.measureCount; ++i) {
                        ((ArrayList)object2).add(new Double(-5.0));
                    }
                } else if (this.prevList != null && this.prevList.size() > 0) {
                    double d15 = (Double)this.prevList.get(0);
                    double d16 = (Double)this.prevList.get(1);
                    double d17 = (Double)this.prevList.get(2);
                    double d18 = (Double)this.prevList.get(3);
                    double d19 = (Double)this.prevList.get(4);
                    double d20 = (Double)this.prevList.get(5);
                    double d21 = (Double)this.prevList.get(6);
                    double d22 = (Double)this.prevList.get(7);
                    double d23 = (Double)this.prevList.get(8);
                    double d24 = (Double)this.prevList.get(9);
                    double d25 = (Double)this.prevList.get(10);
                    double d26 = (Double)this.prevList.get(11);
                    double d27 = (Double)this.prevList.get(12);
                    double d28 = (Double)this.prevList.get(13);
                    double d29 = this.getDiff(d, d15);
                    double d30 = this.getDiff(d2, d16);
                    double d31 = this.getDiff(d3, d17);
                    double d32 = this.getDiff(d4, d18);
                    double d33 = this.getDiff(d5, d19);
                    double d34 = this.getDiff(d6, d20);
                    double d35 = this.getDiff(d7, d21);
                    double d36 = this.getDiff(d8, d22);
                    double d37 = this.getDiff(d9, d23);
                    double d38 = this.getDiff(d10, d24);
                    double d39 = this.getDiff(d11, d25);
                    double d40 = this.getDiff(d12, d26);
                    double d41 = this.getDiff(d13, d27);
                    double d42 = this.getDiff(d14, d28);
                    double d43 = -5.0;
                    if (this.numberOfProcessor > 0.0) {
                        d29 /= this.numberOfProcessor;
                    }
                    if (d30 > 0.0) {
                        d30 /= 1048576.0;
                    }
                    if (this.timeSinceLastTest > 0.0) {
                        d43 = d29 / this.timeSinceLastTest * 100.0;
                        d30 /= this.timeSinceLastTest;
                        d31 /= this.timeSinceLastTest;
                        d32 /= this.timeSinceLastTest;
                        d33 /= this.timeSinceLastTest;
                        d34 /= this.timeSinceLastTest;
                        d35 /= this.timeSinceLastTest;
                        d36 /= this.timeSinceLastTest;
                        d37 /= this.timeSinceLastTest;
                        d38 /= this.timeSinceLastTest;
                        d39 /= this.timeSinceLastTest;
                        d40 /= this.timeSinceLastTest;
                        d41 /= this.timeSinceLastTest;
                        d42 /= this.timeSinceLastTest;
                    } else {
                        d43 = 0.0;
                        d30 = 0.0;
                        d31 = 0.0;
                        d32 = 0.0;
                        d33 = 0.0;
                        d34 = 0.0;
                        d35 = 0.0;
                        d36 = 0.0;
                        d37 = 0.0;
                        d38 = 0.0;
                        d39 = 0.0;
                        d40 = 0.0;
                        d41 = 0.0;
                        d42 = 0.0;
                    }
                    d43 = d43 < 0.0 ? -5.0 : d43;
                    d29 = d29 < 0.0 ? -5.0 : d29;
                    d30 = d30 < 0.0 ? -5.0 : d30;
                    d31 = d31 < 0.0 ? -5.0 : d31;
                    d32 = d32 < 0.0 ? -5.0 : d32;
                    d33 = d33 < 0.0 ? -5.0 : d33;
                    d34 = d34 < 0.0 ? -5.0 : d34;
                    d35 = d35 < 0.0 ? -5.0 : d35;
                    d36 = d36 < 0.0 ? -5.0 : d36;
                    d37 = d37 < 0.0 ? -5.0 : d37;
                    d38 = d38 < 0.0 ? -5.0 : d38;
                    d39 = d39 < 0.0 ? -5.0 : d39;
                    d40 = d40 < 0.0 ? -5.0 : d40;
                    d41 = d41 < 0.0 ? -5.0 : d41;
                    double d44 = d42 = d42 < 0.0 ? -5.0 : d42;
                    if (d43 > 100.0) {
                        d43 = 100.0;
                    }
                    object2 = new ArrayList();
                    ((ArrayList)object2).add(new Double(d43));
                    ((ArrayList)object2).add(new Double(d29));
                    ((ArrayList)object2).add(new Double(d30));
                    ((ArrayList)object2).add(new Double(d31));
                    ((ArrayList)object2).add(new Double(d32));
                    ((ArrayList)object2).add(new Double(d33));
                    ((ArrayList)object2).add(new Double(d34));
                    ((ArrayList)object2).add(new Double(d35));
                    ((ArrayList)object2).add(new Double(d36));
                    ((ArrayList)object2).add(new Double(d37));
                    ((ArrayList)object2).add(new Double(d38));
                    ((ArrayList)object2).add(new Double(d39));
                    ((ArrayList)object2).add(new Double(d40));
                    ((ArrayList)object2).add(new Double(d41));
                    ((ArrayList)object2).add(new Double(d42));
                } else {
                    object2 = new ArrayList();
                    for (int i = 0; i < this.measureCount; ++i) {
                        ((ArrayList)object2).add(new Double(-5.0));
                    }
                }
                this.addNewMeasure((ArrayList)object2);
                this.prevList = new ArrayList();
                this.prevList.add(new Double(d));
                this.prevList.add(new Double(d2));
                this.prevList.add(new Double(d3));
                this.prevList.add(new Double(d4));
                this.prevList.add(new Double(d5));
                this.prevList.add(new Double(d6));
                this.prevList.add(new Double(d7));
                this.prevList.add(new Double(d8));
                this.prevList.add(new Double(d9));
                this.prevList.add(new Double(d10));
                this.prevList.add(new Double(d11));
                this.prevList.add(new Double(d12));
                this.prevList.add(new Double(d13));
                this.prevList.add(new Double(d14));
                this.closeStmt((Statement)object4);
                this.closeConn(this.conn);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("[OraTimeWorkloadTest] compute Measure()", "Exception ", exception.toString());
                Object var107_30 = null;
                this.closeStmt((Statement)object4);
                this.closeConn(this.conn);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var107_31 = null;
            this.closeStmt((Statement)object4);
            this.closeConn(this.conn);
            throw throwable;
        }
        Object var107_29 = null;
        this.closeStmt((Statement)object4);
        this.closeConn(this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double executeQry(Statement statement, String string) {
        double d;
        ResultSet resultSet;
        block10: {
            block9: {
                resultSet = null;
                d = -5.0;
                if (this.conn != null) break block9;
                System.out.println("OraTimeWorkloadTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.logToErrorFile("Error  :", this.entity, " executeQry() Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                double d2 = d;
                Object var10_8 = null;
                this.closeRs(resultSet);
                return d2;
            }
            if (statement != null) break block10;
            try {
                statement = this.conn.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTimeWorkloadTest executeQry() Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.closeConn(this.conn);
                double d3 = d;
                Object var10_9 = null;
                this.closeRs(resultSet);
                return d3;
            }
        }
        try {
            try {
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    d = resultSet.getDouble(1);
                }
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                double d4 = d;
                Object var10_11 = null;
                this.closeRs(resultSet);
                return d4;
            }
            Object var10_10 = null;
            this.closeRs(resultSet);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closeRs(resultSet);
            throw throwable;
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d2 > 0.0 && d >= d2) {
            d3 = d - d2;
        }
        return d3;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTimeWorkloadTest oraTimeWorkloadTest = new OraTimeWorkloadTest(stringArray);
        oraTimeWorkloadTest.computeMeasures(new Hashtable());
    }
}

