'use strict'

const { BroadcastChannel, threadId } = require('worker_threads');

const logger = require('../../logger');
const appConstants = require('../../app-constants');

const appendMsg = 'Worker Threads Communicator:';

class Communicator {
  constructor(agent) {
    this.agent = agent;
    this.isRunning = false;
  }

  start() {
    this.isRunning = true;
    this.broadcastChannel = new BroadcastChannel(appConstants.WT_BROADCAST_CHANNEL);
    this.transportChannel = new BroadcastChannel(appConstants.WT_TRANSPORT_CHANNEL);
    this.broadcastChannel.unref();
    this.transportChannel.unref();

    this.broadcastChannel.onmessage = (event) => {
      if (!event || !event.data) return;
      if (event.data.config && event.data.action === appConstants.WT_INFRA_BROADCAST_MSG) {
        this.agent.config = event.data.config;
        this.agent.collectAndSendInfraMetrics();
      } else if (event.data.action === appConstants.STOP_WTM_MSG) {
        logger.info(appendMsg, 'Stop signal received from the main thread');
        this.agent.stop();
      }
    };
  }

  send(data) {
    data.threadId = threadId;
    this.transportChannel.postMessage(data);
    logger.info(appendMsg, 'Infra metrics were sent from thread ' + threadId);
  }

  stop() {
    this.broadcastChannel.close();
    this.transportChannel.close();
    this.isRunning = false;
  }
}

module.exports = Communicator;