'use strict'

const threads = require('../../utils/threads');

// Don't inject our worker agent into main thread.
if (threads.isMainThread) return;

let params = process.env.EG_NODE_PARAM;
if (!params) return;
try {
  params = JSON.parse(params);
} catch (err) { }

const appInfo = require('../../app-info');
appInfo.logDirectory = params.logDirectory;
appInfo.homeDirectory = params.homeDirectory;
// set log folder path before loading logger.

const logger = require('../../logger');
logger.setConfig(params.config);

const Agent = require('./agent');
const agent = new Agent(params.config);
agent.start();