/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.sift;

import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.sift.AbstractDiscriminator;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDCBasedDiscriminator
extends AbstractDiscriminator<ILoggingEvent> {
    private String key;
    private String defaultValue;

    @Override
    public String getDiscriminatingValue(ILoggingEvent iLoggingEvent) {
        Map<String, String> map = iLoggingEvent.getMDCPropertyMap();
        if (map == null) {
            return this.defaultValue;
        }
        String string = map.get(this.key);
        if (string == null) {
            return this.defaultValue;
        }
        return string;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (OptionHelper.isEmpty(this.key)) {
            ++n2;
            this.addError("The \"Key\" property must be set");
        }
        if (OptionHelper.isEmpty(this.defaultValue)) {
            ++n2;
            this.addError("The \"DefaultValue\" property must be set");
        }
        if (n2 == 0) {
            this.started = true;
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }
}

