/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.rolling.helper;

import com.eg.ch.qos.logback.core.pattern.Converter;
import com.eg.ch.qos.logback.core.pattern.LiteralConverter;
import com.eg.ch.qos.logback.core.rolling.helper.ArchiveRemover;
import com.eg.ch.qos.logback.core.rolling.helper.DateTokenConverter;
import com.eg.ch.qos.logback.core.rolling.helper.FileFilterUtil;
import com.eg.ch.qos.logback.core.rolling.helper.FileNamePattern;
import com.eg.ch.qos.logback.core.rolling.helper.RollingCalendar;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    @Override
    public void clean(Date date) {
        long l2 = date.getTime();
        int n2 = this.computeElapsedPeriodsSinceLastClean(l2);
        this.lastHeartBeat = l2;
        if (n2 > 1) {
            this.addInfo("Multiple periods, i.e. " + n2 + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getPeriodOffsetForDeletionTarget() - i2;
            Date date2 = this.rc.getEndOfNextNthPeriod(date, n3);
            this.cleanPeriod(date2);
        }
    }

    protected File[] getFilesInPeriod(Date date) {
        String string = this.fileNamePattern.convert(date);
        File file = new File(string);
        if (this.fileExistsAndIsFile(file)) {
            return new File[]{file};
        }
        return new File[0];
    }

    private boolean fileExistsAndIsFile(File file) {
        return file.exists() && file.isFile();
    }

    public void cleanPeriod(Date date) {
        File[] fileArray;
        for (File file : fileArray = this.getFilesInPeriod(date)) {
            this.addInfo("deleting " + file);
            file.delete();
        }
        if (this.parentClean && fileArray.length > 0) {
            File file = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty(file);
        }
    }

    void capTotalSize(Date date) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.maxHistory; ++i2) {
            Date date2 = this.rc.getEndOfNextNthPeriod(date, -i2);
            File[] fileArray = this.getFilesInPeriod(date2);
            this.descendingSortByLastModified(fileArray);
            for (File file : fileArray) {
                long l4 = file.length();
                if (l2 + l4 > this.totalSizeCap) {
                    this.addInfo("Deleting [" + file + "]" + " of size " + new FileSize(l4));
                    l3 += l4;
                    file.delete();
                }
                l2 += l4;
            }
        }
        this.addInfo("Removed  " + new FileSize(l3) + " of files");
    }

    private void descendingSortByLastModified(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                long l2;
                long l3 = file.lastModified();
                if (l3 == (l2 = file2.lastModified())) {
                    return 0;
                }
                if (l2 < l3) {
                    return -1;
                }
                return 1;
            }
        });
    }

    File getParentDir(File file) {
        File file2 = file.getAbsoluteFile();
        File file3 = file2.getParentFile();
        return file3;
    }

    int computeElapsedPeriodsSinceLastClean(long l2) {
        long l3 = 0L;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            l3 = this.rc.periodBarriersCrossed(l2, l2 + 2764800000L);
            l3 = Math.min(l3, 336L);
        } else {
            l3 = this.rc.periodBarriersCrossed(this.lastHeartBeat, l2);
        }
        return (int)l3;
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> converter;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = fileNamePattern.headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            String string;
            if (converter instanceof LiteralConverter && (string = converter.convert(null)).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n2) {
        if (n2 >= 3) {
            return;
        }
        if (file.isDirectory() && FileFilterUtil.isEmptyDirectory(file)) {
            this.addInfo("deleting folder [" + file + "]");
            file.delete();
            this.removeFolderIfEmpty(file.getParentFile(), n2 + 1);
        }
    }

    @Override
    public void setMaxHistory(int n2) {
        this.maxHistory = n2;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    @Override
    public void setTotalSizeCap(long l2) {
        this.totalSizeCap = l2;
    }

    public String toString() {
        return "c.e.c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date date) {
        ArhiveRemoverRunnable arhiveRemoverRunnable = new ArhiveRemoverRunnable(date);
        ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
        Future<?> future = scheduledExecutorService.submit(arhiveRemoverRunnable);
        return future;
    }

    public class ArhiveRemoverRunnable
    implements Runnable {
        Date now;

        ArhiveRemoverRunnable(Date date) {
            this.now = date;
        }

        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
            if (TimeBasedArchiveRemover.this.totalSizeCap != 0L && TimeBasedArchiveRemover.this.totalSizeCap > 0L) {
                TimeBasedArchiveRemover.this.capTotalSize(this.now);
            }
        }
    }
}

