/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.AmazonSimpleEmailServiceException;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.SendDataPoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;

class AWSAmazonSESTest
extends AWSEc2CloudBase {
    AmazonSimpleEmailService sesClient = null;
    CloudConnection cloudConn = null;
    Hashtable ht_prev_sends = new Hashtable();
    boolean firstTime = true;

    public AWSAmazonSESTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.fixedTestPeriod = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string;
            Hashtable hashtable2;
            block6: {
                Date date = null;
                Date date2 = null;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                gregorianCalendar.add(13, -1 * gregorianCalendar.get(13));
                date = gregorianCalendar.getTime();
                int n = (int)this.measurePeriod / 60000;
                gregorianCalendar.add(14, -((int)this.measurePeriod));
                date2 = gregorianCalendar.getTime();
                String string2 = this.cInfo.getAccessType();
                this.cloudConn = string2 != null && string2.equalsIgnoreCase("Role_Based") ? new RoleBasedCloudConnection(this.cInfo) : new AccessKeyBasedCloudConnection(this.cInfo);
                ArrayList arrayList = CloudConstants.getAWSRegions();
                hashtable2 = null;
                try {
                    hashtable2 = this.getSESData(this.cloudConn, arrayList, this.firstTime, date, date2);
                }
                catch (Exception exception) {
                    string = exception.getMessage().toLowerCase();
                    if (string.indexOf("request has expired") < 0 && string.indexOf("request is expired") < 0) break block6;
                    this.cInfo.setErrorMsg(true);
                    hashtable2 = this.getSESData(this.cloudConn, arrayList, this.firstTime, date, date2);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable2.get(string);
                    this.addNewMeasure(string, arrayList);
                }
            }
            this.firstTime = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getSESData(CloudConnection cloudConnection, ArrayList arrayList, boolean bl, Date date, Date date2) {
        Hashtable hashtable = new Hashtable();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            ArrayList arrayList2 = this.cInfo.getExcludeRegion();
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string;
                    String string2 = (String)arrayList.get(i);
                    boolean bl2 = false;
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            string = (String)arrayList2.get(j);
                            if (!this.isPaternMatch(string2.toLowerCase(), string.toLowerCase())) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (bl2 || string2 == null) continue;
                    this.sesClient = cloudConnection.getAWSSESConnection(string2);
                    if (this.sesClient == null) {
                        return null;
                    }
                    if (this.sesClient == null) continue;
                    try {
                        Double d;
                        Object object;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        double d5 = 0.0;
                        double d6 = -5.0;
                        double d7 = -5.0;
                        double d8 = -5.0;
                        double d9 = -5.0;
                        double d10 = -5.0;
                        double d11 = -5.0;
                        double d12 = -5.0;
                        double d13 = -5.0;
                        GetSendStatisticsRequest getSendStatisticsRequest = new GetSendStatisticsRequest();
                        GetSendStatisticsResult getSendStatisticsResult = this.sesClient.getSendStatistics(getSendStatisticsRequest);
                        List list = new ArrayList();
                        if (getSendStatisticsResult != null && (list = getSendStatisticsResult.getSendDataPoints()) != null && list.size() > 0 && (object = this.getLatestSendDatapoint(list, date, date2)) != null && ((ArrayList)object).size() >= 4) {
                            d = null;
                            Double d14 = null;
                            Double d15 = null;
                            Double d16 = null;
                            d = (Double)((ArrayList)object).get(0);
                            if (d != null) {
                                d2 = d;
                            }
                            if ((d14 = (Double)((ArrayList)object).get(1)) != null) {
                                d3 = d14;
                            }
                            if ((d15 = (Double)((ArrayList)object).get(2)) != null) {
                                d4 = d15;
                            }
                            if ((d16 = (Double)((ArrayList)object).get(3)) != null) {
                                d5 = d16;
                            }
                        }
                        if ((object = this.sesClient.getSendQuota()) != null) {
                            d6 = object.getMax24HourSend();
                            d9 = object.getMaxSendRate();
                            d8 = object.getSentLast24Hours();
                        }
                        if (this.ht_prev_sends != null && this.ht_prev_sends.containsKey(string2)) {
                            d = (Double)this.ht_prev_sends.get(string2);
                            double d17 = 0.0;
                            if (d != null) {
                                d17 = d;
                            }
                            d7 = d8 < d17 ? 0.0 : d8 - d17;
                        }
                        if (bl) {
                            d7 = -5.0;
                        }
                        double d18 = 0.0;
                        double d19 = 0.0;
                        double d20 = 0.0;
                        double d21 = 0.0;
                        if (d5 > 0.0) {
                            if (d2 >= 0.0) {
                                d19 = d2 / d5 * 100.0;
                            }
                            if (d4 >= 0.0) {
                                d20 = d4 / d5 * 100.0;
                            }
                            if (d3 >= 0.0) {
                                d21 = d3 / d5 * 100.0;
                            }
                        }
                        if (d8 >= 0.0 && d6 > 0.0) {
                            d18 = d8 / d6 * 100.0;
                        }
                        this.ht_prev_sends.put(string2, new Double(d8));
                        ArrayList<Double> arrayList3 = new ArrayList<Double>();
                        arrayList3.add(new Double(d6));
                        arrayList3.add(new Double(d8));
                        arrayList3.add(new Double(d7));
                        arrayList3.add(new Double(d18));
                        arrayList3.add(new Double(d9));
                        arrayList3.add(new Double(d2));
                        arrayList3.add(new Double(d19));
                        arrayList3.add(new Double(d3));
                        arrayList3.add(new Double(d21));
                        arrayList3.add(new Double(d4));
                        arrayList3.add(new Double(d20));
                        arrayList3.add(new Double(d5));
                        hashtable.put(string2, arrayList3);
                        continue;
                    }
                    catch (AmazonSimpleEmailServiceException amazonSimpleEmailServiceException) {
                        string = amazonSimpleEmailServiceException.getMessage().toLowerCase();
                        if (string.indexOf("request has expired") < 0 && string.indexOf("request is expired") < 0) continue;
                        this.cInfo.setErrorMsg(true);
                        throw amazonSimpleEmailServiceException;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (AmazonSimpleEmailServiceException amazonSimpleEmailServiceException) {
            String string = amazonSimpleEmailServiceException.getMessage().toLowerCase();
            if (string.indexOf("request has expired") >= 0 || string.indexOf("request is expired") >= 0) {
                this.cInfo.setErrorMsg(true);
                throw amazonSimpleEmailServiceException;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashtable;
    }

    protected ArrayList getLatestSendDatapoint(List list, Date date, Date date2) {
        ArrayList<Double> arrayList;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (list != null && list.size() > 0) {
            arrayList = null;
            for (int i = 0; i < list.size(); ++i) {
                SendDataPoint sendDataPoint = (SendDataPoint)list.get(i);
                Date date3 = sendDataPoint.getTimestamp();
                if ((!date3.after(date2) || !date3.before(date)) && !date3.equals(date2) && !date3.equals(date)) continue;
                l += sendDataPoint.getBounces().longValue();
                l2 += sendDataPoint.getComplaints().longValue();
                l3 += sendDataPoint.getRejects().longValue();
                l4 += sendDataPoint.getDeliveryAttempts().longValue();
            }
        }
        arrayList = new ArrayList<Double>();
        arrayList.add(new Double(l));
        arrayList.add(new Double(l2));
        arrayList.add(new Double(l3));
        arrayList.add(new Double(l4));
        return arrayList;
    }

    public boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string2.startsWith("*")) {
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        if (string.indexOf(string3 = string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2) != -1) {
            System.out.println(" [AWSAmazonSESTest] paternMatch true : " + string + " : " + string3);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
    }
}

