/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

class AWSClientApiBase {
    private CloudInfo cInfo = null;
    private String reportingName = "";
    private String serviceName = "";
    private static String sync = new String("awsapi");
    private String syncString = new String("aws");
    private static Hashtable syncStringHash = new Hashtable();
    private static Hashtable lastTimeHash = new Hashtable();
    private static Hashtable ht_AllServiceData = new Hashtable();
    String str_index = "";

    public AWSClientApiBase(CloudInfo cloudInfo) {
        this.cInfo = cloudInfo;
        if (cloudInfo != null) {
            this.reportingName = cloudInfo.getReportingName();
            this.serviceName = cloudInfo.getServiceName();
            String string = cloudInfo.getAWSAccessKey();
            this.str_index = this.reportingName + "#" + this.serviceName;
            if (this.serviceName.equalsIgnoreCase("ELB_Application") || this.serviceName.equalsIgnoreCase("ELB_Network")) {
                this.str_index = this.reportingName + "#AppNwELB";
            }
        }
    }

    public Hashtable getServiceData(String string) {
        Hashtable hashtable = new Hashtable();
        if (ht_AllServiceData != null && ht_AllServiceData.containsKey(string)) {
            hashtable = (Hashtable)ht_AllServiceData.get(string);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPerformanceData() {
        boolean bl = false;
        Hashtable hashtable = sync;
        synchronized (hashtable) {
            this.syncString = (String)syncStringHash.get(this.str_index);
            if (this.syncString == null) {
                this.syncString = new String(this.str_index);
                syncStringHash.put(this.str_index, this.syncString);
                lastTimeHash.put(this.str_index, new Long(0L));
            }
        }
        hashtable = this.syncString;
        synchronized (hashtable) {
            long l;
            long l2;
            long l3;
            long l4 = 0L;
            Long l5 = (Long)lastTimeHash.get(this.str_index);
            if (l5 != null) {
                l4 = l5;
            }
            if (!((double)(l3 = (l2 = System.currentTimeMillis()) - l4) >= 0.9 * (double)(l = this.cInfo.getMeasureTime()))) {
                bl = false;
                return true;
            }
            bl = true;
            lastTimeHash.put(this.str_index, new Long(System.currentTimeMillis()));
        }
        if (bl) {
            hashtable = this.getApiData();
            lastTimeHash.put(this.str_index, new Long(System.currentTimeMillis()));
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            ht_AllServiceData.put(this.str_index, hashtable);
        }
        return true;
    }

    private Hashtable getApiData() {
        try {
            String string = this.cInfo.getEc2RegionName();
            ArrayList arrayList = new ArrayList();
            if (string.equalsIgnoreCase("all")) {
                arrayList = CloudConstants.getAWSRegions();
            } else {
                arrayList.add(string);
            }
            if (arrayList == null || arrayList.size() == 0 || this.serviceName == null || this.serviceName.length() == 0) {
                return null;
            }
            int n = arrayList.size();
            Vector<AWSClientAPIRequestThread> vector = new Vector<AWSClientAPIRequestThread>();
            Hashtable hashtable = new Hashtable();
            int n2 = CloudConstants.maxCloudThreads;
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.length() <= 0) continue;
                ArrayList arrayList2 = this.cInfo.getExcludeRegion();
                boolean bl = false;
                if (arrayList2 != null && arrayList2.size() > 0) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        String string3 = (String)arrayList2.get(j);
                        if (string3 == null || !this.isPaternMatch(string2.toLowerCase(), string3.toLowerCase())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                try {
                    long l = System.currentTimeMillis();
                    long l2 = 2 * VmInfo.commandTimeOut * 1000;
                    long l3 = l - l2;
                    while (vector.size() >= n2) {
                        for (int j = 0; j < vector.size(); ++j) {
                            AWSClientAPIRequestThread aWSClientAPIRequestThread = (AWSClientAPIRequestThread)vector.get(j);
                            if (aWSClientAPIRequestThread.done) {
                                Hashtable hashtable2 = aWSClientAPIRequestThread.ht_outData;
                                if (hashtable2 != null) {
                                    hashtable.putAll(hashtable2);
                                }
                                vector.remove(j);
                                --j;
                                continue;
                            }
                            l = System.currentTimeMillis();
                            l3 = l - l2;
                            if (aWSClientAPIRequestThread.startTime >= l3) continue;
                            try {
                                aWSClientAPIRequestThread.interrupt();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            vector.remove(j);
                            --j;
                        }
                        if (vector.size() < n2) continue;
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                    AWSClientAPIRequestThread aWSClientAPIRequestThread = new AWSClientAPIRequestThread(string2, this.cInfo);
                    vector.add(aWSClientAPIRequestThread);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long l = 2 * VmInfo.commandTimeOut * 1000;
            while (vector.size() > 0) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                for (int i = 0; i < vector.size(); ++i) {
                    AWSClientAPIRequestThread aWSClientAPIRequestThread = (AWSClientAPIRequestThread)vector.get(i);
                    if (aWSClientAPIRequestThread.done) {
                        Hashtable hashtable3 = aWSClientAPIRequestThread.ht_outData;
                        if (hashtable3 != null) {
                            hashtable.putAll(hashtable3);
                        }
                        vector.remove(i);
                        --i;
                        continue;
                    }
                    if (aWSClientAPIRequestThread.startTime >= l5) continue;
                    try {
                        aWSClientAPIRequestThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    vector.remove(i);
                    --i;
                }
                if (vector == null || vector.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            return hashtable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string2.startsWith("*")) {
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        return string.indexOf(string3 = string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2) != -1;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage java AWSClientApiBase <AccessKey> <scretKey> <serviceName>");
            return;
        }
        CloudInfo cloudInfo = new CloudInfo("abc");
        String string = EgCrypt.decrypt((String)stringArray[0]);
        String string2 = EgCrypt.decrypt((String)stringArray[1]);
        cloudInfo.setAWSAccessKey(string);
        cloudInfo.setAWSSecretKey(string2);
        cloudInfo.setServiceName(stringArray[2]);
        AWSClientApiBase aWSClientApiBase = new AWSClientApiBase(cloudInfo);
        Hashtable hashtable = aWSClientApiBase.getApiData();
    }
}

