/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.services.cloudtrail.AWSCloudTrailClient;
import com.amazonaws.services.cloudtrail.model.AWSCloudTrailException;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.Trail;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AWSTrailS3Base {
    public static Hashtable ht_Trail_data = new Hashtable();
    private static String sync = new String("awss3");
    public String syncString = new String("aws");
    private static Hashtable syncStringHash = new Hashtable();
    private long lastTestRunTime = -1L;
    private boolean firstTime = true;
    private long lastTime = 0L;
    public static Hashtable ht_firstTimeHash = new Hashtable();
    public static Hashtable lastTrailS3UpdateTime = new Hashtable();
    public static Hashtable lastTimeHash = new Hashtable();
    private CloudInfo cInfo = null;
    CloudConnection cloudConn = null;
    private String reportingName = "";
    AmazonS3Client s3Client = null;
    AWSCloudTrailClient trailClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSTrailS3Base(CloudInfo cloudInfo, String string) {
        this.cInfo = cloudInfo;
        this.reportingName = string;
        String string2 = sync;
        synchronized (string2) {
            String string3 = (String)syncStringHash.get(string);
            if (string3 == null) {
                string3 = new String(string);
                syncStringHash.put(string, string3);
                ht_Trail_data.put(string, new Hashtable());
                lastTimeHash.put(string, new Long(0L));
                lastTrailS3UpdateTime.put(string, new Long(0L));
                ht_firstTimeHash.put(string, new Boolean(true));
            }
            this.syncString = (String)syncStringHash.get(string);
        }
    }

    public Hashtable getTrailData() {
        Hashtable hashtable = null;
        if (ht_Trail_data != null && ht_Trail_data.containsKey(this.reportingName)) {
            hashtable = (Hashtable)ht_Trail_data.get(this.reportingName);
        }
        if (hashtable != null) {
            return (Hashtable)hashtable.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectAWSTrailData() {
        String string = this.syncString;
        synchronized (string) {
            Long l = (Long)lastTimeHash.get(this.reportingName);
            if (l != null) {
                this.lastTime = l;
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.lastTime;
            long l4 = this.cInfo.getMeasureTime();
            boolean bl = false;
            bl = !((double)l3 >= 0.9 * (double)l4);
            if (!bl) {
                this.firstTime = (Boolean)ht_firstTimeHash.get(this.reportingName);
                if (this.firstTime) {
                    this.lastTestRunTime = System.currentTimeMillis();
                    System.out.println(this.reportingName + " AWSTrailS3Base it cum in first time lastTestRunTime : " + this.lastTestRunTime);
                    this.firstTime = false;
                    lastTrailS3UpdateTime.put(this.reportingName, new Long(this.lastTestRunTime));
                    lastTimeHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                    ht_firstTimeHash.put(this.reportingName, new Boolean(this.firstTime));
                    return true;
                }
                System.out.println(this.reportingName + " AWSTrailS3Base Start to collect event data : " + new Date());
                Hashtable hashtable = this.getData();
                if (hashtable != null) {
                    ht_Trail_data.put(this.reportingName, hashtable);
                }
                System.out.println(this.reportingName + " AWSTrailS3Base end to collect event data : " + new Date());
                lastTimeHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                lastTrailS3UpdateTime.put(this.reportingName, new Long(this.lastTestRunTime));
            }
        }
        return true;
    }

    private Hashtable getData() {
        try {
            String string;
            int n;
            String string2;
            int n2;
            long l = 0L;
            Long l2 = (Long)lastTrailS3UpdateTime.get(this.reportingName);
            if (l2 != null) {
                l = l2;
            }
            long l3 = System.currentTimeMillis();
            this.lastTestRunTime = l3 + 1L;
            Hashtable hashtable = new Hashtable();
            String string3 = this.cInfo.getEc2RegionName();
            ArrayList arrayList = this.cInfo.getExcludeRegion();
            LinkedList<String> linkedList = null;
            if (string3.equalsIgnoreCase("all")) {
                linkedList = new LinkedList(CloudConstants.getAWSRegions());
            } else {
                linkedList = new LinkedList<String>();
                linkedList.add(string3);
            }
            if (arrayList != null && arrayList.size() > 0) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string2 = (String)arrayList.get(n2);
                    if (string2 == null) continue;
                    for (n = 0; n < linkedList.size(); ++n) {
                        string = (String)linkedList.get(n);
                        if (!this.isPaternMatch(string.toLowerCase(), string2.toLowerCase())) continue;
                        linkedList.remove(n);
                    }
                }
            }
            if (linkedList == null || linkedList.size() == 0) {
                return null;
            }
            n2 = linkedList.size();
            string2 = this.cInfo.getAccessType();
            this.cloudConn = string2 != null && string2.equalsIgnoreCase("Role_Based") ? new RoleBasedCloudConnection(this.cInfo) : new AccessKeyBasedCloudConnection(this.cInfo);
            for (n = 0; n < n2; ++n) {
                block35: {
                    string = (String)linkedList.get(n);
                    if (string == null || string.equalsIgnoreCase("cn-northwest-1") || string.equalsIgnoreCase("cn-north-1")) continue;
                    Hashtable hashtable2 = new Hashtable();
                    if (string != null) {
                        this.trailClient = this.cloudConn.getAWSCloudTrailConnection(string);
                        if (this.trailClient != null) {
                            Object object;
                            String string4;
                            try {
                                DescribeTrailsRequest describeTrailsRequest = new DescribeTrailsRequest();
                                string4 = this.trailClient.describeTrails(describeTrailsRequest);
                                if (string4 == null) continue;
                                object = new ArrayList();
                                if (string4 == null) break block35;
                                object = string4.getTrailList();
                                if (object == null || object.size() == 0) {
                                    System.out.println(this.reportingName + " [AWSTrailS3Base] No Trail So it will continue for this region ==> " + string);
                                    continue;
                                }
                                for (int i = 0; i < object.size(); ++i) {
                                    Object object2;
                                    Object object3;
                                    Trail trail = (Trail)object.get(i);
                                    if (trail == null) continue;
                                    String string5 = trail.getCloudWatchLogsLogGroupArn();
                                    String string6 = trail.getCloudWatchLogsRoleArn();
                                    String string7 = trail.getKmsKeyId();
                                    Boolean bl = trail.getHasCustomEventSelectors();
                                    String string8 = trail.getHomeRegion();
                                    boolean bl2 = trail.getIsMultiRegionTrail();
                                    Boolean bl3 = trail.getLogFileValidationEnabled();
                                    String string9 = trail.getName();
                                    String string10 = trail.getS3BucketName();
                                    String string11 = trail.getS3KeyPrefix();
                                    String string12 = trail.getSnsTopicARN();
                                    String string13 = trail.getSnsTopicName();
                                    String string14 = trail.getTrailARN();
                                    Boolean bl4 = trail.getIsOrganizationTrail();
                                    String string15 = "";
                                    boolean bl5 = false;
                                    boolean bl6 = false;
                                    if (string14 != null && string14.toLowerCase().indexOf(string.toLowerCase()) >= 0) {
                                        bl6 = true;
                                    }
                                    System.out.println(this.reportingName + " [AWSTrailS3Base] isToCallTrailStatus = " + bl6);
                                    if (string9 != null && bl6) {
                                        try {
                                            boolean bl7;
                                            object3 = new GetTrailStatusRequest().withName(string9);
                                            object2 = this.trailClient.getTrailStatus((GetTrailStatusRequest)object3);
                                            if (object2 != null && (bl7 = object2.getIsLogging().booleanValue())) {
                                                bl5 = true;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (!bl5) continue;
                                    if (string14 != null && string14.indexOf(":") > 0) {
                                        object3 = string14.substring(0, string14.lastIndexOf(":"));
                                        string15 = ((String)object3).substring(((String)object3).lastIndexOf(":") + 1);
                                    }
                                    if (string10 == null) continue;
                                    this.s3Client = this.cloudConn.getAWSS3ConnectionWithoutUrl();
                                    object3 = new ArrayList();
                                    if (this.s3Client == null) continue;
                                    object2 = new Date();
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                                    String string16 = simpleDateFormat.format((Date)object2);
                                    ArrayList<String> arrayList2 = new ArrayList<String>();
                                    if (bl2) {
                                        arrayList2 = new ArrayList(linkedList);
                                    } else {
                                        arrayList2.add(string8);
                                    }
                                    if (arrayList2 == null || arrayList2.size() <= 0) continue;
                                    for (int j = 0; j < arrayList2.size(); ++j) {
                                        Object object4;
                                        String string17;
                                        String string18 = (String)arrayList2.get(j);
                                        String string19 = "";
                                        string19 = string11 != null ? string11 + "AWSLogs/" + string15 + "/CloudTrail/" + string18 + "/" + string16 : "AWSLogs/" + string15 + "/CloudTrail/" + string18 + "/" + string16;
                                        List list = new ArrayList();
                                        ArrayList arrayList3 = new ArrayList();
                                        try {
                                            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(string10).withPrefix(string19);
                                            string17 = this.s3Client.listObjects(listObjectsRequest);
                                            if (string17 != null) {
                                                list = string17.getObjectSummaries();
                                                while (string17.isTruncated()) {
                                                    string17 = this.s3Client.listNextBatchOfObjects((ObjectListing)string17);
                                                    list.addAll(string17.getObjectSummaries());
                                                }
                                            }
                                            if (list != null) {
                                                for (int k = 0; k < list.size(); ++k) {
                                                    Vector vector;
                                                    S3Object s3Object;
                                                    String string20;
                                                    S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)list.get(k);
                                                    String string21 = s3ObjectSummary.getKey();
                                                    Date date = s3ObjectSummary.getLastModified();
                                                    long l4 = date.getTime();
                                                    if (l > l4 || l3 <= l4 || (string20 = AWSTrailS3Base.displayTextInputStream((InputStream)(s3Object = this.s3Client.getObject(new GetObjectRequest(string10, string21))).getObjectContent())) == null || (vector = this.parseTrailData(string20)) == null) continue;
                                                    arrayList3.addAll(vector);
                                                }
                                                System.out.println(" ALL Events for Trail ==> " + arrayList3);
                                            }
                                            object4 = "";
                                            if (string9 != null && string18 != null) {
                                                object4 = string18 + ":" + string9;
                                            }
                                            if (object4 == null || arrayList3 == null) continue;
                                            hashtable.put(object4, arrayList3);
                                            continue;
                                        }
                                        catch (AmazonS3Exception amazonS3Exception) {
                                            string17 = amazonS3Exception.getMessage().toLowerCase();
                                            if (string17.indexOf("request has expired") < 0 && string17.indexOf("request is expired") < 0) continue;
                                            this.cInfo.setErrorMsg(true);
                                            object4 = this.getData();
                                            return object4;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            catch (AWSCloudTrailException aWSCloudTrailException) {
                                string4 = aWSCloudTrailException.getMessage().toLowerCase();
                                if (string4.indexOf("request has expired") >= 0 || string4.indexOf("request is expired") >= 0) {
                                    this.cInfo.setErrorMsg(true);
                                    object = this.getData();
                                    return object;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                this.cloudConn.disconnectWebClient((AmazonWebServiceClient)this.trailClient);
                this.cloudConn.disconnectWebClient((AmazonWebServiceClient)this.s3Client);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.cloudConn.disconnectWebClient((AmazonWebServiceClient)this.trailClient);
            this.cloudConn.disconnectWebClient((AmazonWebServiceClient)this.s3Client);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String displayTextInputStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(inputStream)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static Hashtable getKeyValuePair(Map map) {
        try {
            if (map == null || map.size() == 0) {
                return null;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Set set = map.keySet();
            if (set == null) {
                return null;
            }
            for (String string : set) {
                Cloneable cloneable;
                if (map.get(string) instanceof Integer || map.get(string) instanceof Long) {
                    long l = ((Number)map.get(string)).longValue();
                    hashtable.put(string, new Long(l));
                    continue;
                }
                if (map.get(string) instanceof Boolean) {
                    boolean bl = (Boolean)map.get(string);
                    hashtable.put(string, new Boolean(bl));
                    continue;
                }
                if (map.get(string) instanceof Float || map.get(string) instanceof Double) {
                    double d = ((Number)map.get(string)).doubleValue();
                    hashtable.put(string, new Double(d));
                    continue;
                }
                if (map.get(string) instanceof JSONObject) {
                    JSONObject jSONObject = (JSONObject)map.get(string);
                    cloneable = AWSTrailS3Base.getKeyValuePair((Map)jSONObject);
                    if (cloneable == null || ((Hashtable)cloneable).size() <= 0) continue;
                    hashtable.put(string, cloneable);
                    continue;
                }
                if (map.get(string) instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)map.get(string);
                    cloneable = new ArrayList();
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        Object object;
                        if (jSONArray.get(i) instanceof JSONObject) {
                            object = (JSONObject)jSONArray.get(i);
                            Hashtable hashtable2 = AWSTrailS3Base.getKeyValuePair((Map)object);
                            ((ArrayList)cloneable).add(hashtable2);
                            continue;
                        }
                        object = (String)jSONArray.get(i);
                        ((ArrayList)cloneable).add(object);
                    }
                    hashtable.put(string, cloneable);
                    continue;
                }
                String string2 = (String)map.get(string);
                if (string2 == null || string2.equalsIgnoreCase("null")) continue;
                hashtable.put(string, string2);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Vector parseTrailData(String string) {
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            Map map = AWSTrailS3Base.stringToJSON(string);
            Object var3_4 = null;
            JSONArray jSONArray = (JSONArray)map.get("Records");
            Iterator iterator = jSONArray.iterator();
            Map map2 = null;
            Vector<Hashtable> vector = new Vector<Hashtable>();
            while (iterator.hasNext()) {
                map2 = (Map)iterator.next();
                Hashtable hashtable = AWSTrailS3Base.getKeyValuePair(map2);
                vector.add(hashtable);
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Map stringToJSON(String string) {
        JSONParser jSONParser = new JSONParser();
        Object object = null;
        try {
            object = jSONParser.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return (JSONObject)object;
    }

    private boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string2.startsWith("*")) {
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        return string.indexOf(string3 = string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2) != -1;
    }

    public static void main(String[] stringArray) {
        System.out.println("Hello World!");
    }
}

