/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class CloudEc2Helper {
    private static CloudEc2Helper helper = null;
    private static Hashtable htInstanceCacheLastTime = new Hashtable();
    private static Hashtable htInstanceCache = new Hashtable();
    private static Hashtable htEBSVloumeCache = new Hashtable();

    private CloudEc2Helper() {
    }

    public static synchronized CloudEc2Helper getCloudEc2Helper() {
        if (helper == null) {
            helper = new CloudEc2Helper();
        }
        return helper;
    }

    public ArrayList getRegionDetails(CloudInfo cloudInfo) {
        CloudRegionDetails cloudRegionDetails = new CloudRegionDetails(cloudInfo);
        ArrayList arrayList = cloudRegionDetails.getRegions();
        return arrayList;
    }

    public Hashtable getInstanceDetails(CloudInfo cloudInfo, ArrayList arrayList) {
        CloudRegionDetails cloudRegionDetails = new CloudRegionDetails(cloudInfo);
        Hashtable hashtable = cloudRegionDetails.getInstanceData();
        return hashtable;
    }

    public Hashtable getEBSVolumeData(CloudInfo cloudInfo, ArrayList arrayList) {
        CloudRegionDetails cloudRegionDetails = new CloudRegionDetails(cloudInfo);
        Hashtable hashtable = cloudRegionDetails.getVolumeData();
        return hashtable;
    }

    public boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string2.startsWith("*")) {
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        if (string.indexOf(string3 = string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2) != -1) {
            System.out.println(" [CloudEC2Helper] paternMatch true : " + string + " : " + string3);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Format should be CloudEc2Helper <Accesskey> <secretkey> <regionName>");
            return;
        }
        CloudEc2Helper cloudEc2Helper = CloudEc2Helper.getCloudEc2Helper();
        CloudInfo cloudInfo = new CloudInfo("XXXX");
        cloudInfo.setAWSAccessKey(stringArray[0]);
        cloudInfo.setAWSSecretKey(stringArray[1]);
        cloudInfo.setEc2RegionName(stringArray[2]);
        ArrayList arrayList = cloudEc2Helper.getRegionDetails(cloudInfo);
        Hashtable hashtable = cloudEc2Helper.getInstanceDetails(cloudInfo, arrayList);
        System.out.println(" CloudEc2Helper instance details =" + hashtable);
    }
}

