/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.IPV6Helper;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainerUtils;
import com.eg.apm.KubernetesAPI;
import com.egurkha.util.EgUtilities;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DockerHelper {
    private static DockerHelper helper = null;
    private static Hashtable htPausedContainer = new Hashtable();
    private static Hashtable htTotalContainers = new Hashtable();
    private static Hashtable htRunningContainers = new Hashtable();
    private static Hashtable htCrashedContainers = new Hashtable();
    private static Hashtable htRunningContainersToRunCmd = new Hashtable();
    private static Hashtable ht_ContainerIdNameMapping = new Hashtable();
    private static Hashtable htImageDetails = new Hashtable();
    private static Hashtable htCacheLastTime = new Hashtable();
    public static Hashtable ht_RunningContainerInfo = new Hashtable();
    public static Hashtable ht_RunningContainerInfoLastUpdated = new Hashtable();
    public static Hashtable ht_RunningTopContainerInfoLastUpdated = new Hashtable();
    public static Hashtable ht_RunningContainerTopData = new Hashtable();
    public static Hashtable ht_RunningDockContainerInfoLastUpdated = new Hashtable();
    public static Hashtable ht_RunningDockContainerData = new Hashtable();
    public static ArrayList processingHost = new ArrayList();
    public static Hashtable ht_InfoDetails = new Hashtable();
    public static Hashtable ht_InfoLastUpdated = new Hashtable();
    public static Hashtable ht_VersionDetails = new Hashtable();
    public static Hashtable ht_VersionLastUpdated = new Hashtable();
    public static Hashtable ht_ContainerPodIpMap = new Hashtable();
    public static Hashtable ht_ContainerPodIpMapUpdatedTime = new Hashtable();
    public static long podIpCacheTime = 10800000L;
    private static long cachePeriod = EgConfigInfo.msecPerMin * 3L;
    private DockerInfo info = null;
    public String reportingName = "";
    public String syncString = "";
    public static String globalSync = "Docker";
    private static Hashtable syncStringHash = new Hashtable();
    private static final String logDispStr = "";
    private static Hashtable htRunContainerFullId = new Hashtable();
    private static Hashtable ht_dockerCmdData = new Hashtable();
    private static Hashtable ht_dockerLastUpdated = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerHelper(DockerInfo dockerInfo) {
        this.info = dockerInfo;
        this.reportingName = dockerInfo.reportingName;
        String string = globalSync;
        synchronized (string) {
            this.syncString = (String)syncStringHash.get(this.reportingName);
            if (this.syncString == null) {
                this.syncString = new String(this.reportingName);
                syncStringHash.put(this.reportingName, this.syncString);
            }
            this.syncString = (String)syncStringHash.get(this.reportingName);
        }
    }

    public Hashtable getImagesWithContainers() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)htImageDetails.get(this.reportingName);
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.clone();
    }

    public Hashtable getContainerIdNameMap() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)ht_ContainerIdNameMapping.get(this.reportingName);
        return hashtable;
    }

    public Hashtable getRunningContainers() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)htRunningContainers.get(this.reportingName);
        return hashtable;
    }

    public Hashtable getRunningContainersToRunCommand() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)htRunningContainersToRunCmd.get(this.reportingName);
        return hashtable;
    }

    public Hashtable getPausedContainers() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)htPausedContainer.get(this.reportingName);
        return hashtable;
    }

    public Hashtable getCrashedContainers() {
        this.getAllContainers();
        Hashtable hashtable = (Hashtable)htCrashedContainers.get(this.reportingName);
        return hashtable;
    }

    public Hashtable getAllContainers() {
        long l;
        Long l2 = (Long)htCacheLastTime.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod || processingHost.contains(this.reportingName)) {
            Hashtable hashtable = (Hashtable)htTotalContainers.get(this.reportingName);
            return hashtable;
        }
        if (!processingHost.contains(this.reportingName)) {
            processingHost.add(this.reportingName);
        }
        DockerHelperThread dockerHelperThread = new DockerHelperThread(this);
        Hashtable hashtable = (Hashtable)htTotalContainers.get(this.reportingName);
        processingHost.remove(this.reportingName);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContainerDetails() {
        try {
            ArrayList arrayList;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = new Hashtable();
            Hashtable<String, ArrayList<String>> hashtable4 = new Hashtable<String, ArrayList<String>>();
            Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
            Hashtable hashtable6 = new Hashtable();
            Hashtable hashtable7 = new Hashtable();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = "docker ps -a -s";
            if (this.info.isItPodMan()) {
                string = "podman ps -a -s --pod";
            }
            if (this.info.isSudo()) {
                string = "sudo " + string;
            }
            if ((arrayList = this.executeCommand(string)) == null || arrayList.size() == 0) {
                System.out.println(this.reportingName + " [DockerHelper] " + string + "\toutput is null so return  ");
                return;
            }
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            String string2 = logDispStr;
            String string3 = logDispStr;
            String string4 = logDispStr;
            String string5 = logDispStr;
            String string6 = logDispStr;
            String string7 = logDispStr;
            String string8 = logDispStr;
            String string9 = logDispStr;
            String string10 = logDispStr;
            String string11 = logDispStr;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string12 = (String)arrayList.get(i);
                if (string12 == null) continue;
                if (string12.indexOf("CONTAINER ID") >= 0) {
                    n2 = string12.indexOf("CONTAINER ID");
                    n3 = string12.indexOf("IMAGE");
                    n4 = string12.indexOf("COMMAND");
                    n5 = string12.indexOf("CREATED");
                    n6 = string12.indexOf("STATUS");
                    n7 = string12.indexOf("PORTS");
                    n8 = string12.indexOf("NAMES");
                    n9 = string12.indexOf("SIZE");
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                Hashtable<String, String> hashtable8 = new Hashtable<String, String>();
                string2 = string12.substring(n2, n3 - 1).trim();
                string4 = string12.substring(n3, n4 - 1).trim();
                string5 = string12.substring(n4, n5 - 1).trim();
                string6 = string12.substring(n5, n6 - 1).trim();
                string8 = string12.substring(n6, n7 - 1).trim();
                string9 = string12.substring(n7, n8 - 1).trim();
                string10 = string12.substring(n8, n9 - 1).trim();
                string11 = string12.substring(n9).trim();
                string3 = string2 != null && string2.length() >= 12 ? string2.substring(0, 12) : string2;
                hashtable8.put("Image", string4);
                hashtable8.put("Command", string5);
                hashtable8.put("Created", string6);
                hashtable8.put("Status", string8);
                hashtable8.put("Port", string9);
                hashtable8.put("Names", string10);
                hashtable8.put("Size", string11);
                hashtable5.put(string3, string10);
                if (string8 != null) {
                    if (string8.toLowerCase().indexOf("pause") >= 0) {
                        hashtable6.put(string3, hashtable8);
                    } else if (string8.toLowerCase().indexOf("up") >= 0) {
                        hashtable2.put(string3, hashtable8);
                        if (string5 == null || !string5.trim().equalsIgnoreCase("\"/pause\"")) {
                            hashtable7.put(string3, hashtable8);
                            arrayList2.add(string2);
                        }
                    } else {
                        hashtable3.put(string3, hashtable8);
                    }
                }
                if (string4 != null) {
                    ArrayList<String> arrayList3;
                    if (hashtable4.containsKey(string4)) {
                        arrayList3 = (ArrayList<String>)hashtable4.get(string4);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<String>();
                        }
                        if (!arrayList3.contains(string10)) {
                            arrayList3.add(string10);
                        }
                        hashtable4.put(string4, arrayList3);
                    } else {
                        arrayList3 = new ArrayList<String>();
                        arrayList3.add(string10);
                        hashtable4.put(string4, arrayList3);
                    }
                }
                hashtable.put(string3, hashtable8);
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                htRunContainerFullId.put(this.reportingName, arrayList2);
            }
            this.performCache(hashtable5, ht_ContainerIdNameMapping);
            this.performCache(hashtable, htTotalContainers);
            this.performCache(hashtable2, htRunningContainers);
            this.performCache(hashtable7, htRunningContainersToRunCmd);
            this.performCache(hashtable3, htCrashedContainers);
            this.performCache(hashtable4, htImageDetails);
            this.performCache(hashtable6, htPausedContainer);
            String string13 = this.syncString;
            synchronized (string13) {
                long l = System.currentTimeMillis();
                htCacheLastTime.put(this.reportingName, new Long(l));
            }
        }
        catch (Exception exception) {
            AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getRunningContainersData() {
        Hashtable hashtable;
        String string;
        Object object;
        int n;
        int n2;
        long l;
        Long l2 = (Long)ht_RunningContainerInfoLastUpdated.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod) {
            Hashtable hashtable2 = (Hashtable)ht_RunningContainerInfo.get(this.reportingName);
            return hashtable2;
        }
        int n3 = EgMainAgent.maxDockerThreads;
        Hashtable hashtable3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
        if (this.info != null) {
            hashtable3 = this.getRunningContainers();
        }
        if (hashtable3 != null && hashtable3.size() > 0) {
            int n4 = hashtable3.size();
            n2 = 10;
            int n5 = 1;
            n = 0;
            object = hashtable3.keys();
            string = logDispStr;
            while (object.hasMoreElements()) {
                String string2;
                String string3 = (String)object.nextElement();
                ++n;
                if (string3 == null) {
                    if (n5 == n2) {
                        arrayList.add(string);
                        string = logDispStr;
                        n5 = 1;
                    }
                    if (n != n4 || n5 == n2) continue;
                    arrayList.add(string);
                    continue;
                }
                Hashtable hashtable6 = (Hashtable)hashtable3.get(string3);
                if (hashtable6 == null) continue;
                String string4 = null;
                if (n5 <= n2) {
                    string = n5 == 1 ? string3 : string + " " + string3;
                    ++n5;
                }
                if (n5 == n2) {
                    arrayList.add(string);
                    string = logDispStr;
                    n5 = 1;
                }
                if (n == n4 && n5 != n2) {
                    arrayList.add(string);
                }
                if (hashtable6.containsKey("Names")) {
                    string4 = (String)hashtable6.get("Names");
                    if (string4 == null) continue;
                    hashtable4.put(string3, string4);
                }
                if (!hashtable6.containsKey("Command") || (string2 = (String)hashtable6.get("Command")) == null) continue;
                if ((string2 = string2.trim()).startsWith("\"") && string2.endsWith("\"")) {
                    string2.substring(1, string2.length() - 1);
                }
                hashtable5.put(string3, string2);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<DockerThread> arrayList3 = new ArrayList<DockerThread>();
            n2 = arrayList.size();
            String string5 = "docker inspect --format=\"{{.Name}}#@#{{.State.StartedAt}}#@#{{.RestartCount}}#@#{{.NetworkSettings.Ports}}#@#{{.Config.Labels}}#@#{{.NetworkSettings.IPAddress}}#@#{{range.NetworkSettings.Networks}}{{.IPAddress}}{{end}}#@#{{.Id}}#@#{{.Config.Cmd}}#@#{{.Config.Env}}#@#{{.Config.Image}}#@#{{.Config.Entrypoint}}#@#{{.HostConfig.PortBindings}}\"  ";
            if (this.info.isItPodMan()) {
                string5 = "podman inspect --format=\"{{.Name}}#@#{{.State.StartedAt}}#@#{{.NetworkSettings.Ports}}#@#{{.Config.Labels}}#@#{{.NetworkSettings.IPAddress}}#@#{{.Id}}#@#{{.Config.Cmd}}#@#{{.Config.Env}}#@#{{.Config.Image}}#@#{{.Config.Entrypoint}}#@#{{.HostConfig.PortBindings}}\"  ";
            }
            if (this.info.isSudo()) {
                string5 = "sudo " + string5;
            }
            for (n = 0; n < n2; ++n) {
                object = (String)arrayList.get(n);
                if (object == null) continue;
                string = string5 + (String)object;
                long l5 = System.currentTimeMillis();
                long l6 = 2 * VmInfo.commandTimeOut * 1000;
                long l7 = l5 - l6;
                while (arrayList3.size() >= n3) {
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        DockerThread dockerThread = (DockerThread)arrayList3.get(i);
                        if (dockerThread.isDone()) {
                            ArrayList arrayList4 = dockerThread.getOutput();
                            if (arrayList4 != null && arrayList4.size() > 0) {
                                arrayList2.addAll(arrayList4);
                            }
                            arrayList3.remove(i--);
                            continue;
                        }
                        l5 = System.currentTimeMillis();
                        l7 = l5 - l6;
                        if (dockerThread.startTime >= l7) continue;
                        try {
                            dockerThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList3.remove(i);
                        --i;
                    }
                    if (arrayList3.size() < n3) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                DockerThread dockerThread = new DockerThread(this, string);
                arrayList3.add(dockerThread);
            }
            long l8 = 2 * VmInfo.commandTimeOut * 1000;
            while (arrayList3.size() > 0) {
                long l9 = System.currentTimeMillis();
                long l10 = l9 - l8;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    DockerThread dockerThread = (DockerThread)arrayList3.get(i);
                    if (dockerThread.isDone()) {
                        ArrayList arrayList5 = dockerThread.getOutput();
                        if (arrayList5 != null && arrayList5.size() > 0) {
                            arrayList2.addAll(arrayList5);
                        }
                        arrayList3.remove(i);
                        --i;
                        continue;
                    }
                    if (dockerThread.startTime >= l10) continue;
                    try {
                        dockerThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList3.remove(i);
                    --i;
                }
                if (arrayList3 == null || arrayList3.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        if ((hashtable = this.getRunningContainerUptime(arrayList2, hashtable4, hashtable5)) != null) {
            this.performCache(hashtable, ht_RunningContainerInfo);
        }
        l3 = System.currentTimeMillis();
        String string6 = this.syncString;
        synchronized (string6) {
            ht_RunningContainerInfoLastUpdated.put(this.reportingName, new Long(l3));
        }
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            AgentLogger.bgTaskLogger.trace("{} getRunningContainersData() al_runningContainersData {} ", (Object)logDispStr, arrayList2);
            AgentLogger.bgTaskLogger.trace("{} getRunningContainersData() ht_ContainerNameIdMapping {} ", (Object)logDispStr, hashtable4);
            AgentLogger.bgTaskLogger.trace("{} getRunningContainersData() ht_RunningContainerInfo {} ", (Object)logDispStr, (Object)ht_RunningContainerInfo);
        }
        return hashtable;
    }

    public Hashtable getRunningContainerUptime(ArrayList arrayList, Hashtable hashtable, Hashtable hashtable2) {
        String string;
        Object object;
        String string2;
        Object object2;
        Object object3;
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            AgentLogger.bgTaskLogger.trace("{} getRunningContainerUptime() output : {} ht_ContainerNameIdMap  {} ", new Object[]{logDispStr, arrayList, hashtable});
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Hashtable<Object, Object> hashtable3 = new Hashtable<Object, Object>();
        for (int i = 0; i < n; ++i) {
            String string3;
            int n2;
            int n3;
            StringTokenizer stringTokenizer;
            Hashtable hashtable4;
            String string4;
            StringTokenizer stringTokenizer2;
            int n4;
            StringTokenizer stringTokenizer3;
            int n5;
            Object object4;
            String string5;
            object3 = (String)arrayList.get(i);
            if (object3 == null) continue;
            object2 = this.egTokenizer((String)object3, "#@#");
            AgentLogger.bgTaskLogger.trace("{} getRunningContainerUptime() al_tokens.size() : {} ", (Object)logDispStr, (Object)((ArrayList)object2).size());
            if (object2 == null || ((ArrayList)object2).size() < 6) continue;
            string2 = null;
            object = logDispStr;
            string = null;
            String string6 = logDispStr;
            String string7 = (String)((ArrayList)object2).get(0);
            string7 = string7.trim();
            if ((string7 = string7.substring(1)).startsWith("/")) {
                object = string7.substring(1);
            }
            String string8 = (String)((ArrayList)object2).get(1);
            String string9 = logDispStr;
            String string10 = logDispStr;
            String string11 = logDispStr;
            String string12 = logDispStr;
            String string13 = logDispStr;
            String string14 = logDispStr;
            String string15 = logDispStr;
            String string16 = logDispStr;
            if (!this.info.isItPodMan()) {
                string10 = (String)((ArrayList)object2).get(2);
                string11 = (String)((ArrayList)object2).get(3);
                string12 = (String)((ArrayList)object2).get(4);
                string13 = (String)((ArrayList)object2).get(5);
                string9 = (String)((ArrayList)object2).get(6);
                string2 = (String)((ArrayList)object2).get(7);
                if (string2 != null && string2.length() >= 12) {
                    string2 = string2.substring(0, 12);
                }
                if (((ArrayList)object2).size() >= 9) {
                    string14 = (String)((ArrayList)object2).get(8);
                }
                if (((ArrayList)object2).size() >= 11) {
                    string6 = (String)((ArrayList)object2).get(9);
                    string15 = (String)((ArrayList)object2).get(10);
                }
                if (((ArrayList)object2).size() >= 12 && (string5 = (String)((ArrayList)object2).get(11)) != null && !string5.trim().contains("<no value>")) {
                    string14 = string14 != null && string14.trim().contains("<no value>") || string14 == null || string14.length() <= 0 ? string5.trim() : string14 + " " + string5.trim();
                }
                if (((ArrayList)object2).size() >= 13) {
                    string16 = (String)((ArrayList)object2).get(12);
                }
            } else {
                string11 = (String)((ArrayList)object2).get(2);
                string12 = (String)((ArrayList)object2).get(3);
                string13 = (String)((ArrayList)object2).get(4);
                string2 = (String)((ArrayList)object2).get(5);
                if (string2 != null && string2.length() >= 12) {
                    string2 = string2.substring(0, 12);
                }
                if (((ArrayList)object2).size() >= 7) {
                    string14 = (String)((ArrayList)object2).get(6);
                }
                if (((ArrayList)object2).size() >= 9) {
                    string6 = (String)((ArrayList)object2).get(7);
                    string15 = (String)((ArrayList)object2).get(8);
                }
                if (((ArrayList)object2).size() >= 10) {
                    string16 = (String)((ArrayList)object2).get(9);
                }
            }
            if (string13 != null && string13.length() > 0) {
                if ((string13 = string13.trim()).equals("\"")) {
                    string13 = logDispStr;
                }
                if (string13.startsWith("\"")) {
                    string13 = string13.substring(1);
                }
                if (string13.endsWith("\"")) {
                    string13 = string13.substring(0, string13.length() - 1);
                }
            } else if (string9 != null && string9.length() > 0) {
                if ((string9 = string9.trim()).startsWith("\"")) {
                    string9 = string9.substring(1);
                }
                if (string9.endsWith("\"")) {
                    string9 = string9.substring(0, string9.length() - 1);
                }
                string13 = string9;
            }
            string5 = logDispStr;
            try {
                if (string8 != null) {
                    string8 = string8.trim();
                    int n6 = string8.lastIndexOf(".");
                    object4 = string8.substring(0, n6 + 4);
                    int n7 = 0;
                    String string17 = logDispStr;
                    if (!this.info.isItPodMan()) {
                        n7 = string8.indexOf("Z");
                        string17 = string8.substring(n7);
                    }
                    string5 = (String)object4 + string17;
                }
                if (string10 != null) {
                    string10 = string10.trim();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            AgentLogger.bgTaskLogger.trace("{} strContainerId : {} al_contAplictn  : {} ", new Object[]{logDispStr, string2, string14});
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (string14 != null && string14.length() > 0 && string14.trim().startsWith("[") && (n5 = (stringTokenizer3 = new StringTokenizer((String)(object4 = string14.substring(1, string14.length() - 1)))).countTokens()) > 0) {
                while (stringTokenizer3.hasMoreTokens()) {
                    String string18 = stringTokenizer3.nextToken();
                    arrayList3.add(string18);
                }
            }
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                AgentLogger.bgTaskLogger.trace("{} strContainerId : {} docker inspect results : {} ", new Object[]{logDispStr, string2, object3});
            }
            object4 = new ArrayList();
            if (string6 != null && string6.length() > 0 && string6.trim().startsWith("[") && (n4 = (stringTokenizer2 = new StringTokenizer(string4 = string6.substring(1, string6.length() - 1))).countTokens()) > 0) {
                while (stringTokenizer2.hasMoreTokens()) {
                    String string19 = stringTokenizer2.nextToken();
                    ((ArrayList)object4).add(string19);
                }
            }
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            if (string16 != null && string16.length() > 0) {
                StringTokenizer stringTokenizer4;
                int n8;
                if (string16.trim().startsWith("map[")) {
                    StringTokenizer stringTokenizer5;
                    int n9;
                    if (string16.length() > 4 && (n9 = (stringTokenizer5 = new StringTokenizer(string16 = string16.substring(4, string16.length() - 1), ":")).countTokens()) > 1) {
                        for (int j = 0; j < n9; ++j) {
                            hashtable4 = stringTokenizer5.nextToken();
                            if (hashtable4 == null || ((String)((Object)hashtable4)).indexOf("/") <= 0) continue;
                            hashtable4 = ((String)((Object)hashtable4)).substring(0, ((String)((Object)hashtable4)).indexOf("/"));
                            stringTokenizer = new StringTokenizer((String)((Object)hashtable4));
                            n3 = stringTokenizer.countTokens();
                            System.out.println("[DockerHelper] portbindings port =" + (String)((Object)hashtable4) + "\tcountToks2 =" + n3);
                            if (n3 > 1) {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    string3 = stringTokenizer.nextToken();
                                    if (n2 != n3 - 1 || arrayList4.contains(string3)) continue;
                                    arrayList4.add(string3);
                                }
                                continue;
                            }
                            if (arrayList4.contains(hashtable4)) continue;
                            arrayList4.add(hashtable4);
                        }
                    }
                } else if (string16.trim().startsWith("[{") && (n8 = (stringTokenizer4 = new StringTokenizer(string16 = string16.substring(2, string16.length() - 1), " ")).countTokens()) > 0) {
                    for (int j = 0; j < n8; ++j) {
                        hashtable4 = stringTokenizer4.nextToken();
                        try {
                            double d = Double.parseDouble((String)((Object)hashtable4));
                            if (arrayList4.contains(hashtable4)) continue;
                            arrayList4.add(hashtable4);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (string11 != null && string11.length() > 0) {
                StringTokenizer stringTokenizer6;
                int n10;
                if (string11.trim().startsWith("map[")) {
                    StringTokenizer stringTokenizer7;
                    int n11;
                    if (string11.length() > 4 && (n11 = (stringTokenizer7 = new StringTokenizer(string11 = string11.substring(4, string11.length() - 1), ":")).countTokens()) > 1) {
                        for (int j = 0; j < n11; ++j) {
                            hashtable4 = stringTokenizer7.nextToken();
                            if (hashtable4 == null || ((String)((Object)hashtable4)).indexOf("/") <= 0) continue;
                            hashtable4 = ((String)((Object)hashtable4)).substring(0, ((String)((Object)hashtable4)).indexOf("/"));
                            stringTokenizer = new StringTokenizer((String)((Object)hashtable4));
                            n3 = stringTokenizer.countTokens();
                            System.out.println("[DockerHelper] port =" + (String)((Object)hashtable4) + "\tcountToks2 =" + n3);
                            if (n3 > 1) {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    string3 = stringTokenizer.nextToken();
                                    if (n2 != n3 - 1 || arrayList4.contains(string3)) continue;
                                    arrayList4.add(string3);
                                }
                                continue;
                            }
                            if (arrayList4.contains(hashtable4)) continue;
                            arrayList4.add(hashtable4);
                        }
                    }
                } else if (string11.trim().startsWith("[{") && (n10 = (stringTokenizer6 = new StringTokenizer(string11 = string11.substring(2, string11.length() - 1), " ")).countTokens()) > 0) {
                    for (int j = 0; j < n10; ++j) {
                        hashtable4 = stringTokenizer6.nextToken();
                        try {
                            double d = Double.parseDouble((String)((Object)hashtable4));
                            if (arrayList4.contains(hashtable4)) continue;
                            arrayList4.add(hashtable4);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (string2 != null) {
                Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
                hashtable5.put("Names", object);
                if (string5 != null) {
                    hashtable5.put("StartedAt", string5);
                }
                if (string10 != null) {
                    hashtable5.put("RestartCount", string10);
                }
                if (string13 != null) {
                    hashtable5.put("IPAddress", string13.trim());
                }
                if (arrayList4 != null) {
                    hashtable5.put("ContainerPort", arrayList4);
                }
                if (arrayList3 != null && arrayList3.size() > 0) {
                    hashtable5.put("ContainerAppStartCmd", arrayList3);
                }
                if (object4 != null && ((ArrayList)object4).size() > 0) {
                    hashtable5.put("ContainerEnv", object4);
                }
                if (string15 != null) {
                    hashtable5.put("ContainerImage", string15);
                }
                hashtable5.put("containerId", string2);
                hashtable3.put(string2, hashtable5);
            }
            if (!((String)object).toLowerCase().startsWith("k8s_")) continue;
            String string20 = logDispStr;
            String string21 = logDispStr;
            String string22 = logDispStr;
            try {
                if (string12 != null && (string12 = string12.trim()).startsWith("map[") && string12.endsWith("]")) {
                    string12 = string12.substring(4, string12.length() - 1);
                    hashtable4 = new StringTokenizer(string12);
                    while (((StringTokenizer)((Object)hashtable4)).hasMoreTokens()) {
                        int n12;
                        String string23;
                        String string24;
                        String string25 = ((StringTokenizer)((Object)hashtable4)).nextToken();
                        if (string25 == null || string25.indexOf(":") <= 0) continue;
                        n3 = string25.indexOf(":");
                        String string26 = string25.substring(0, n3);
                        string3 = string25.substring(n3 + 1);
                        if (string26.equalsIgnoreCase("io.kubernetes.pod.name")) {
                            string20 = string3;
                        }
                        if (string26.equalsIgnoreCase("annotation.io.kubernetes.container.ports") && (string24 = string3) != null && string24.indexOf("\"containerPort\":") >= 0 && (string23 = string24.substring((n12 = string24.indexOf("\"containerPort\":")) + 16)) != null && string23.indexOf(",") > 0) {
                            string21 = string23.substring(0, string23.indexOf(","));
                        }
                        if (string26.equalsIgnoreCase("annotation.io.kubernetes.pod.namespace")) {
                            string = string3;
                        }
                        if (string != null && string.length() > 0 || !string26.equalsIgnoreCase("io.kubernetes.pod.namespace")) continue;
                        string = string3;
                    }
                }
                if (string2 != null) {
                    if (hashtable3 != null && hashtable3.containsKey(string2)) {
                        hashtable4 = (Hashtable)hashtable3.get(string2);
                        if (hashtable4 == null) {
                            hashtable4 = new Hashtable();
                        }
                        if (string21 != null && string21.length() > 0 && (arrayList4 == null || arrayList4.size() == 0)) {
                            arrayList4 = new ArrayList();
                            arrayList4.add(string21);
                            hashtable4.put("ContainerPort", arrayList4);
                        }
                        if (string20 != null && string20.length() > 0) {
                            hashtable4.put("podName", string20);
                        }
                        hashtable3.put(string2, hashtable4);
                        if (hashtable4.containsKey("Command")) {
                            string22 = (String)hashtable4.get("Command");
                        }
                        if (string != null && string.length() > 0) {
                            hashtable4.put("nameSpace", string);
                        }
                        if (string20 != null && string2 != null && string != null && string.length() > 0) {
                            KubernetesAPI kubernetesAPI = KubernetesAPI.createInstance();
                            String string27 = kubernetesAPI.getPodIp(string, string20);
                            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                                AgentLogger.bgTaskLogger.trace("{} getRunningContainerUptime()  KubernetesAPI.getPodIp() {} : {} - {}", new Object[]{logDispStr, string, string20, string27});
                            }
                            if (string27 != null && string27.length() > 0) {
                                hashtable4.put("IPAddress", string27);
                                hashtable4.put("PodIPAddr", string27);
                            }
                        }
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            AgentLogger.bgTaskLogger.trace("{} getRunningContainerUptime()  {} : {} ", new Object[]{logDispStr, string2, hashtable4});
                        }
                    }
                    if (hashtable2 != null) {
                        string22 = (String)hashtable2.get(string2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string13 != null && (string13.length() != 0 || string2 == null) || string22 != null && string22.trim().equalsIgnoreCase("\"/pause\"")) continue;
            arrayList2.add(string2);
        }
        Hashtable hashtable6 = this.getKubePodIpDetails(arrayList2);
        if (hashtable6 != null && hashtable6.size() > 0) {
            object3 = hashtable6.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (object2 == null || (string2 = (String)hashtable6.get(object2)) == null || hashtable3 == null || !hashtable3.containsKey(object2)) continue;
                object = (Hashtable)hashtable3.get(object2);
                if (object == null) {
                    object = new Hashtable<String, String>();
                }
                ((Hashtable)object).put("PodIPAddr", string2);
                string = (String)((Hashtable)object).get("IPAddress");
                if (string == null || string.length() <= 0) {
                    ((Hashtable)object).put("IPAddress", string2);
                }
                hashtable3.put(object2, object);
            }
        }
        AgentLogger.bgTaskLogger.debug("{} getRunningContainerUptime() ht_data {} ", (Object)logDispStr, hashtable3);
        return hashtable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCache(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable != null) {
            String string = this.syncString;
            synchronized (string) {
                hashtable2.put(this.reportingName, hashtable);
            }
        }
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0 || this.info == null) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            if (this.info.isItAgentLessComp()) {
                EgJavaSSH egJavaSSH = new EgJavaSSH(this.info.getDockerIp(), this.info.getSshPort(), this.info.getSshUser(), this.info.getSshPass(), this.info.getEncryptionType(), this.info.getKeyFile(), this.info.getTimeout());
                arrayList2 = egJavaSSH.executeCommand(string);
            } else {
                EgUtilities egUtilities = EgUtilities.createInstance();
                arrayList2 = egUtilities.getExecOutputLines(string);
            }
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Excepiton  occured in DockerHelper while calling executeCommand " + string + "\tfor " + this.info.getDockerIp() + "\tdata =" + arrayList2);
            AgentLogger.bgTaskLogger.warn("{} exception {} : {}", new Object[]{logDispStr, string, exception});
            exception.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTopContainers() {
        Cloneable cloneable;
        long l;
        Long l2 = (Long)ht_RunningTopContainerInfoLastUpdated.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod) {
            Hashtable hashtable = (Hashtable)ht_RunningContainerTopData.get(this.reportingName);
            return hashtable;
        }
        int n = EgMainAgent.maxDockerThreads;
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (this.info != null) {
            hashtable = this.getRunningContainersToRunCommand();
        }
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        if (hashtable != null && hashtable.size() > 0) {
            long l5;
            cloneable = new ArrayList();
            int n2 = hashtable.size();
            int n3 = 10;
            boolean bl = true;
            int n4 = 0;
            Enumeration enumeration = hashtable.keys();
            String string = logDispStr;
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable3;
                String string2 = (String)enumeration.nextElement();
                ++n4;
                if (string2 == null || (hashtable3 = (Hashtable)hashtable.get(string2)) == null) continue;
                String string3 = null;
                if (hashtable3.containsKey("Names")) {
                    string3 = (String)hashtable3.get("Names");
                }
                if (string3 == null) {
                    string3 = string2;
                }
                String string4 = "docker top " + string3;
                if (this.info.isItPodMan()) {
                    string4 = "podman top " + string3;
                }
                if (this.info.isSudo()) {
                    string4 = "sudo " + string4;
                }
                l5 = System.currentTimeMillis();
                long l6 = 2 * VmInfo.commandTimeOut * 1000;
                long l7 = l5 - l6;
                while (((ArrayList)cloneable).size() >= n) {
                    for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                        DockerThread dockerThread = (DockerThread)((ArrayList)cloneable).get(i);
                        if (dockerThread.isDone()) {
                            ArrayList arrayList3 = dockerThread.getOutput();
                            String string5 = dockerThread.getContainerId();
                            if (arrayList3 != null && arrayList3.size() > 0 && string5 != null) {
                                hashtable2.put(string5, arrayList3);
                            }
                            ((ArrayList)cloneable).remove(i);
                            --i;
                            continue;
                        }
                        l5 = System.currentTimeMillis();
                        l7 = l5 - l6;
                        if (dockerThread.startTime >= l7) continue;
                        try {
                            dockerThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((ArrayList)cloneable).remove(i);
                        --i;
                    }
                    if (((ArrayList)cloneable).size() < n) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                DockerThread dockerThread = new DockerThread(this, string4, string2);
                ((ArrayList)cloneable).add(dockerThread);
            }
            long l8 = 2 * VmInfo.commandTimeOut * 1000;
            while (((ArrayList)cloneable).size() > 0) {
                long l9 = System.currentTimeMillis();
                l5 = l9 - l8;
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    DockerThread dockerThread = (DockerThread)((ArrayList)cloneable).get(i);
                    if (dockerThread.isDone()) {
                        ArrayList arrayList4 = dockerThread.getOutput();
                        String string6 = dockerThread.getContainerId();
                        if (arrayList4 != null && arrayList4.size() > 0 && string6 != null) {
                            hashtable2.put(string6, arrayList4);
                        }
                        ((ArrayList)cloneable).remove(i);
                        --i;
                        continue;
                    }
                    if (dockerThread.startTime >= l5) continue;
                    try {
                        dockerThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((ArrayList)cloneable).remove(i);
                    --i;
                }
                if (cloneable == null || ((ArrayList)cloneable).size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        if ((cloneable = this.getTopContainerData(hashtable2)) != null) {
            this.performCache((Hashtable)cloneable, ht_RunningContainerTopData);
        }
        l3 = System.currentTimeMillis();
        String string = this.syncString;
        synchronized (string) {
            ht_RunningTopContainerInfoLastUpdated.put(this.reportingName, new Long(l3));
        }
        return cloneable;
    }

    public Hashtable getTopContainerData(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        String string = logDispStr;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string3 : arrayList) {
                if (string3.indexOf("UID") >= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                int n = stringTokenizer.countTokens();
                int n2 = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (n2 == 2 && (string = string4) != null && !arrayList2.contains(string)) {
                        arrayList2.add(string);
                    }
                    ++n2;
                }
            }
            hashtable2.put(string2, arrayList2);
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getContainersInfo() {
        Cloneable cloneable;
        long l;
        Long l2 = (Long)ht_RunningDockContainerInfoLastUpdated.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod) {
            Hashtable hashtable = (Hashtable)ht_RunningDockContainerData.get(this.reportingName);
            return hashtable;
        }
        int n = EgMainAgent.maxDockerThreads;
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (this.info != null) {
            hashtable = this.getAllContainers();
        }
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        if (hashtable != null && hashtable.size() > 0) {
            long l5;
            cloneable = new ArrayList();
            int n2 = hashtable.size();
            int n3 = 10;
            boolean bl = true;
            int n4 = 0;
            Enumeration enumeration = hashtable.keys();
            String string = logDispStr;
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable3;
                String string2 = (String)enumeration.nextElement();
                ++n4;
                if (string2 == null || (hashtable3 = (Hashtable)hashtable.get(string2)) == null) continue;
                String string3 = null;
                if (hashtable3.containsKey("Names")) {
                    string3 = (String)hashtable3.get("Names");
                }
                if (string3 == null) {
                    string3 = string2;
                }
                String string4 = "docker inspect " + string3;
                if (this.info.isItPodMan()) {
                    string4 = "podman inspect " + string3;
                }
                if (this.info.isSudo()) {
                    string4 = "sudo " + string4;
                }
                l5 = System.currentTimeMillis();
                long l6 = 2 * VmInfo.commandTimeOut * 1000;
                long l7 = l5 - l6;
                while (((ArrayList)cloneable).size() >= n) {
                    for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                        DockerThread dockerThread = (DockerThread)((ArrayList)cloneable).get(i);
                        if (dockerThread.isDone()) {
                            ArrayList arrayList3 = dockerThread.getOutput();
                            String string5 = dockerThread.getContainerId();
                            if (arrayList3 != null && arrayList3.size() > 0 && string5 != null) {
                                hashtable2.put(string5, arrayList3);
                            }
                            ((ArrayList)cloneable).remove(i);
                            --i;
                            continue;
                        }
                        l5 = System.currentTimeMillis();
                        l7 = l5 - l6;
                        if (dockerThread.startTime >= l7) continue;
                        try {
                            dockerThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((ArrayList)cloneable).remove(i);
                        --i;
                    }
                    if (((ArrayList)cloneable).size() < n) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                DockerThread dockerThread = new DockerThread(this, string4, string3);
                ((ArrayList)cloneable).add(dockerThread);
            }
            long l8 = 2 * VmInfo.commandTimeOut * 1000;
            while (((ArrayList)cloneable).size() > 0) {
                long l9 = System.currentTimeMillis();
                l5 = l9 - l8;
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    DockerThread dockerThread = (DockerThread)((ArrayList)cloneable).get(i);
                    if (dockerThread.isDone()) {
                        ArrayList arrayList4 = dockerThread.getOutput();
                        String string6 = dockerThread.getContainerId();
                        if (arrayList4 != null && arrayList4.size() > 0 && string6 != null) {
                            hashtable2.put(string6, arrayList4);
                        }
                        ((ArrayList)cloneable).remove(i);
                        --i;
                        continue;
                    }
                    if (dockerThread.startTime >= l5) continue;
                    try {
                        dockerThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((ArrayList)cloneable).remove(i);
                    --i;
                }
                if (cloneable == null || ((ArrayList)cloneable).size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        if ((cloneable = (Hashtable)hashtable2.clone()) != null) {
            this.performCache((Hashtable)cloneable, ht_RunningDockContainerData);
        }
        String string = this.syncString;
        synchronized (string) {
            l3 = System.currentTimeMillis();
            ht_RunningDockContainerInfoLastUpdated.put(this.reportingName, new Long(l3));
        }
        return cloneable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDockerVersionForConfig() {
        long l;
        ArrayList arrayList = null;
        String string = "docker version --format={{.Client.Version}}#@#{{.Client.APIVersion}}#@#{{.Client.GoVersion}}#@#{{.Client.GitCommit}}#@#{{.Client.Os}}/{{.Client.Arch}}#@#{{.Server.Version}}#@#{{.Server.APIVersion}}#@#{{.Server.GoVersion}}#@#{{.Server.GitCommit}}";
        if (this.info.isSudo()) {
            string = "sudo " + string;
        }
        Long l2 = (Long)ht_VersionLastUpdated.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod) {
            arrayList = (ArrayList)ht_VersionDetails.get(this.reportingName);
            return arrayList;
        }
        arrayList = this.executeCommand(string);
        String string2 = this.syncString;
        synchronized (string2) {
            ht_VersionDetails.put(this.reportingName, arrayList);
            ht_VersionLastUpdated.put(this.reportingName, new Long(l3));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDockerVersionDetails() {
        long l;
        ArrayList arrayList = null;
        String string = "docker version --format {{.Server.Version}}";
        if (this.info.isSudo()) {
            string = "sudo " + string;
        }
        Long l2 = (Long)ht_InfoLastUpdated.get(this.reportingName);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 != null) {
            l4 = l2;
        }
        if ((l = l3 - l4) < cachePeriod) {
            arrayList = (ArrayList)ht_InfoDetails.get(this.reportingName);
            return arrayList;
        }
        arrayList = this.executeCommand(string);
        String string2 = this.syncString;
        synchronized (string2) {
            ht_InfoDetails.put(this.reportingName, arrayList);
            ht_InfoLastUpdated.put(this.reportingName, new Long(l3));
        }
        return arrayList;
    }

    public Hashtable getKubePodIpDetails(ArrayList arrayList) {
        Object object;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = arrayList.size();
        int n2 = EgMainAgent.maxDockerThreads;
        ArrayList<DockerThread> arrayList2 = new ArrayList<DockerThread>();
        for (int i = 0; i < n; ++i) {
            long l;
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            Long l2 = (Long)ht_ContainerPodIpMapUpdatedTime.get(string);
            long l3 = 0L;
            if (l2 != null) {
                l3 = l2;
            }
            if ((l = System.currentTimeMillis()) - l3 < podIpCacheTime && (object = (String)ht_ContainerPodIpMap.get(string)) != null) {
                hashtable.put(string, object);
                continue;
            }
            object = "docker exec " + string + " hostname -i";
            if (this.info.isItPodMan()) {
                object = "podman exec " + string + " hostname -i";
            }
            if (this.info.isSudo()) {
                object = "sudo " + (String)object;
            }
            System.out.println(new Date() + " [DockerHelper] getKubePodIpDetails  strCommand = " + (String)object);
            long l4 = System.currentTimeMillis();
            long l5 = 2 * VmInfo.commandTimeOut * 1000;
            long l6 = l4 - l5;
            while (arrayList2.size() >= n2) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    DockerThread dockerThread = (DockerThread)arrayList2.get(j);
                    if (dockerThread.isDone()) {
                        String string2;
                        ArrayList arrayList3 = dockerThread.getOutput();
                        String string3 = dockerThread.getContainerId();
                        if (arrayList3 != null && arrayList3.size() > 0 && string3 != null && (string2 = (String)arrayList3.get(0)) != null && IPV6Helper.validateIPV4((String)string2.trim())) {
                            hashtable.put(string3, string2);
                            ht_ContainerPodIpMap.put(string3, string2);
                            ht_ContainerPodIpMapUpdatedTime.put(string3, new Long(System.currentTimeMillis()));
                        }
                        arrayList2.remove(j);
                        --j;
                        continue;
                    }
                    l4 = System.currentTimeMillis();
                    l6 = l4 - l5;
                    if (dockerThread.startTime >= l6) continue;
                    try {
                        dockerThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(j);
                    --j;
                }
                if (arrayList2.size() < n2) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            DockerThread dockerThread = new DockerThread(this, (String)object, string);
            arrayList2.add(dockerThread);
        }
        long l = 2 * VmInfo.commandTimeOut * 1000;
        while (arrayList2.size() > 0) {
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l;
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (DockerThread)arrayList2.get(i);
                if (object.isDone()) {
                    String string;
                    ArrayList arrayList4 = object.getOutput();
                    String string4 = object.getContainerId();
                    if (arrayList4 != null && arrayList4.size() > 0 && string4 != null && (string = (String)arrayList4.get(0)) != null && IPV6Helper.validateIPV4((String)string.trim())) {
                        hashtable.put(string4, string);
                        ht_ContainerPodIpMap.put(string4, string);
                        ht_ContainerPodIpMapUpdatedTime.put(string4, new Long(System.currentTimeMillis()));
                    }
                    arrayList2.remove(i);
                    --i;
                    continue;
                }
                if (object.startTime >= l8) continue;
                try {
                    object.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList2.remove(i);
                --i;
            }
            if (arrayList2 == null || arrayList2.size() == 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public ArrayList egTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    public boolean isDockerMachine() {
        return ContainerUtils.isDockerDaemonRunning();
    }

    public boolean isPodmanMachine() {
        return ContainerUtils.isPodmanDaemonRunning();
    }

    public Hashtable getPidForContainer(Hashtable hashtable) {
        if (AgentLogger.bgTaskLogger.isDebugEnabled()) {
            AgentLogger.bgTaskLogger.debug("{}  ht_dockerLastUpdated {} ", (Object)logDispStr, (Object)ht_dockerLastUpdated);
            AgentLogger.bgTaskLogger.debug("{}  ht_dockerCmdData {} ", (Object)logDispStr, (Object)ht_dockerCmdData);
            AgentLogger.bgTaskLogger.debug("{}  htRunContainerFullId {} ", (Object)logDispStr, (Object)htRunContainerFullId);
        }
        Hashtable hashtable2 = null;
        try {
            Object object;
            int n;
            Long l = (Long)ht_dockerLastUpdated.get(this.reportingName);
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            if (l != null) {
                l3 = l;
            }
            long l4 = l2 - l3;
            int n2 = EgMainAgent.maxDockerThreads;
            ArrayList arrayList = null;
            if (this.info != null) {
                arrayList = this.getRunningContainersWthFullId();
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (arrayList != null && arrayList.size() > 0) {
                int n3 = arrayList.size();
                n = 10;
                int n4 = 1;
                int n5 = 0;
                object = logDispStr;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    ++n5;
                    if (string != null && n4 <= n) {
                        object = n4 == 1 ? string : (String)object + " " + string;
                        ++n4;
                    }
                    if (n4 == n) {
                        arrayList2.add(object);
                        object = logDispStr;
                        n4 = 1;
                    }
                    if (n5 != n3 || n4 == n) continue;
                    arrayList2.add(object);
                }
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (arrayList2 != null && arrayList2.size() > 0) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    String string = (String)arrayList2.get(n);
                    String string2 = "docker inspect " + string;
                    if (this.info.isSudo()) {
                        string2 = "sudo " + string2;
                    }
                    object = this.executeCommand(string2);
                    String string3 = ((AbstractCollection)object).toString();
                    arrayList3.add(string3);
                }
            }
            AgentLogger.bgTaskLogger.debug("{} al_runningContainersData : {} ", (Object)logDispStr, arrayList3);
            hashtable2 = this.getParentPidForContainer(arrayList3, hashtable);
            this.performCache(hashtable2, ht_dockerCmdData);
            l2 = System.currentTimeMillis();
            ht_dockerLastUpdated.put(this.reportingName, new Long(l2));
        }
        catch (Exception exception) {
            AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
        }
        AgentLogger.bgTaskLogger.debug("{}  ht_runcContData {} ", (Object)logDispStr, hashtable2);
        return hashtable2;
    }

    public ArrayList getRunningContainersWthFullId() {
        this.getAllContainers();
        ArrayList arrayList = (ArrayList)htRunContainerFullId.get(this.reportingName);
        return arrayList;
    }

    private Hashtable getParentPidForContainer(ArrayList arrayList, Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            String string = "ps -e -o pid,ppid,user,pcpu,pmem,args";
            ArrayList arrayList2 = this.executeCommand(string);
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                AgentLogger.bgTaskLogger.trace("{}  ps -e -o pid,ppid,user,pcpu,pmem,args cmd result - al_data : {} ", (Object)logDispStr, (Object)arrayList2);
            }
            if (hashtable == null) {
                hashtable = new Hashtable<String, ArrayList>();
            }
            if (arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList.get(i);
                    AgentLogger.bgTaskLogger.trace("{}  ps cmd result  : {} ", (Object)logDispStr, (Object)string2);
                    if (string2 == null) continue;
                    try {
                        JSONArray jSONArray = this.stringToJSONArray(string2);
                        if (jSONArray == null || jSONArray.size() <= 0) continue;
                        for (int j = 0; j < jSONArray.size(); ++j) {
                            try {
                                JSONArray jSONArray2 = (JSONArray)jSONArray.get(j);
                                if (jSONArray2 == null || jSONArray2.size() <= 0) continue;
                                for (int k = 0; k < jSONArray2.size(); ++k) {
                                    JSONObject jSONObject;
                                    Map map = (Map)jSONArray2.get(k);
                                    if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                                        AgentLogger.bgTaskLogger.trace("{} innerjson_Arr.get(j) j {} : {} ", new Object[]{logDispStr, k, jSONArray2.get(k)});
                                    }
                                    if (map == null) continue;
                                    String string3 = logDispStr;
                                    String string4 = logDispStr;
                                    if (map.containsKey("Id") && (string4 = (String)map.get("Id")) != null && string4.length() > 13) {
                                        string4 = string4.substring(0, 12);
                                    }
                                    if (!map.containsKey("State") || (jSONObject = (JSONObject)map.get("State")) == null || !jSONObject.containsKey("Pid")) continue;
                                    String string5 = ((Long)jSONObject.get("Pid")).toString();
                                    if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                                        AgentLogger.bgTaskLogger.debug("{}  cont_id {} - Pid {} ", new Object[]{logDispStr, string4, string5});
                                    }
                                    if (string5 == null || string5.length() == 0) continue;
                                    String string6 = "ps -aef | grep -v grep | grep " + string5;
                                    String[] stringArray = new String[]{"bash", "-c", string6};
                                    ArrayList arrayList3 = this.executeArrayOfCommand(stringArray);
                                    hashtable.put(string4, arrayList3);
                                    Hashtable hashtable3 = this.readPidMapPPid(string5, arrayList3);
                                    if (hashtable3 == null) continue;
                                    String string7 = (String)hashtable3.get(string5);
                                    Vector vector = new Vector(arrayList2);
                                    Vector vector2 = new Vector();
                                    this.getRecursivePID(vector, vector2, string7);
                                    if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                                        AgentLogger.bgTaskLogger.trace("{}   j {}  : pidMap {} ", new Object[]{logDispStr, k, hashtable3});
                                        AgentLogger.bgTaskLogger.trace("{}   j {}  : prt_pid {} ", new Object[]{logDispStr, k, string7});
                                        AgentLogger.bgTaskLogger.trace("{}   j {}  : v_pids {} ", new Object[]{logDispStr, k, vector2});
                                    }
                                    hashtable2.put(string4, new ArrayList(vector2));
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
        }
        return hashtable2;
    }

    boolean getRecursivePID(Vector vector, Vector vector2, String string) {
        int n;
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)vector.elementAt(n));
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken().trim();
            if (!string.equalsIgnoreCase(string3)) continue;
            vector3.addElement(string2);
            ++n2;
        }
        if (n2 > 0) {
            vector2.addElement(string);
        }
        if (vector3.size() > 0) {
            for (n = 0; n < vector3.size(); ++n) {
                this.getRecursivePID(vector, vector2, (String)vector3.elementAt(n));
            }
        } else {
            vector2.addElement(string);
            return false;
        }
        return true;
    }

    private Hashtable readPidMapPPid(String string, ArrayList arrayList) {
        try {
            if (string == null || arrayList == null || arrayList.size() == 0) {
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.toLowerCase().startsWith("uid")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = logDispStr;
                String string4 = logDispStr;
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (++n == 2) {
                        string3 = string5;
                    }
                    if (n != 3) continue;
                    string4 = string5;
                    break;
                }
                if (!string3.equalsIgnoreCase(string)) continue;
                hashtable.put(string3, string4);
            }
            return hashtable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ArrayList executeArrayOfCommand(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || this.info == null) {
            return null;
        }
        ArrayList arrayList = null;
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList2 = egUtilities.getExecOutputLines(stringArray);
            if (ApmConfigManager.getInstance().isLogBigSizeObjects() && stringArray != null) {
                AgentLogger.bgTaskLogger.trace("{}  cmd : {}, output :  {} ", new Object[]{logDispStr, Arrays.asList(stringArray), arrayList2});
            }
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
        }
        return arrayList;
    }

    public JSONArray stringToJSONArray(String string) {
        JSONParser jSONParser = new JSONParser();
        JSONArray jSONArray = null;
        try {
            jSONArray = (JSONArray)jSONParser.parse(string);
        }
        catch (Exception exception) {
            AgentLogger.bgTaskLogger.warn("{} exception {} ", (Object)logDispStr, (Object)exception);
            return null;
        }
        return jSONArray;
    }
}

