/*
 * Decompiled with CFR 0.152.
 */
import com.eg.HelperThread;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EsxGuestsMonitor {
    private static Hashtable workingIps = new Hashtable();
    private static Hashtable failedIps = new Hashtable();
    private static long workingIpCacheTime = EgMainAgent.workingVmIpCachePeriod;
    private static int maxThreads = 20;
    public static Vector v_SuspectedIps = new Vector();
    public ArrayList vmGuests = null;
    public ArrayList registeredVmGuests = null;
    public static Hashtable lastUpdateHash = new Hashtable();
    public static Hashtable vmGuestsHash = new Hashtable();
    public static Hashtable registeredVmGuestsHash = new Hashtable();
    public static Hashtable syncHash = new Hashtable();
    private boolean isXenServer = false;
    private boolean isLdoms = false;
    private boolean isHyperV = false;
    private boolean isConnected = false;
    private boolean isLpar = false;
    private boolean isOraHypervisor = false;
    private boolean isRHELHyperV = false;
    private boolean isQVD = false;
    private boolean isKVM = false;
    private boolean isOVMServer = false;
    private boolean isAcropolisServer = false;
    private boolean isCloudVM = false;
    private boolean isProxmox = false;
    private ESX3iInfo esx = null;
    private String me = "";
    public static String sync = new String("x");
    private boolean isWindows = false;
    private ArrayList arrExcludedVms = null;
    private ArrayList arrIgnoreVms = null;
    private ArrayList al_excludeIPList = null;
    private static Hashtable htFailedHostPortHash = new Hashtable();
    private static Vector vProcessingServers = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsxGuestsMonitor(ESX3iInfo eSX3iInfo) {
        String string;
        Object object;
        Object object2;
        this.me = eSX3iInfo.reportingName;
        this.esx = eSX3iInfo;
        this.arrExcludedVms = this.esx.getExcludeVms();
        String string2 = this.esx.getIgnoreVms();
        if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("none")) {
            this.arrIgnoreVms = new ArrayList();
            object2 = new StringTokenizer(string2, ",");
            int n = ((StringTokenizer)object2).countTokens();
            if (n > 0) {
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (object == null) continue;
                    this.arrIgnoreVms.add(object);
                }
            }
        }
        if ((object2 = this.esx.getExcludeIps()) != null && ((String)object2).length() > 0 && !((String)object2).equalsIgnoreCase("none")) {
            this.al_excludeIPList = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (object == null) continue;
                this.al_excludeIPList.add(object);
            }
        }
        if ((string = System.getProperty("os.name").toLowerCase()) != null && string.indexOf("win") >= 0) {
            this.isWindows = true;
        }
        this.vmGuests = (ArrayList)vmGuestsHash.get(this.me);
        this.registeredVmGuests = (ArrayList)registeredVmGuestsHash.get(this.me);
        object = (Long)lastUpdateHash.get(this.me);
        long l = 0L;
        l = object == null ? 0L : (Long)object;
        String string3 = (String)syncHash.get(this.me);
        if (string3 == null) {
            Hashtable hashtable = syncHash;
            synchronized (hashtable) {
                string3 = (String)syncHash.get(this.me);
                if (string3 == null) {
                    syncHash.put(this.me, new String(this.me));
                    string3 = (String)syncHash.get(this.me);
                }
            }
        }
        boolean bl = true;
        long l2 = System.currentTimeMillis();
        boolean bl2 = false;
        this.isXenServer = this.esx.isXenServer;
        this.isLdoms = this.esx.isLdoms;
        boolean bl3 = this.esx.isItInsideViewTest;
        if (bl3) {
            bl = false;
        }
        this.isHyperV = this.esx.isHyperV;
        this.isLpar = this.esx.isLpar;
        this.isOraHypervisor = this.esx.isOraHypervisor;
        this.isRHELHyperV = this.esx.isRHELHyperV;
        this.isQVD = this.esx.isQVD;
        this.isKVM = this.esx.isKVM;
        this.isOVMServer = this.esx.isOVMServer;
        this.isAcropolisServer = this.esx.isAcropolisServer;
        this.isCloudVM = this.esx.isCloudVM;
        this.isProxmox = this.esx.isProxmox;
        long l3 = VmInfo.CACHE_PERIOD_getVmGuestsInfo / 2L;
        if (vProcessingServers.contains(this.me)) {
            return;
        }
        if (!(!bl && l2 - l <= l3 * EgConfigInfo.msecPerMin || this.isHyperV && l2 - l < EgConfigInfo.msecPerMin)) {
            String string4 = string3;
            synchronized (string4) {
                vProcessingServers.add(this.me);
                l2 = System.currentTimeMillis();
                if (bl || l2 - l > l3 * EgConfigInfo.msecPerMin) {
                    l = l2;
                    lastUpdateHash.put(this.me, new Long(l));
                    this.findVmGuests();
                    l = l2;
                    VmInfo.isToRefreshEsxCache.put(this.me, new Boolean(false));
                    lastUpdateHash.put(this.me, new Long(l));
                    if (this.vmGuests != null) {
                        vmGuestsHash.put(this.me, this.vmGuests);
                    }
                    if (this.registeredVmGuests != null) {
                        registeredVmGuestsHash.put(this.me, this.registeredVmGuests);
                    }
                }
                vProcessingServers.remove(this.me);
            }
        }
    }

    public ArrayList getVmGuests() {
        if (this.vmGuests == null) {
            return null;
        }
        return (ArrayList)this.vmGuests.clone();
    }

    public ArrayList getRegisteredVmGuests() {
        if (this.registeredVmGuests == null) {
            return null;
        }
        return (ArrayList)this.registeredVmGuests.clone();
    }

    private void findVmGuests() {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2;
        int n;
        Object object4;
        int n2;
        String string3;
        String string4;
        Object object5;
        int n3;
        int n4;
        String string5;
        Object object6;
        Object object7;
        EsxHelper esxHelper = EsxHelper.getEsxHelper();
        String string6 = VmCommands.getVmInfo();
        ArrayList arrayList = null;
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl = false;
        String string10 = "";
        String string11 = "";
        if (this.isXenServer) {
            object7 = XenHelper.getInstance();
            arrayList = object7.VMguestInfo(this.esx);
            this.isConnected = arrayList != null;
        } else if (this.isLdoms) {
            object7 = new LdomsGuestInfo();
            object7.setESXInfoObj(this.esx);
            object7.setRpNameObj(this.me);
            ArrayList arrayList2 = object7.fillGuestObjs();
            arrayList = object7.buildData(arrayList2);
        } else if (this.isHyperV) {
            object7 = this.esx.getEsxHostIp();
            boolean bl2 = this.esx.meAgentless;
            object6 = new HypervGuestInfo((String)object7, bl2);
            arrayList = object6.getGuestDetails();
        } else if (this.isLpar) {
            object7 = this.esx.getRealServerName();
            String string12 = this.esx.getEsxHostIp();
            object6 = this.esx.getRootUser();
            string5 = this.esx.getRootPassword();
            n4 = this.esx.getSSHPort();
            boolean bl3 = this.esx.isHmc;
            boolean bl4 = this.esx.isIvm;
            n3 = this.esx.isHMCHighSecure;
            if (bl3) {
                object5 = new LparGuestInfo((String)object7, string12, n4, (String)object6, string5, n3 != 0);
                arrayList = object5.getGuestDetails();
            }
            if (bl4) {
                object5 = new LparGuestInfoUsingIvm((String)object7, string12, n4, (String)object6, string5);
                arrayList = object5.getGuestDetails();
            }
        } else if (this.isOraHypervisor) {
            object7 = this.esx.getEsxHostIp();
            String string13 = this.esx.getRootUser();
            object6 = this.esx.getRootPassword();
            int n5 = this.esx.getSSHPort();
            EsxGuestsMonitor esxGuestsMonitor = this;
            String string14 = esxGuestsMonitor.esx.getSudoCmd();
            OraVMBoxGuestInfo oraVMBoxGuestInfo = new OraVMBoxGuestInfo((String)object7, n5, string13, (String)object6, string14, this.esx.meAgentless);
            arrayList = oraVMBoxGuestInfo.getTotalVms();
        } else if (this.isRHELHyperV) {
            object7 = this.esx.getEsxHostIp();
            String string15 = this.esx.getRhelMgrHostIp();
            object6 = this.esx.getRootUser();
            string5 = this.esx.getRootPassword();
            String string16 = this.esx.getRhelDomain();
            boolean bl5 = this.esx.isSsl();
            String string17 = "https";
            string17 = bl5 ? "https" : "http";
            n3 = this.esx.getRhelPort();
            object5 = new RHELHypGuestInfo(string15, (String)object7, (String)object6, string5, string16, string17, n3, this.esx.reportingName);
            arrayList = object5.getTotalVms();
        } else if (this.isAcropolisServer) {
            object7 = new NutanixVmInfo(this.esx);
            object7.updateNutanixVmInfo(false);
            arrayList = object7.getVmDataForInsideView();
        } else if (this.isQVD) {
            object7 = new QVDVMInfo(this.esx.reportingName);
            arrayList = object7.getVmInfo();
        } else if (this.isKVM) {
            object7 = this.esx.getEsxHostIp();
            boolean bl6 = this.esx.meAgentless;
            object6 = new KVMGuestInfo(this.esx.reportingName, (String)object7, bl6);
            arrayList = object6.getVMsDetails();
        } else if (this.isOVMServer) {
            object7 = new OVMGuestInfo(this.esx);
            boolean bl7 = object7.updateOVmGuestInfo(false);
            arrayList = object7.getVmDetails();
        } else if (this.isCloudVM) {
            object7 = new CloudVmHelper(this.esx.reportingName);
            arrayList = object7.getVMsDetails();
        } else if (this.isProxmox) {
            object7 = this.esx.getEsxHostIp();
            String string18 = this.esx.getRootUser();
            object6 = this.esx.getRootPassword();
            string5 = this.esx.getNodeName();
            n4 = this.esx.getSSHPort();
            ProxmoxGuestInfo proxmoxGuestInfo = new ProxmoxGuestInfo((String)object7, n4, string18, (String)object6, this.esx.meAgentless, this.esx.reportingName, string5);
            arrayList = proxmoxGuestInfo.getVMsDetails();
        } else {
            if (this.esx != null) {
                string7 = this.esx.getEsxHostIp();
                string8 = this.esx.getRootUser();
                string9 = this.esx.getRootPassword();
                bl = this.esx.isSsl();
                string10 = this.esx.getVirtualCenterHostIp();
                string11 = this.esx.getWebPort();
            }
            if ((this.esx.isEsx3i || string6.equals("getinfo.class")) && string8 != null && string8.length() > 0 && string9 != null && string9.length() > 0) {
                object7 = new VmGetInfo(string7, string8, string9, bl, string10, this.esx.meAgentless, string11);
                arrayList = object7.getGuestInfo();
            } else {
                if (string6.equals("getinfo.class") && (string8 == null || string8.length() == 0 || string9 == null || string9.length() == 0)) {
                    string6 = ESXInfo.getSudoCmd() + " " + EgInstallInfo.getInstallDir() + "/lib" + "/vmgfiles" + "/getinfo.sh";
                }
                arrayList = esxHelper.getCommandOutput(string6);
            }
            if (arrayList == null || arrayList.size() < 0) {
                object7 = new EgDateInfo();
                System.out.println("[VmHelper][getVmGuestsInfo]output of " + string6 + " is null " + object7.egetDate(false));
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList == null || arrayList.size() < 0) {
            object7 = new EgDateInfo();
            this.registeredVmGuests = null;
            this.vmGuests = null;
            System.out.println("[EsxGuestsMonitor] Discovered VMs output is null " + object7.egetDate(false));
            return;
        }
        int n6 = arrayList.size();
        if (n6 < 0) {
            return;
        }
        if (this.registeredVmGuests == null) {
            this.registeredVmGuests = new ArrayList();
        }
        if (this.vmGuests == null) {
            this.vmGuests = new ArrayList();
        }
        ArrayList<VmGuest> arrayList3 = new ArrayList<VmGuest>();
        object6 = new ArrayList();
        int n7 = 4;
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        for (int i = 0; i < n6; ++i) {
            String string19 = (String)arrayList.get(i);
            string19 = string19.trim();
            System.out.println(new Date() + " VM[" + i + "]: " + string19);
            if (!string19.startsWith("Machine Name:")) continue;
            VmGuest vmGuest = null;
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[getVmGuestsInfo]line=" + string19);
            }
            object5 = EsxGuestsMonitor.myTokenizer(string19, "~!~");
            int n8 = -1;
            if (object5 != null) {
                n8 = ((ArrayList)object5).size();
            }
            if (n8 < n7) continue;
            vmGuest = new VmGuest(this.esx.reportingName);
            vmGuest.setInsideView(this.esx.getInsideView());
            string4 = "";
            string3 = "";
            boolean bl8 = false;
            ArrayList<String> arrayList5 = new ArrayList<String>();
            for (n2 = 0; n2 < n8; ++n2) {
                object4 = (String)((ArrayList)object5).get(n2);
                n = ((String)object4).indexOf(":");
                if (n <= 0) continue;
                string4 = ((String)object4).substring(0, n);
                string3 = ((String)object4).substring(n + 1);
                if (VmConstants.isDebugEnabled()) {
                    System.out.println("[getVmGuestsInfo]strName=" + string4);
                    System.out.println("[getVmGuestsInfo]strValue=" + string3);
                }
                if (string4.equals("Machine Name")) {
                    if (string3.startsWith("TemplateVm:")) {
                        string2 = "TemplateVm:";
                        int n9 = string2.length();
                        if (string3.length() > n9) {
                            object3 = string3.substring(n9);
                            vmGuest.setTemplateVmName((String)object3);
                        }
                    } else if (string3.startsWith("OrphanedVm:")) {
                        string2 = "OrphenedVm:";
                        int n10 = string2.length();
                        if (string3.length() > n10) {
                            object3 = string3.substring(n10).trim();
                            vmGuest.setOrphenedVmName(object3);
                        }
                    } else if (string3.startsWith("VmConnState:")) {
                        string2 = "VmConnState:";
                        int n11 = string2.length();
                        if (string3.length() > n11) {
                            object3 = string3.substring(n11).trim();
                            int n12 = ((String)object3).indexOf(":");
                            if (n12 > 0) {
                                object2 = ((String)object3).substring(0, n12);
                                vmGuest.setVmConnectionState((String)object2);
                                if (((String)object3).length() > n12 + 1) {
                                    object3 = ((String)object3).substring(n12 + 1, ((String)object3).length());
                                }
                            }
                            vmGuest.setNotConnectedVmName((String)object3);
                        }
                    } else if (string3.startsWith("LparVms:")) {
                        StringTokenizer stringTokenizer;
                        int n13;
                        string2 = "LparVms:";
                        int n14 = string2.length();
                        if (string3.length() > n14 && (n13 = (stringTokenizer = new StringTokenizer((String)(object3 = string3.substring(n14).trim()), "*~*")).countTokens()) == 2) {
                            object = stringTokenizer.nextToken();
                            vmGuest.setVmName((String)object);
                            String string20 = stringTokenizer.nextToken();
                            vmGuest.setLparEnvi(string20);
                        }
                    } else {
                        vmGuest.setVmName(string3);
                    }
                    if (!this.isCloudVM) continue;
                    vmGuest.setCloudVm(true);
                    continue;
                }
                if (string4.equals("IP Address")) {
                    string2 = "";
                    ArrayList<String> arrayList6 = new ArrayList<String>();
                    if (string3 != null && string3.length() > 0) {
                        object3 = Command.failedTargets;
                        if (object3 == null) {
                            object3 = new Hashtable();
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                        object2 = vmGuest.getVmName();
                        boolean bl9 = this.isITExcludeOrIgnoredVmList(this.arrExcludedVms, (String)object2);
                        boolean bl10 = false;
                        if (!bl9) {
                            bl10 = this.isITExcludeOrIgnoredVmList(this.arrIgnoreVms, (String)object2);
                        }
                        string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            String string21 = stringTokenizer.nextToken().trim();
                            if (string21.equals("0.0.0.0") || string21.equals("127.0.0.1")) continue;
                            if (this.al_excludeIPList != null && this.al_excludeIPList.contains(string21)) {
                                System.out.println(this.me + " EsxGuestsMonitor exclude ip list contains " + string21 + " so continue..");
                                continue;
                            }
                            if (v_SuspectedIps.contains(string21)) {
                                System.out.println(this.me + " EsxGuestsMonitor Suspected Ip list contains " + string21 + "\tso continue for " + vmGuest.getVmName());
                                continue;
                            }
                            string2 = string2 + string21 + ",";
                            if (((Hashtable)object3).containsKey(string21)) {
                                System.out.println(this.me + " EsxGuestsMonitor failedtarget  contains " + string21 + "\tso continue for " + vmGuest.getVmName());
                                continue;
                            }
                            string = string + string21 + ",";
                            if (workingIps.containsKey(string21)) {
                                Long l = (Long)workingIps.get(string21);
                                if (l == null) continue;
                                long l2 = System.currentTimeMillis() - l;
                                if (l2 > workingIpCacheTime) {
                                    workingIps.remove(string21);
                                } else {
                                    vmGuest.setIpAddress(string21);
                                    arrayList6.add(string21);
                                }
                            }
                            if (!bl9 && !bl10 && EgMainAgent.isInsideviewEnabled && !this.isCloudVM) {
                                if (arrayList5.contains(string21)) continue;
                                arrayList5.add(string21);
                                continue;
                            }
                            System.out.println(" [EsxGuestsMonitor] vm " + (String)object2 + "\tis in exclude or ignorelist or insideview is not enabled so we dont check ip validation for " + string21);
                        }
                        if (string != null && string.endsWith(",")) {
                            string = string.substring(0, string.lastIndexOf(","));
                        }
                        vmGuest.setIpAddress(string);
                    } else {
                        bl8 = true;
                    }
                    if (string2 != null && string2.length() > 0) {
                        if (string2.endsWith(",")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        vmGuest.setIpAddresses(string2);
                    } else {
                        vmGuest.setIpAddresses(string3);
                    }
                    if (arrayList6 == null || arrayList6.size() <= 1) continue;
                    vmGuest.setValidIps(arrayList6);
                    vmGuest.setMultipleIps(true);
                    continue;
                }
                if (string4.equals("State")) {
                    vmGuest.setState(string3);
                    continue;
                }
                if (string4.equals("OS")) {
                    vmGuest.setOs(string3);
                    continue;
                }
                if (string4.equals("DNSname")) {
                    vmGuest.setDnsName(string3);
                    continue;
                }
                if (!string4.equals("QVDVM")) continue;
                vmGuest.setQVDVm(true);
            }
            if (!bl8) {
                for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                    object4 = (String)arrayList5.get(n2);
                    object4 = vmGuest.getOs() + "#" + (String)object4;
                    if (arrayList4.contains(object4)) continue;
                    arrayList4.add(object4);
                }
            }
            ((ArrayList)object6).add(vmGuest);
        }
        ArrayList arrayList7 = new ArrayList();
        if (!this.isCloudVM) {
            arrayList7 = this.getValidIps(arrayList4);
        }
        String string22 = this.esx.getInsideView();
        String string23 = this.esx.getAdminUser();
        for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
            VmGuest vmGuest = (VmGuest)((ArrayList)object6).get(i);
            string4 = vmGuest.getIpAddress();
            string3 = "";
            String string24 = vmGuest.getVmName();
            boolean bl11 = this.isITExcludeOrIgnoredVmList(this.arrExcludedVms, string24);
            if (bl11 || (n2 = this.isITExcludeOrIgnoredVmList(this.arrIgnoreVms, string24)) != 0) continue;
            if (string4 != null && string4.indexOf(",") >= 0) {
                object4 = new StringTokenizer(string4, ",");
                n = 0;
                string2 = null;
                ArrayList<Object> arrayList8 = new ArrayList<Object>();
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object4).nextToken().trim();
                    if (v_SuspectedIps.contains(object3)) {
                        System.out.println(vmGuest + " 11 EsxGuestsMonitor Suspected Ip list contains " + string4 + "\tso continue for " + vmGuest.getVmName());
                        continue;
                    }
                    if (((String)object3).equals("0.0.0.0") || ((String)object3).equals("127.0.0.1")) continue;
                    if (string2 == null) {
                        string2 = object3;
                    }
                    string3 = string3 + (String)object3 + ",";
                    if (!arrayList7.contains(object3)) continue;
                    vmGuest.setIpAddress((String)object3);
                    n = 1;
                    arrayList8.add(object3);
                }
                if (arrayList8 != null && arrayList8.size() > 1) {
                    vmGuest.setValidIps(arrayList8);
                    vmGuest.setMultipleIps(true);
                }
                if (string3.endsWith(",")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                vmGuest.setIpAddresses(string3);
                if (n == 0) {
                    if ((string22.equalsIgnoreCase("tcp") || string22.equalsIgnoreCase("wmi") || string22.equalsIgnoreCase("exe")) && EgMainAgent.isInsideviewEnabled && !this.isCloudVM) {
                        int n15;
                        object3 = new StringTokenizer(string4, ",");
                        Object object8 = "";
                        object2 = "";
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            object = ((StringTokenizer)object3).nextToken().trim();
                            n15 = IPV6Helper.validateIPV6((String)object);
                            if (n15 != 0) {
                                if (((String)object2).length() == 0) {
                                    object2 = object;
                                    continue;
                                }
                                object2 = (String)object2 + " " + (String)object;
                                continue;
                            }
                            if (((String)object8).length() == 0) {
                                object8 = object;
                                continue;
                            }
                            object8 = (String)object8 + " " + (String)object;
                        }
                        if (object8 != null && ((String)object8).length() > 0) {
                            object = this.getValidIpForGuest((String)object8, false);
                            if (object != null && ((ArrayList)object).size() > 0) {
                                for (n15 = 0; n15 < ((ArrayList)object).size(); ++n15) {
                                    string = (String)((ArrayList)object).get(n15);
                                    if (string == null) continue;
                                    workingIps.put(string, new Long(System.currentTimeMillis()));
                                    vmGuest.setIpAddress(string);
                                    arrayList8.add(string);
                                }
                            } else {
                                vmGuest.setIpAddress(string2);
                            }
                        } else if (object2 != null && ((String)object2).length() > 0) {
                            object = this.getValidIpForGuest((String)object2, true);
                            if (object != null && ((ArrayList)object).size() > 0) {
                                for (n15 = 0; n15 < ((ArrayList)object).size(); ++n15) {
                                    string = (String)((ArrayList)object).get(n15);
                                    if (string == null) continue;
                                    workingIps.put(string, new Long(System.currentTimeMillis()));
                                    vmGuest.setIpAddress(string);
                                }
                            } else {
                                vmGuest.setIpAddress(string2);
                            }
                        } else {
                            vmGuest.setIpAddress(string2);
                        }
                    } else {
                        vmGuest.setIpAddress(string2);
                    }
                    if (arrayList8 != null && arrayList8.size() > 1) {
                        vmGuest.setValidIps(arrayList8);
                        vmGuest.setMultipleIps(true);
                    }
                }
            }
            if (esxHelper.validateVmGuestInfo(vmGuest)) {
                arrayList3.add(vmGuest);
                if (!VmConstants.isDebugEnabled()) continue;
                System.out.println("[name=" + vmGuest.getVmName() + "][ip=" + vmGuest.getIpAddress() + "]");
                continue;
            }
            if (!VmConstants.isDebugEnabled()) continue;
            System.out.println("[name=" + vmGuest.getVmName() + "]Validation failed.");
        }
        esxHelper.setESXInfo(arrayList3, this.esx);
        esxHelper.findAndSetOsInfo(arrayList3, this.esx.reportingName);
        this.vmGuests = arrayList3;
        this.registeredVmGuests = object6;
    }

    private ArrayList getValidIps(ArrayList arrayList) {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        int n2;
        String string;
        int n3;
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<VmConnectionThread> arrayList3 = new ArrayList<VmConnectionThread>();
        ArrayList<int[]> arrayList4 = new ArrayList<int[]>();
        String string2 = this.esx.getAdminUser();
        String string3 = this.esx.getInsideView();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        block4: for (n3 = 0; n3 < arrayList.size(); ++n3) {
            int n4;
            Object object3;
            long l;
            string = (String)arrayList.get(n3);
            n2 = string.indexOf("#");
            if (n2 < 0) continue;
            String string4 = string.substring(0, n2);
            object2 = string.substring(n2 + 1);
            if (arrayList2.contains(object2)) continue;
            if (workingIps.containsKey(object2)) {
                serializable = (Long)workingIps.get(object2);
                if (serializable == null) continue;
                l = System.currentTimeMillis() - (Long)serializable;
                if (l > workingIpCacheTime) {
                    workingIps.remove(object2);
                } else {
                    arrayList2.add(object2);
                    continue;
                }
            }
            if (!arrayList2.contains(object2)) {
                if (failedIps.containsKey(object2)) {
                    serializable = (Long)failedIps.get(object2);
                    if (serializable != null) {
                        l = System.currentTimeMillis() - (Long)serializable;
                        if (l > workingIpCacheTime) {
                            failedIps.remove(object2);
                            arrayList5.add(object2);
                        }
                    } else {
                        arrayList5.add(object2);
                    }
                } else {
                    arrayList5.add(object2);
                }
            }
            boolean bl = false;
            int n5 = 22;
            if (string4 != null && string4.toLowerCase().indexOf("win") >= 0) {
                n5 = 139;
            } else {
                if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("none")) {
                    bl = true;
                }
                if (bl) {
                    object3 = EgMainAgent.Ssh_Port;
                    if (object3 == null) {
                        n5 = 22;
                    } else {
                        n4 = 0;
                        if (((int[])object3).length == 1) {
                            n5 = object3[0];
                        } else {
                            for (int i = 0; i < ((int[])object3).length; ++i) {
                                boolean bl2;
                                n = object3[i];
                                object = (String)object2 + ":" + n;
                                if (((int[])object3).length > 1 && htFailedHostPortHash.containsKey(object)) {
                                    long l2;
                                    Long l3 = (Long)htFailedHostPortHash.get(object);
                                    long l4 = 0L;
                                    if (l3 != null) {
                                        l4 = l3;
                                    }
                                    if ((l2 = System.currentTimeMillis()) - l4 < workingIpCacheTime) continue;
                                    htFailedHostPortHash.remove(object);
                                }
                                if (bl2 = this.doesSocketExist((String)object2, n)) {
                                    if (!arrayList2.contains(object2)) {
                                        arrayList2.add(object2);
                                    }
                                    n5 = n;
                                    n4 = 1;
                                    break;
                                }
                                if (((int[])object3).length <= 1) continue;
                                htFailedHostPortHash.put(object, new Long(System.currentTimeMillis()));
                            }
                            if (n4 == 0) {
                                n5 = 22;
                            }
                        }
                    }
                }
            }
            if (!(!string3.equalsIgnoreCase("wmi") && !string3.equalsIgnoreCase("tcp") || n5 != 139 && bl)) {
                n5 = (int)EgMainAgent.WmiInsideViewPort;
            }
            if (arrayList2.contains(object2) || arrayList4.contains(object3 = (Object)((String)object2 + ":" + n5))) continue;
            arrayList4.add((int[])object3);
            while (!(string3.equalsIgnoreCase("exe") && (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase("none")) || (string3.equalsIgnoreCase("tcp") || string3.equalsIgnoreCase("wmi")) && string4 != null && string4.toLowerCase().indexOf("win") < 0 && string4.toLowerCase().indexOf("linux") < 0 && string4.toLowerCase().indexOf("centos") < 0 && string4.toLowerCase().indexOf("ubuntu") < 0 && string4.toLowerCase().indexOf("suse") < 0 && string4.toLowerCase().indexOf("freebsd") < 0 && string4.toLowerCase().indexOf("debian") < 0 && string4.toLowerCase().indexOf("rhel") < 0 && string4.toLowerCase().indexOf("vmwarephoton") < 0 && (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase("none")))) {
                if (arrayList3.size() < maxThreads) {
                    VmConnectionThread vmConnectionThread = new VmConnectionThread((String)object2, n5);
                    arrayList3.add(vmConnectionThread);
                    continue block4;
                }
                for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                    String string5;
                    VmConnectionThread vmConnectionThread = (VmConnectionThread)arrayList3.get(n4);
                    if (!vmConnectionThread.isDone()) continue;
                    arrayList3.remove(n4--);
                    if (!vmConnectionThread.isSocketExist() || (string5 = vmConnectionThread.getGuestValidIp()) == null) continue;
                    workingIps.put(string5, new Long(System.currentTimeMillis()));
                    if (arrayList2.contains(string5)) continue;
                    arrayList2.add(string5);
                }
                if (arrayList3.size() < maxThreads) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        while (arrayList3.size() > 0) {
            for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                String string6;
                string = (VmConnectionThread)arrayList3.get(n3);
                if (!string.isDone()) continue;
                arrayList3.remove(n3--);
                if (!string.isSocketExist() || (string6 = string.getGuestValidIp()) == null) continue;
                workingIps.put(string6, new Long(System.currentTimeMillis()));
                if (arrayList2.contains(string6)) continue;
                arrayList2.add(string6);
            }
            if (arrayList3.size() == 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string3.equalsIgnoreCase("exe") && (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase("none")) && arrayList5 != null && arrayList5.size() > 0) {
            int n6;
            n3 = arrayList5.size();
            string = "";
            n2 = 0;
            int n7 = 24;
            object2 = new ArrayList();
            serializable = new ArrayList();
            String string7 = "";
            int n8 = 0;
            for (int i = 0; i < n3; ++i) {
                String string8 = (String)arrayList5.get(i);
                if (string8 == null) continue;
                if (!this.isWindows) {
                    n = IPV6Helper.validateIPV6((String)string8);
                    if (n != 0) {
                        if (n8 <= n7) {
                            string7 = string7 + string8 + " ";
                            ++n8;
                        }
                        if (n8 == n7) {
                            ((ArrayList)serializable).add(string7);
                            string7 = "";
                            n8 = 0;
                        }
                    } else {
                        if (n2 <= n7) {
                            string = string + string8 + " ";
                            ++n2;
                        }
                        if (n2 == n7) {
                            ((ArrayList)object2).add(string);
                            string = "";
                            n2 = 0;
                        }
                    }
                    if (i != n3 - 1) continue;
                    if (n8 != n7 && string7.length() > 0) {
                        ((ArrayList)serializable).add(string7);
                    }
                    if (n2 == n7 || string.length() <= 0) continue;
                    ((ArrayList)object2).add(string);
                    continue;
                }
                if (i <= n7) {
                    string = string + string8 + " ";
                }
                if (i == n7) {
                    ((ArrayList)object2).add(string);
                    string = "";
                    n7 += 25;
                }
                if (i != n3 - 1 || i == n7) continue;
                ((ArrayList)object2).add(string);
            }
            ArrayList arrayList6 = new ArrayList();
            for (n6 = 0; n6 < ((ArrayList)object2).size(); ++n6) {
                String string9 = (String)((ArrayList)object2).get(n6);
                if (string9 == null || (object = this.getValidIpForGuest(string9, false)) == null || ((ArrayList)object).size() <= 0) continue;
                arrayList6.addAll(object);
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string10 = (String)((ArrayList)object).get(i);
                    if (string10 == null) continue;
                    workingIps.put(string10, new Long(System.currentTimeMillis()));
                    if (arrayList2.contains(string10)) continue;
                    arrayList2.add(string10);
                }
            }
            if (serializable != null && ((ArrayList)serializable).size() > 0) {
                n6 = ((ArrayList)serializable).size();
                for (int i = 0; i < n6; ++i) {
                    ArrayList arrayList7;
                    object = (String)((ArrayList)serializable).get(i);
                    if (object == null || (arrayList7 = this.getValidIpForGuest((String)object, true)) == null || arrayList7.size() <= 0) continue;
                    arrayList6.addAll(arrayList7);
                    for (int j = 0; j < arrayList7.size(); ++j) {
                        String string11 = (String)arrayList7.get(j);
                        if (string11 == null) continue;
                        workingIps.put(string11, new Long(System.currentTimeMillis()));
                        if (arrayList2.contains(string11)) continue;
                        arrayList2.add(string11);
                    }
                }
            }
            if (arrayList5 != null && arrayList5.size() > 0) {
                for (n6 = 0; n6 < arrayList5.size(); ++n6) {
                    String string12 = (String)arrayList5.get(n6);
                    if (string12 == null || arrayList6 != null && arrayList6.contains(string12)) continue;
                    failedIps.put(string12, new Long(System.currentTimeMillis()));
                }
            }
        }
        return arrayList2;
    }

    public boolean doesSocketExist(String string, int n) {
        long l;
        long l2 = 10000L;
        HelperThread helperThread = new HelperThread(string, n, (int)l2);
        long l3 = 0L;
        long l4 = 5L;
        do {
            this.suspendForPeriod(l4);
            if (helperThread.done) {
                return helperThread.status;
            }
            if ((l3 += l4) >= l2) {
                helperThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                helperThread = null;
                return false;
            }
            l = l4 * 2L;
            if (l > 30L) {
                l = 30L;
            }
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        helperThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        helperThread = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private ArrayList getValidIpForGuest(String string, boolean bl) {
        Object object;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = EgInstallInfo.getInstallDir();
        if (this.isWindows) {
            object = string2 + "\\bin\\nfping.exe " + string + " -t 100";
            ArrayList arrayList2 = null;
            arrayList2 = this.getMeasures((String)object);
            if (arrayList2 != null && arrayList2.size() > 0) {
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    StringTokenizer stringTokenizer;
                    String string3 = (String)arrayList2.get(i);
                    if (string3 == null || !string3.startsWith("Reply") || (stringTokenizer = new StringTokenizer(string3)).countTokens() < 3) continue;
                    stringTokenizer.nextToken().trim();
                    stringTokenizer.nextToken().trim();
                    String string4 = stringTokenizer.nextToken().trim();
                    if (string4 == null) continue;
                    if (string4.endsWith(":")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    arrayList.add(string4);
                }
            }
        } else {
            object = new String(string2 + "/bin/fping -t 100 " + string);
            if (bl) {
                object = new String(string2 + "/bin/fping6 -t 100 " + string);
            }
            ArrayList arrayList3 = null;
            arrayList3 = this.getMeasures((String)object);
            double d = 0.0;
            if (arrayList3 != null && arrayList3.size() > 0) {
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    StringTokenizer stringTokenizer;
                    String string5 = (String)arrayList3.get(i);
                    if (string5 == null || (stringTokenizer = new StringTokenizer(string5)).countTokens() < 3) continue;
                    String string6 = stringTokenizer.nextToken();
                    String string7 = stringTokenizer.nextToken();
                    String string8 = stringTokenizer.nextToken();
                    if (!string8.equalsIgnoreCase("alive")) continue;
                    arrayList.add(string6);
                }
            }
        }
        object = new ArrayList(new HashSet(arrayList));
        return object;
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }

    private boolean isITExcludeOrIgnoredVmList(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        boolean bl = false;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            if (string2 == null || !EgUtilities.isMatch((String)string.toLowerCase(), (String)string2.toLowerCase())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ArrayList getMeasures(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("EsxGuestsMonitor  " + string + "command failed to execute");
            return null;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() <= 0) {
            System.out.println("In EsxGuestsMonitor the command  " + string + " is not in expected format");
            return null;
        }
        return arrayList2;
    }
}

