/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class InterfaceDetailsTest
extends EgSnmpGenericTest {
    public static String Sync = new String("InterfaceDetailsTest Object Lock");
    private static Hashtable prevTimeHash = new Hashtable();
    private static String oldInterfaceName_Oid = ".1.3.6.1.2.1.2.2.1.2";
    private static String interfaceAliasName_Oid = ".1.3.6.1.2.1.31.1.1.1.18";
    private static String oldInterfaceSpeed_Oid = ".1.3.6.1.2.1.2.2.1.5";
    private static String newInterfaceSpeed_Oid = ".1.3.6.1.2.1.31.1.1.1.15";
    private static String newInterfaceName_Oid = ".1.3.6.1.2.1.31.1.1.1.1";
    private static String ifTypeOid = ".1.3.6.1.2.1.2.2.1.3";
    private Hashtable<String, String> ifInternalNames = null;
    private Hashtable<String, String> ifInternalTypes = null;
    private Hashtable<String, String> ifAliasNames = null;
    private static HashMap interfaceHashForAllDevice = new HashMap();
    private static HashMap SingleHashForAllDevice = new HashMap();
    private String deviceIP = "";
    private String interfaceName_Oid = "";
    private boolean isDone = false;
    private boolean useExtension = false;
    public static EgDnsManager dns;
    private static final String agntConfigPath;
    private static final String netflowConfigPath;
    private static Hashtable syncHash;
    private String mySyncString = null;

    public InterfaceDetailsTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("use_ifx_name");
        this.interfaceName_Oid = string.equalsIgnoreCase("yes") && string != null && string.length() > 0 ? newInterfaceName_Oid : oldInterfaceName_Oid;
        String string2 = this.getValueForParam("useExtension");
        this.useExtension = string2 == null || string2.length() <= 0 || !string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("false");
        dns = EgDnsManager.getInstance();
    }

    public void getIface() {
        try {
            this.ifInternalNames = new Hashtable();
            this.ifInternalTypes = new Hashtable();
            this.ifAliasNames = new Hashtable();
            Hashtable hashtable = new Hashtable();
            this.ifInternalNames = this.getMeasure(this.interfaceName_Oid);
            this.ifAliasNames = this.getMeasure(interfaceAliasName_Oid);
            ArrayList arrayList = new ArrayList();
            if (this.ifInternalNames != null && this.ifInternalNames.size() > 0) {
                if (this.ifAliasNames != null && this.ifAliasNames.size() > 0) {
                    if (this.ifInternalNames.size() == this.ifAliasNames.size()) {
                        arrayList.add(this.ifAliasNames);
                    } else {
                        this.mapInternalNames();
                        arrayList.add(this.ifInternalNames);
                    }
                } else {
                    arrayList.add(this.ifInternalNames);
                }
            } else if (this.ifAliasNames != null && this.ifAliasNames.size() > 0) {
                arrayList.add(this.ifAliasNames);
            } else {
                arrayList.add(new Hashtable());
            }
            if (this.useExtension) {
                hashtable = this.getMeasure(newInterfaceSpeed_Oid);
                if (hashtable != null) {
                    arrayList.add(hashtable);
                } else {
                    hashtable = this.getMeasure(oldInterfaceSpeed_Oid);
                    if (hashtable != null) {
                        arrayList.add(hashtable);
                    } else {
                        arrayList.add(new Hashtable());
                    }
                }
            } else {
                hashtable = this.getMeasure(oldInterfaceSpeed_Oid);
                if (hashtable != null) {
                    arrayList.add(hashtable);
                } else {
                    hashtable = this.getMeasure(newInterfaceSpeed_Oid);
                    if (hashtable != null) {
                        arrayList.add(hashtable);
                    } else {
                        arrayList.add(new Hashtable());
                    }
                }
            }
            this.ifInternalTypes = this.getMeasure(ifTypeOid);
            this.ifInternalTypes = this.organizeInterfaceTypes(this.ifInternalTypes);
            if (this.ifInternalTypes != null) {
                arrayList.add(this.ifInternalTypes);
            } else {
                arrayList.add(new Hashtable());
            }
            this.setSingleHash(arrayList, hashtable.keySet());
            interfaceHashForAllDevice.put(this.deviceIP, arrayList);
        }
        catch (Exception exception) {
            System.err.println("Exception occured while getting Interface details for " + this.deviceIP);
        }
    }

    private Hashtable<String, String> organizeInterfaceTypes(Hashtable<String, String> hashtable) {
        IniFile iniFile = new IniFile(agntConfigPath + "eg_tests.ini");
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = hashtable.get(string);
            String string3 = iniFile.getValue("NetworkInterfaceTest_Descriptor", string2).trim();
            if (string3 != null && string3.length() > 0) {
                hashtable.put(string, string3);
                continue;
            }
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    private void setSingleHash(ArrayList arrayList, Set set) {
        try {
            Object[] objectArray = set.toArray();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = ((Hashtable)arrayList.get(1)).get(string) + "," + ((Hashtable)arrayList.get(0)).get(string) + "," + ((Hashtable)arrayList.get(2)).get(string);
                hashtable.put(string, string2);
            }
            SingleHashForAllDevice.put(this.deviceIP, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void mapInternalNames() {
        Enumeration<String> enumeration = this.ifInternalNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!this.ifAliasNames.containsKey(string) || this.ifAliasNames.get(string) == null || this.ifAliasNames.get(string).trim().length() <= 0) continue;
            this.ifInternalNames.put(string, this.ifAliasNames.get(string));
        }
    }

    public Hashtable getMeasure(String string) {
        try {
            boolean bl = false;
            bl = this.runSnmpCmdForOid(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".") || this.lhs[i] == null || this.lhs[i].trim().length() == 0 || this.rhs[i] == null || this.rhs[i].trim().length() == 0) continue;
                    hashtable.put(this.lhs[i], this.rhs[i]);
                }
                return hashtable;
            }
            return null;
        }
        catch (Exception exception) {
            System.err.println("Exception occured while getting Interface details for " + this.deviceIP);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getInterfaceDetails(String string, long l) {
        String string2;
        if (this.mySyncString == null) {
            string2 = Sync;
            synchronized (string2) {
                if (this.mySyncString == null) {
                    this.mySyncString = (String)syncHash.get(string);
                    if (this.mySyncString == null) {
                        this.mySyncString = new String(string);
                        syncHash.put(string, this.mySyncString);
                    }
                }
            }
        }
        string2 = this.mySyncString;
        synchronized (string2) {
            this.deviceIP = string;
            long l2 = this.getPrevRunTime();
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            if ((double)l4 >= 0.9 * (double)l * 12.0) {
                this.isDone = true;
                this.setLastRunTime(l3);
            } else {
                this.isDone = false;
            }
            if (this.isDone) {
                this.getIface();
                this.updateToFile();
            }
            try {
                return (ArrayList)interfaceHashForAllDevice.get(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private long getPrevRunTime() {
        Long l = (Long)prevTimeHash.get(this.deviceIP);
        long l2 = 0L;
        if (l != null) {
            l2 = l;
        }
        return l2;
    }

    private void setLastRunTime(long l) {
        prevTimeHash.put(this.deviceIP, new Long(l));
    }

    private void updateToFile() {
        try {
            File file;
            Hashtable hashtable = (Hashtable)SingleHashForAllDevice.get(this.deviceIP);
            if (hashtable == null) {
                return;
            }
            Properties properties = new Properties();
            String string = ".properties";
            File file2 = new File(netflowConfigPath);
            String string2 = netflowConfigPath;
            if (!Files.exists(file2.toPath(), new LinkOption[0])) {
                Files.createDirectory(file2.toPath(), new FileAttribute[0]);
            }
            if ((file = new File(string2 = string2 + this.deviceIP + string)).exists()) {
                file.delete();
                file.createNewFile();
            } else {
                file.createNewFile();
            }
            properties.putAll((Map<?, ?>)hashtable);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "Interface speed,Interface Name,Interface Type");
        }
        catch (IOException iOException) {
            System.err.println("IO Exception:" + iOException);
        }
    }

    static {
        agntConfigPath = EgInstallInfo.getInstallDir() + "/agent/config/";
        netflowConfigPath = EgInstallInfo.getInstallDir() + "/NetFlow/config/templates/";
        syncHash = new Hashtable();
    }
}

