/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class MongoTicket
extends MongoDBBase {
    private boolean isFirstTime = true;
    private String engineType = "";
    private double versionNumber = 1.0;
    private ArrayList prevTicketList = new ArrayList();
    private Hashtable prevValueHT_WRAP = new Hashtable();
    private Hashtable prevValueHT = new Hashtable();

    public MongoTicket(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
    }

    public static void main(String[] stringArray) {
        MongoTicket mongoTicket = new MongoTicket(stringArray);
        mongoTicket.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = this.methodNameTemplate("computeMeasures");
        try {
            this.collectMetrics();
            Hashtable hashtable2 = this.getData();
            if (hashtable2 == null) {
                this.printOut(string + "After call getData() method ::: metricHash.size : 0 metricHash : null");
                return;
            }
            this.printOut(string + "After call getData() method ::: metricHash.size : " + hashtable2.size() + " metricHash : " + hashtable2);
            Hashtable hashtable3 = (Hashtable)hashtable2.get("serverStatus");
            if (hashtable3 == null || hashtable3.size() == 0) {
                return;
            }
            Set set = hashtable3.keySet();
            for (String string2 : set) {
                Hashtable hashtable4 = (Hashtable)hashtable3.get(string2);
                Set set2 = hashtable4.keySet();
                for (String string3 : set2) {
                    Object object;
                    Hashtable hashtable5 = (Hashtable)hashtable4.get(string3);
                    if (!this.prevValueHT_WRAP.isEmpty() && this.prevValueHT_WRAP.containsKey(string3)) {
                        this.prevValueHT = (Hashtable)this.prevValueHT_WRAP.get(string3);
                        this.prevTicketList = (ArrayList)this.prevValueHT.get("prevTicketList");
                    }
                    if (this.isFirstTime) {
                        if (hashtable5.containsKey("version") && hashtable5.containsKey("storageEngine")) {
                            object = (String)hashtable5.get("version");
                            this.engineType = (String)hashtable5.get("storageEngine");
                            if (object != null && ((String)object).length() > 0) {
                                object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                                try {
                                    this.versionNumber = Double.parseDouble((String)object);
                                }
                                catch (Exception exception) {
                                    this.isFirstTime = true;
                                    return;
                                }
                            }
                        } else {
                            this.isFirstTime = true;
                            this.logToErrorFile("INFO :", this.entity + " Not able to find StorageEngine ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName);
                            return;
                        }
                    }
                    if (this.versionNumber < 3.2) {
                        this.logToErrorFile("INFO :", this.entity + " support from Mongo Database version 3.2 onwards ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName);
                        return;
                    }
                    object = (ArrayList)hashtable5.get("concurrentTransactions");
                    if (object == null || ((ArrayList)object).size() != 6) continue;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    d5 = this.getDoubleValue(String.valueOf(((ArrayList)object).get(0)));
                    d6 = this.getDoubleValue(String.valueOf(((ArrayList)object).get(1)));
                    d4 = this.getDoubleValue(String.valueOf(((ArrayList)object).get(2)));
                    d2 = this.getDoubleValue(String.valueOf(((ArrayList)object).get(3)));
                    d3 = this.getDoubleValue(String.valueOf(((ArrayList)object).get(4)));
                    d = this.getDoubleValue(String.valueOf(((ArrayList)object).get(5)));
                    if (d > 0.0) {
                        d7 = d2 / d * 100.0;
                    }
                    if (d4 > 0.0) {
                        d8 = d5 / d4 * 100.0;
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d8));
                    this.printOut(string + " Descriptor :: none , measureList :: " + arrayList);
                    this.addNewMeasure(arrayList);
                }
            }
            this.isFirstTime = false;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + " MongoTicket Exception while getting ticket measures. ", exception);
        }
    }

    private double getDoubleValue(String string) {
        String string2 = this.methodNameTemplate("getDoubleValue");
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + " MongoTicket Exception while get double value. ", exception);
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d2 >= 0.0 && d >= d2 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }
}

