/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class MongoUptimeTest
extends MongoDBBase {
    private boolean isFirstTime = true;
    double prevValue = 0.0;
    double diffuptime = 0.0;
    double rebooted = 0.0;
    private DataOutputStream dataOutStm = null;
    private DataInputStream dataInStm = null;
    private File file = null;
    public String ddLine = "";
    private String installdir = "";
    protected Hashtable uptimeHash_DD = new Hashtable();
    protected Hashtable rebootedHash_DD = new Hashtable();
    private static EgDateInfo dateInfo = new EgDateInfo();
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private Hashtable prevValueHT_WRAP = new Hashtable();
    private Hashtable prevValueHT = new Hashtable();

    public static void main(String[] stringArray) {
        MongoUptimeTest mongoUptimeTest = new MongoUptimeTest(stringArray);
        mongoUptimeTest.computeMeasures(new Hashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoUptimeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.installdir = EgInstallInfo.getInstallDir() + "/agent/logs/mongodbuptime_" + this.targetHost + "_" + this.portNo + ".log";
        this.file = new File(this.installdir);
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = this.methodNameTemplate("computeMeasures");
        this.ddLine = new String();
        double[] dArray = new double[1];
        double d = 0.0;
        long l = this.file.lastModified();
        try {
            this.collectMetrics();
            Hashtable hashtable2 = this.getData();
            if (hashtable2 == null) {
                this.printOut(string + "After call getData() method ::: metricHash.size : 0 metricHash : null");
                return;
            }
            this.printOut(string + "After call getData() method ::: metricHash.size : " + hashtable2.size() + " metricHash : " + hashtable2);
            Hashtable hashtable3 = (Hashtable)hashtable2.get("serverStatus");
            if (hashtable3 == null || hashtable3.size() == 0) {
                return;
            }
            Set set = hashtable3.keySet();
            for (String string2 : set) {
                Hashtable hashtable4 = (Hashtable)hashtable3.get(string2);
                Set set2 = hashtable4.keySet();
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string3 = (String)iterator.next();
                    Hashtable hashtable5 = (Hashtable)hashtable4.get(string3);
                    double d2 = 0.0;
                    try {
                        if (!hashtable5.containsKey("uptime")) {
                            return;
                        }
                        d2 = (Double)hashtable5.get("uptime");
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace(string + " MongoUptimeTest Exception while getting uptime measures from srvStatsHT. ", exception);
                        return;
                    }
                    dArray[0] = d2;
                    if (this.isFirstTime) {
                        d2 = dArray[0];
                        this.writeDoubleToFile(d2);
                        arrayList.add(new Double(0.0));
                        arrayList.add(new Double(-5.0));
                        d = d2 / 60.0;
                        arrayList.add(new Double(d));
                        this.printOut(string + " [isFirstTime] Descriptor :: none, measureList :: " + arrayList);
                        this.addNewMeasure(arrayList);
                    } else {
                        d2 = dArray[0];
                        this.prevValue = this.readDoubleFromFile();
                        if (d2 < this.prevValue) {
                            long l2;
                            arrayList.add(new Double(1.0));
                            arrayList.add(new Double(d2));
                            d = d2 / 60.0;
                            arrayList.add(new Double(d));
                            this.printOut(string + " [is not first time] (uptime < prevValue) Descriptor ::none , measureList :: " + arrayList);
                            this.addNewMeasure(arrayList);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                            Date date = null;
                            long l3 = 0L;
                            long l4 = 0L;
                            String string4 = "";
                            String string5 = "";
                            long l5 = System.currentTimeMillis();
                            if (this.isReportMgrTime) {
                                l2 = l5 - l;
                                l3 = dateInfo.egetUTCDate() - l2;
                                string4 = dateInfo.egetDate(l3);
                                l4 = dateInfo.egetUTCDate() - (long)d2 * 1000L;
                                string5 = dateInfo.egetDate(l4);
                            } else {
                                l3 = l;
                                date = new Date(l3);
                                string4 = simpleDateFormat.format(date);
                                l4 = l5 - (long)d2 * 1000L;
                                date = new Date(l4);
                                string5 = simpleDateFormat.format(date);
                            }
                            l2 = l4 - l3;
                            if (l2 > 0L) {
                                double d3 = (double)l2 / 1000.0 / 60.0;
                                String string6 = "No";
                                if (this.checkMaintenance()) {
                                    string6 = "Yes";
                                }
                                this.ddLine = string4 + fieldSep + string5 + fieldSep + this.round(d3, 4) + fieldSep + string6;
                            }
                        } else {
                            this.diffuptime = d2 - this.prevValue;
                            d = d2 / 60.0;
                            arrayList.add(new Double(0.0));
                            arrayList.add(new Double(this.diffuptime));
                            arrayList.add(new Double(d));
                            this.printOut(string + " [is not first time] !(uptime < prevValue) Descriptor :: none , measureList :: " + arrayList);
                            this.addNewMeasure(arrayList);
                        }
                    }
                    this.writeDoubleToFile(d2);
                }
                this.uptimeHash_DD.put("isRebooted", this.rebootedHash_DD);
            }
            this.isFirstTime = false;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + " MongoUptimeTest Exception while getting uptime measures. ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile(double d) {
        String string = this.methodNameTemplate("writeDoubleToFile");
        try {
            this.dataOutStm = new DataOutputStream(new FileOutputStream(this.file));
            this.dataOutStm.writeDouble(d);
            this.dataOutStm.flush();
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + " MongoUptimeTest Exception while write double to File. ", exception);
        }
        finally {
            try {
                this.dataOutStm.close();
            }
            catch (Exception exception) {}
            this.dataOutStm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readDoubleFromFile() {
        String string = this.methodNameTemplate("readDoubleFromFile");
        double d = 0.0;
        try {
            if (!this.file.exists()) {
                double d2 = -5.0;
                return d2;
            }
            this.dataInStm = new DataInputStream(new FileInputStream(this.file));
            d = this.dataInStm.readDouble();
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + " MongoUptimeTest Exception while read double from File. ", exception);
        }
        finally {
            try {
                this.dataInStm.close();
            }
            catch (Exception exception) {}
            this.dataInStm = null;
        }
        return d;
    }

    public void freeTest() {
        this.ddLine = new String();
    }
}

