/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraRacFlashAreaTest
extends GenericTest {
    private String username = "";
    private String password = "";
    private String oraSid = "";
    private static final int i_measureCount = 4;
    private boolean service = true;
    private String serviceName = "";
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private ArrayList prevInfoList = new ArrayList();
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraRacFlashAreaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        this.password = this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.password);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        this.printOut("end of constractor");
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        String string2;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                string2 = "tcps";
                object2 = this.targetHost;
                object = this.portNo;
                string = "";
                String string3 = "";
                if (this.service) {
                    string3 = this.serviceName;
                    string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=" + (String)object2 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string3 + ")))";
                } else {
                    string3 = this.oraSid;
                    string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=" + (String)object2 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SID=" + string3 + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        try {
            try {
                string2 = "select name, space_limit/1024/1024 space_limit_mb, space_used/1024/1024 space_used_mb from v$recovery_file_dest";
                this.printOut("OraRacFlashAreaTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                connection = this.isSSLEnabled ? ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.username, this.password, debug);
                if (connection == null) {
                    this.printOut("OraRacFlashAreaTest connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                    this.logToErrorFile("[OraRacFlashAreaTest] compute Measure()", "database conn is null ", "TargetHost" + this.targetHost);
                    int i = 0;
                    while (true) {
                        if (i >= this.prevInfoList.size()) {
                            Object var17_18 = null;
                            this.closeRset(resultSet);
                            this.closeStmt(statement);
                            this.closeConn(connection);
                            return;
                        }
                        object = new ArrayList();
                        string = (String)this.prevInfoList.get(i);
                        for (int j = 0; j < this.measureCount; ++j) {
                            ((ArrayList)object).add(new Double(-1.0));
                        }
                        this.printOut("Adding MeasureList :" + object);
                        this.addNewMeasure(string, (ArrayList)object);
                        ++i;
                    }
                }
                this.printOut("OraRacFlashAreaTest connection is established targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.prevInfoList = new ArrayList();
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + " serviceName:" + this.serviceName, exception.toString());
                    this.closeConn(connection);
                    Object var17_19 = null;
                    this.closeRset(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                this.printOut("OraRacFlashAreaTest statement is created targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.printOut("OraRacFlashAreaTest before executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                resultSet = statement.executeQuery(string2);
                this.printOut("OraRacFlashAreaTest after executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                while (resultSet.next()) {
                    object2 = resultSet.getString(1);
                    double d = resultSet.getDouble(2);
                    double d2 = resultSet.getDouble(3);
                    double d3 = d2 / d * 100.0;
                    double d4 = 100.0 - d3;
                    arrayList = new ArrayList();
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    this.printOut(" [OraRacFlashAreaTest] (addNewMeasure) Adding logInfoList :" + arrayList);
                    this.addNewMeasure((String)object2, arrayList);
                    this.prevInfoList.add(object2);
                }
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                this.printOut("Exception Occured in OraRacFlashAreaTest.computeMeasures():" + exception.toString());
                exception.printStackTrace();
                this.logToErrorFile("[OraRacFlashAreaTest] compute Measure()", "Exception ", exception.toString());
                object2 = new ArrayList();
                int i = 0;
                while (true) {
                    if (i >= this.measureCount) {
                        this.printOut("Adding MeasureList :" + object2);
                        this.addNewMeasure((ArrayList)object2);
                        Object var17_21 = null;
                        this.closeRset(resultSet);
                        this.closeStmt(statement);
                        this.closeConn(connection);
                        return;
                    }
                    ((ArrayList)object2).add(new Double(-1.0));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.closeRset(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
        Object var17_20 = null;
        this.closeRset(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
    }

    void closeRset(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public static void main(String[] stringArray) {
        OraRacFlashAreaTest oraRacFlashAreaTest = new OraRacFlashAreaTest(stringArray);
        oraRacFlashAreaTest.computeMeasures(new Hashtable());
    }
}

