/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraRacSqlConTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    public boolean service = true;
    public String serviceName = "";
    public boolean foundVersion = false;
    public boolean isSql9 = false;
    public boolean isSql10 = false;
    public boolean userPrivilege = true;
    public int defValue = -1;
    public String queryStmt;
    public double prevBytesSent = -1.0;
    public double prevBytesRecvd = -1.0;
    double kbytesSentRate;
    double kbytesRecvdRate;
    public String isSSL = "";
    public String trustStorePath = "";
    public String trustStoreType = "";
    public String trustStorePassword = "";
    public boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    public Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraRacSqlConTest oraRacSqlConTest = new OraRacSqlConTest(stringArray);
        oraRacSqlConTest.computeMeasures(new Hashtable());
    }

    public OraRacSqlConTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if (this.isPassive) {
            this.defValue = -5;
        }
        this.queryStmt = "SELECT name,value  FROM v$sysstat  WHERE NAME IN  ('bytes sent via SQL*Net to client','bytes received via SQL*Net from client','SQL*Net roundtrips to/from client')";
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        this.needAgentlessDD = true;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        ArrayList<Double> arrayList;
        Object object3;
        Object var2_2 = null;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object3 = "tcps";
                String string = this.targetHost;
                arrayList = this.portNo;
                object2 = "";
                object = "";
                if (this.service) {
                    object = this.serviceName;
                    object2 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object3 + ")(HOST=" + string + ")(PORT=" + arrayList + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)object + ")))";
                } else {
                    object = this.oraSid;
                    object2 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object3 + ")(HOST=" + string + ")(PORT=" + arrayList + "))(CONNECT_DATA=(SID=" + (String)object + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object2);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isPassive) {
            this.kbytesSentRate = this.defValue;
            this.kbytesRecvdRate = this.defValue;
        } else {
            this.kbytesSentRate = -5.0;
            this.kbytesRecvdRate = -5.0;
        }
        object3 = new OraRacSqlConHelper(this);
        boolean bl = this.checkForTimeout((OraRacSqlConHelper)object3);
        arrayList = new ArrayList();
        if (bl) {
            object2 = ((OraRacSqlConHelper)object3).names;
            object = ((OraRacSqlConHelper)object3).values;
            if (object2 == null || object == null || ((ArrayList)object2).size() == 0 || ((ArrayList)object).size() == 0) {
                arrayList = new ArrayList();
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
            } else {
                for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                    String string = (String)((ArrayList)object2).get(i);
                    Double d = (Double)((ArrayList)object).get(i);
                    double d2 = d;
                    if (string.startsWith("bytes sent")) {
                        if (this.prevBytesSent < 0.0 || this.prevBytesSent > d2 || this.timeSinceLastTest < 0.0) {
                            this.prevBytesSent = d2;
                            continue;
                        }
                        this.kbytesSentRate = (d2 - this.prevBytesSent) / (1000.0 * this.timeSinceLastTest);
                        this.kbytesSentRate = this.roundDouble(this.kbytesSentRate, 4);
                        if (new Double(this.kbytesSentRate).toString().length() >= 16) {
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate current value", "" + d2);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate previous value is ", "" + this.prevBytesSent);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate calculated value", "" + this.kbytesSentRate);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate value is too large", this.targetHost);
                            this.kbytesSentRate = -5.0;
                        }
                        this.prevBytesSent = d2;
                        continue;
                    }
                    if (!string.startsWith("bytes rec")) continue;
                    if (this.prevBytesRecvd < 0.0 || this.prevBytesRecvd > d2 || this.timeSinceLastTest < 0.0) {
                        this.prevBytesRecvd = d2;
                        continue;
                    }
                    this.kbytesRecvdRate = (d2 - this.prevBytesRecvd) / (1000.0 * this.timeSinceLastTest);
                    this.kbytesRecvdRate = this.roundDouble(this.kbytesRecvdRate, 4);
                    if (new Double(this.kbytesRecvdRate).toString().length() >= 16) {
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate current value is ", "" + d2);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate previous value is ", "" + this.prevBytesRecvd);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate calculated value", "" + this.kbytesRecvdRate);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate value is too large", this.targetHost);
                        this.kbytesRecvdRate = -5.0;
                    }
                    this.prevBytesRecvd = d2;
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
            }
        } else {
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.kbytesSentRate));
            arrayList.add(new Double(this.kbytesRecvdRate));
        }
        this.errorMsg = new String("Exception while executing OraRacSqlNetTest for target: " + this.targetHost);
        this.printOut("Adding MeasureList :" + arrayList);
        this.addNewMeasure(arrayList);
    }

    private boolean checkForTimeout(OraRacSqlConHelper oraRacSqlConHelper) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            long l4 = System.currentTimeMillis();
            this.suspendForPeriod(l3);
            if (oraRacSqlConHelper.done) {
                return true;
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            if (l6 < 0L) {
                l6 = l3;
            }
            if ((l2 += l6) >= this.timeout) {
                this.printOut("OraRacSqlNetTest timeout happeneded ... " + l2);
                double d = this.timeout / 1000L;
                oraRacSqlConHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oraRacSqlConHelper.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        double d = this.timeout / 1000L;
        oraRacSqlConHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        oraRacSqlConHelper.stop();
        this.printOut("OraRacSqlNetTest timeout happeneded ... " + l2);
        return false;
    }

    public void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < EgAgentCommon.minimumSleep) {
                l = EgAgentCommon.minimumSleep;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                this.printOut("Error :" + exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private double roundDouble(double d, int n) {
        Object object;
        double d2 = 0.0;
        Object object2 = "";
        if (n <= 0) {
            object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        } else {
            String string;
            object = "";
            if (d < 0.0) {
                object = (String)object + "-";
                d = -d;
            }
            if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                int n2 = (int)d;
                object = (String)object + n2;
                d -= (double)n2;
            } else {
                object = (String)object + "0";
            }
            if (d > 0.0) {
                String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                object = (String)object + "." + string2.substring(1);
            }
            object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
        }
        object = new Double((String)object2);
        d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        return d2;
    }
}

