/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.EgApmFilesSync;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisClstrBase
extends RedisBase {
    protected String mstrSlvGrpPrefix = "";
    protected boolean mstrSlvGrp = false;
    protected String clusterNodes = "";
    protected static final String metaFileLocation = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs/eg_metadata.ini";

    public RedisClstrBase(String[] args) {
        super(args);
        try {
            this.needAgentlessDD = true;
            this.mstrSlvGrpPrefix = this.getValueForParam("master_slave_group_prefix");
            this.mstrSlvGrp = Boolean.parseBoolean(this.getValueForParam("master_slave_group"));
            this.clusterNodes = this.getValueForParam("cluster_nodes");
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisClusterTest", (Object)this.logPrefix, (Object)e);
        }
    }

    public boolean isRedisServerReachable() {
        boolean status = false;
        Jedis jedis = null;
        try {
            try {
                jedis = this.getConnection();
                String serverStatus = "none";
                try {
                    jedis.connect();
                    if (jedis.isConnected()) {
                        status = true;
                    } else {
                        logger.info("{} Agent NOT ABLE to connect Redis server...Please check redis server is UP or Give correct IP / PORT ", (Object)this.logPrefix);
                    }
                    try {
                        serverStatus = jedis.ping();
                        logger.debug("{} Able to connect Redis server... Response from Redis server : {}", (Object)this.logPrefix, (Object)serverStatus);
                        boolean bl = serverStatus.equals("PONG");
                    }
                    catch (JedisConnectionException e) {
                        status = false;
                    }
                }
                catch (JedisConnectionException e) {
                    status = false;
                    logger.debug("{} Error occured while connecting redis server..check redis server is UP or Please give correct IP / PORT / PASSWORD.  Exception message : {}", (Object)this.logPrefix, (Object)e.getMessage());
                }
                catch (Exception exp) {
                    status = false;
                    logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exp);
                }
            }
            catch (Exception exp) {
                logger.debug("{} Error occured while connecting redis server..check redis server is UP...", (Object)this.logPrefix);
                status = false;
            }
        }
        catch (Throwable throwable) {}
        this.closeConnection(jedis);
        return status;
    }

    public String getMetrics(String redisCommand, String ip, int port) {
        Jedis jedisConnection;
        String redisCommandOutput;
        block6: {
            if (redisCommand == null || redisCommand.length() <= 0) {
                logger.info("{} REDIS_COMMAND is NULL or EMPTY hence returning null String", (Object)this.logPrefix);
                return null;
            }
            redisCommandOutput = null;
            jedisConnection = null;
            jedisConnection = this.getConnection(ip, port);
            if (jedisConnection != null) break block6;
            logger.info("{} JEDIS Connection object is NULL hence returning null String", (Object)this.logPrefix);
            this.closeConnection(jedisConnection);
            jedisConnection = null;
            return null;
        }
        try {
            try {
                redisCommandOutput = jedisConnection.info(redisCommand);
                logger.debug("{} Successfully executed the REDIS Command", (Object)this.logPrefix);
            }
            catch (Exception e) {
                logger.warn("{} [getRedisMetrics] Exception occured while connecting to Redis.. {}:{}", new Object[]{this.logPrefix, ip, port, e});
                this.closeConnection(jedisConnection);
                jedisConnection = null;
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(jedisConnection);
            jedisConnection = null;
            throw throwable;
        }
        this.closeConnection(jedisConnection);
        jedisConnection = null;
        logger.debug("{} Result for REDIS Command [" + redisCommand + "] :{}", (Object)this.logPrefix, (Object)redisCommandOutput);
        return redisCommandOutput;
    }

    public String getMetrics(String redisCommand, ArrayList nodeList) {
        String redisCommandOutput = null;
        if (redisCommand == null || redisCommand.length() <= 0) {
            logger.info("{} getMetrics() nodeList REDIS_COMMAND is NULL or EMPTY hence returning null String", (Object)this.logPrefix);
            return null;
        }
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.size()) {
                block16: {
                    String nodesDetails = (String)nodeList.get(i);
                    if (nodesDetails != null) {
                        int port;
                        String ip;
                        Jedis jedisConnection;
                        block14: {
                            jedisConnection = null;
                            ip = "0.0.0.0";
                            port = 0;
                            int index = nodesDetails.indexOf("#");
                            if (index > 0) {
                                ip = nodesDetails.substring(0, index).trim();
                                port = Integer.parseInt(nodesDetails.substring(index + 1).trim());
                            }
                            if ((jedisConnection = this.getConnection(ip, port)) != null) break block14;
                            logger.info("{} JEDIS Connection object is NULL hence returning null String", (Object)this.logPrefix);
                            this.closeConnection(jedisConnection);
                            if (redisCommandOutput != null && redisCommandOutput.length() > 0) {
                                logger.debug("{} Result found for {}-{}", new Object[]{this.logPrefix, nodesDetails, redisCommand});
                                return redisCommandOutput;
                            }
                            return null;
                        }
                        try {
                            try {
                                redisCommandOutput = jedisConnection.info(redisCommand);
                                logger.debug("{} Successfully executed the REDIS Command", (Object)this.logPrefix);
                                logger.debug("{} II Result for REDIS Command [" + redisCommand + "] :{}", (Object)this.logPrefix, (Object)redisCommandOutput);
                            }
                            catch (Exception e) {
                                logger.warn("{} [getRedisMetrics] Exception occured while connecting to Redis.. {}:{}", new Object[]{this.logPrefix, ip, port, e});
                                this.closeConnection(jedisConnection);
                                if (redisCommandOutput != null && redisCommandOutput.length() > 0) {
                                    logger.debug("{} Result found for {}-{}", new Object[]{this.logPrefix, nodesDetails, redisCommand});
                                    return redisCommandOutput;
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            this.closeConnection(jedisConnection);
                            if (redisCommandOutput != null && redisCommandOutput.length() > 0) {
                                logger.debug("{} Result found for {}-{}", new Object[]{this.logPrefix, nodesDetails, redisCommand});
                                return redisCommandOutput;
                            }
                            throw throwable;
                        }
                        this.closeConnection(jedisConnection);
                        if (redisCommandOutput != null && redisCommandOutput.length() > 0) {
                            logger.debug("{} Result found for {}-{}", new Object[]{this.logPrefix, nodesDetails, redisCommand});
                            return redisCommandOutput;
                        }
                    }
                }
                ++i;
            }
        }
        return redisCommandOutput;
    }

    public String getMetricsWithRetry(String redisCommand) {
        ArrayList nodeList;
        String measureString = this.getMetrics(redisCommand);
        if ((measureString == null || measureString.length() <= 0) && (nodeList = this.getNodesList()) != null) {
            measureString = this.getMetrics(redisCommand, nodeList);
        }
        return measureString;
    }

    private ArrayList getNodesList() {
        ArrayList nodeList = new ArrayList();
        nodeList = this.isClusterNodesAutoDiscoveryEnabled() ? this.getClusterNodesFromIni() : this.getClusterNodesFromTestParam();
        logger.trace("{} getNodesList() isClusterNodesAutoDiscoveryEnabled : {}, nodeList : {}", new Object[]{this.logPrefix, this.isClusterNodesAutoDiscoveryEnabled(), nodeList});
        return nodeList;
    }

    boolean isClusterNodesAutoDiscoveryEnabled() {
        if (this.clusterNodes != null) {
            return this.clusterNodes.equalsIgnoreCase("auto_discover");
        }
        return false;
    }

    ArrayList getClusterNodesFromTestParam() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.clusterNodes != null) {
            String commaSep = ",";
            StringTokenizer nodeTokenizer = new StringTokenizer(this.clusterNodes, commaSep);
            while (nodeTokenizer.hasMoreTokens()) {
                String nodeData = nodeTokenizer.nextToken();
                if (nodeData == null || list.contains(nodeData.trim())) continue;
                list.add(nodeData.trim());
            }
        }
        return list;
    }

    public boolean isClusterEnabled() {
        try {
            String REDIS_CLUSTER_COMMAND = "Cluster";
            String measureString = this.getMetrics(REDIS_CLUSTER_COMMAND);
            Hashtable results = this.parseMetrics(measureString, false);
            Hashtable cluster = (Hashtable)results.get("Cluster");
            if (((String)cluster.get("cluster_enabled")).equals("1")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("{} Exception occurs while checking cluster enabled or not.", (Object)this.logPrefix);
        }
        return false;
    }

    public boolean isClusterEnabledWithRetry() {
        boolean clusterEnabled = false;
        try {
            String measureString;
            Hashtable results;
            Hashtable cluster;
            String REDIS_CLUSTER_COMMAND = "Cluster";
            clusterEnabled = this.isClusterEnabled();
            if (!clusterEnabled && ((String)(cluster = (Hashtable)(results = this.parseMetrics(measureString = this.getMetricsWithRetry(REDIS_CLUSTER_COMMAND), false)).get("Cluster")).get("cluster_enabled")).equals("1")) {
                clusterEnabled = true;
            }
        }
        catch (Exception e) {
            logger.warn("{} Exception occurs while checking cluster enabled or not.", (Object)this.logPrefix);
        }
        return clusterEnabled;
    }

    public Hashtable groupMasterSlaveNodes(String clusterNodes) {
        int slaveCount;
        int masterCount;
        TreeMap<Long, String> slotOrder;
        Hashtable<String, Serializable> masterMap = new Hashtable<String, Serializable>();
        if (clusterNodes != null && clusterNodes.length() > 0) {
            StringTokenizer lineTokenizer = new StringTokenizer(clusterNodes, "\n");
            Hashtable slaveGrp = null;
            slotOrder = new TreeMap<Long, String>();
            masterCount = 0;
            slaveCount = 0;
            logger.debug("{} cluster nodes got from cluster : {}", (Object)this.logPrefix, (Object)clusterNodes);
            while (lineTokenizer.hasMoreTokens()) {
                slaveGrp = new Hashtable();
                String id = "-";
                String ip = "0";
                String port = "0";
                String flags = "-";
                String master = "-";
                String slot = "-";
                String lineString = lineTokenizer.nextToken().trim();
                try {
                    String[] measureTokenizer = lineString.split(" ");
                    id = measureTokenizer[0];
                    String ipPort = measureTokenizer[1];
                    if (ipPort.contains(":") && ipPort.length() > 5 && !ipPort.startsWith(":")) {
                        StringTokenizer ipTokenizer = new StringTokenizer(ipPort, ":");
                        while (ipTokenizer.hasMoreTokens()) {
                            ip = ipTokenizer.nextToken();
                            port = ipTokenizer.nextToken();
                            String string = port = port.contains("@") ? port.substring(0, port.indexOf("@")) : port;
                        }
                    } else if (ipPort.length() > 5 && ipPort.startsWith(":")) {
                        ip = "0";
                        port = (ipPort = ipPort.substring(1)).contains("@") ? ipPort.substring(0, ipPort.indexOf("@")) : ipPort;
                    }
                    flags = measureTokenizer[2].contains("master") ? "master" : "replica";
                    master = measureTokenizer[3];
                    logger.debug("{} parsed ip and port from cluster nodes {} : {}  and cluster role", new Object[]{this.logPrefix, ip, port, flags});
                    slot = measureTokenizer.length > 8 ? measureTokenizer[8] : "-";
                    String masterId = measureTokenizer[2].contains("master") ? id : master;
                    this.storeIpAndPortInMetaData(ip, port, id, flags, masterId);
                    String descriptor = "";
                    descriptor = ip.equals("0") || port.equals("0") ? this.getIpAndPortFromMetaData(ip, port, id) : String.valueOf(ip) + ":" + port;
                    String dummySlot = "99999";
                    if (flags.contains("master")) {
                        ++masterCount;
                        if (masterMap.get(id) != null) {
                            slaveGrp = (Hashtable)masterMap.get(id);
                        }
                        slaveGrp.put(descriptor, flags);
                        if (!slot.equals("-")) {
                            String slotLowerBound = slot.split("-")[0];
                            slotOrder.put(Long.parseLong(slotLowerBound), id);
                        } else {
                            slotOrder.put(Long.parseLong(String.valueOf(dummySlot) + masterCount), id);
                        }
                        masterMap.put(id, slaveGrp);
                        continue;
                    }
                    if (masterMap.get(master) != null && !masterMap.isEmpty()) {
                        slaveGrp = (Hashtable)masterMap.get(master);
                        slaveGrp.put(descriptor, flags);
                        masterMap.put(master, slaveGrp);
                        ++slaveCount;
                        continue;
                    }
                    slaveGrp.put(descriptor, flags);
                    masterMap.put(master, slaveGrp);
                    ++slaveCount;
                }
                catch (Exception e) {
                    logger.warn("{} - Exception while parsing the values : {}, mastermap : {} and the exception is :{} ", new Object[]{this.logPrefix, lineString, masterMap, e});
                }
            }
        } else {
            logger.warn("{} cluster node values  are null: {}", (Object)this.logPrefix);
            return masterMap;
        }
        masterMap.put("masterNodes", Integer.valueOf(masterCount));
        masterMap.put("slaveNodes", Integer.valueOf(slaveCount));
        masterMap.put("sortedList", new ArrayList(slotOrder.values()));
        logger.debug("{} groupMasterSlaveNodes() slotOrder : {} and ip:port {}", (Object)this.logPrefix, slotOrder);
        return masterMap;
    }

    private void storeIpAndPortInMetaData(String ip, String port, String id, String role, String masterId) {
        IniFile iniFile = EgApmFilesSync.getInstance((String)metaFileLocation, (boolean)true);
        try {
            try {
                String val = iniFile.getValue("REDIS_OSS_CLUSTER_NODES_INFO_" + this.reportingName + "_" + this.portNo, id);
                String metdata = String.valueOf(ip) + "," + port + "," + role + "," + masterId;
                if (!(val != null && val.length() != 0 && val.equalsIgnoreCase(metdata) || ip.equals("0") || port.equals("0"))) {
                    iniFile.setValue("REDIS_OSS_CLUSTER_NODES_INFO_" + this.reportingName + "_" + this.portNo, id, metdata);
                }
            }
            catch (Exception e) {
                logger.warn("{} - {} Exception occurs while storing redis ip and port to metadata.ini : {} ", (Object)this.reportingName, (Object)e);
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance((IniFile)iniFile);
            }
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance((IniFile)iniFile);
        }
    }

    private String getIpAndPortFromMetaData(String ip, String port, String id) {
        IniFile iniFile = new IniFile(metaFileLocation);
        String descriptor = "";
        try {
            String data = iniFile.getValue("REDIS_OSS_CLUSTER_NODES_INFO_" + this.reportingName + "_" + this.portNo, id);
            if (data == null || data.length() <= 0 || data.lastIndexOf(",") <= 1) {
                return String.valueOf(id) + ":0";
            }
            descriptor = String.valueOf(data.split(",")[0]) + ":" + data.split(",")[1];
            logger.debug("{} - {}  Getting redis ip and port from metadata.ini : {} ", (Object)this.reportingName, (Object)descriptor);
        }
        catch (Exception e) {
            logger.warn("{} - {} Exception occurs while getting redis ip and port to metadata.ini : {} ", (Object)this.reportingName, (Object)e);
        }
        return descriptor;
    }

    protected ArrayList getClusterNodesFromIni() {
        ArrayList<String> nodesdata = new ArrayList<String>();
        IniFile iniFile = new IniFile(metaFileLocation);
        logger.trace("{} Getting all node details from from metadata.ini", (Object)this.logPrefix);
        try {
            Vector data = iniFile.getAllValues("REDIS_OSS_CLUSTER_NODES_INFO_" + this.reportingName + "_" + this.portNo);
            logger.trace("{} getClusterNodesFromIni() nodeValues : {}", (Object)this.logPrefix, (Object)data);
            if (data != null && data.size() > 0) {
                int i = 0;
                while (i < data.size()) {
                    String[] array;
                    String nodeIniValue = (String)data.get(i);
                    if (nodeIniValue != null && (array = nodeIniValue.split(",")) != null && array.length >= 2) {
                        String ip = array[0];
                        String port = array[1];
                        nodesdata.add(String.valueOf(ip) + "#" + port);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.warn("{} - Exception occurs while getting redis ip and port details from metadata.ini : {} ", (Object)this.logPrefix, (Object)e);
        }
        return nodesdata;
    }

    Hashtable getClusterNodes() {
        Hashtable clusterData = new Hashtable();
        try {
            String flag = "clusterNodes";
            String clusterNodes = this.getClusterDetails(flag);
            clusterData = this.groupMasterSlaveNodes(clusterNodes);
            logger.debug("{} clusterNodes : {}", (Object)this.logPrefix, (Object)clusterNodes);
            logger.debug("{} clusterData : {}", (Object)this.logPrefix, (Object)clusterData);
        }
        catch (Exception e) {
            logger.warn("{} - {} Exception occurs while getting cluster node : {} ", (Object)this.logPrefix, (Object)e);
        }
        return clusterData;
    }

    Hashtable getClusterNodesWithRetry() {
        Hashtable clusterData = new Hashtable();
        try {
            String clusterNodes = this.getClusterNodesDetailsOuput();
            clusterData = this.groupMasterSlaveNodes(clusterNodes);
            logger.debug("{} getClusterNodesWithRetryclusterNodes : {}", (Object)this.logPrefix, (Object)clusterNodes);
            logger.debug("{} clusterData : {}", (Object)this.logPrefix, (Object)clusterData);
        }
        catch (Exception e) {
            logger.warn("{} - {} Exception occurs while getting cluster node : {} ", (Object)this.logPrefix, (Object)e);
        }
        return clusterData;
    }

    String getClusterNodesDetailsOuput() {
        String clusterNodes = null;
        try {
            String flag = "clusterNodes";
            clusterNodes = this.getClusterDetails(flag);
            if (clusterNodes == null || clusterNodes.length() == 0) {
                ArrayList nodeList = this.getNodesList();
                clusterNodes = this.getClusterDetailsWithRetry(flag, nodeList);
            }
        }
        catch (Exception e) {
            logger.warn("{} - {} Exception occurs while getting cluster node output : {} ", (Object)this.logPrefix, (Object)e);
        }
        return clusterNodes;
    }

    String getClusterInfoDetailsOuput() {
        String clusterNodes = null;
        try {
            String flag = "clusterInfo";
            clusterNodes = this.getClusterDetails(flag);
            if (clusterNodes == null || clusterNodes.length() == 0) {
                ArrayList nodeList = this.getNodesList();
                clusterNodes = this.getClusterDetailsWithRetry(flag, nodeList);
            }
        }
        catch (Exception e) {
            logger.warn("{} - {} Exception occurs while getting cluster node output : {} ", (Object)this.logPrefix, (Object)e);
        }
        return clusterNodes;
    }

    public String getClusterDetails(String flag) {
        Jedis jedis = null;
        String clusterDetails = null;
        try {
            try {
                jedis = this.getConnection();
                if (flag.equalsIgnoreCase("clusterInfo")) {
                    clusterDetails = jedis.clusterInfo();
                } else if (flag.equalsIgnoreCase("clusterNodes")) {
                    clusterDetails = jedis.clusterNodes();
                }
            }
            catch (Exception e) {
                logger.warn("{} - Exception occured while connecting redis cluster {}", new Object[]{this.logPrefix, this.entity, e});
                this.closeConnection(jedis);
            }
        }
        finally {
            this.closeConnection(jedis);
        }
        return clusterDetails;
    }

    public String getClusterDetailsWithRetry(String flag, ArrayList nodeList) {
        String clusterDetails = null;
        try {
            if (nodeList != null) {
                int i = 0;
                while (i < nodeList.size()) {
                    String nodesDetails = (String)nodeList.get(i);
                    if (nodesDetails != null) {
                        String ip = "0.0.0.0";
                        int port = 0;
                        int index = nodesDetails.indexOf("#");
                        if (index > 0) {
                            ip = nodesDetails.substring(0, index).trim();
                            port = Integer.parseInt(nodesDetails.substring(index + 1).trim());
                        }
                        if ((clusterDetails = this.getClusterDetails(flag, ip, port)) != null && clusterDetails.length() > 0) {
                            logger.debug("{} getClusterDetailsWithRetry() Result found for {}-{}", new Object[]{this.logPrefix, nodesDetails, clusterDetails});
                            return clusterDetails;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.warn("{} - Exception occured while connecting redis cluster {}", (Object)this.logPrefix, (Object)e);
        }
        return clusterDetails;
    }

    public String getClusterDetails(String flag, String ip, int port) {
        String clusterDetails;
        block8: {
            Jedis jedis = null;
            clusterDetails = null;
            try {
                try {
                    jedis = this.getConnection(ip, port);
                    if (flag.equalsIgnoreCase("clusterInfo")) {
                        clusterDetails = jedis.clusterInfo();
                    } else if (flag.equalsIgnoreCase("clusterNodes")) {
                        clusterDetails = jedis.clusterNodes();
                    }
                }
                catch (Exception e) {
                    logger.warn("{} Exception occured while connecting redis cluster {}", (Object)this.logPrefix, (Object)e);
                    this.closeConnection(jedis);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(jedis);
                throw throwable;
            }
            this.closeConnection(jedis);
        }
        return clusterDetails;
    }

    public ArrayList finalMeasuresAsUnknown(int size) {
        ArrayList<Double> measure = new ArrayList<Double>();
        int z = 0;
        while (z < size) {
            measure.add(new Double(-1.0));
            ++z;
        }
        logger.trace("{} [finalMeasures] creating and initializing the measure list ", (Object)this.logPrefix);
        return measure;
    }

    public ArrayList finalMeasuresAsNotApplicable(int size) {
        ArrayList<Double> measure = new ArrayList<Double>();
        int z = 0;
        while (z < size) {
            measure.add(new Double(-3.0));
            ++z;
        }
        logger.trace("{} [finalMeasures] creating and initializing the measure list ", (Object)this.logPrefix);
        return measure;
    }
}

