/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceBridgeStTest
extends GenericTest {
    private String urlStr = "";
    private String userName = this.getValueForParam("username");
    private String password = this.getValueForParam("password");
    private String portNumber = this.getValueForParam("port");
    private String sysPackage;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private int timeout = 60;
    private URL url;
    private boolean isFirst = true;
    private static final String BRIDGE_STATUS_CMD = "<rpc><show><bridge><bridge-name-pattern>*</bridge-name-pattern></bridge></show></rpc>";

    public SolaceBridgeStTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("ssl");
        System.out.println(this.entity + " username ==>" + this.userName + " password ==>" + this.password + " ssl ==>" + string + " port number ==>" + this.portNumber);
        this.urlStr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "https://" + this.targetHost + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "http://" + this.targetHost + "/SEMP");
    }

    public void computeMeasures(Hashtable hashtable) {
        block14: {
            try {
                this.printOut("URL String ==>" + this.urlStr + " Bridge Status CMD ==>" + BRIDGE_STATUS_CMD);
                String string = this.getXMLOutput(this.urlStr, BRIDGE_STATUS_CMD);
                if (string == null || string.trim().length() == 0) {
                    if (this.isFirst) {
                        this.logToErrorFile("Info", "[SolaceBridgeStTest] No bridge details available for", this.targetHost);
                        this.isFirst = false;
                    }
                    return;
                }
                if (string == null || string.trim().length() <= 0 || string.contains("schema validation error")) break block14;
                org.json.JSONObject jSONObject = XML.toJSONObject((String)string);
                String string2 = jSONObject.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject2 = null;
                if (string2 == null || string2.trim().length() <= 0) break block14;
                try {
                    jSONObject2 = (JSONObject)jSONParser.parse(string2);
                    JSONObject jSONObject3 = this.getShowJSONObject(jSONObject2);
                    if (jSONObject3 != null) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        JSONObject jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3, "bridge");
                        JSONObject jSONObject5 = this.getJSONObjectFromJSONObject(jSONObject4, "bridges");
                        Object object6 = jSONObject5.get((Object)"bridge");
                        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
                        if (object6 instanceof JSONObject && (object5 = this.getBridgeStatusHash((JSONObject)(object4 = this.getJSONObjectFromJSONObject(jSONObject5, "bridge")))) != null && ((Hashtable)object5).size() > 0) {
                            object3 = ((Hashtable)object5).keys();
                            while (object3.hasMoreElements()) {
                                object2 = (String)object3.nextElement();
                                object = (ArrayList)((Hashtable)object5).get(object2);
                                this.printOut("Info1 ==>" + (String)object2 + " valList ==>" + object);
                                hashtable2.put(object2, object);
                            }
                        }
                        if (object6 instanceof JSONArray) {
                            object4 = (JSONArray)jSONObject5.get((Object)"bridge");
                            for (int i = 0; i < object4.size(); ++i) {
                                object3 = (JSONObject)object4.get(i);
                                object2 = this.getBridgeStatusHash((JSONObject)object3);
                                if (object2 == null || ((Hashtable)object2).size() <= 0) continue;
                                object = ((Hashtable)object2).keys();
                                while (object.hasMoreElements()) {
                                    String string3 = (String)object.nextElement();
                                    ArrayList arrayList = (ArrayList)((Hashtable)object2).get(string3);
                                    this.printOut("Info2 ==>" + string3 + " valList ==>" + arrayList);
                                    hashtable2.put(string3, arrayList);
                                }
                            }
                        }
                        if (hashtable2 != null && hashtable2.size() > 0) {
                            object4 = hashtable2.keys();
                            while (object4.hasMoreElements()) {
                                object5 = (String)object4.nextElement();
                                object3 = (ArrayList)hashtable2.get(object5);
                                this.printOut("Info ==>" + (String)object5 + " valList ==>" + object3);
                                this.addNewMeasure((String)object5, (ArrayList)object3);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
            }
        }
    }

    private Hashtable getBridgeStatusHash(JSONObject jSONObject) {
        Hashtable hashtable;
        block12: {
            hashtable = new Hashtable();
            try {
                if (jSONObject == null) break block12;
                String string = this.getValueFromJSONObject(jSONObject, "bridge-name");
                String string2 = this.getValueFromJSONObject(jSONObject, "local-vpn-name");
                String string3 = this.getValueFromJSONObject(jSONObject, "connected-remote-vpn-name");
                String string4 = this.getValueFromJSONObject(jSONObject, "connected-remote-router-name");
                String string5 = this.getValueFromJSONObject(jSONObject, "admin-state");
                String string6 = this.getValueFromJSONObject(jSONObject, "connection-establisher");
                String string7 = this.getValueFromJSONObject(jSONObject, "inbound-operational-state");
                String string8 = this.getValueFromJSONObject(jSONObject, "outbound-operational-state");
                String string9 = this.getValueFromJSONObject(jSONObject, "queue-operational-state");
                String string10 = this.getValueFromJSONObject(jSONObject, "redundancy");
                String string11 = this.getValueFromJSONObject(jSONObject, "connection-uptime-in-seconds");
                String string12 = string + "^" + string2 + "~" + string3 + "@" + string4;
                string12 = this.checkCharLength(string12);
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                double d7 = -5.0;
                if (string5 != null && string5.trim().length() > 0) {
                    d = (string5 = string5.trim()).equalsIgnoreCase("Disabled") || string5.equalsIgnoreCase("Disable") ? 0.0 : 1.0;
                }
                if (string6 != null && string6.trim().length() > 0) {
                    d2 = (string6 = string6.trim()).equalsIgnoreCase("Local") ? 0.0 : (string6.equalsIgnoreCase("Remote") ? 1.0 : 2.0);
                }
                if (string7 != null && string7.trim().length() > 0) {
                    string7 = string7.trim();
                    d3 = this.getNumericStateVal(string7);
                }
                if (string8 != null && string8.trim().length() > 0) {
                    string8 = string8.trim();
                    d4 = this.getNumericStateVal(string8);
                }
                if (string9 != null && string9.trim().length() > 0) {
                    string9 = string9.trim();
                    d5 = this.getNumericStateVal(string9);
                }
                if (string10 != null && string10.trim().length() > 0) {
                    string10 = string10.trim();
                    d6 = this.getNumericStateVal(string10);
                }
                if (string11 != null && string11.trim().length() > 0 && !string11.equals("-")) {
                    try {
                        d7 = Double.parseDouble(string11);
                        if (d7 > 0.0) {
                            d7 /= 60.0;
                        }
                    }
                    catch (Exception exception) {
                        d7 = -5.0;
                    }
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                hashtable.put(string12, arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    private double getNumericStateVal(String string) {
        double d = -5.0;
        try {
            d = string.equalsIgnoreCase("Down") || string.equalsIgnoreCase("Auto") ? 0.0 : (string.equalsIgnoreCase("Up") || string.equalsIgnoreCase("Primary") ? 1.0 : (string.equalsIgnoreCase("Ready-InSync") || string.equalsIgnoreCase("Ready") || string.equalsIgnoreCase("Bound") || string.equalsIgnoreCase("Backup") ? 2.0 : 3.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private String checkCharLength(String string) {
        String string2 = "-";
        try {
            string2 = string != null && string.trim().length() > 0 && !string.equals("-") ? (string.length() < 128 ? string : "..." + string.substring(string.length() - 123, string.length())) : "-";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        Object var6_6 = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.userName, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            System.out.println("helper done ==> " + ((SolaceTestHelper)object).done);
            do {
                this.suspendForPeriod(l2);
                if (!((SolaceTestHelper)object).done) continue;
                string4 = ((SolaceTestHelper)object).xmlOutputStr;
                return string4;
            } while ((l = System.currentTimeMillis() - l3) < (long)this.timeout);
            ((Thread)object).interrupt();
            Thread.yield();
            object = null;
            return null;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void resetHttpProps() {
        try {
            if (this.urlStr.startsWith("https") && this.sysPackage != null) {
                System.getProperties().put("java.protocol.handler.pkgs", this.sysPackage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string3 = "" + jSONObject.get((Object)string);
            string2 = string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("null") || string3.equalsIgnoreCase("none") ? "-" : string3.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return object;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public static void main(String[] stringArray) {
        new SolaceBridgeStTest(stringArray).computeMeasures(new Hashtable());
    }
}

