/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgInstallInfo;
import com.eg.IPV6Helper;
import com.eg.PortDiscovery;
import com.egurkha.util.EgUtilities;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceClusterStTest
extends GenericTest {
    private boolean isFirst = true;
    private String userName = "";
    private String password = "";
    private String portNumber = "";
    private boolean isSSL = false;
    private boolean isNetworkConn = true;
    private ArrayList totalNodeList = new ArrayList();
    private ArrayList primaryNodeList = new ArrayList();
    private ArrayList backupNodeList = new ArrayList();
    private String urlStr = "";
    private String sysPackage;
    private URL url;
    private int timeout = 60;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private static final String SYSTEM_REDUNDANCY_COMMAND = "<rpc> <show> <redundancy> </redundancy> </show> </rpc>";
    public String agentOS = System.getProperty("os.name");
    public String ipStacktrace = "";
    private boolean isValidCluster = false;
    public PortDiscovery pd = null;
    public Hashtable ddHash = new Hashtable();
    private Hashtable prevStateHash = new Hashtable();

    public SolaceClusterStTest(String[] stringArray) {
        super(stringArray);
        String string;
        StringTokenizer stringTokenizer;
        this.needAgentlessDD = true;
        this.pd = new PortDiscovery();
        this.userName = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        String string2 = this.getValueForParam("ssl");
        String string3 = this.getValueForParam("include_network_connectivity");
        this.isNetworkConn = string3 != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"));
        this.isSSL = string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"));
        String string4 = this.getValueForParam("Total_cluster_nodes");
        String string5 = this.getValueForParam("Primary_nodes");
        if (string4 != null && string4.trim().length() > 0 && (stringTokenizer = new StringTokenizer(string4, ",")).countTokens() > 1) {
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                this.totalNodeList.add(string);
            }
        }
        if (string5 != null && string5.trim().length() > 0 && (stringTokenizer = new StringTokenizer(string5, ",")).countTokens() >= 1) {
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                this.primaryNodeList.add(string);
            }
        }
        if (this.totalNodeList != null && this.totalNodeList.size() > 0) {
            for (int i = 0; i < this.totalNodeList.size(); ++i) {
                string = (String)this.totalNodeList.get(i);
                if (this.primaryNodeList.contains(string)) continue;
                this.backupNodeList.add(string);
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        block36: {
            try {
                this.ddHash = new Hashtable();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Hashtable hashtable2 = new Hashtable();
                Hashtable hashtable3 = new Hashtable();
                this.printOut(" Total Nodes List ==>" + this.totalNodeList + " Primary Nodes List ==>" + this.primaryNodeList + " Backup Nodes List ==>" + this.backupNodeList);
                if (this.totalNodeList == null || this.totalNodeList.size() <= 1 || this.primaryNodeList == null || this.primaryNodeList.size() <= 0) break block36;
                for (int i = 0; i < this.primaryNodeList.size(); ++i) {
                    String string = (String)this.primaryNodeList.get(i);
                    this.isValidCluster = this.totalNodeList.contains(string);
                }
                if (this.isValidCluster) {
                    double d;
                    double d2;
                    ArrayList arrayList3;
                    ArrayList<Double> arrayList4 = new ArrayList<Double>();
                    double d3 = this.totalNodeList.size();
                    arrayList4.add(new Double(d3));
                    if (this.isNetworkConn) {
                        arrayList3 = this.getNetworkConnList(this.totalNodeList);
                        d2 = ((ArrayList)arrayList3.get(0)).size();
                        d = -5.0;
                        if (d3 > 0.0 && d2 >= 0.0) {
                            d = d2 / d3 * 100.0;
                        }
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            this.ddHash.put("NetworkConnList", arrayList3);
                        }
                        arrayList4.add(new Double(d2));
                        arrayList4.add(new Double(d));
                        this.printOut(" Total node count ==>" + d3 + " Total node count with network connectivity ==>" + d2 + " Total node with nw connectivity pct ==>" + d);
                    } else {
                        arrayList4.add(new Double(-5.0));
                        arrayList4.add(new Double(-5.0));
                    }
                    arrayList3 = this.getPortStatus(this.totalNodeList);
                    d2 = ((ArrayList)arrayList3.get(0)).size();
                    d = -5.0;
                    if (d3 > 0.0 && d2 >= 0.0) {
                        d = d2 / d3 * 100.0;
                    }
                    arrayList4.add(new Double(d2));
                    arrayList4.add(new Double(d));
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        this.ddHash.put("PortStatusList", arrayList3);
                    }
                    this.printOut(" Total node count ==>" + d3 + " Total node count with successful port reachablility ==>" + d2 + " Total node with successful port reachability pct ==>" + d);
                    Hashtable hashtable4 = this.getSEMPResultForNodes(this.totalNodeList);
                    this.printOut(" SEMP Result Hash ==>" + hashtable4);
                    Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
                    double d4 = 0.0;
                    double d5 = -5.0;
                    if (hashtable4 != null && hashtable4.size() > 0) {
                        Enumeration enumeration = hashtable4.keys();
                        while (enumeration.hasMoreElements()) {
                            ArrayList<String> arrayList5;
                            String string = (String)enumeration.nextElement();
                            ArrayList arrayList6 = (ArrayList)hashtable4.get(string);
                            if (arrayList6 != null && arrayList6.size() > 0) {
                                d4 += 1.0;
                                arrayList5 = new ArrayList();
                                arrayList5.add("Success");
                                hashtable2.put(string, arrayList5);
                                String string2 = this.getNodeState(arrayList6, "primary");
                                String string3 = this.getNodeState(arrayList6, "backup");
                                this.printOut("Node ==>" + string + " Primary node state ==>" + string2 + " Backup node state ==>" + string3);
                                if (string2 != null && string2.trim().length() > 0) {
                                    if (string2.equalsIgnoreCase("Local-Active") || string2.equalsIgnoreCase("Local Active")) {
                                        if (!arrayList.contains(string)) {
                                            arrayList.add(string);
                                            hashtable5.put(string, "Local-Active");
                                        }
                                    } else if ((string2.equalsIgnoreCase("Mate-Active") || string2.equalsIgnoreCase("Mate Active")) && !arrayList2.contains(string)) {
                                        arrayList2.add(string);
                                        hashtable5.put(string, "Mate-Active");
                                    }
                                }
                                if (string3 == null || string3.trim().length() <= 0) continue;
                                if (string3.equalsIgnoreCase("Local_Active") || string3.equalsIgnoreCase("Local Active")) {
                                    if (arrayList.contains(string)) continue;
                                    arrayList.add(string);
                                    hashtable5.put(string, "Local-Active");
                                    continue;
                                }
                                if (!string3.equalsIgnoreCase("Mate-Active") && !string3.equalsIgnoreCase("Mate Active") || arrayList2.contains(string)) continue;
                                arrayList2.add(string);
                                hashtable5.put(string, "Mate-Active");
                                continue;
                            }
                            arrayList5 = new ArrayList<String>();
                            arrayList5.add("Failed");
                            hashtable2.put(string, arrayList5);
                        }
                    }
                    arrayList4.add(new Double(d4));
                    if (hashtable2 != null && hashtable2.size() > 0) {
                        this.ddHash.put("SEMPResultList", hashtable2);
                    }
                    if (d3 > 0.0 && d4 >= 0.0) {
                        d5 = d4 / d3 * 100.0;
                    }
                    arrayList4.add(new Double(d5));
                    this.printOut(" Total node count ==>" + d3 + " Total node count with SEMP conn ==>" + d4 + " Total node with SEMP conn pct ==>" + d5);
                    this.printOut(" State Hash ==>" + hashtable5);
                    if (d4 >= 1.0) {
                        ArrayList arrayList7;
                        double d6 = arrayList.size();
                        double d7 = arrayList2.size();
                        arrayList4.add(new Double(d6));
                        if (arrayList != null && arrayList.size() > 0) {
                            this.ddHash.put("PrimaryRoleList", arrayList);
                        }
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            this.ddHash.put("BackupRoleList", arrayList2);
                        }
                        double d8 = -5.0;
                        double d9 = -5.0;
                        if (d3 > 0.0 && d6 >= 0.0) {
                            d8 = d6 / d3 * 100.0;
                        }
                        if (d3 > 0.0 && d7 >= 0.0) {
                            d9 = d7 / d3 * 100.0;
                        }
                        arrayList4.add(new Double(d8));
                        arrayList4.add(new Double(d7));
                        arrayList4.add(new Double(d9));
                        this.printOut(" Primary role list ==>" + arrayList + " Primary node count ==>" + d6 + " Primary node count pct ==>" + d8);
                        this.printOut(" Backup role list ==>" + arrayList2 + " Backup node count ==>" + d7 + " Backup node count pct ==>" + d9);
                        this.printOut("Current State Hash ==>" + hashtable5 + " Previous State Hash ==>" + this.prevStateHash);
                        double d10 = 0.0;
                        double d11 = 0.0;
                        double d12 = 0.0;
                        ArrayList arrayList8 = this.getCurrStatList(this.primaryNodeList, arrayList, hashtable2);
                        if (arrayList8 != null && arrayList8.size() > 0) {
                            d11 = arrayList8.size();
                        }
                        if ((arrayList7 = this.getCurrStatList(this.backupNodeList, arrayList2, hashtable2)) != null && arrayList7.size() > 0) {
                            d12 = arrayList7.size();
                        }
                        if (d11 > 0.0) {
                            this.ddHash.put("NodeNotLocalActive", arrayList8);
                        }
                        if (d12 > 0.0) {
                            this.ddHash.put("NodeNotMateActive", arrayList7);
                        }
                        this.printOut(" primaryNotAvailCheck ==>" + arrayList8 + " nodeNotInPrimary ==>" + d11);
                        this.printOut(" backupNotAvailCheck ==>" + arrayList7 + " nodeNotInBackup ==>" + d12);
                        if (this.prevStateHash != null && this.prevStateHash.size() > 0) {
                            Hashtable hashtable6 = new Hashtable();
                            Enumeration enumeration = this.prevStateHash.keys();
                            while (enumeration.hasMoreElements()) {
                                String string;
                                String string4;
                                String string5 = (String)enumeration.nextElement();
                                ArrayList<String> arrayList9 = new ArrayList<String>();
                                if (hashtable5 == null || hashtable5.size() <= 0 || !hashtable5.containsKey(string5) || (string4 = (String)this.prevStateHash.get(string5)).equals(string = (String)hashtable5.get(string5))) continue;
                                d10 += 1.0;
                                arrayList9.add(string4);
                                arrayList9.add(string);
                                if (arrayList9 == null || arrayList9.size() <= 0) continue;
                                hashtable6.put(string5, arrayList9);
                            }
                            if (hashtable6 != null && hashtable6.size() > 0) {
                                this.ddHash.put("StateChangeList", hashtable6);
                            }
                        }
                        this.prevStateHash = (Hashtable)hashtable5.clone();
                        this.printOut("Node Role Changed ==>" + d10);
                        this.printOut("DD Hash ==>" + this.ddHash);
                        arrayList4.add(new Double(d10));
                        arrayList4.add(new Double(d11));
                        arrayList4.add(new Double(d12));
                        this.printOut(" MeasureList ==>" + arrayList4);
                        this.addNewMeasure(arrayList4);
                    } else {
                        for (int i = 0; i < 7; ++i) {
                            arrayList4.add(new Double(0.0));
                        }
                        this.printOut(" MeasureList ==>" + arrayList4);
                        this.addNewMeasure(arrayList4);
                    }
                    break block36;
                }
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceClusterStTest] >> one or more primary nodes are not included in the total cluster nodes field  ", this.reportingName);
                    this.isFirst = false;
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private ArrayList getCurrStatList(ArrayList arrayList, ArrayList arrayList2, Hashtable hashtable) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        try {
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    ArrayList arrayList4 = (ArrayList)hashtable.get(string);
                    String string2 = (String)arrayList4.get(0);
                    if (arrayList2.contains(string)) continue;
                    arrayList3.add(string + "^" + string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList3;
    }

    private Hashtable getSEMPResultForNodes(ArrayList arrayList) {
        Hashtable hashtable = new Hashtable();
        try {
            if (arrayList != null && arrayList.size() > 1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    string = string.trim();
                    String string2 = null;
                    String string3 = null;
                    if (string.indexOf(":") > -1) {
                        string2 = string.substring(0, string.indexOf(":"));
                        string3 = string.substring(string.indexOf(":") + 1, string.length());
                    } else {
                        string2 = string;
                    }
                    this.urlStr = this.isSSL ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + string2 + ":" + string3 + "/SEMP" : "https://" + string2 + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + string2 + ":" + string3 + "/SEMP" : "http://" + string2 + "/SEMP");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    String string4 = this.getSEMPOutput(this.urlStr, SYSTEM_REDUNDANCY_COMMAND);
                    if (string4 != null && string4.trim().length() > 0) {
                        arrayList2.add(string4);
                    }
                    hashtable.put(string, arrayList2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getSEMPOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        this.printOut("Encrypted Password ==>" + this.password);
        String string5 = EgCrypt.decrypt((String)this.password);
        this.printOut("Decrypted Password ==>" + string5);
        HttpURLConnection httpURLConnection = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, string5);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !string5.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", string5);
                } else {
                    string3 = this.encode(this.userName, string5);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            this.printOut("helper done ==> " + ((SolaceTestHelper)object).done);
            while (true) {
                this.suspendForPeriod(l2);
                if (((SolaceTestHelper)object).done) {
                    string4 = ((SolaceTestHelper)object).xmlOutputStr;
                    return string4;
                }
                l = System.currentTimeMillis() - l3;
                if (l < (long)this.timeout) continue;
                ((Thread)object).interrupt();
                Thread.yield();
                object = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private ArrayList getPortStatus(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        try {
            if (arrayList != null && arrayList.size() > 1) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string;
                    String string2 = (String)arrayList.get(i);
                    if ((string2 = string2.trim()).indexOf(":") <= -1) continue;
                    String string3 = string2.substring(0, string2.indexOf(":"));
                    boolean bl = this.isSpecificPortReachable(string3, string = string2.substring(string2.indexOf(":") + 1, string2.length()));
                    if (bl) {
                        arrayList3.add(string2);
                        continue;
                    }
                    arrayList4.add(string2);
                }
                arrayList2.add(arrayList3);
                arrayList2.add(arrayList4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    private ArrayList getNetworkConnList(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        try {
            if (arrayList != null && arrayList.size() > 1) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (string.indexOf(":") <= -1) continue;
                    String string2 = string.substring(0, string.indexOf(":"));
                    boolean bl = this.isIPReachable(string2);
                    if (bl) {
                        arrayList3.add(string);
                        continue;
                    }
                    arrayList4.add(string);
                }
                arrayList2.add(arrayList3);
                arrayList2.add(arrayList4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    public boolean isIPReachable(String string) {
        boolean bl = false;
        try {
            ArrayList arrayList;
            EgUtilities egUtilities = EgUtilities.createInstance();
            String string2 = "";
            this.agentOS = this.agentOS.toLowerCase();
            if (this.agentOS != null && this.agentOS.indexOf("windows") > -1) {
                string2 = "cmd.exe /c  " + EgInstallInfo.getInstallDir() + "/bin/nfping " + string;
            } else if (this.agentOS != null && (this.agentOS.indexOf("linux") > -1 || this.agentOS.indexOf("sunos") > -1 || this.agentOS.indexOf("hpux") > -1 || this.agentOS.indexOf("aix") > -1 || this.agentOS.indexOf("osf1") > -1)) {
                boolean bl2 = IPV6Helper.validateIPV6((String)string);
                string2 = bl2 ? EgInstallInfo.getInstallDir() + "/bin/fping6 " + string : EgInstallInfo.getInstallDir() + "/bin/fping " + string;
            }
            ArrayList arrayList2 = egUtilities.getExecOutputLines(string2);
            if (arrayList2 != null && !arrayList2.isEmpty() && (arrayList = (ArrayList)arrayList2.get(0)) != null && !arrayList.isEmpty()) {
                ArrayList arrayList3;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).toLowerCase();
                    if (string3 == null || string3.length() <= 0 || string3.indexOf("alive") <= 0 && !string3.startsWith("reply")) continue;
                    bl = true;
                    break;
                }
                if (!bl && arrayList2.size() >= 2 && (arrayList3 = (ArrayList)arrayList2.get(1)) != null && !arrayList3.isEmpty()) {
                    this.ipStacktrace = (String)arrayList3.get(0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean isSpecificPortReachable(String string, String string2) {
        boolean bl = false;
        try {
            this.pd.setTimeOut(250);
            if (string2 != null && !string2.equalsIgnoreCase("NULL")) {
                int n = Integer.parseInt(string2);
                bl = this.pd.doesSocketExist(string, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    private String getNodeState(ArrayList arrayList, String string) {
        String string2 = "";
        try {
            String string3;
            if (arrayList != null && arrayList.size() > 0 && (string3 = (String)arrayList.get(0)) != null && string3.trim().length() > 0 && !string3.contains("schema validation error")) {
                JSONObject jSONObject;
                String string4;
                JSONObject jSONObject2;
                org.json.JSONObject jSONObject3 = XML.toJSONObject((String)string3);
                String string5 = jSONObject3.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject4 = null;
                if (string5 != null && string5.trim().length() > 0 && (jSONObject2 = this.getShowJSONObject(jSONObject4 = (JSONObject)jSONParser.parse(string5))) != null && (string4 = this.getValueFromJSONObject(jSONObject = this.getJSONObjectFromJSONObject(jSONObject2, "redundancy"), "config-status")) != null && string4.toLowerCase().startsWith("enabled")) {
                    string2 = this.getNodeActivityState(string, jSONObject);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getNodeActivityState(String string, JSONObject jSONObject) {
        String string2 = "";
        try {
            JSONObject jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "virtual-routers");
            JSONObject jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2, string);
            JSONObject jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3, "status");
            string2 = this.getValueFromJSONObject(jSONObject4, "activity");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject2;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void freeTest() {
        this.ddHash = new Hashtable();
    }

    public static void main(String[] stringArray) {
        new SolaceClusterStTest(stringArray).computeMeasures(new Hashtable());
    }
}

