/*
 * Decompiled with CFR 0.152.
 */
import eg.netflow.flow.analyzer.AggregateItem;
import eg.netflow.flow.analyzer.AggregationType;
import eg.netflow.flow.analyzer.ComponentType;
import eg.netflow.flow.analyzer.FlowAnalyzer;
import eg.netflow.flow.analyzer.InterfaceGroupAggregator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class SpecificSrcTest
extends InterfaceDetailsTest {
    FlowAnalyzer flowAnalyzer;
    InterfaceGroupAggregator ifSrcAggregator;
    InterfaceGroupAggregator ifSrcDstPortAggregator;
    private static final double bytesToKb = 0.008;
    private static final double bytesToKB = 0.001;
    private int reportLimit = 5;
    private String interface_exclude = "none";
    private String srcInclude = "none";
    private boolean showAllInterfaces = true;
    boolean showAllInterfacestype = true;
    private String interfacestype_exclude = "yes";
    private boolean isIfaceNameAvailable = false;
    private boolean isIfaceTypeAvailable = false;
    private boolean isIfaceSpeedAvailable = false;
    private String deviceIP;
    private int testFrequency = (int)this.measurePeriod / 1000;
    public ArrayList interfaceDetailsList = new ArrayList();
    public Hashtable interfaceNamesTable = new Hashtable();
    public Hashtable interfaceSpeedTable = new Hashtable();
    public Hashtable interfaceTypeTable = new Hashtable();
    private List<String> singleIP = new ArrayList<String>();
    private List<String> ipRange = new ArrayList<String>();
    private List<String> ipGroup = new ArrayList<String>();
    private boolean showHostNames = false;
    private int showTraf = 0;
    private int showDDForTopTopN = 3;
    public HashMap topNflows_DD = new HashMap();
    private boolean useExtension = false;
    private String snmpCommunity = null;

    public void freeTest() {
        this.topNflows_DD = new HashMap();
    }

    public SpecificSrcTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        Object object;
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.targetHost);
            this.deviceIP = inetAddress.toString().substring(inetAddress.toString().indexOf("/") + 1);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("unknown host '" + this.targetHost);
        }
        this.interface_exclude = this.getValueForParam("Exclude_Interfaces");
        if (this.interface_exclude != null && !this.interface_exclude.trim().equalsIgnoreCase("none") && !this.interface_exclude.trim().equalsIgnoreCase("null")) {
            this.showAllInterfaces = false;
        }
        this.srcInclude = this.getValueForParam("Include_Sources");
        if (this.srcInclude != null && !this.srcInclude.trim().equalsIgnoreCase("none") && !this.srcInclude.trim().equalsIgnoreCase("null")) {
            object = new StringTokenizer(this.srcInclude, ",");
            int n = ((StringTokenizer)object).countTokens();
            for (int i = 0; i < n; ++i) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                if (string3.indexOf("-") > 0) {
                    this.ipRange.add(string3);
                    continue;
                }
                if (string3.indexOf("*") > 0) {
                    this.ipGroup.add(string3);
                    continue;
                }
                this.singleIP.add(string3);
            }
        } else {
            this.srcInclude = "none";
        }
        if ((object = this.getValueForParam("Report_Top_N_Flows")) != null && !((String)object).trim().equalsIgnoreCase("none") && !((String)object).trim().equalsIgnoreCase("null")) {
            try {
                this.reportLimit = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                this.reportLimit = 5;
            }
        }
        if ((string2 = this.getValueForParam("Show_dd_for_top_Top_N_Flows")) != null && !string2.trim().equalsIgnoreCase("none") && !string2.trim().equalsIgnoreCase("null")) {
            try {
                this.showDDForTopTopN = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this.showDDForTopTopN = 3;
            }
        }
        this.interfacestype_exclude = this.getValueForParam("Report_By_Interface_Type");
        if (!(this.interfacestype_exclude == null || this.interfacestype_exclude.trim().equalsIgnoreCase("none") || this.interfacestype_exclude.trim().equalsIgnoreCase("null") || this.interfacestype_exclude.trim().equalsIgnoreCase("no"))) {
            this.showAllInterfacestype = false;
        }
        if ((string = this.getValueForParam("Show_host_names")) != null && (string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("true"))) {
            this.showHostNames = true;
        }
        if ((string3 = this.getValueForParam("Show_traffic")) != null && string3.trim().equalsIgnoreCase("out_traffic")) {
            this.showTraf = 1;
        } else if (string3 != null && string3.trim().equalsIgnoreCase("both_traffic")) {
            this.showTraf = 2;
        }
        String string4 = this.getValueForParam("useExtension");
        this.useExtension = string4 == null || string4.length() <= 0 || !string4.equalsIgnoreCase("no") && !string4.equalsIgnoreCase("false");
        this.flowAnalyzer = FlowAnalyzer.getInstance((String)this.deviceIP, (ComponentType)ComponentType.NETFLOW);
        this.flowAnalyzer.setFrequency(this.testFrequency);
        this.ifSrcAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_MATRIX);
        this.ifSrcDstPortAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_DESTINATION_PORT_MATRIX);
        this.snmpCommunity = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        block40: {
            int[] nArray;
            if (this.snmpCommunity != null && !this.snmpCommunity.trim().equalsIgnoreCase("none")) {
                this.interfaceDetailsList = this.getInterfaceDetails(this.deviceIP, this.measurePeriod);
            }
            if (this.interfaceDetailsList != null && this.interfaceDetailsList.size() >= 2) {
                this.interfaceNamesTable = (Hashtable)this.interfaceDetailsList.get(0);
                this.interfaceSpeedTable = (Hashtable)this.interfaceDetailsList.get(1);
                this.interfaceTypeTable = (Hashtable)this.interfaceDetailsList.get(2);
            }
            if (this.interfaceTypeTable != null && this.interfaceTypeTable.size() > 0) {
                this.isIfaceTypeAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface type");
            }
            if (this.interfaceNamesTable != null && this.interfaceNamesTable.size() > 0) {
                this.isIfaceNameAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface name");
            }
            if (this.interfaceSpeedTable != null && this.interfaceSpeedTable.size() > 0) {
                this.isIfaceSpeedAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface speed");
            }
            this.flowAnalyzer.analyze();
            if (this.ifSrcAggregator == null || (nArray = this.ifSrcAggregator.getInterfaceIDs()) == null) break block40;
            double d = 0.0;
            if (this.showAllInterfaces) {
                for (int n : nArray) {
                    String string;
                    long[] lArray = this.ifSrcAggregator.getTotalValues(n);
                    List list = this.ifSrcAggregator.getSortedList(n, 0);
                    if (list == null || list.isEmpty()) continue;
                    String string2 = Integer.toString(n);
                    String string3 = "";
                    String string4 = "ifType:" + string2;
                    if (this.showAllInterfacestype) {
                        if (this.isIfaceNameAvailable) {
                            string3 = (String)this.interfaceNamesTable.get(string2);
                            string4 = (String)this.interfaceTypeTable.get(string2);
                            if (string4 == null || string4.length() == 0) {
                                string4 = "ifType:" + string2;
                            }
                            if (string3 == null || string3.length() == 0) {
                                string3 = "ifIndex:" + string2;
                            }
                            string3 = string4 + ">" + string3;
                        } else {
                            string3 = string4 + ">ifIndex:" + string2;
                        }
                    } else {
                        string3 = (String)this.interfaceNamesTable.get(string2);
                        if (string3 == null || string3.length() == 0) {
                            string3 = "ifIndex:" + string2;
                        }
                    }
                    if (this.isIfaceSpeedAvailable && (string = (String)this.interfaceSpeedTable.get(string2)) != null && string.length() > 0) {
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.uploadMeasures(list, lArray, string3, d);
                    d = 0.0;
                }
            } else {
                boolean bl = false;
                if (this.isIfaceNameAvailable) {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string5 = (String)this.interfaceNamesTable.get(string);
                        String string6 = "ifType:" + string;
                        if (this.showAllInterfacestype) {
                            if (this.isIfaceNameAvailable) {
                                string5 = (String)this.interfaceNamesTable.get(string);
                                string6 = (String)this.interfaceTypeTable.get(string);
                                if (string6 == null || string6.length() == 0) {
                                    string6 = "ifType:" + string;
                                }
                                if (string5 == null || string5.length() == 0) {
                                    string5 = string6 + ">ifIndex:" + string;
                                }
                                string5 = string6 + ">" + string5;
                            } else {
                                string5 = string6 + ">ifIndex:" + string;
                            }
                        } else {
                            string5 = (String)this.interfaceNamesTable.get(string);
                            if (string5 == null || string5.length() == 0) {
                                string5 = "ifIndex:" + string;
                            }
                        }
                        bl = this.checkWithExcludeIfacesList(string5);
                        if (bl) continue;
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcAggregator.getTotalValues(n);
                        List list = this.ifSrcAggregator.getSortedList(n, 0);
                        if (list == null || list.isEmpty()) continue;
                        this.uploadMeasures(list, (long[])object, string5, d);
                        d = 0.0;
                    }
                } else {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string7 = "ifIndex:" + string;
                        String string8 = (String)this.interfaceTypeTable.get(string);
                        if (this.showAllInterfacestype) {
                            if (string8 == null || string8.length() == 0) {
                                string8 = "ifType:" + string;
                            }
                            string7 = string8 + ">" + string7;
                        }
                        if (bl = this.checkWithExcludeIfacesList(string7)) continue;
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcAggregator.getTotalValues(n);
                        List list = this.ifSrcAggregator.getSortedList(n, 0);
                        if (list == null || list.isEmpty()) continue;
                        this.uploadMeasures(list, (long[])object, string7, d);
                        d = 0.0;
                    }
                }
            }
        }
    }

    private void uploadMeasures(List<AggregateItem> list, long[] lArray, String string, double d) {
        try {
            boolean bl = false;
            List<AggregateItem> list2 = new ArrayList<AggregateItem>();
            for (AggregateItem aggregateItem : list) {
                Object object = aggregateItem.getGroupByElements()[0];
                String string2 = object.toString();
                if (!this.srcInclude.equalsIgnoreCase("none")) {
                    bl = this.isSourceInclude(string2);
                }
                if (!bl) continue;
                list2.add(aggregateItem);
            }
            if ((list2 = this.getTopN(list2, this.reportLimit)) == null || list2.isEmpty()) {
                return;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = lArray[0];
            long l6 = lArray[1];
            long l7 = lArray[2];
            long l8 = lArray[3];
            long l9 = l5 + l6;
            double d2 = this.useExtension ? d * 1000.0 : d / 1000.0;
            int n = 1;
            ArrayList<String> arrayList = (ArrayList<String>)this.topNflows_DD.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            for (AggregateItem aggregateItem : list2) {
                Object object = aggregateItem.getGroupByElements()[0];
                String string3 = object.toString();
                int n2 = aggregateItem.getInput();
                int n3 = aggregateItem.getOutput();
                if (this.showHostNames) {
                    string3 = dns.getHostName(string3);
                }
                if (n <= this.showDDForTopTopN) {
                    arrayList.add(string3);
                    ++n;
                }
                double d3 = aggregateItem.getInOctets();
                double d4 = aggregateItem.getOutOctets();
                double d5 = aggregateItem.getInPackets();
                double d6 = aggregateItem.getOutPackets();
                double d7 = d5 + d6;
                double d8 = d3 * 0.001 * 8.0;
                double d9 = d8 / (double)this.testFrequency;
                double d10 = d4 * 0.001 * 8.0;
                double d11 = d10 / (double)this.testFrequency;
                double d12 = d5 / (double)this.testFrequency;
                double d13 = d6 / (double)this.testFrequency;
                double d14 = -5.0;
                double d15 = -5.0;
                double d16 = -5.0;
                if (l9 > 0L) {
                    d14 = d3 / (double)l9 * 100.0;
                    d15 = d4 / (double)l9 * 100.0;
                    d16 = d14 + d15;
                }
                double d17 = -5.0;
                double d18 = -5.0;
                double d19 = -5.0;
                if (d > 0.0) {
                    d17 = d3 * 0.008 / (double)this.testFrequency / d2 * 100.0;
                    d18 = d4 * 0.008 / (double)this.testFrequency / d2 * 100.0;
                    d19 = d17 + d18;
                }
                l = (long)((double)l + d3);
                l2 = (long)((double)l2 + d4);
                l3 = (long)((double)l3 + d5);
                l4 = (long)((double)l4 + d6);
                d3 = this.round(d3 * 0.001);
                d4 = this.round(d4 * 0.001);
                double d20 = d3 + d4;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                if (this.showTraf == 0) {
                    arrayList2.add(new Double(d3 == 0.0 ? -5.0 : d3));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d20));
                    arrayList2.add(new Double(d5 == 0.0 ? -5.0 : d5));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d9 == 0.0 ? -5.0 : d9));
                    arrayList2.add(new Double(d12 == 0.0 ? -5.0 : d12));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d9 + d11));
                    arrayList2.add(new Double(d12 + d13));
                    arrayList2.add(new Double(d14 == 0.0 ? -5.0 : d14));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d16));
                    arrayList2.add(new Double(d17 == 0.0 ? -5.0 : d17));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d19));
                } else if (this.showTraf == 1) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d4 == 0.0 ? -5.0 : d4));
                    arrayList2.add(new Double(d20));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d6 == 0.0 ? -5.0 : d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d11 == 0.0 ? -5.0 : d11));
                    arrayList2.add(new Double(d13 == 0.0 ? -5.0 : d13));
                    arrayList2.add(new Double(d9 + d11));
                    arrayList2.add(new Double(d12 + d13));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d15 == 0.0 ? -5.0 : d15));
                    arrayList2.add(new Double(d16));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d18 == 0.0 ? -5.0 : d18));
                    arrayList2.add(new Double(d19));
                } else {
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d20));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d9));
                    arrayList2.add(new Double(d12));
                    arrayList2.add(new Double(d11));
                    arrayList2.add(new Double(d13));
                    arrayList2.add(new Double(d9 + d11));
                    arrayList2.add(new Double(d12 + d13));
                    arrayList2.add(new Double(d14));
                    arrayList2.add(new Double(d15));
                    arrayList2.add(new Double(d16));
                    arrayList2.add(new Double(d17));
                    arrayList2.add(new Double(d18));
                    arrayList2.add(new Double(d19));
                }
                this.addNewMeasure(string + "!" + string3, arrayList2);
            }
            this.topNflows_DD.put(string, arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isSourceInclude(String string) {
        boolean bl = false;
        if (!this.singleIP.isEmpty()) {
            for (String string2 : this.singleIP) {
                bl = this.compareIP(string2, string);
                if (!bl) continue;
                return true;
            }
        }
        if (!this.ipGroup.isEmpty()) {
            for (String string2 : this.ipGroup) {
                bl = string.regionMatches(0, string2 = string2.substring(0, string2.indexOf("*")), 0, string2.length());
                if (!bl) continue;
                return true;
            }
        }
        if (!this.ipRange.isEmpty()) {
            for (String string2 : this.ipRange) {
                String string3;
                String string4 = string2.substring(0, string2.indexOf("-")).trim();
                bl = this.compareIP(string4, string3 = string2.substring(string2.indexOf("-") + 1, string2.length()).trim(), string);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareIP(String string, String string2, String string3) {
        try {
            long l = SpecificSrcTest.ipToLong(InetAddress.getByName(string));
            long l2 = SpecificSrcTest.ipToLong(InetAddress.getByName(string2));
            long l3 = SpecificSrcTest.ipToLong(InetAddress.getByName(string3));
            return l3 >= l && l3 <= l2;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Configuration Error!! Please configure valid source address to include");
            return false;
        }
    }

    private boolean compareIP(String string, String string2) {
        try {
            long l = SpecificSrcTest.ipToLong(InetAddress.getByName(string));
            long l2 = SpecificSrcTest.ipToLong(InetAddress.getByName(string2));
            return l == l2;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Configuration Error!! Please configure valid source address to include");
            return false;
        }
    }

    public static long ipToLong(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        long l = 0L;
        for (byte by : byArray) {
            l <<= 8;
            l |= (long)(by & 0xFF);
        }
        return l;
    }

    public boolean checkWithExcludeIfacesList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.interface_exclude, ",");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string2;
            boolean bl;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
            if (!(string3.indexOf("/*") > 0 ? (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("/*") + 1), 0, string2.length())) : string3.indexOf("*") > 0 && string3.indexOf("/") < 0 && (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("*")), 0, string2.length())))) continue;
            return true;
        }
        return false;
    }

    private List<AggregateItem> getTopN(List<AggregateItem> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return list;
        }
        int n3 = n;
        if (n > n2) {
            n3 = n2;
        }
        return list.subList(0, n3);
    }

    public List<AggregateItem> getIfDDValues(int n) {
        List<Object> list = new ArrayList<AggregateItem>();
        if (this.ifSrcDstPortAggregator != null) {
            list = this.ifSrcDstPortAggregator.getTopN(n, 10, this.showTraf);
        }
        return list;
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public EgDnsManager getDnsManagerInstance() {
        return dns;
    }

    private double round(double d) {
        double d2 = Math.round(d * 100.0);
        return d2 / 100.0;
    }

    public static void main(String[] stringArray) {
        SpecificSrcTest specificSrcTest = new SpecificSrcTest(stringArray);
        specificSrcTest.computeMeasures(new Hashtable());
    }
}

