/*
 * Decompiled with CFR 0.152.
 */
import eg.netflow.flow.analyzer.AggregateItem;
import eg.netflow.flow.analyzer.AggregationType;
import eg.netflow.flow.analyzer.ComponentType;
import eg.netflow.flow.analyzer.FlowAnalyzer;
import eg.netflow.flow.analyzer.InterfaceGroupAggregator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class TopConverTest
extends InterfaceDetailsTest {
    FlowAnalyzer flowAnalyzer;
    InterfaceGroupAggregator ifSrcDstAggregator;
    InterfaceGroupAggregator ifSrcDstPortAggregator;
    private static final double bytesToKb = 0.008;
    private static final double bytesToKB = 0.001;
    private int reportLimit = 5;
    private String interface_exclude = "none";
    private String interfacestype_exclude = "yes";
    private boolean showAllInterfaces = true;
    boolean showAllInterfacestype = true;
    private boolean ignoreLocalTraffic = false;
    private boolean isIfaceNameAvailable = false;
    private boolean isIfaceTypeAvailable = false;
    private boolean isIfaceSpeedAvailable = false;
    private boolean filterBy_trafficPercentage = false;
    private boolean filterBy_bandwidthUsed = false;
    private double minimum_percent = 3.0;
    private String deviceIP;
    private int testFrequency = (int)this.measurePeriod / 1000;
    public ArrayList interfaceDetailsList = new ArrayList();
    public Hashtable interfaceNamesTable = new Hashtable();
    public Hashtable interfaceSpeedTable = new Hashtable();
    public Hashtable interfaceTypeTable = new Hashtable();
    private Hashtable interfaceDD = new Hashtable();
    private boolean showHostNames = false;
    private int showTraf = 0;
    private int showDDForTopTopN = 3;
    private long totalIfOctets = 0L;
    public HashMap topNflows_DD = new HashMap();
    public HashMap topNConsolidated_DD = new HashMap();
    private boolean useExtension = false;
    private String snmpCommunity = null;

    public void freeTest() {
        this.topNflows_DD = new HashMap();
        this.topNConsolidated_DD = new HashMap();
    }

    public TopConverTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.targetHost);
            this.deviceIP = inetAddress.toString().substring(inetAddress.toString().indexOf("/") + 1);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("unknown host '" + this.targetHost);
        }
        String string7 = this.getValueForParam("Report_Top_N_Flows");
        if (string7 != null && !string7.trim().equalsIgnoreCase("none") && !string7.trim().equalsIgnoreCase("null")) {
            try {
                this.reportLimit = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                this.reportLimit = 5;
            }
        }
        if ((string6 = this.getValueForParam("Show_dd_for_top_Top_N_Flows")) != null && !string6.trim().equalsIgnoreCase("none") && !string6.trim().equalsIgnoreCase("null")) {
            try {
                this.showDDForTopTopN = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                this.showDDForTopTopN = 3;
            }
        }
        if ((string5 = this.getValueForParam("Minimum_percent")) != null && !string5.trim().equalsIgnoreCase("none") && !string5.trim().equalsIgnoreCase("null")) {
            try {
                this.minimum_percent = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.minimum_percent = 3.0;
            }
        }
        if ((string4 = this.getValueForParam("Filter_by")) != null && !string4.trim().equalsIgnoreCase("none") && !string4.trim().equalsIgnoreCase("null")) {
            if (string4.equalsIgnoreCase("Traffic_percentage")) {
                this.filterBy_trafficPercentage = true;
            } else if (string4.equalsIgnoreCase("Bandwidth_used")) {
                this.filterBy_bandwidthUsed = true;
            }
        }
        if ((string3 = this.getValueForParam("Ignore_local_traffic").trim()) != null && !string3.equalsIgnoreCase("null") && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            this.ignoreLocalTraffic = true;
        }
        this.interface_exclude = this.getValueForParam("Exclude_Interfaces");
        if (this.interface_exclude != null && !this.interface_exclude.trim().equalsIgnoreCase("none") && !this.interface_exclude.trim().equalsIgnoreCase("null")) {
            this.showAllInterfaces = false;
        }
        this.interfacestype_exclude = this.getValueForParam("Report_By_Interface_Type");
        if (!(this.interfacestype_exclude == null || this.interfacestype_exclude.trim().equalsIgnoreCase("none") || this.interfacestype_exclude.trim().equalsIgnoreCase("null") || this.interfacestype_exclude.trim().equalsIgnoreCase("yes"))) {
            this.showAllInterfacestype = false;
        }
        if ((string2 = this.getValueForParam("Show_host_names")) != null && (string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("true"))) {
            this.showHostNames = true;
        }
        if ((string = this.getValueForParam("Show_traffic")) != null && string.trim().equalsIgnoreCase("out_traffic")) {
            this.showTraf = 1;
        } else if (string != null && string.trim().equalsIgnoreCase("both_traffic")) {
            this.showTraf = 2;
        }
        String string8 = this.getValueForParam("useExtension");
        this.useExtension = string8 == null || string8.length() <= 0 || !string8.equalsIgnoreCase("no") && !string8.equalsIgnoreCase("false");
        this.flowAnalyzer = FlowAnalyzer.getInstance((String)this.deviceIP, (ComponentType)ComponentType.NETFLOW);
        this.flowAnalyzer.setFrequency(this.testFrequency);
        this.ifSrcDstAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_DESTINATION_MATRIX);
        this.ifSrcDstPortAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_DESTINATION_PORT_MATRIX);
        this.snmpCommunity = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        int[] nArray;
        if (this.snmpCommunity != null && !this.snmpCommunity.trim().equalsIgnoreCase("none")) {
            this.interfaceDetailsList = this.getInterfaceDetails(this.deviceIP, this.measurePeriod);
        }
        if (this.interfaceDetailsList != null && this.interfaceDetailsList.size() >= 2) {
            this.interfaceNamesTable = (Hashtable)this.interfaceDetailsList.get(0);
            this.interfaceSpeedTable = (Hashtable)this.interfaceDetailsList.get(1);
            this.interfaceTypeTable = (Hashtable)this.interfaceDetailsList.get(2);
        }
        if (this.interfaceTypeTable != null && this.interfaceTypeTable.size() > 0) {
            this.isIfaceTypeAvailable = true;
        } else {
            this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface type");
        }
        if (this.interfaceNamesTable != null && this.interfaceNamesTable.size() > 0) {
            this.isIfaceNameAvailable = true;
        } else {
            this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface name");
        }
        if (this.interfaceSpeedTable != null && this.interfaceSpeedTable.size() > 0) {
            this.isIfaceSpeedAvailable = true;
        } else {
            this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface speed");
        }
        this.flowAnalyzer.analyze();
        this.interfaceDD = (Hashtable)TopConverTestHelper.htDD_networkinterface.get(this.reportingName);
        if (this.interfaceDD == null) {
            this.interfaceDD = new Hashtable();
            TopConverTestHelper.htDD_networkinterface.put(this.reportingName, this.interfaceDD);
        } else {
            this.interfaceDD = new Hashtable();
        }
        if (this.ifSrcDstAggregator != null && (nArray = this.ifSrcDstAggregator.getInterfaceIDs()) != null) {
            double d = 0.0;
            this.totalIfOctets = this.ifSrcDstAggregator.getTotalIfOctets();
            List<AggregateItem> list = new ArrayList();
            if (this.showAllInterfaces) {
                for (int n : nArray) {
                    String string;
                    Object object2;
                    long[] lArray = this.ifSrcDstAggregator.getTotalValues(n);
                    List list2 = this.ifSrcDstAggregator.getTopN(n, this.reportLimit, this.showTraf);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (Object object2 : list2) {
                        int n2 = Arrays.hashCode(object2.getGroupByElements());
                        arrayList.add(n2);
                    }
                    this.topNConsolidated_DD.put(n, arrayList);
                    if (list2 == null || list2.isEmpty()) continue;
                    String string2 = Integer.toString(n);
                    object2 = "";
                    String string3 = "ifType";
                    if (this.showAllInterfacestype) {
                        if (this.isIfaceNameAvailable) {
                            object2 = (String)this.interfaceNamesTable.get(string2);
                            string3 = (String)this.interfaceTypeTable.get(string2);
                            if (string3 == null || string3.length() == 0) {
                                string3 = "ifType:" + (String)string2;
                            }
                            if (object2 == null || ((String)object2).length() == 0) {
                                object2 = "ifIndex:" + (String)string2;
                            }
                            object2 = string3 + ">" + (String)object2;
                        } else {
                            object2 = string3 + ">ifIndex:" + (String)string2;
                        }
                    } else {
                        object2 = (String)this.interfaceNamesTable.get(string2);
                        if (object2 == null || ((String)object2).length() == 0) {
                            object2 = "ifIndex:" + (String)string2;
                        }
                    }
                    if (this.isIfaceSpeedAvailable && (string = (String)this.interfaceSpeedTable.get(string2)) != null && string.length() > 0) {
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((list = this.ifSrcDstAggregator.getSortedListforConvers(n, 0)) != null && !list.isEmpty()) {
                        this.computeDDForInterfacesTest(list, (String)object2, lArray);
                    }
                    if (lArray == null) continue;
                    this.uploadMeasures(list2, lArray, (String)object2, d);
                    d = 0.0;
                }
                TopConverTestHelper.htDD_networkinterface.put(this.reportingName, this.interfaceDD);
            } else {
                boolean bl = false;
                if (this.isIfaceNameAvailable) {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string4 = (String)this.interfaceNamesTable.get(string);
                        String string5 = "ifType:" + string;
                        if (this.showAllInterfacestype) {
                            if (this.isIfaceNameAvailable) {
                                string4 = (String)this.interfaceNamesTable.get(string);
                                string5 = (String)this.interfaceTypeTable.get(string);
                                if (string5 == null || string5.length() == 0) {
                                    string5 = "ifType:" + string;
                                }
                                if (string4 == null || string4.length() == 0) {
                                    string4 = string5 + ">ifIndex:" + string;
                                }
                                string4 = string5 + ">" + string4;
                            } else {
                                string4 = string5 + ">ifIndex:" + string;
                            }
                        } else {
                            string4 = (String)this.interfaceNamesTable.get(string);
                            if (string4 == null || string4.length() == 0) {
                                string4 = "ifIndex:" + string;
                            }
                        }
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcDstAggregator.getTotalValues(n);
                        list = this.ifSrcDstAggregator.getSortedListforConvers(n, 0);
                        if (list != null && !list.isEmpty()) {
                            this.computeDDForInterfacesTest(list, string4, (long[])object);
                        }
                        if (bl = this.checkWithExcludeIfaceList(string4)) continue;
                        List list3 = this.ifSrcDstAggregator.getTopN(n, this.reportLimit, this.showTraf);
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (AggregateItem aggregateItem : list3) {
                            int n3 = Arrays.hashCode(aggregateItem.getGroupByElements());
                            arrayList.add(n3);
                        }
                        this.topNConsolidated_DD.put(n, arrayList);
                        if (list3 == null || list3.isEmpty()) continue;
                        this.uploadMeasures(list3, (long[])object, string4, d);
                        d = 0.0;
                    }
                } else {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string6 = "ifIndex:" + string;
                        String string7 = (String)this.interfaceTypeTable.get(string);
                        if (this.showAllInterfacestype) {
                            if (string7 == null || string7.length() == 0) {
                                string7 = "ifType:" + string;
                            }
                            string6 = string7 + ">" + string6;
                        }
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcDstAggregator.getTotalValues(n);
                        list = this.ifSrcDstAggregator.getSortedListforConvers(n, 0);
                        if (list != null && !list.isEmpty()) {
                            this.computeDDForInterfacesTest(list, string6, (long[])object);
                        }
                        if (bl = this.checkWithExcludeIfaceList(string6)) continue;
                        List list4 = this.ifSrcDstAggregator.getTopN(n, this.reportLimit, this.showTraf);
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (AggregateItem aggregateItem : list4) {
                            int n4 = Arrays.hashCode(aggregateItem.getGroupByElements());
                            arrayList.add(n4);
                        }
                        this.topNConsolidated_DD.put(n, arrayList);
                        if (list4 == null || list4.isEmpty()) continue;
                        this.uploadMeasures(list4, (long[])object, string6, d);
                        d = 0.0;
                    }
                }
                TopConverTestHelper.htDD_networkinterface.put(this.reportingName, this.interfaceDD);
            }
        }
    }

    private void computeDDForInterfacesTest(List<AggregateItem> list, String string, long[] lArray) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            long l = lArray[0] + lArray[1];
            for (AggregateItem aggregateItem : list) {
                Object object = aggregateItem.getGroupByElements()[0];
                String string2 = object.toString();
                Object object2 = aggregateItem.getGroupByElements()[1];
                String string3 = object2.toString();
                long l2 = aggregateItem.getInOctets() + aggregateItem.getOutOctets();
                long l3 = aggregateItem.getInPackets() + aggregateItem.getOutPackets();
                double d = (double)l2 / (double)l * 100.0;
                arrayList.add(string2);
                arrayList.add(string3);
                arrayList.add(new Double((double)l2 / 1000.0));
                arrayList.add(new Double(l3));
                arrayList.add(new Double(d));
                arrayList.add("");
            }
            this.interfaceDD.put(string, arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void uploadMeasures(List<AggregateItem> list, long[] lArray, String string, double d) {
        try {
            double d2;
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = lArray[0];
            long l6 = lArray[1];
            long l7 = lArray[2];
            long l8 = lArray[3];
            long l9 = l5 + l6;
            double d3 = this.useExtension ? d * 1000.0 : d / 1000.0;
            double d4 = (double)l9 / (double)this.totalIfOctets * 100.0;
            double d5 = (double)l9 * 0.008 / (double)this.testFrequency / d3 * 100.0;
            if (this.filterBy_trafficPercentage && d4 > 0.0 && d4 < this.minimum_percent) {
                return;
            }
            if (this.filterBy_bandwidthUsed && d5 > 0.0 && d5 < this.minimum_percent) {
                return;
            }
            int n2 = 1;
            ArrayList<String> arrayList = (ArrayList<String>)this.topNflows_DD.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            for (AggregateItem aggregateItem : list) {
                Object object = aggregateItem.getGroupByElements()[0];
                String string2 = object.toString();
                Object object2 = aggregateItem.getGroupByElements()[1];
                String string3 = object2.toString();
                int n3 = (Integer)aggregateItem.getGroupByElements()[2];
                int n4 = aggregateItem.getInput();
                int n5 = aggregateItem.getOutput();
                if (this.showHostNames) {
                    string2 = dns.getHostName(string2);
                    string3 = dns.getHostName(string3);
                }
                if (n2 <= this.showDDForTopTopN) {
                    arrayList.add(string2 + " to " + string3);
                    ++n2;
                }
                double d6 = aggregateItem.getInOctets();
                double d7 = aggregateItem.getOutOctets();
                double d8 = aggregateItem.getInPackets();
                double d9 = aggregateItem.getOutPackets();
                double d10 = d8 + d9;
                double d11 = d6 * 0.001 * 8.0;
                double d12 = d11 / (double)this.testFrequency;
                double d13 = d7 * 0.001 * 8.0;
                double d14 = d13 / (double)this.testFrequency;
                double d15 = d8 / (double)this.testFrequency;
                double d16 = d9 / (double)this.testFrequency;
                double d17 = -5.0;
                double d18 = -5.0;
                d2 = -5.0;
                if (l9 > 0L) {
                    d17 = d6 / (double)l9 * 100.0;
                    d18 = d7 / (double)l9 * 100.0;
                    d2 = d17 + d18;
                }
                double d19 = -5.0;
                double d20 = -5.0;
                double d21 = -5.0;
                if (d > 0.0) {
                    d19 = d6 * 0.008 / (double)this.testFrequency / d3 * 100.0;
                    d20 = d7 * 0.008 / (double)this.testFrequency / d3 * 100.0;
                    d21 = d19 + d20;
                }
                if (this.ignoreLocalTraffic && n5 == n4 || d6 == 0.0 && d7 == 0.0) continue;
                ++n;
                l = (long)((double)l + d6);
                l2 = (long)((double)l2 + d7);
                l3 = (long)((double)l3 + d8);
                l4 = (long)((double)l4 + d9);
                d6 = this.round(d6 * 0.001);
                d7 = this.round(d7 * 0.001);
                double d22 = d6 + d7;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                if (this.showTraf == 0) {
                    arrayList2.add(new Double(d6 == 0.0 ? -5.0 : d6));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(d8 == 0.0 ? -5.0 : d8));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d10));
                    arrayList2.add(new Double(d12 == 0.0 ? -5.0 : d12));
                    arrayList2.add(new Double(d15 == 0.0 ? -5.0 : d15));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d12 + d14));
                    arrayList2.add(new Double(d15 + d16));
                    arrayList2.add(new Double(d17 == 0.0 ? -5.0 : d17));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d19 == 0.0 ? -5.0 : d19));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d21));
                    arrayList2.add(new Double(n3));
                } else if (this.showTraf == 1) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d7 == 0.0 ? -5.0 : d7));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d9 == 0.0 ? -5.0 : d9));
                    arrayList2.add(new Double(d10));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d14 == 0.0 ? -5.0 : d14));
                    arrayList2.add(new Double(d16 == 0.0 ? -5.0 : d16));
                    arrayList2.add(new Double(d12 + d14));
                    arrayList2.add(new Double(d15 + d16));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d18 == 0.0 ? -5.0 : d18));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d20 == 0.0 ? -5.0 : d20));
                    arrayList2.add(new Double(d21));
                    arrayList2.add(new Double(n3));
                } else {
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(d8));
                    arrayList2.add(new Double(d9));
                    arrayList2.add(new Double(d10));
                    arrayList2.add(new Double(d12));
                    arrayList2.add(new Double(d15));
                    arrayList2.add(new Double(d14));
                    arrayList2.add(new Double(d16));
                    arrayList2.add(new Double(d12 + d14));
                    arrayList2.add(new Double(d15 + d16));
                    arrayList2.add(new Double(d17));
                    arrayList2.add(new Double(d18));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d19));
                    arrayList2.add(new Double(d20));
                    arrayList2.add(new Double(d21));
                    arrayList2.add(new Double(n3));
                }
                this.addNewMeasure(string + "!" + string2 + " to " + string3, arrayList2);
            }
            this.topNflows_DD.put(string, arrayList);
            if (n <= 0) {
                if (debug) {
                    System.out.println("TopConverTest " + new Date() + "  Flow records for interface " + string + " did not meet the specified criteria " + this.minimum_percent + " % (Filter By/Bandwidth Used in Test Configuration page) , Source/Destination includes/excludes in netflow.properties");
                }
                return;
            }
            if (n > 0) {
                double d23 = l5 - l;
                double d24 = l6 - l2;
                double d25 = l7 - l3;
                double d26 = l8 - l4;
                double d27 = d25 + d26;
                if (d23 <= 0.0) {
                    d23 = 0.0;
                }
                if (d24 <= 0.0) {
                    d24 = 0.0;
                }
                if (d25 <= 0.0) {
                    d25 = 0.0;
                }
                if (d26 <= 0.0) {
                    d26 = 0.0;
                }
                double d28 = d23 * 0.001 * 8.0;
                double d29 = d28 / (double)this.testFrequency;
                double d30 = d24 * 0.001 * 8.0;
                double d31 = d30 / (double)this.testFrequency;
                double d32 = d25 / (double)this.testFrequency;
                double d33 = d26 / (double)this.testFrequency;
                double d34 = -5.0;
                double d35 = -5.0;
                double d36 = -5.0;
                if (l9 > 0L) {
                    d34 = d23 / (double)l9 * 100.0;
                    d35 = d24 / (double)l9 * 100.0;
                    d36 = d34 + d35;
                }
                double d37 = -5.0;
                double d38 = -5.0;
                double d39 = -5.0;
                if (d > 0.0) {
                    d37 = d23 * 0.008 / (double)this.testFrequency / d3 * 100.0;
                    d38 = d24 * 0.008 / (double)this.testFrequency / d3 * 100.0;
                    d39 = d37 + d38;
                }
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                d23 = this.round(d23 * 0.001);
                d24 = this.round(d24 * 0.001);
                d2 = d23 + d24;
                arrayList3.add(new Double(d23));
                arrayList3.add(new Double(d24));
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(d25));
                arrayList3.add(new Double(d26));
                arrayList3.add(new Double(d27));
                arrayList3.add(new Double(d29));
                arrayList3.add(new Double(d32));
                arrayList3.add(new Double(d31));
                arrayList3.add(new Double(d33));
                arrayList3.add(new Double(d29 + d31));
                arrayList3.add(new Double(d32 + d33));
                arrayList3.add(new Double(d34));
                arrayList3.add(new Double(d35));
                arrayList3.add(new Double(d36));
                arrayList3.add(new Double(d37));
                arrayList3.add(new Double(d38));
                arrayList3.add(new Double(d39));
                arrayList3.add(new Double(-5.0));
                this.addNewMeasure(string + "!Others", arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkWithExcludeIfaceList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.interface_exclude, ",");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string2;
            boolean bl;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
            if (!(string3.indexOf("/*") > 0 ? (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("/*") + 1), 0, string2.length())) : string3.indexOf("*") > 0 && string3.indexOf("/") < 0 && (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("*")), 0, string2.length())))) continue;
            return true;
        }
        return false;
    }

    public List<AggregateItem> getIfDDValues(int n) {
        List<Object> list = new ArrayList<AggregateItem>();
        if (this.ifSrcDstPortAggregator != null) {
            list = this.ifSrcDstPortAggregator.getTopN(n, 10, this.showTraf);
        }
        return list;
    }

    public static void main(String[] stringArray) {
        TopConverTest topConverTest = new TopConverTest(stringArray);
        topConverTest.computeMeasures(null);
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public EgDnsManager getDnsManagerInstance() {
        return dns;
    }

    private double round(double d) {
        double d2 = Math.round(d * 100.0);
        return d2 / 100.0;
    }
}

