/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Process;
import com.eg.apm.TAG;
import com.eg.jtm.BTMConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class JavaProcess
implements Process {
    private String pid = "-1";
    private String ppid = "-1";
    private String user = null;
    private String port = null;
    private String directory = null;
    private long upTime = -1L;
    private String upTimeAsDate = null;
    private String jvmOptions = null;
    private String jvmName = null;
    private String jvmVersion = null;
    private String jvmVendor = null;
    private String jvmHome = "";
    private String executable = null;
    private String commandLine = null;
    private String javaVersionCmdResult = null;
    private String serverType = null;
    private String systemProperties = null;
    private HashMap systemPropsMap = null;
    private TreeSet listeningPorts = new TreeSet();
    private ArrayList processStatusList = new ArrayList();
    private static ArrayList statusValidator = null;
    private static final String loggerDispStr = "[JavaProcess]";
    private static int MAX_ATTEMPT = 15;
    private static long MAX_TIME_DIFF = 1800000L;
    private int retryAttemptCounter = 0;

    public JavaProcess() {
    }

    public JavaProcess(String string, String string2, String string3, String string4, String string5, String string6, long l) {
        this.user = string;
        this.pid = string2;
        this.executable = string3;
        this.commandLine = string4;
        this.upTime = l;
        this.upTimeAsDate = string5;
        this.systemProperties = string6;
        this.setPidStatus();
        this.setExecutableStatus();
    }

    public JavaProcess(String string) {
        this.init(string);
    }

    private void init(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "^|^");
            if (stringTokenizer.countTokens() >= 4) {
                this.user = this.validate(stringTokenizer.nextToken(), "");
                this.pid = this.validate(stringTokenizer.nextToken(), "0");
                this.executable = this.validate(stringTokenizer.nextToken(), "");
                this.commandLine = this.validate(stringTokenizer.nextToken(), "");
                this.upTime = this.validate(stringTokenizer.nextToken(), 1L);
                this.upTimeAsDate = this.epochToDate(this.upTime);
                this.systemProperties = "";
                this.setPidStatus();
                this.setExecutableStatus();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private String epochToDate(long l) {
        if (l > 0L) {
            return APMUtils.getDateFromEpoch(l);
        }
        return "";
    }

    private String validate(String string, String string2) {
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("-")) {
            return string;
        }
        return string2;
    }

    private long validate(String string, long l) {
        try {
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase("-")) {
                return Long.parseLong(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public String getUser() {
        return this.user;
    }

    public String getPid() {
        return this.pid;
    }

    public String getParentPid() {
        return this.ppid;
    }

    public String getDirectory() {
        return this.directory;
    }

    public long getUptime() {
        return this.upTime;
    }

    public String getUptimeAsDate() {
        return this.upTimeAsDate;
    }

    public String getExecutable() {
        return this.executable;
    }

    public String getSystemPropertiesAsString() {
        return this.systemProperties;
    }

    public HashMap getSystemProperties() {
        return this.systemPropsMap;
    }

    public void setSystemProperties(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() >= 2) {
            this.systemProperties = arrayList.toString();
            this.systemPropsMap = APMUtils.getArrayListAsMap(arrayList, "=", APMDiscoveryLogger.discoveryLogger);
            this.setJvmDetails(this.systemPropsMap);
            this.setSystemPropertyStatus();
        }
    }

    private void setJvmDetails(HashMap hashMap) {
        if (hashMap != null) {
            String string;
            String string2;
            String string3;
            String string4 = (String)hashMap.get("java.vm.name");
            if (string4 != null && string4.length() > 0) {
                this.jvmName = string4;
            }
            if ((string3 = (String)hashMap.get("java.version")) != null && string3.length() > 0) {
                this.jvmVersion = string3;
            }
            if ((string2 = (String)hashMap.get("java.vm.vendor")) != null && string2.length() > 0) {
                this.jvmVendor = string2;
            }
            if ((string = (String)hashMap.get("java.home")) != null && string.length() > 0) {
                this.setStatus((Object)TAG.JAVA_HOME_FOUND);
                this.jvmHome = APMUtils.removeJavaEscapeChar(string);
            }
        }
    }

    public String getJvmHome() {
        return this.jvmHome;
    }

    public String getJvmExecutable() {
        return this.getJvmHome() + BTMConstants.fileSeperator + "bin" + BTMConstants.fileSeperator + "java";
    }

    public String getJvmVendor() {
        return this.jvmVendor;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public String getJvmOption() {
        return this.jvmOptions;
    }

    public String getCommand() {
        return this.commandLine;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getPort() {
        if (this.isPortFinalized()) {
            return this.port;
        }
        String string = this.getEgDiscoveryPort();
        if (string != null && string.length() > 0) {
            this.port = string;
            this.setPortStatus(TAG.PORT_FOUND_IN_EG_PORT_DISCOVERY_WISHLIST);
            return this.port;
        }
        string = this.getPriorityPort();
        if (string != null && string.length() > 0) {
            this.port = string;
            this.setPortStatus(TAG.PORT_FOUND_IN_JAVA_APP_DISCOVERY_WISHLIST);
            return this.port;
        }
        string = this.getLeastPort();
        if (string != null && string.length() > 0 && string.length() <= 4) {
            this.port = string;
            this.setPortStatus(TAG.PORT_FOUND_IN_LEAST_LISTENING_PORT);
            return this.port;
        }
        if (string != null && string.length() >= 5) {
            if (this.isPortExistsInExcludedPortRanges(string)) {
                this.setMsg("EXCLUDED_PORT_RANGE_CHECK_DONE");
                this.setStatus((Object)TAG.EXCLUDED_PORT_FOUND);
            } else {
                this.port = string;
                this.setMsg("EXCLUDED_PORT_RANGE_CHECK_DONE");
                this.setPortStatus(TAG.PORT_FOUND_IN_LEAST_LISTENING_PORT);
                return this.port;
            }
        }
        return "NULL";
    }

    private boolean isPortExistsInExcludedPortRanges(String string) {
        ArrayList arrayList;
        ConcurrentHashMap concurrentHashMap = ApmConfigManager.getInstance().getAppDiscoveryPriorityPorts();
        if (concurrentHashMap != null && concurrentHashMap.size() > 0 && concurrentHashMap.containsKey("Excluded_Port_Ranges") && (arrayList = (ArrayList)concurrentHashMap.get("Excluded_Port_Ranges")) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                try {
                    int n;
                    String[] stringArray;
                    if (string2 == null || (stringArray = string2.split("-")) == null || stringArray.length != 2) continue;
                    int n2 = Integer.parseInt(stringArray[0].trim());
                    int n3 = Integer.parseInt(stringArray[1].trim());
                    if (string == null || string.length() <= 0 || n2 > (n = Integer.parseInt(string)) || n > n3) continue;
                    this.setMsg(string + "_PORT_AVAILABLE_IN_EXCLUDED_PORT_RANGE_OF_" + string2);
                    return true;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to parse Excluded_Port_Ranges : {}, tempPort : {} ", new Object[]{loggerDispStr, string2, string, exception});
                }
            }
        }
        return false;
    }

    private String getPriorityPort() {
        block8: {
            ConcurrentHashMap concurrentHashMap = ApmConfigManager.getInstance().getAppDiscoveryPriorityPorts();
            try {
                ArrayList arrayList;
                if (concurrentHashMap == null || concurrentHashMap.size() <= 0) break block8;
                ArrayList arrayList2 = new ArrayList();
                if (this.isServerTypeDiscovered() && concurrentHashMap.containsKey(this.serverType)) {
                    arrayList2 = (ArrayList)concurrentHashMap.get(this.serverType);
                }
                if (concurrentHashMap.containsKey("Default_Https_Ports") && (arrayList = (ArrayList)concurrentHashMap.get("Default_Https_Ports")) != null && arrayList.size() > 0) {
                    arrayList2.addAll(arrayList);
                }
                if (concurrentHashMap.containsKey("Default_Http_Ports") && (arrayList = (ArrayList)concurrentHashMap.get("Default_Http_Ports")) != null && arrayList.size() > 0) {
                    arrayList2.addAll(arrayList);
                }
                APMDiscoveryLogger.discoveryLogger.trace("{} Consolidated priority port list : {} & current listening ports : {}", new Object[]{loggerDispStr, arrayList2, this.listeningPorts});
                if (arrayList2 == null || arrayList2.size() <= 0 || this.listeningPorts == null || this.listeningPorts.size() <= 0) break block8;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = (String)arrayList2.get(i);
                    try {
                        if (!this.listeningPorts.contains(Integer.parseInt(string))) continue;
                        return string;
                    }
                    catch (NumberFormatException numberFormatException) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to parse port : {} ", new Object[]{loggerDispStr, string, numberFormatException});
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get priority port  ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return "";
    }

    private String getEgDiscoveryPort() {
        block6: {
            ConcurrentHashMap concurrentHashMap = ApmConfigManager.getInstance().getEgPortDiscoveryMap();
            try {
                if (concurrentHashMap == null || concurrentHashMap.size() <= 0) break block6;
                ArrayList arrayList = new ArrayList();
                if (this.isServerTypeDiscovered() && concurrentHashMap.containsKey(this.serverType)) {
                    arrayList = (ArrayList)concurrentHashMap.get(this.serverType);
                }
                if (arrayList == null || arrayList.size() <= 0 || this.listeningPorts == null || this.listeningPorts.size() <= 0) break block6;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    try {
                        if (!this.listeningPorts.contains(Integer.parseInt(string))) continue;
                        return string;
                    }
                    catch (NumberFormatException numberFormatException) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to parse port : {} ", new Object[]{loggerDispStr, string, numberFormatException});
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get eG Discovery ports  ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return "";
    }

    private String getLeastPort() {
        if (this.listeningPorts != null && this.listeningPorts.size() > 0) {
            Iterator iterator = this.listeningPorts.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n <= 1) continue;
                this.port = n + "";
                return this.port + "";
            }
        }
        return "";
    }

    public void setCommand(String string) {
        if (string != null && string.length() > 0) {
            this.commandLine = string;
            this.setCommandStatus();
        }
    }

    public void setCommandStatus() {
        this.setStatus((Object)TAG.COMMAND_LINE_DISCOVERED);
    }

    public void setSystemPropertyStatus() {
        this.setStatus((Object)TAG.SYSTEM_PROPERTY_DISCOVERED);
    }

    public void setPortStatus(TAG tAG) {
        this.setStatus((Object)TAG.PORT_FINALIZED);
        this.setStatus((Object)tAG);
    }

    public void setPidStatus() {
        if (!this.pid.equalsIgnoreCase("-1") && !this.pid.equalsIgnoreCase("0")) {
            this.setStatus((Object)TAG.PID_DISCOVERED);
        }
    }

    public void setExecutableStatus() {
        if (this.executable != null && this.executable.length() > 0) {
            this.setStatus((Object)TAG.EXECUTABLE_FOUND);
        }
    }

    public void setListeningPort(TreeSet treeSet) {
        if (treeSet != null && treeSet.size() > 0) {
            this.listeningPorts.addAll(treeSet);
            this.setStatus((Object)TAG.PORTS_DISCOVERED);
        }
    }

    public void setServerType(String string) {
        if (string != null && string.length() > 0) {
            this.serverType = string;
            this.setStatus((Object)TAG.SERVER_TYPE_DISCOVERED);
        }
    }

    public void setServerTypeStatus(TAG tAG) {
        this.setStatus((Object)tAG);
    }

    public void setStatus(Object object) {
        if (!this.processStatusList.contains(object)) {
            this.processStatusList.add(object);
        }
    }

    private boolean isStatusAvailable(TAG tAG) {
        return this.processStatusList.contains((Object)tAG);
    }

    public void setMsg(String string) {
        this.setStatus(string);
    }

    public void setAttachStatus(TAG tAG) {
        this.setStatus((Object)tAG);
    }

    public boolean isBlockListed() {
        return this.isStatusAvailable(TAG.BLOCK_LISTED);
    }

    public boolean isFullyDiscovered() {
        if (statusValidator != null) {
            return this.processStatusList.containsAll(statusValidator);
        }
        return false;
    }

    boolean isPortFinalized() {
        return this.isStatusAvailable(TAG.PORT_FINALIZED);
    }

    boolean isSystemProperyDiscovered() {
        return this.isStatusAvailable(TAG.SYSTEM_PROPERTY_DISCOVERED);
    }

    boolean isCmdLineDiscovered() {
        return this.isStatusAvailable(TAG.COMMAND_LINE_DISCOVERED);
    }

    boolean isPortDiscovered() {
        return this.isStatusAvailable(TAG.PORTS_DISCOVERED);
    }

    boolean isServerTypeDiscovered() {
        return this.isStatusAvailable(TAG.SERVER_TYPE_DISCOVERED);
    }

    public boolean isJavaHomeAvailable() {
        try {
            return this.isStatusAvailable(TAG.JAVA_HOME_FOUND) || this.getExecutable().trim().endsWith("java");
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred ", (Object)loggerDispStr, (Object)exception);
            return false;
        }
    }

    boolean isMaxRetryAttemptReached() {
        return this.retryAttemptCounter > MAX_ATTEMPT && System.currentTimeMillis() - this.upTime > MAX_TIME_DIFF;
    }

    boolean isExcludedPortFound() {
        return this.isStatusAvailable(TAG.EXCLUDED_PORT_FOUND);
    }

    void updateRetryAttempt() {
        ++this.retryAttemptCounter;
    }

    void setJavaVersionCmdResult(String string) {
        if (string != null && string.length() > 5) {
            this.javaVersionCmdResult = string;
            this.setStatus((Object)TAG.JAVA_VERSION_CMD_EXECUTED);
            this.setStatus((Object)TAG.JAVA_VERSION_FOUND);
        }
    }

    public String getJavaVersionCmdResult() {
        return this.javaVersionCmdResult;
    }

    boolean isJavaVersionCmdExecuted() {
        return this.isStatusAvailable(TAG.JAVA_VERSION_CMD_EXECUTED);
    }

    boolean isJavaVersionFound() {
        return this.isStatusAvailable(TAG.JAVA_VERSION_FOUND);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{JavaProcess={");
        stringBuilder.append("pid=").append(this.pid);
        stringBuilder.append(", user=").append(APMUtils.wrapWithDoubleQuotes(this.user));
        stringBuilder.append(", jvmName=").append(this.jvmName);
        stringBuilder.append(", jvmVersion=").append(this.jvmVersion);
        stringBuilder.append(", jvmVendor=").append(this.jvmVendor);
        stringBuilder.append(", jvmHome=").append(APMUtils.wrapWithDoubleQuotes(this.jvmHome));
        stringBuilder.append(", serverType=").append(this.serverType);
        stringBuilder.append(", processEventStatus=").append(APMUtils.wrapWithDoubleQuotes(this.processStatusList.toString()));
        stringBuilder.append(", port=").append(this.port);
        stringBuilder.append(", listeningPorts=").append(this.listeningPorts);
        stringBuilder.append(", upTime=").append(this.upTime).append(" - ").append(APMUtils.wrapWithDoubleQuotes(this.upTimeAsDate));
        stringBuilder.append(", executable=").append(APMUtils.wrapWithDoubleQuotes(this.executable));
        stringBuilder.append(", commandLine={").append(APMUtils.wrapWithDoubleQuotes(this.commandLine)).append("}");
        stringBuilder.append(", systemProperties=").append(APMUtils.getAsJsonString(this.systemPropsMap));
        stringBuilder.append(", discoveryReAttemptCounter=").append(this.retryAttemptCounter);
        stringBuilder.append(", javaVersionCmdResult=").append(APMUtils.wrapWithDoubleQuotes(this.javaVersionCmdResult));
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    static {
        statusValidator = new ArrayList(){
            {
                this.add(TAG.PID_DISCOVERED);
                this.add(TAG.PORTS_DISCOVERED);
                this.add(TAG.SERVER_TYPE_DISCOVERED);
            }
        };
    }
}

