/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraIdleSessionTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String inactive_period;
    public int period;
    private static final int i_measureCount = 1;
    public Hashtable idleSessionDetailsDD;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public void freeTest() {
        this.idleSessionDetailsDD = new Hashtable();
    }

    public OraIdleSessionTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        this.inactive_period = this.getValueForParam("inactive_period");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.period = this.inactive_period == null || this.inactive_period.equalsIgnoreCase("NULL") || this.inactive_period.equalsIgnoreCase("none") ? 10 : new Integer(this.inactive_period);
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                var2_2 = "tcps";
                var3_3 = this.targetHost;
                var4_5 = this.portNo;
                var5_6 = this.oraSid;
                var6_7 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + var2_2 + ")(HOST=" + (String)var3_3 + ")(PORT=" + (String)var4_5 + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)var5_6 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", var6_7);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled != false ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.reportingName);
            var2_2 = new ArrayList<E>();
            var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (var2_2 != null && var2_2.size() > 2) {
                var3_4 = (Integer)var2_2.get(0);
                var4_5 = (String)var2_2.get(1);
                if (var4_5.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (var3_4 >= 12) {
                    this.isOracle12c = true;
                    var5_6 = (String)var2_2.get(2);
                    if (var5_6.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            var2_2 = new Hashtable<K, V>();
            var2_2 = this.isSSLEnabled != false ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.reportingName);
            if (var2_2 == null) return;
            if (var2_2.size() == 0) {
                return;
            }
            var3_3 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
            if (var3_3 == null) return;
            if (var3_3.size() <= 0) return;
            var4_5 = (String)var3_3.get(2);
            var5_6 = (String)var3_3.get(3);
            if (!var4_5.equalsIgnoreCase("PRIMARY") && var5_6.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        this.idleSessionDetailsDD = new Hashtable<K, V>();
        var2_2 = new ArrayList<E>();
        var3_3 = null;
        var4_5 = null;
        var5_6 = null;
        var6_8 = 0;
        var7_9 = "SELECT  SID, USERNAME,(LAST_CALL_ET/60) idle_time FROM  v$session WHERE  username IS NOT NULL AND (LAST_CALL_ET / 60) > " + this.period + " AND  STATUS = 'INACTIVE' order by idle_time";
        try {
            block44: {
                block43: {
                    block41: {
                        block42: {
                            if (!this.isMultitenantDb) break block41;
                            if (!this.isCDB) break block42;
                            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                                this.logToErrorFile("INFO", "OraIdleSessionTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                this.msgLogCounter = 0;
                            }
                            ++this.msgLogCounter;
                            var14_10 = null;
                            ** GOTO lbl168
                        }
                        var7_9 = "SELECT  SID, USERNAME,(LAST_CALL_ET/60) idle_time,con_id FROM  v$session WHERE con_id > 0 and username IS NOT NULL AND (LAST_CALL_ET / 60) > 50 AND  STATUS = 'INACTIVE' order by idle_time";
                        var3_3 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug);
                        break block43;
                    }
                    var3_3 = this.isSSLEnabled != false ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraIdleSessionTest.debug);
                }
                if (var3_3 != null) break block44;
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                ** GOTO lbl175
            }
            try {
                var4_5 = var3_3.createStatement();
            }
            catch (Exception var8_22) {
                this.logToErrorFile("Error :", "OraIdleSessionTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var8_22.toString());
                var8_22.printStackTrace();
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
                catch (Exception var9_25) {
                }
                var14_12 = null;
                try {
                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
                }
                catch (Exception var15_18) {
                    System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_18.toString());
                }
                return;
            }
            var5_6 = var4_5.executeQuery(var7_9);
            if (var5_6 != null) {
                while (var5_6.next()) {
                    var8_23 = new ArrayList<Object>();
                    var9_26 = var5_6.getString("SID");
                    var8_23.add(var9_26);
                    var8_23.add(var5_6.getString("USERNAME"));
                    var10_29 = var5_6.getDouble("idle_time");
                    var12_30 = new BigDecimal(var10_29).setScale(2, 6);
                    var8_23.add(new Double(var12_30.doubleValue()));
                    this.idleSessionDetailsDD.put(var9_26, var8_23);
                    ++var6_8;
                }
            }
            var5_6.close();
            var4_5.close();
            var2_2.add(new Double(var6_8));
            this.addNewMeasure((ArrayList)var2_2);
            ** GOTO lbl183
        }
        catch (Exception var8_24) {
            try {
                if (var5_6 != null) {
                    var5_6.close();
                }
            }
            catch (Exception var9_27) {
                // empty catch block
            }
            try {
                if (var4_5 != null) {
                    var4_5.close();
                }
            }
            catch (Exception var9_28) {
                // empty catch block
            }
            this.logToErrorFile("Error :", "OraIdleSessionTest.computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var8_24.toString());
            System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures():" + var8_24.toString());
            var14_14 = null;
            try {}
            catch (Exception var15_20) {
                System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_20.toString());
                return;
            }
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
        {
            catch (Throwable var13_31) {
                var14_15 = null;
                ** try [egrp 6[TRYBLOCK] [14 : 1619->1632)] { 
lbl162:
                // 1 sources

                if (var3_3 == null) throw var13_31;
                var3_3.close();
                throw var13_31;
lbl165:
                // 1 sources

                catch (Exception var15_21) {
                    System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_21.toString());
                }
                throw var13_31;
            }
lbl168:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [14 : 1619->1632)] { 
lbl169:
            // 1 sources

            if (var3_3 == null) return;
            var3_3.close();
            return;
lbl172:
            // 1 sources

            catch (Exception var15_16) {
                System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_16.toString());
            }
            return;
lbl175:
            // 1 sources

            var14_11 = null;
            ** try [egrp 6[TRYBLOCK] [14 : 1619->1632)] { 
lbl177:
            // 1 sources

            if (var3_3 == null) return;
            var3_3.close();
            return;
lbl180:
            // 1 sources

            catch (Exception var15_17) {
                System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_17.toString());
            }
            return;
lbl183:
            // 1 sources

            var14_13 = null;
            try {}
            catch (Exception var15_19) {}
            System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + var15_19.toString());
            return;
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
    }
}

