/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraRacDbGrowthTest
extends GenericTest {
    private String user;
    private String passwd;
    private String oraSid;
    private String viewName;
    private static final int i_measureCount = 10;
    private static double gbConvertor = 1.073741824E9;
    private boolean service = true;
    private String serviceName = "";
    private boolean useMaxSize = true;
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraRacDbGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("username");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.viewName = this.getValueForParam("alternate_view");
        String string = this.getValueForParam("use_max_size");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        this.useMaxSize = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string = "";
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                String string2 = "tcps";
                object2 = this.targetHost;
                String string3 = this.portNo;
                object = "";
                String string4 = "";
                if (this.service) {
                    string4 = this.serviceName;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=" + (String)object2 + ")(PORT=" + string3 + "))(CONNECT_DATA=(SERVICE_NAME=" + string4 + ")))";
                } else {
                    string4 = this.oraSid;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=" + (String)object2 + ")(PORT=" + string3 + "))(CONNECT_DATA=(SID=" + string4 + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        try {
            try {
                string = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from DBA_FREE_SPACE group by file_id) b on a.file_id = b.file_id" : "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from " + this.viewName + " group by file_id) b on a.file_id = b.file_id";
                this.printOut("OraRacDbGrowthTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                connection = this.isSSLEnabled ? ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug, this.sslParametersHT) : ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug);
                if (connection == null) {
                    this.printOut(this.entity + " connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                    this.logToErrorFile("[OraRacDbGrowthTest] compute Measure()", "database conn is null ", "TargetHost" + this.targetHost);
                    Object var38_31 = null;
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                    return;
                }
                this.printOut("OraRacDbGrowthTest connection established targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + " serviceName:" + this.serviceName, exception.toString());
                    this.closeConn(connection);
                    Object var38_32 = null;
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                    return;
                }
                this.printOut("OraRacDbGrowthTest statement created targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.printOut("OraRacDbGrowthTest before executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                resultSet = statement.executeQuery(string);
                this.printOut("OraRacDbGrowthTest after executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                while (resultSet.next()) {
                    double d12 = resultSet.getDouble(1);
                    double d13 = resultSet.getDouble(2);
                    double d14 = resultSet.getDouble(3);
                    double d15 = resultSet.getDouble(4);
                    if (d13 == 0.0 || d13 < d14) {
                        d13 = d14;
                    }
                    if (this.useMaxSize) {
                        d3 += d13;
                        d6 = d13 - d14 + d15;
                        d += d6;
                    } else {
                        d3 += d14;
                        d6 = d15;
                        d += d6;
                    }
                    d7 += d14;
                    d8 = d15;
                    d9 += d8;
                }
                d4 = d3 / gbConvertor;
                d10 = d7 / gbConvertor;
                d2 = d / gbConvertor;
                d11 = d9 / gbConvertor;
                arrayList.add(new Double(d10));
                arrayList.add(new Double(d10 - d11));
                arrayList.add(new Double(d11));
                this.printOut("aloc_totalSize_gb== " + d10);
                this.printOut("aloc_availability_gb== " + d11);
                BigDecimal bigDecimal = new BigDecimal((d10 - d11) / d10 * 100.0);
                bigDecimal = bigDecimal.setScale(2, 6);
                arrayList.add(new Double(bigDecimal.doubleValue()));
                object2 = new BigDecimal(d11 / d10 * 100.0);
                object2 = ((BigDecimal)object2).setScale(2, 6);
                arrayList.add(new Double(((BigDecimal)object2).doubleValue()));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d4 - d2));
                arrayList.add(new Double(d2));
                BigDecimal bigDecimal2 = new BigDecimal((d4 - d2) / d4 * 100.0);
                bigDecimal2 = bigDecimal2.setScale(2, 6);
                arrayList.add(new Double(bigDecimal2.doubleValue()));
                object = new BigDecimal(d2 / d4 * 100.0);
                object = ((BigDecimal)object).setScale(2, 6);
                arrayList.add(new Double(((BigDecimal)object).doubleValue()));
                this.addNewMeasure(arrayList);
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                this.printOut("Exception Occured in OraRacDbGrowthTest.computeMeasures():" + exception.toString());
                exception.printStackTrace();
                this.logToErrorFile("Error :", " Exception Occured in OraRacDbGrowthTest.computeMeasures():", exception.toString());
                object2 = new ArrayList();
                int i = 0;
                while (true) {
                    if (i >= this.measureCount) {
                        this.printOut("Adding MeasureList :" + object2);
                        this.addNewMeasure((ArrayList)object2);
                        Object var38_34 = null;
                        this.closeRS(resultSet);
                        this.closeST(statement);
                        this.closeConn(connection);
                        return;
                    }
                    ((ArrayList)object2).add(new Double(-1.0));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var38_35 = null;
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            throw throwable;
        }
        Object var38_33 = null;
        this.closeRS(resultSet);
        this.closeST(statement);
        this.closeConn(connection);
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeST(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }
}

