/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class SystemTest
extends EgTest {
    private int repeat = 3;
    private int period;
    private static long lastCacheTime = 0L;
    private static long lastRunTime = 0L;
    private static Hashtable lastResults = new Hashtable();
    private Hashtable hres = new Hashtable();
    private static String dsync = new String("dt");
    private double cpuUtil = 0.0;
    private double run = 0.0;
    private double block = 0.0;
    private double swap = 0.0;
    private double free = 0.0;
    private double scan = 0.0;
    private double sysCpu = 0.0;
    private double idleCpu = 0.0;
    private double page = -5.0;
    private double steal = -5.0;
    private double zcpuUtil = 0.0;
    private double zsysCpu = 0.0;
    private double zrun = 0.0;
    private double zblock = 0.0;
    private double zswap = 0.0;
    private double zfree = 0.0;
    private double zscan = 0.0;
    private double zIdleCpu = 0.0;
    private String index;
    private EgUtilities egutil = null;
    private static int cpuUtilIndex = 0;
    private static int sysCpuIndex = 1;
    private static int runIndex = 2;
    private static int blockIndex = 3;
    private static int swapIndex = 4;
    private static int freeIndex = 5;
    private static int scanIndex = 6;
    private static int stealIndex = 7;
    private static String cmd1 = "swap -s";
    private boolean isMultiProcessor = false;
    private String mpstat = "mpstat";
    private String sindex = "";
    private boolean summary = false;
    private boolean useiostat = false;
    private double CPU = -5.0;
    private double SYSCPU = -5.0;
    private double IDLECPU = -5.0;
    private double ZCPU = -5.0;
    private double ZSYSCPU = -5.0;
    private double ZIDLECPU = -5.0;
    private Hashtable zoneValues;
    private Hashtable zoneValues2;
    private Hashtable zoneValue3;
    private String zoneName;
    public boolean is_non_global_zone = false;
    public ArrayList cpuDDList = new ArrayList();
    public ArrayList memDDList = new ArrayList();
    public boolean isEnabledFreeMemDD = false;
    public boolean isDoneCpuDD = false;
    public boolean isDoneMemDD = false;
    public boolean isCpuFromIdle = false;

    public void freeTest() {
        this.cpuDDList = new ArrayList();
        this.memDDList = new ArrayList();
        this.isDoneCpuDD = false;
        this.isDoneMemDD = false;
        this.hres = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        if (this.cacheTestResults) {
            String string = dsync;
            synchronized (string) {
                lastResults.clear();
                lastCacheTime = 0L;
            }
        }
    }

    public SystemTest(String[] stringArray) {
        super(stringArray);
        this.is_non_global_zone = this.isNonGlobalZone();
        if (stringArray.length < 2) {
            System.err.println("Usage: SystemTest -host <hostName> -duration <period> -summary <yes/no>");
            return;
        }
        this.period = 5;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equalsIgnoreCase("-summary")) {
                if (!stringArray[++i].equalsIgnoreCase("yes") && !stringArray[i].equalsIgnoreCase("y")) continue;
                this.summary = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-duration")) {
                if (++i >= stringArray.length) continue;
                this.period = Integer.parseInt(stringArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-host")) {
                this.targetHost = new String(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-useiostat")) {
                if (!stringArray[++i].equalsIgnoreCase("yes") && !stringArray[i].equalsIgnoreCase("y")) continue;
                this.useiostat = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-enable_memory_diagnosis")) {
                if ((string = stringArray[++i].trim()).equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y")) {
                    this.isEnabledFreeMemDD = true;
                    continue;
                }
                this.isEnabledFreeMemDD = false;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-include_wait")) continue;
            this.isCpuFromIdle = (string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"));
        }
        this.numOutputFields = 8;
        this.isMultiProcessor = this.checkForMultiProcs();
        if (!this.isMultiProcessor) {
            this.index = !this.is_non_global_zone ? new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator) : new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "kernel");
        } else {
            this.index = "";
            this.sindex = !this.is_non_global_zone ? new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary") : new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "kernel:Summary");
        }
        this.egutil = EgUtilities.createInstance();
        if (this.localZone) {
            RunVmstat runVmstat = new RunVmstat(this.repeat, this.period, true);
        }
    }

    private boolean checkForMultiProcs() {
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(this.mpstat);
        if (arrayList == null || arrayList.size() < 2) {
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return false;
        }
        return arrayList2.size() > 2;
    }

    private void calculatePageSize() {
        ArrayList arrayList;
        File file = new File("/usr/bin/kstat");
        if (!file.exists()) {
            this.page = -5.0;
            return;
        }
        String string = "pagesize";
        ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
        if (arrayList2 == null || arrayList2.size() < 2) {
            this.page = -5.0;
        }
        if ((arrayList = (ArrayList)arrayList2.get(0)) == null || arrayList.size() == 0) {
            this.page = -5.0;
        }
        int n = arrayList.size();
        String string2 = (String)arrayList.get(n - 1);
        string2 = string2.trim();
        try {
            this.page = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            this.page = -5.0;
        }
    }

    private ArrayList executeiostatOnZone(String string) {
        String string2;
        this.ZCPU = -5.0;
        this.ZSYSCPU = -5.0;
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Failed to run " + string);
            return this.setDefaultValues(2);
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() < 4) {
            return this.setDefaultValues(2);
        }
        String string3 = "";
        string3 = (String)arrayList2.get(arrayList2.size() - 1);
        if (string3 == null || string3.length() == 0) {
            return this.setDefaultValues(2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3 = string3.trim());
        int n = stringTokenizer.countTokens();
        if (n < 4) {
            return this.setDefaultValues(2);
        }
        String string4 = stringTokenizer.nextToken();
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        if (string4 != null) {
            d = Double.parseDouble(string4);
        }
        if ((string2 = stringTokenizer.nextToken()) != null) {
            d2 = Double.parseDouble(string2);
        }
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        if (string6 != null) {
            d3 = Double.parseDouble(string6);
        }
        if (d < 0.0 || d2 < 0.0) {
            this.ZCPU = -5.0;
            this.ZSYSCPU = -5.0;
        } else if (this.isCpuFromIdle) {
            this.ZIDLECPU = d3;
            if (this.ZIDLECPU > 100.0) {
                this.ZIDLECPU = 100.0;
            }
            this.ZCPU = 100.0 - this.ZIDLECPU;
        } else {
            this.ZSYSCPU = d2;
            this.ZCPU = d + d2;
        }
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        arrayList3.add(new Double(this.ZSYSCPU));
        arrayList3.add(new Double(this.ZCPU));
        return arrayList3;
    }

    private boolean executeiostat(String string) {
        String string2;
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Failed to run " + string);
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() < 4) {
            return false;
        }
        String string3 = "";
        string3 = (String)arrayList2.get(arrayList2.size() - 1);
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3 = string3.trim());
        int n = stringTokenizer.countTokens();
        if (n < 4) {
            return false;
        }
        String string4 = stringTokenizer.nextToken();
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        if (string4 != null) {
            d = Double.parseDouble(string4);
        }
        if ((string2 = stringTokenizer.nextToken()) != null) {
            d2 = Double.parseDouble(string2);
        }
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        if (string6 != null) {
            d3 = Double.parseDouble(string6);
        }
        if (d < 0.0 || d2 < 0.0) {
            this.CPU = -5.0;
            this.SYSCPU = -5.0;
        } else if (this.isCpuFromIdle) {
            this.IDLECPU = d3;
            if (this.IDLECPU > 100.0) {
                this.IDLECPU = 100.0;
            }
            this.CPU = 100.0 - this.IDLECPU;
        } else {
            this.SYSCPU = d2;
            this.CPU = d + d2;
        }
        return true;
    }

    private ArrayList executeOnZone(String string, String string2) {
        Object object;
        this.zcpuUtil = 0.0;
        this.zsysCpu = 0.0;
        this.zrun = 0.0;
        this.zblock = 0.0;
        this.zswap = 0.0;
        this.zfree = 0.0;
        this.zscan = 0.0;
        this.zIdleCpu = 0.0;
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Failed to run" + string);
            return this.setDefaultValues(7);
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() < 4) {
            return this.setDefaultValues(7);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (String)arrayList2.get(i);
            if (((String)(object = ((String)object).toLowerCase())).indexOf("state change") <= 0) continue;
            return this.setDefaultValues(7);
        }
        String string3 = (String)arrayList2.get(4);
        object = new StringTokenizer(string3);
        String[] stringArray = new String[((StringTokenizer)object).countTokens()];
        int n = ((StringTokenizer)object).countTokens();
        block13: for (int i = 0; i < n; ++i) {
            stringArray[i] = ((StringTokenizer)object).nextToken();
            double d = -1.0;
            try {
                d = Double.parseDouble(stringArray[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d < 0.0) {
                return this.setDefaultValues(7);
            }
            switch (i) {
                case 0: {
                    this.zrun = d;
                    continue block13;
                }
                case 1: {
                    this.zblock = d;
                    continue block13;
                }
                case 3: {
                    this.zswap = d / 1024.0;
                    continue block13;
                }
                case 4: {
                    this.zfree = d / 1024.0;
                    continue block13;
                }
                case 11: {
                    this.zscan = d;
                    continue block13;
                }
                case 19: {
                    this.zcpuUtil = d;
                    continue block13;
                }
                case 20: {
                    this.zsysCpu = d;
                    continue block13;
                }
                case 21: {
                    this.zIdleCpu = d;
                }
            }
        }
        String string4 = "zlogin " + string2 + " swap -s";
        this.zswap = this.findSwapUsedOnZone(string4);
        if (this.isCpuFromIdle) {
            if (this.zcpuUtil > 100.0) {
                this.zcpuUtil = 100.0;
            }
            this.zcpuUtil = 100.0 - this.zIdleCpu;
        } else {
            this.zcpuUtil += this.zsysCpu;
        }
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        arrayList3.add(new Double(this.zcpuUtil));
        arrayList3.add(new Double(this.zsysCpu));
        arrayList3.add(new Double(this.zrun));
        arrayList3.add(new Double(this.zblock));
        arrayList3.add(new Double(this.zswap));
        arrayList3.add(new Double(this.zfree));
        arrayList3.add(new Double(this.zscan));
        arrayList3.add(new Double(this.steal));
        return arrayList3;
    }

    private boolean execute(String string) {
        Object object;
        if (this.meAgentless) {
            this.isDynamicInfoTest = true;
            return true;
        }
        ArrayList arrayList = RunVmstat.runCmd();
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Failed to run" + string);
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() < 4) {
            return false;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (String)arrayList2.get(i);
            if (((String)(object = ((String)object).toLowerCase())).indexOf("state change") <= 0) continue;
            return false;
        }
        String string2 = (String)arrayList2.get(4);
        object = new StringTokenizer(string2);
        String[] stringArray = new String[((StringTokenizer)object).countTokens()];
        int n = ((StringTokenizer)object).countTokens();
        this.cpuUtil = 0.0;
        this.sysCpu = 0.0;
        this.idleCpu = 0.0;
        double d = -5.0;
        d = this.findFreeMemory();
        block13: for (int i = 0; i < n; ++i) {
            stringArray[i] = ((StringTokenizer)object).nextToken();
            double d2 = -5.0;
            try {
                d2 = Double.parseDouble(stringArray[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (i) {
                case 0: {
                    this.run = d2;
                    continue block13;
                }
                case 1: {
                    this.block = d2;
                    continue block13;
                }
                case 3: {
                    if (!(d2 >= 0.0)) continue block13;
                    this.swap = d2 / 1024.0;
                    continue block13;
                }
                case 4: {
                    if (this.page <= 0.0 && d < 0.0 && d2 >= 0.0) {
                        this.free = d2 / 1024.0;
                        continue block13;
                    }
                    this.free = d;
                    continue block13;
                }
                case 11: {
                    this.scan = d2;
                    continue block13;
                }
                case 19: {
                    this.cpuUtil = d2;
                    continue block13;
                }
                case 20: {
                    this.sysCpu = d2;
                    continue block13;
                }
                case 21: {
                    this.idleCpu = d2;
                }
            }
        }
        if (this.isCpuFromIdle) {
            if (this.idleCpu > 100.0) {
                this.idleCpu = 100.0;
            }
            this.cpuUtil = this.idleCpu >= 0.0 ? 100.0 - this.idleCpu : -5.0;
        } else {
            this.cpuUtil = this.cpuUtil >= 0.0 && this.sysCpu >= 0.0 ? (this.cpuUtil += this.sysCpu) : -5.0;
        }
        return true;
    }

    private double getCacheMemory() {
        String string = "/usr/bin/kstat zfs:0:arcstats:size";
        double d = -5.0;
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            return d;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return d;
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList2.get(i);
            if (!(string2 = string2.trim()).startsWith("size")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble(string3);
                if (d >= 0.0) {
                    d /= 1048576.0;
                    continue;
                }
                d = -5.0;
                continue;
            }
            catch (Exception exception) {
                d = -5.0;
            }
        }
        return d;
    }

    private double findFreeMemory() {
        double d;
        String string = "/usr/bin/kstat -c pages";
        double d2 = -5.0;
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            return -5.0;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return -5.0;
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList2.get(i);
            if (!(string2 = string2.trim()).startsWith("freemem")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                d2 = Double.parseDouble(string3);
                if (this.page >= 0.0) {
                    d2 = d2 * this.page / 1048576.0;
                    break;
                }
                d2 = -5.0;
            }
            catch (Exception exception) {
                d2 = -5.0;
            }
            break;
        }
        if ((d = this.getCacheMemory()) > 0.0) {
            d2 += d;
        }
        return d2;
    }

    private double findSwapUsed() {
        ArrayList arrayList = this.egutil.getExecOutputLines(cmd1);
        if (arrayList == null || arrayList.size() < 2) {
            return -5.0;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return -5.0;
        }
        int n = arrayList2.size();
        String string = (String)arrayList2.get(n - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 12) {
            return -5.0;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        double d = this.parse(string4);
        return d;
    }

    private double findSwapUsedOnZone(String string) {
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            return -5.0;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return -5.0;
        }
        int n = arrayList2.size();
        String string2 = (String)arrayList2.get(n - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() < 12) {
            return -5.0;
        }
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        double d = this.parse(string5);
        return d;
    }

    private double parse(String string) {
        double d = -5.0;
        string = string.substring(0, string.length() - 1);
        try {
            d = Double.parseDouble(string);
            d /= 1024.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private void executeForLocalZone() {
        this.executeForLocalZone(-1.0);
    }

    private void executeForLocalZone(double d) {
        if (this.is_non_global_zone) {
            int n = 0;
            ZoneHelper zoneHelper = ZoneHelper.getInstance();
            this.egutil = EgUtilities.createInstance();
            ArrayList arrayList = ZoneHelper.getCommandOutput((String)("prstat -Z " + this.period + " " + this.repeat + " | tr -s \" \" \"\""));
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("[SystemTest] output of  outputLst object is null");
            }
            int n2 = arrayList != null && arrayList.size() > 0 ? arrayList.size() : 0;
            for (int i = 0; i < n2 - 1; ++i) {
                StringTokenizer stringTokenizer;
                String string = (String)arrayList.get(i);
                if (string.indexOf("ZONEID") > -1) {
                    ++n;
                }
                if (n != this.repeat || string.indexOf("ZONEID") > -1 || (stringTokenizer = new StringTokenizer(string)).countTokens() < 8) continue;
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string7);
                if (string6 != null) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                if (d >= 0.0) {
                    double d2 = -1.0;
                    try {
                        d2 = Double.parseDouble(string6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d2 > d) {
                        d2 = d;
                        string6 = "" + d2;
                    }
                }
                this.cpuDDList.add(infoFieldSeparator + string7);
                this.addValueToResultSet(string8, cpuUtilIndex, string6);
                this.addValueToResultSet(string8, sysCpuIndex, -5.0);
                this.addValueToResultSet(string8, runIndex, -5.0);
                this.addValueToResultSet(string8, blockIndex, -5.0);
                this.addValueToResultSet(string8, swapIndex, -5.0);
                this.addValueToResultSet(string8, freeIndex, -5.0);
                this.addValueToResultSet(string8, scanIndex, -5.0);
                this.addValueToResultSet(string8, stealIndex, -5.0);
                if (!this.cacheTestResults) continue;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(string6));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                this.hres.put(string8, arrayList2);
            }
        }
    }

    public boolean isNonGlobalZone() {
        ArrayList arrayList;
        File file = new File("/usr/bin/zonename");
        File file2 = new File("/sbin/zonename");
        if (!file.exists() && !file2.exists()) {
            return false;
        }
        if (this.egutil == null) {
            this.egutil = EgUtilities.createInstance();
        }
        if ((arrayList = this.egutil.getExecOutputLines("zonename")) == null || arrayList.size() < 2) {
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 != null && arrayList2.indexOf("global") == -1) {
            this.zoneName = arrayList2.get(0).toString();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTest() {
        this.initTest();
        this.cpuDDList = new ArrayList();
        this.memDDList = new ArrayList();
        this.CPU = -5.0;
        this.SYSCPU = -5.0;
        String string = dsync;
        synchronized (string) {
            Object object;
            int n;
            String string2;
            long l;
            long l2;
            if (this.cacheTestResults && lastResults != null && lastResults.size() > 0 && (l2 = (l = System.currentTimeMillis()) - lastCacheTime) < this.minMeasurePeriod / 2L) {
                Hashtable hashtable = null;
                Object object2 = dsync;
                synchronized (object2) {
                    hashtable = (Hashtable)lastResults.clone();
                }
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    String string3 = (String)object2.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable.get(string3);
                    if (arrayList == null) continue;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string4;
                        int n2;
                        Double d = (Double)arrayList.get(i);
                        double d2 = d;
                        if (i == 0 && d2 > 0.0) {
                            n2 = string3.lastIndexOf(infoFieldSeparator);
                            if (n2 >= 0) {
                                string4 = string3.substring(n2);
                                this.cpuDDList.add(string4);
                            }
                        } else if (i == 5 && d2 > 0.0 && (n2 = string3.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string4 = string3.substring(n2);
                            this.memDDList.add(string4);
                        }
                        this.addValueToResultSet(string3, i, d2);
                    }
                }
                this.updateAllResultSets();
                return true;
            }
            this.hres = new Hashtable();
            String string5 = "vmstat -S " + this.period + " " + this.repeat;
            boolean bl = true;
            for (int i = 0; i < 3; ++i) {
                if (this.localZone) {
                    bl = this.execute(string5);
                    if (!bl) continue;
                    break;
                }
                this.zoneValues = new Hashtable();
                int n3 = this.zonenames.size();
                string2 = null;
                for (n = 0; n < n3; ++n) {
                    string2 = (String)this.zonenames.get(n);
                    string5 = "zlogin " + string2 + " vmstat -S " + this.period + " " + this.repeat;
                    object = this.executeOnZone(string5, string2);
                    this.zoneValues.put(string2, object);
                    bl = true;
                }
                if (bl) break;
            }
            if (!bl) {
                if (this.cacheTestResults) {
                    String string6 = dsync;
                    synchronized (string6) {
                        lastResults.clear();
                    }
                }
                this.updateAllResultSets();
                return true;
            }
            double d = this.findSwapUsed();
            if (!this.isMultiProcessor) {
                if (!this.useiostat) {
                    if (this.localZone) {
                        string2 = this.index + "Summary";
                        if (this.cpuUtil > 0.0 && (n = string2.lastIndexOf(infoFieldSeparator)) >= 0) {
                            object = string2.substring(n);
                            this.cpuDDList.add(object);
                        }
                        this.addValueToResultSet(string2, cpuUtilIndex, this.cpuUtil);
                        this.addValueToResultSet(string2, sysCpuIndex, this.sysCpu);
                        this.addValueToResultSet(string2, runIndex, this.run);
                        this.addValueToResultSet(string2, blockIndex, this.block);
                        this.addValueToResultSet(string2, swapIndex, d);
                        this.addValueToResultSet(string2, freeIndex, this.free);
                        if (this.free > 0.0 && (n = string2.lastIndexOf(infoFieldSeparator)) >= 0) {
                            object = string2.substring(n);
                            this.memDDList.add(object);
                        }
                        this.addValueToResultSet(string2, scanIndex, this.scan);
                        this.addValueToResultSet(string2, stealIndex, this.steal);
                        if (this.cacheTestResults) {
                            ArrayList<Double> arrayList = new ArrayList<Double>();
                            arrayList.add(new Double(this.cpuUtil));
                            arrayList.add(new Double(this.sysCpu));
                            arrayList.add(new Double(this.run));
                            arrayList.add(new Double(this.block));
                            arrayList.add(new Double(d));
                            arrayList.add(new Double(this.free));
                            arrayList.add(new Double(this.scan));
                            arrayList.add(new Double(this.steal));
                            this.hres.put(string2, arrayList);
                        }
                        this.executeForLocalZone(this.cpuUtil);
                    } else {
                        int n4 = this.zonenames.size();
                        String string7 = null;
                        for (int i = 0; i < n4; ++i) {
                            string7 = (String)this.zonenames.get(i);
                            ArrayList arrayList = (ArrayList)this.zoneValues.get(string7);
                            String string8 = this.index + ":" + string7;
                            ArrayList<Double> arrayList2 = new ArrayList<Double>();
                            for (int j = 0; j < 7; ++j) {
                                Double d3 = (Double)arrayList.get(j);
                                double d4 = d3;
                                this.addValueToResultSet(string8, j, d4);
                                arrayList2.add(new Double(d4));
                            }
                            if (!this.cacheTestResults) continue;
                            this.hres.put(string8, arrayList2);
                        }
                    }
                } else {
                    ArrayList arrayList;
                    String string9;
                    string2 = "iostat -c " + this.period + " " + this.repeat;
                    for (n = 0; n < 3; ++n) {
                        if (this.localZone) {
                            bl = this.executeiostat(string2);
                            if (!bl) continue;
                            break;
                        }
                        this.zoneValues2 = new Hashtable();
                        int n5 = this.zonenames.size();
                        string9 = null;
                        for (int i = 0; i < n5; ++i) {
                            string9 = (String)this.zonenames.get(i);
                            string2 = "zlogin " + string9 + " iostat -c " + this.period + " " + this.repeat;
                            arrayList = this.executeiostatOnZone(string2);
                            this.zoneValues2.put(string9, arrayList);
                            bl = true;
                        }
                        if (bl) break;
                    }
                    if (this.localZone) {
                        int n6;
                        int n7;
                        String string10 = this.index + "Summary";
                        if (this.CPU > 0.0 && (n7 = string10.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string9 = string10.substring(n7);
                            this.cpuDDList.add(string9);
                        }
                        this.addValueToResultSet(string10, cpuUtilIndex, this.CPU);
                        this.addValueToResultSet(string10, sysCpuIndex, this.SYSCPU);
                        this.addValueToResultSet(string10, runIndex, this.run);
                        this.addValueToResultSet(string10, blockIndex, this.block);
                        this.addValueToResultSet(string10, swapIndex, d);
                        this.addValueToResultSet(string10, freeIndex, this.free);
                        if (this.free > 0.0 && (n6 = string10.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string9 = string10.substring(n6);
                            this.memDDList.add(string9);
                        }
                        this.addValueToResultSet(string10, scanIndex, this.scan);
                        this.addValueToResultSet(string10, stealIndex, this.steal);
                        if (this.cacheTestResults) {
                            ArrayList<Double> arrayList3 = new ArrayList<Double>();
                            arrayList3.add(new Double(this.CPU));
                            arrayList3.add(new Double(this.SYSCPU));
                            arrayList3.add(new Double(this.run));
                            arrayList3.add(new Double(this.block));
                            arrayList3.add(new Double(d));
                            arrayList3.add(new Double(this.free));
                            arrayList3.add(new Double(this.scan));
                            arrayList3.add(new Double(this.steal));
                            this.hres.put(string10, arrayList3);
                        }
                        this.executeForLocalZone(this.CPU);
                    } else {
                        n = this.zonenames.size();
                        String string11 = null;
                        for (int i = 0; i < n; ++i) {
                            double d5;
                            Double d6;
                            int n8;
                            string11 = (String)this.zonenames.get(i);
                            String string12 = this.index + ":" + string11;
                            arrayList = (ArrayList)this.zoneValues2.get(string11);
                            ArrayList<Double> arrayList4 = new ArrayList<Double>();
                            for (n8 = 0; n8 < 2; ++n8) {
                                d6 = (Double)arrayList.get(n8);
                                d5 = d6;
                                this.addValueToResultSet(string12, n8, d5);
                                arrayList4.add(new Double(d5));
                            }
                            arrayList = (ArrayList)this.zoneValues.get(string11);
                            for (n8 = 2; n8 < 7; ++n8) {
                                d6 = (Double)arrayList.get(n8);
                                d5 = d6;
                                this.addValueToResultSet(string12, n8, d5);
                                arrayList4.add(new Double(d5));
                            }
                            if (!this.cacheTestResults) continue;
                            this.hres.put(string12, arrayList4);
                        }
                    }
                }
            } else {
                if (this.localZone) {
                    boolean bl2 = this.runMultiProcTest(this.run, this.block, this.swap, this.free, this.scan);
                    if (this.cacheTestResults) {
                        String string13 = dsync;
                        synchronized (string13) {
                            lastResults = this.hres;
                            lastCacheTime = System.currentTimeMillis();
                        }
                    }
                    this.updateAllResultSets();
                    return bl2;
                }
                int n9 = this.zonenames.size();
                String string14 = null;
                for (int i = 0; i < n9; ++i) {
                    string14 = (String)this.zonenames.get(i);
                    ArrayList arrayList = (ArrayList)this.zoneValues.get(string14);
                    Double d7 = (Double)arrayList.get(2);
                    this.run = d7;
                    d7 = (Double)arrayList.get(3);
                    this.block = d7;
                    d7 = (Double)arrayList.get(4);
                    this.swap = d7;
                    d7 = (Double)arrayList.get(5);
                    this.free = this.page <= 0.0 ? d7.doubleValue() : this.findFreeMemory();
                    d7 = (Double)arrayList.get(6);
                    this.scan = d7;
                    this.runMultiProcsTestOnZone(this.run, this.block, this.swap, this.free, this.scan, string14, this.useiostat);
                }
                if (this.cacheTestResults) {
                    String string15 = dsync;
                    synchronized (string15) {
                        lastResults = this.hres;
                        lastCacheTime = System.currentTimeMillis();
                    }
                }
                this.updateAllResultSets();
                return true;
            }
            if (this.cacheTestResults) {
                String string16 = dsync;
                synchronized (string16) {
                    lastResults = this.hres;
                    lastCacheTime = System.currentTimeMillis();
                }
            }
            this.updateAllResultSets();
            return true;
        }
    }

    public boolean runMultiProcsTestOnZone(double d, double d2, double d3, double d4, double d5, String string, boolean bl) {
        String string2;
        String string3;
        Object object;
        int n;
        int n2;
        String string4 = "zlogin " + string + " mpstat " + this.period + "  " + this.repeat;
        String[] stringArray = null;
        this.util = EgUtilities.createInstance();
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        ArrayList arrayList = this.util.getExecOutputLines(string4);
        if (arrayList == null || arrayList.size() < 2) {
            return false;
        }
        arrayList = (ArrayList)arrayList.get(0);
        int n3 = 0;
        String string5 = null;
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        if (arrayList != null) {
            n3 = arrayList.size();
        }
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            string5 = (String)arrayList.get(n2);
            if ((string5 = string5.trim()).startsWith("CPU")) {
                ++n4;
            }
            if (n4 == this.repeat) break;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = n2 + 1; n < n3; ++n) {
            string5 = (String)arrayList.get(n);
            arrayList2.add(string5);
        }
        n = arrayList2.size();
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        String string6 = null;
        StringTokenizer stringTokenizer = null;
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            string6 = (String)arrayList2.get(i);
            stringTokenizer = new StringTokenizer(string6);
            stringArray = new String[stringTokenizer.countTokens()];
            int n7 = stringTokenizer.countTokens();
            object = "";
            block9: for (n2 = 0; n2 < n7; ++n2) {
                stringArray[n2] = stringTokenizer.nextToken();
                switch (n2) {
                    case 0: {
                        object = "cpu" + stringArray[n2];
                        continue block9;
                    }
                    case 12: {
                        d8 = Double.parseDouble(stringArray[n2]);
                        continue block9;
                    }
                    case 13: {
                        d6 = Double.parseDouble(stringArray[n2]);
                        d10 += d6;
                        continue block9;
                    }
                    case 15: {
                        d11 = Double.parseDouble(stringArray[n2]);
                    }
                }
            }
            if (this.isCpuFromIdle) {
                if (d11 > 100.0) {
                    d11 = 100.0;
                }
                d7 = 100.0 - d11;
                d9 += d7;
            } else if (d8 >= 0.0) {
                d7 = d8 + d6;
                d9 += d7;
            } else {
                d7 = -5.0;
            }
            string3 = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string + ":" + (String)object);
            if (bl) continue;
            if (this.summary) {
                this.addValueToResultSet(string3, cpuUtilIndex, d7);
                this.addValueToResultSet(string3, sysCpuIndex, d6);
                this.addValueToResultSet(string3, runIndex, -5.0);
                this.addValueToResultSet(string3, freeIndex, -5.0);
                this.addValueToResultSet(string3, scanIndex, -5.0);
                this.addValueToResultSet(string3, blockIndex, -5.0);
                this.addValueToResultSet(string3, swapIndex, -5.0);
                this.addValueToResultSet(string3, stealIndex, -5.0);
                if (!this.cacheTestResults) continue;
                ArrayList<Double> arrayList4 = new ArrayList<Double>();
                arrayList4.add(new Double(d7));
                arrayList4.add(new Double(d6));
                arrayList4.add(new Double(-5.0));
                arrayList4.add(new Double(-5.0));
                arrayList4.add(new Double(-5.0));
                arrayList4.add(new Double(-5.0));
                arrayList4.add(new Double(-5.0));
                arrayList4.add(new Double(-5.0));
                this.hres.put(string3, arrayList4);
                continue;
            }
            if (d7 > 0.0 && (n6 = string3.lastIndexOf(infoFieldSeparator)) >= 0) {
                string2 = string3.substring(n6);
                this.cpuDDList.add(string2);
            }
            this.addValueToResultSet(string3, cpuUtilIndex, d7);
            this.addValueToResultSet(string3, sysCpuIndex, d6);
            this.addValueToResultSet(string3, runIndex, d);
            this.addValueToResultSet(string3, freeIndex, d4);
            if (d4 > 0.0 && (n5 = string3.lastIndexOf(infoFieldSeparator)) >= 0) {
                string2 = string3.substring(n5);
                this.memDDList.add(string2);
            }
            this.addValueToResultSet(string3, scanIndex, d5);
            this.addValueToResultSet(string3, blockIndex, d2);
            this.addValueToResultSet(string3, swapIndex, d3);
            this.addValueToResultSet(string3, stealIndex, this.steal);
            if (!this.cacheTestResults) continue;
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            arrayList5.add(new Double(d7));
            arrayList5.add(new Double(d6));
            arrayList5.add(new Double(d));
            arrayList5.add(new Double(d2));
            arrayList5.add(new Double(d3));
            arrayList5.add(new Double(d4));
            arrayList5.add(new Double(d5));
            arrayList5.add(new Double(this.steal));
            this.hres.put(string3, arrayList5);
        }
        if (this.summary && n > 0 && !bl) {
            int n8;
            int n9;
            Object var37_27 = null;
            d9 /= (double)n;
            d10 /= (double)n;
            String string7 = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string + ":Summary");
            if (d9 > 0.0 && (n9 = string7.lastIndexOf(infoFieldSeparator)) >= 0) {
                string3 = string7.substring(n9);
                this.cpuDDList.add(string3);
            }
            this.addValueToResultSet(string7, cpuUtilIndex, d9);
            this.addValueToResultSet(string7, sysCpuIndex, d10);
            this.addValueToResultSet(string7, runIndex, d);
            this.addValueToResultSet(string7, blockIndex, d2);
            this.addValueToResultSet(string7, swapIndex, d3);
            this.addValueToResultSet(string7, freeIndex, d4);
            if (d4 > 0.0 && (n8 = string7.lastIndexOf(infoFieldSeparator)) >= 0) {
                string3 = string7.substring(n8);
                this.memDDList.add(string3);
            }
            this.addValueToResultSet(string7, scanIndex, d5);
            this.addValueToResultSet(string7, stealIndex, this.steal);
            if (this.cacheTestResults) {
                ArrayList<Double> arrayList6 = new ArrayList<Double>();
                arrayList6.add(new Double(d9));
                arrayList6.add(new Double(d10));
                arrayList6.add(new Double(d));
                arrayList6.add(new Double(d2));
                arrayList6.add(new Double(d3));
                arrayList6.add(new Double(d4));
                arrayList6.add(new Double(d5));
                arrayList6.add(new Double(this.steal));
                this.hres.put(string7, arrayList6);
            }
        } else if (bl) {
            int n10;
            int n11;
            String string8 = "zlogin " + string + " iostat -c " + this.period + " " + this.repeat;
            ArrayList arrayList7 = this.executeiostatOnZone(string8);
            object = (Double)arrayList7.get(0);
            this.ZCPU = (Double)object;
            object = (Double)arrayList7.get(1);
            this.ZSYSCPU = (Double)object;
            string3 = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string + ":Summary");
            this.addValueToResultSet(string3, cpuUtilIndex, this.CPU);
            if (this.CPU > 0.0 && (n11 = string3.lastIndexOf(infoFieldSeparator)) >= 0) {
                string2 = string3.substring(n11);
                this.cpuDDList.add(string2);
            }
            this.addValueToResultSet(string3, sysCpuIndex, this.SYSCPU);
            this.addValueToResultSet(string3, runIndex, d);
            this.addValueToResultSet(string3, blockIndex, d2);
            this.addValueToResultSet(string3, swapIndex, d3);
            this.addValueToResultSet(string3, freeIndex, d4);
            if (d4 > 0.0 && (n10 = string3.lastIndexOf(infoFieldSeparator)) >= 0) {
                string2 = string3.substring(n10);
                this.memDDList.add(string2);
            }
            this.addValueToResultSet(string3, scanIndex, d5);
            this.addValueToResultSet(string3, stealIndex, this.steal);
            if (this.cacheTestResults) {
                ArrayList<Double> arrayList8 = new ArrayList<Double>();
                arrayList8.add(new Double(this.CPU));
                arrayList8.add(new Double(this.SYSCPU));
                arrayList8.add(new Double(d));
                arrayList8.add(new Double(d2));
                arrayList8.add(new Double(d3));
                arrayList8.add(new Double(d4));
                arrayList8.add(new Double(d5));
                arrayList8.add(new Double(this.steal));
                this.hres.put(string3, arrayList8);
            }
        }
        return true;
    }

    private ArrayList setDefaultValues(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }

    private boolean runMultiProcTest(double d, double d2, double d3, double d4, double d5) {
        try {
            ArrayList arrayList = new ArrayList();
            String string = new String("mpstat " + this.period + " " + this.repeat);
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    String string2;
                    int n;
                    int n2;
                    String string3;
                    int n3 = 0;
                    int n4 = 0;
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        n4 = i + 1;
                        string3 = (String)arrayList3.get(i);
                        if ((string3 = string3.trim()).startsWith("CPU")) {
                            ++n3;
                        }
                        if (n3 == this.repeat) break;
                    }
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    for (int i = n4; i < arrayList3.size(); ++i) {
                        string3 = (String)arrayList3.get(i);
                        arrayList4.add(string3);
                    }
                    double d6 = 0.0;
                    double d7 = 0.0;
                    for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                        int n5;
                        String string4;
                        int n6;
                        String string5 = (String)arrayList4.get(n2);
                        StringTokenizer stringTokenizer = new StringTokenizer(string5);
                        String[] stringArray = new String[stringTokenizer.countTokens()];
                        n = stringTokenizer.countTokens();
                        string2 = "";
                        double d8 = -5.0;
                        double d9 = -5.0;
                        double d10 = -5.0;
                        double d11 = -5.0;
                        block11: for (int i = 0; i < n; ++i) {
                            stringArray[i] = stringTokenizer.nextToken();
                            switch (i) {
                                case 0: {
                                    string2 = "cpu" + stringArray[i];
                                    continue block11;
                                }
                                case 12: {
                                    d10 = Double.parseDouble(stringArray[i]);
                                    continue block11;
                                }
                                case 13: {
                                    d8 = Double.parseDouble(stringArray[i]);
                                    d7 += d8;
                                    continue block11;
                                }
                                case 15: {
                                    d11 = Double.parseDouble(stringArray[i]);
                                }
                            }
                        }
                        if (this.isCpuFromIdle) {
                            if (d11 > 100.0) {
                                d11 = 100.0;
                            }
                            d9 = 100.0 - d11;
                            d6 += d9;
                        } else if (d10 >= 0.0) {
                            d9 = d10 + d8;
                            d6 += d9;
                        } else {
                            d9 = -5.0;
                        }
                        String string6 = "";
                        string6 = !this.is_non_global_zone ? new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string2) : new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "kernel:" + string2);
                        if (this.useiostat) continue;
                        if (this.summary) {
                            this.addValueToResultSet(string6, cpuUtilIndex, d9);
                            this.addValueToResultSet(string6, sysCpuIndex, d8);
                            this.addValueToResultSet(string6, runIndex, -5.0);
                            this.addValueToResultSet(string6, blockIndex, -5.0);
                            this.addValueToResultSet(string6, swapIndex, -5.0);
                            this.addValueToResultSet(string6, freeIndex, -5.0);
                            this.addValueToResultSet(string6, scanIndex, -5.0);
                            this.addValueToResultSet(string6, stealIndex, -5.0);
                            if (!this.cacheTestResults) continue;
                            ArrayList<Double> arrayList5 = new ArrayList<Double>();
                            arrayList5.add(new Double(d9));
                            arrayList5.add(new Double(d8));
                            arrayList5.add(new Double(-5.0));
                            arrayList5.add(new Double(-5.0));
                            arrayList5.add(new Double(-5.0));
                            arrayList5.add(new Double(-5.0));
                            arrayList5.add(new Double(-5.0));
                            arrayList5.add(new Double(-5.0));
                            this.hres.put(string6, arrayList5);
                            continue;
                        }
                        if (d9 > 0.0 && (n6 = string6.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string4 = string6.substring(n6);
                            this.cpuDDList.add(string4);
                        }
                        this.addValueToResultSet(string6, cpuUtilIndex, d9);
                        this.addValueToResultSet(string6, sysCpuIndex, d8);
                        this.addValueToResultSet(string6, runIndex, d);
                        this.addValueToResultSet(string6, blockIndex, d2);
                        this.addValueToResultSet(string6, swapIndex, d3);
                        if (d4 > 0.0 && (n5 = string6.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string4 = string6.substring(n5);
                            this.memDDList.add(string4);
                        }
                        this.addValueToResultSet(string6, freeIndex, d4);
                        this.addValueToResultSet(string6, scanIndex, d5);
                        this.addValueToResultSet(string6, stealIndex, this.steal);
                        if (!this.cacheTestResults) continue;
                        ArrayList<Double> arrayList6 = new ArrayList<Double>();
                        arrayList6.add(new Double(d9));
                        arrayList6.add(new Double(d8));
                        arrayList6.add(new Double(d));
                        arrayList6.add(new Double(d2));
                        arrayList6.add(new Double(d3));
                        arrayList6.add(new Double(d4));
                        arrayList6.add(new Double(d5));
                        arrayList6.add(new Double(this.steal));
                        this.hres.put(string6, arrayList6);
                    }
                    if (this.summary && arrayList4.size() > 0 && !this.useiostat) {
                        d7 /= (double)arrayList4.size();
                        String string7 = this.sindex;
                        this.addValueToResultSet(string7, cpuUtilIndex, d6 /= (double)arrayList4.size());
                        if (d6 > 0.0 && (n = string7.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string2 = string7.substring(n);
                            this.cpuDDList.add(string2);
                        }
                        this.addValueToResultSet(string7, sysCpuIndex, d7);
                        this.addValueToResultSet(string7, runIndex, d);
                        this.addValueToResultSet(string7, blockIndex, d2);
                        this.addValueToResultSet(string7, swapIndex, d3);
                        this.addValueToResultSet(string7, freeIndex, d4);
                        if (d4 > 0.0 && (n = string7.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string2 = string7.substring(n);
                            this.memDDList.add(string2);
                        }
                        this.addValueToResultSet(string7, scanIndex, d5);
                        this.addValueToResultSet(string7, stealIndex, this.steal);
                        if (this.cacheTestResults) {
                            ArrayList<Double> arrayList7 = new ArrayList<Double>();
                            arrayList7.add(new Double(d6));
                            arrayList7.add(new Double(d7));
                            arrayList7.add(new Double(d));
                            arrayList7.add(new Double(d2));
                            arrayList7.add(new Double(d3));
                            arrayList7.add(new Double(d4));
                            arrayList7.add(new Double(d5));
                            arrayList7.add(new Double(this.steal));
                            this.hres.put(string7, arrayList7);
                        }
                        this.executeForLocalZone(d6);
                    } else if (this.useiostat) {
                        int n7;
                        String string8;
                        int n8;
                        n2 = 1;
                        String string9 = "iostat -c " + this.period + " " + this.repeat;
                        for (int i = 0; i < 3 && (n2 = (int)(this.executeiostat(string9) ? 1 : 0)) == 0; ++i) {
                        }
                        String string10 = this.sindex;
                        if (this.CPU > 0.0 && (n8 = string10.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string8 = string10.substring(n8);
                            this.cpuDDList.add(string8);
                        }
                        this.addValueToResultSet(string10, cpuUtilIndex, this.CPU);
                        this.addValueToResultSet(string10, sysCpuIndex, this.SYSCPU);
                        this.addValueToResultSet(string10, runIndex, d);
                        this.addValueToResultSet(string10, blockIndex, d2);
                        this.addValueToResultSet(string10, swapIndex, d3);
                        this.addValueToResultSet(string10, freeIndex, d4);
                        if (d4 > 0.0 && (n7 = string10.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string8 = string10.substring(n7);
                            this.memDDList.add(string8);
                        }
                        this.addValueToResultSet(string10, scanIndex, d5);
                        this.addValueToResultSet(string10, stealIndex, this.steal);
                        if (this.cacheTestResults) {
                            ArrayList<Double> arrayList8 = new ArrayList<Double>();
                            arrayList8.add(new Double(this.CPU));
                            arrayList8.add(new Double(this.SYSCPU));
                            arrayList8.add(new Double(d));
                            arrayList8.add(new Double(d2));
                            arrayList8.add(new Double(d3));
                            arrayList8.add(new Double(d4));
                            arrayList8.add(new Double(d5));
                            arrayList8.add(new Double(this.steal));
                            this.hres.put(string10, arrayList8);
                        }
                        this.executeForLocalZone(this.CPU);
                    } else {
                        this.executeForLocalZone();
                    }
                    return true;
                }
                this.errorMsg = new String("Failed to run mpstat");
                return false;
            }
            this.errorMsg = new String("Failed to run mpstat");
            return false;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception in SystemTest - with mpstat");
            return false;
        }
    }
}

