/*
 * Decompiled with CFR 0.152.
 */
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

class VCHelper {
    private VimPortType _service;
    private ServiceContent _sic;
    private ManagedObjectReference _svcRef;
    private String myVersion = "";
    public float vcVersion = -5.0f;
    Vm25Connection vc = null;
    String reportingName = "";

    protected void finalize() throws Throwable {
        try {
            this.vc = null;
            this._sic = null;
            this._service = null;
            this._svcRef = null;
        }
        finally {
            super.finalize();
        }
    }

    public void lock(String string) {
        this.vc.lock(string);
    }

    public void unlock(String string) {
        this.vc.unlock(string);
    }

    public VCHelper(Vm25Connection vm25Connection) {
        String string;
        if (vm25Connection == null) {
            this._svcRef = null;
            this._sic = null;
            this._service = null;
        }
        this.vc = vm25Connection;
        this._svcRef = vm25Connection._svcRef;
        this._sic = vm25Connection._sic;
        this._service = vm25Connection._service;
        this.myVersion = string = this.getVersion(true);
        if (string != null && string.length() > 0) {
            string = string.substring(0, 3);
            try {
                string = string.trim();
                this.vcVersion = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public VimPortType getService() {
        return this._service;
    }

    public ServiceContent getServiceContent() {
        return this._sic;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this._svcRef;
    }

    public long getCurrentVCTime() {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = null;
            this.lock(this.reportingName + " : VCHelper ");
            try {
                xMLGregorianCalendar = this._service.currentTime(this._svcRef);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unlock(this.reportingName + " : VCHelper ");
            if (xMLGregorianCalendar != null) {
                GregorianCalendar gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar();
                if (gregorianCalendar != null) {
                    return gregorianCalendar.getTimeInMillis();
                }
                return -1L;
            }
            return -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public XMLGregorianCalendar getCurrentVCTime(boolean bl) {
        this.lock(this.reportingName + " : VCHelper ");
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = this._service.currentTime(this._svcRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unlock(this.reportingName + " : VCHelper ");
        return xMLGregorianCalendar;
    }

    public Object getDynamicProperty(ManagedObjectReference managedObjectReference, String string) {
        try {
            Object object;
            List list;
            ObjectContent[] objectContentArray = null;
            if (managedObjectReference != null && string != null) {
                objectContentArray = this.getObjectContentForSpecifiedMorefs(managedObjectReference.getType(), new ManagedObjectReference[]{managedObjectReference}, new String[]{string});
            }
            Object object2 = null;
            if (objectContentArray != null && (list = objectContentArray[0].getPropSet()) != null && list.size() > 0 && (object = ((DynamicProperty)list.get(0)).getVal()) != null) {
                String string2 = object.getClass().getName();
                if (string2.indexOf("ArrayOf") != -1) {
                    String string3 = string2.substring(string2.indexOf("ArrayOf") + "ArrayOf".length(), string2.length());
                    string3 = this.methodExists(object, "get" + string3, null) ? "get" + string3 : "get_" + string3.toLowerCase();
                    Method method = object.getClass().getDeclaredMethod(string3, null);
                    if (method != null) {
                        object2 = method.invoke(object, (Object[])null);
                    }
                } else {
                    object2 = object.getClass().isArray() ? object : object;
                }
            }
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    boolean methodExists(Object object, String string, Class[] classArray) {
        boolean bl = false;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            if (method != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public Hashtable getObjectContentForAlarm(String string, String[] stringArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            ObjectContent[] objectContentArray;
            block20: {
                if (this._sic == null || string == null || stringArray == null) {
                    return null;
                }
                ManagedObjectReference managedObjectReference = this._sic.getRootFolder();
                ManagedObjectReference managedObjectReference2 = this._sic.getPropertyCollector();
                String string2 = managedObjectReference.getValue();
                System.out.println(" [VCHelper] |getObjectContentForAlarm| rootFolderRef=>" + string2);
                hashtable.put("rootFolderRef", string2);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                Object var8_9 = null;
                SelectionSpec selectionSpec = new SelectionSpec();
                selectionSpec.setName("folderToFolder");
                TraversalSpec traversalSpec = new TraversalSpec();
                traversalSpec.setName("folderToFolder");
                traversalSpec.setPath("childEntity");
                traversalSpec.setType("Folder");
                traversalSpec.getSelectSet().addAll(Arrays.asList(selectionSpec));
                traversalSpec.setSkip(Boolean.valueOf(false));
                ObjectSpec objectSpec = new ObjectSpec();
                objectSpec.setObj(managedObjectReference);
                objectSpec.setSkip(Boolean.TRUE);
                objectSpec.getSelectSet().add(traversalSpec);
                objectSpec.setSkip(Boolean.valueOf(false));
                PropertySpec propertySpec = new PropertySpec();
                propertySpec.setType(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    propertySpec.getPathSet().add(stringArray[i]);
                }
                PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
                propertyFilterSpec.getObjectSet().add(objectSpec);
                propertyFilterSpec.getPropSet().add(propertySpec);
                ArrayList<PropertyFilterSpec> arrayList2 = new ArrayList<PropertyFilterSpec>();
                arrayList2.add(propertyFilterSpec);
                objectContentArray = null;
                if (this.vcVersion <= 4.0f) {
                    if (this._service != null) {
                        try {
                            List list = null;
                            try {
                                list = this._service.retrieveProperties(managedObjectReference2, arrayList2);
                                System.out.println(" [VCHelper]  |getObjectContentForAlarm|  tempList=>" + list + " count=>" + list.size());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (list == null || list.size() <= 0) break block20;
                            try {
                                objectContentArray = list.toArray(new ObjectContent[list.size()]);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    RetrieveOptions retrieveOptions = new RetrieveOptions();
                    RetrieveResult retrieveResult = null;
                    try {
                        if (this._service != null && managedObjectReference2 != null) {
                            retrieveResult = this._service.retrievePropertiesEx(managedObjectReference2, arrayList2, retrieveOptions);
                        }
                        System.out.println(" [VCHelper]  |getObjectContentForAlarm|  props=> " + retrieveResult);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ArrayList arrayList3 = new ArrayList();
                    if (retrieveResult != null) {
                        arrayList3 = this.getResultFromRetrieveResult(arrayList3, retrieveResult, managedObjectReference2);
                    }
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        try {
                            objectContentArray = arrayList3.toArray(new ObjectContent[arrayList3.size()]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            System.out.println(" [VCHelper]  |getObjectContentForAlarm|  oc=> " + objectContentArray);
            hashtable.put("oc", objectContentArray);
            return hashtable;
        }
        catch (Exception exception) {
            System.out.println(" [VCHelper]  |getObjectContentForAlarm|  exception occured in getObjectContent method for " + string);
            exception.printStackTrace();
            return null;
        }
    }

    public ObjectContent[] getObjectContent(String string, String[] stringArray) {
        try {
            ObjectContent[] objectContentArray;
            ManagedObjectReference managedObjectReference;
            block25: {
                if (this._sic == null || string == null || stringArray == null || this._sic == null) {
                    return null;
                }
                ManagedObjectReference managedObjectReference2 = this._sic.getViewManager();
                ManagedObjectReference managedObjectReference3 = this._sic.getRootFolder();
                ManagedObjectReference managedObjectReference4 = this._sic.getPropertyCollector();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                managedObjectReference = null;
                this.lock(this.reportingName + " : VCHelper ");
                try {
                    managedObjectReference = this._service.createContainerView(managedObjectReference2, managedObjectReference3, arrayList, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.unlock(this.reportingName + " : VCHelper ");
                ObjectSpec objectSpec = new ObjectSpec();
                objectSpec.setObj(managedObjectReference);
                objectSpec.setSkip(Boolean.TRUE);
                TraversalSpec traversalSpec = new TraversalSpec();
                traversalSpec.setName("traverseEntities");
                traversalSpec.setPath("view");
                traversalSpec.setSkip(Boolean.FALSE);
                traversalSpec.setType("ContainerView");
                objectSpec.getSelectSet().add(traversalSpec);
                PropertySpec propertySpec = new PropertySpec();
                propertySpec.setType(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    propertySpec.getPathSet().add(stringArray[i]);
                }
                PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
                propertyFilterSpec.getObjectSet().add(objectSpec);
                propertyFilterSpec.getPropSet().add(propertySpec);
                ArrayList<PropertyFilterSpec> arrayList2 = new ArrayList<PropertyFilterSpec>();
                arrayList2.add(propertyFilterSpec);
                objectContentArray = null;
                if (this.vcVersion <= 4.0f) {
                    if (this._service != null) {
                        try {
                            List list = null;
                            this.lock(this.reportingName + " : VCHelper ");
                            try {
                                list = this._service.retrieveProperties(managedObjectReference4, arrayList2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.unlock(this.reportingName + " : VCHelper ");
                            if (list == null || list.size() <= 0) break block25;
                            try {
                                objectContentArray = list.toArray(new ObjectContent[list.size()]);
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    RetrieveOptions retrieveOptions = new RetrieveOptions();
                    RetrieveResult retrieveResult = null;
                    this.lock(this.reportingName + " : VCHelper ");
                    try {
                        if (this._service != null && managedObjectReference4 != null) {
                            retrieveResult = this._service.retrievePropertiesEx(managedObjectReference4, arrayList2, retrieveOptions);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.unlock(this.reportingName + " : VCHelper ");
                    ArrayList arrayList3 = new ArrayList();
                    if (retrieveResult != null) {
                        arrayList3 = this.getResultFromRetrieveResult(arrayList3, retrieveResult, managedObjectReference4);
                    }
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        try {
                            objectContentArray = arrayList3.toArray(new ObjectContent[arrayList3.size()]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.lock(this.reportingName + " : VCHelper ");
            try {
                if (this._service != null && managedObjectReference != null) {
                    this._service.destroyView(managedObjectReference);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unlock(this.reportingName + " : VCHelper ");
            return objectContentArray;
        }
        catch (Exception exception) {
            System.out.println(" [VCHelper] exception occured in getObjectContent method for " + string);
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getResultFromRetrieveResult(ArrayList arrayList, RetrieveResult retrieveResult, ManagedObjectReference managedObjectReference) {
        try {
            if (retrieveResult != null) {
                String string;
                List list = retrieveResult.getObjects();
                if (list != null) {
                    arrayList.addAll(list);
                }
                if ((string = retrieveResult.getToken()) != null && managedObjectReference != null && this._service != null) {
                    RetrieveResult retrieveResult2 = null;
                    this.lock(this.reportingName + " : VCHelper ");
                    try {
                        retrieveResult2 = this._service.continueRetrievePropertiesEx(managedObjectReference, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.unlock(this.reportingName + " : VCHelper ");
                    this.getResultFromRetrieveResult(arrayList, retrieveResult2, managedObjectReference);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println(" [VCHelper] exception occured in getResultFromRetrieveResult method ");
            exception.printStackTrace();
            return null;
        }
    }

    public ObjectContent[] getObjectContentForSpecifiedMorefs(String string, ManagedObjectReference[] managedObjectReferenceArray, String[] stringArray) {
        try {
            if (this._sic == null || managedObjectReferenceArray == null || managedObjectReferenceArray.length == 0 || stringArray == null || stringArray.length == 0 || this._sic == null) {
                return null;
            }
            List<ManagedObjectReference> list = Arrays.asList(managedObjectReferenceArray);
            ManagedObjectReference managedObjectReference = this._sic.getViewManager();
            ManagedObjectReference managedObjectReference2 = this._sic.getPropertyCollector();
            ManagedObjectReference managedObjectReference3 = null;
            this.lock(this.reportingName + " : VCHelper ");
            try {
                managedObjectReference3 = this._service.createListView(managedObjectReference, list);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unlock(this.reportingName + " : VCHelper ");
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObj(managedObjectReference3);
            objectSpec.setSkip(Boolean.TRUE);
            TraversalSpec traversalSpec = new TraversalSpec();
            traversalSpec.setName("traverseEntities");
            traversalSpec.setPath("view");
            traversalSpec.setSkip(Boolean.FALSE);
            traversalSpec.setType("ListView");
            objectSpec.getSelectSet().add(traversalSpec);
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.setType(string);
            for (int i = 0; i < stringArray.length; ++i) {
                propertySpec.getPathSet().add(stringArray[i]);
            }
            PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
            propertyFilterSpec.getObjectSet().add(objectSpec);
            propertyFilterSpec.getPropSet().add(propertySpec);
            ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
            arrayList.add(propertyFilterSpec);
            ObjectContent[] objectContentArray = null;
            if (this.vcVersion <= 4.0f) {
                if (this._service != null) {
                    try {
                        List list2 = null;
                        this.lock(this.reportingName + " : VCHelper ");
                        try {
                            this._service.retrieveProperties(managedObjectReference2, arrayList);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.unlock(this.reportingName + " : VCHelper ");
                        if (list2 != null) {
                            objectContentArray = list2.toArray(new ObjectContent[list2.size()]);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                RetrieveOptions retrieveOptions = new RetrieveOptions();
                RetrieveResult retrieveResult = null;
                this.lock(this.reportingName + " : VCHelper ");
                try {
                    if (this._service != null && managedObjectReference2 != null) {
                        retrieveResult = this._service.retrievePropertiesEx(managedObjectReference2, arrayList, retrieveOptions);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.unlock(this.reportingName + " : VCHelper ");
                ArrayList arrayList2 = new ArrayList();
                if (retrieveResult != null) {
                    arrayList2 = this.getResultFromRetrieveResult(arrayList2, retrieveResult, managedObjectReference2);
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    try {
                        objectContentArray = arrayList2.toArray(new ObjectContent[arrayList2.size()]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.lock(this.reportingName + " : VCHelper ");
            try {
                if (this._service != null && managedObjectReference3 != null) {
                    this._service.destroyView(managedObjectReference3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unlock(this.reportingName + " : VCHelper ");
            return objectContentArray;
        }
        catch (Exception exception) {
            System.out.println(" [VCHelper] exception occured in getObjectContentForSpecifiedMorefs method");
            exception.printStackTrace();
            return null;
        }
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getVersion(boolean bl) {
        try {
            AboutInfo aboutInfo = null;
            if (this.getServiceContent() != null) {
                aboutInfo = this.getServiceContent().getAbout();
            }
            String string = "";
            if (aboutInfo != null) {
                string = aboutInfo.getVersion();
            }
            return string;
        }
        catch (Exception exception) {
            System.out.println("Exception occured  in while collecting version informations");
            exception.printStackTrace();
            return null;
        }
    }

    public Hashtable getObjectContentProperty(ObjectContent[] objectContentArray) {
        if (objectContentArray == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        List list = null;
        ManagedObjectReference managedObjectReference = null;
        for (int i = 0; i < objectContentArray.length; ++i) {
            list = objectContentArray[i].getPropSet();
            managedObjectReference = objectContentArray[i].getObj();
            int n = list.size();
            Object var7_7 = null;
            ArrayList arrayList = new ArrayList();
            Hashtable hashtable2 = new Hashtable();
            for (int j = 0; j < n; ++j) {
                Object object;
                String string = ((DynamicProperty)list.get(j)).getName();
                ArrayList<Object> arrayList2 = (ArrayList<Object>)hashtable2.get(string);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>();
                }
                if ((object = ((DynamicProperty)list.get(j)).getVal()) == null) continue;
                arrayList2.add(object);
                hashtable2.put(string, arrayList2);
            }
            hashtable.put(managedObjectReference, hashtable2);
        }
        return hashtable;
    }
}

