/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.action;

import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.spi.ActionException;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.spi.ContextAware;
import com.eg.ch.qos.logback.core.spi.LifeCycle;
import com.eg.ch.qos.logback.core.status.StatusListener;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class StatusListenerAction
extends Action {
    boolean inError = false;
    Boolean effectivelyAdded = null;
    StatusListener statusListener = null;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.inError = false;
        this.effectivelyAdded = null;
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty(string2)) {
            this.addError("Missing class name for statusListener. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        try {
            this.statusListener = (StatusListener)OptionHelper.instantiateByClassName(string2, StatusListener.class, this.context);
            this.effectivelyAdded = interpretationContext.getContext().getStatusManager().add(this.statusListener);
            if (this.statusListener instanceof ContextAware) {
                ((ContextAware)((Object)this.statusListener)).setContext(this.context);
            }
            this.addInfo("Added status listener of type [" + string2 + "]");
            interpretationContext.pushObject(this.statusListener);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an StatusListener of type [" + string2 + "].", exception);
            throw new ActionException(exception);
        }
    }

    public void finish(InterpretationContext interpretationContext) {
    }

    public void end(InterpretationContext interpretationContext, String string) {
        Object object;
        if (this.inError) {
            return;
        }
        if (this.isEffectivelyAdded() && this.statusListener instanceof LifeCycle) {
            ((LifeCycle)((Object)this.statusListener)).start();
        }
        if ((object = interpretationContext.peekObject()) != this.statusListener) {
            this.addWarn("The object at the of the stack is not the statusListener pushed earlier.");
        } else {
            interpretationContext.popObject();
        }
    }

    private boolean isEffectivelyAdded() {
        if (this.effectivelyAdded == null) {
            return false;
        }
        return this.effectivelyAdded;
    }
}

