﻿Set-Variable -Name 'scriptPath' -Value (Split-Path -parent $MyInvocation.MyCommand.Definition) -Scope Script -Force

Function Eg-InvokeGraphUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$appId,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$appSecret,
        [Parameter(Mandatory=$true, Position=5)]
        [String]$authString,
        [Parameter(Mandatory=$true, Position=6)]
        [String]$resource
    )

    Process
    {
        $egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
		$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
		$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
		$queryRes = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url 
        $queryRes=$queryRes.Replace('ï»¿','')
        $queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Encoding $encTyp -Append -NoTypeInformation -Force
        }
    }
}

Function Eg-WriteLog{
	Param (
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName,
    [String]$TestFreq,
    [boolean]$isWriteLog
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    if ($isWriteLog -eq $true){
        ( "[" + $date + "] - [" + $ReportingName+"] mTime -  " + $TestFreq + " - " + $writString ) | Out-File -FilePath $LogPath -Append
        if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
            if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
                Remove-Item $LogPath1 
            } 
            Rename-Item $LogPath $LogPath1 
        }
    }
}

Function Eg-WriteFile(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$ComntRptPath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$FileName,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$keyFileName,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$EgPath
    )

    Process
    {
        $dir=$EgPath+'/agent/'+$ComntRptPath
        if(!(Test-Path -Path $dir )){
            $null=New-Item -ItemType directory -Path $dir
        }

        #clear dat and key files - start
        $clrPath=$dir+'/'
        $q=0;$tmpVal1='';$tmpVal2='';$tmpVal3='';$r=0;$tmpcsv1='';$tmpcsv2='';$tmpcsv3='';
        Get-ChildItem -Path $clrPath |Where-Object {$_.Name -like $FileName+'*'}| Sort-Object LastWriteTime -Descending |Select Name |ForEach-Object{
            if($_.Name -like $FileName+'*.dat' -and $q -lt 3){
                if($q -eq 0){$tmpVal1=$_.Name;}
                if($q -eq 1){$tmpVal2=$_.Name;}
                if($q -eq 2){$tmpVal3=$_.Name;}
                $q++
            }
            if($_.Name -like $FileName+'*.csv' -and $r -lt 3){
                if($r -eq 0){$tmpcsv1=$_.Name;}
                if($r -eq 1){$tmpcsv2=$_.Name;}
                if($r -eq 2){$tmpcsv3=$_.Name;}
                $r++
            }
            if($q -gt 3 -and $r -gt 3){
                break;
            }
        }
        Get-ChildItem -Path $clrPath |Where-Object {$_.Name -like $keyFileName+'*.dat' -or $_.Name -like $FileName+'*.dat' -or $_.Name -like $FileName+'*.csv'}| Sort-Object LastWriteTime -Descending |Select Name |ForEach-Object{
            if(!($tmpVal1 -eq $_.Name -or 'k'+$tmpVal1 -eq $_.Name -or $tmpVal2 -eq $_.Name -or 'k'+$tmpVal2 -eq $_.Name -or $tmpVal3 -eq $_.Name -or 'k'+$tmpVal3 -eq $_.Name -or $tmpcsv1 -eq $_.Name -or $tmpcsv2 -eq $_.Name -or $tmpcsv3 -eq $_.Name)){
                $rmvPath=$clrPath+$_.Name
                if([System.IO.File]::Exists($rmvPath)){
                    Remove-Item -Path $rmvPath
                }
            }
        }
        #clear dat and key files - end

        $timenow = [int][double]::Parse((Get-Date -UFormat %s))
        $writFilePath = $dir + "\"+$FileName+ $timenow +".csv"
        $keyName="\"+$keyFileName + $timenow + ".dat"
        $key=Get-CryptoKey -FileDir $dir -FileName $keyName
        $writeArr=@{}
        $writeArr[0]=$key  #key
        $writeArr[1]=$writFilePath #full path 
	    $writeArr[2]=$FileName+ $timenow +".csv" # file name 
        return $writeArr
    }
}

Function Eg-ReadFile(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$ComntRptPath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$FileName,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$keyFileName,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$EgPath
    )

    Process
    {
        $readFilePath=$EgPath+'/agent/'+$ComntRptPath+'/'
	    if ( Test-Path $readFilePath -PathType Container ) {
            $fileRead=Get-ChildItem -Path $readFilePath |Where-Object {$_.Name -like $FileName+'*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
            if($fileRead -ne $null -and $fileRead -ne ''){
                $removFNam=$fileRead.name.toString().Replace($FileName,"")
                $tmpvalue=$removFNam.substring(0,$removFNam.length-4)
	            $kfileval = $keyFileName+$tmpvalue+".dat" 
                $currDat = [int][double]::Parse((Get-Date -UFormat %s))           
                $diffTicks=$currDat-[int]$tmpvalue
                if($diffTicks -gt 259200){
                    $logfilePath=$readFilePath+'egReadfile.log'
                    Eg-WriteLog -writString 'Latest dat files not found' -LogPath $logfilePath -ReportingName $ComntRptPath -isWriteLog $true
                    return $null
                }
            }else{
                return $null
            }
	        $kfile=Get-ChildItem -Path $readFilePath |Where-Object {$_.Name -eq $kfileval}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
	        $kfilename=([String]$kfile.Name).Trim()
        
	        $kvalue=Get-Content -Path $readFilePath$kfilename

	        $filePath=$readFilePath+$fileRead.Name
	        $unProtctPath=$filePath -replace (".csv",".dat")
            $readArr=@{}
            $readArr[0]=$kvalue  #Key
            $readArr[1]=$unProtctPath #Full Path
            $readArr[2]=$readFilePath # relative path
            $readArr[3]=$fileRead.name.toString() # file name 
            $readArr[4]=$kfileval #key file name
	    }
	    else{
		    New-Item -ItemType directory -Path $readFilePath
		    $readArr=@{}
	    }
        return $readArr
    }
}

Function Eg-DeleteFiles(){
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FilePath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Pattern,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$InputFile  
    )
    Process
    {
        $indx=1
          $fileRead=Get-ChildItem -Path $FilePath |Where-Object {$_.Name -like $Pattern+'*.dat' -and $_.Name  -lt $InputFile }| Sort-Object LastWriteTime -Descending | Select Name 
            foreach($file in $fileRead)
            {
                 if($indx -gt 2){
                    $fileName=([String]$file.Name).Trim()
                    $tempPath=$FilePath+$fileName
                    if([System.IO.File]::Exists($tempPath)){
                        Remove-Item $tempPath -Force
                    }
                 }
               $indx++ 
        }
    }
}

Function Eg-DeleteCsvFiles(){
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FilePath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Pattern
    )
    Process
    {
          $fileRead=Get-ChildItem -Path $FilePath |Where-Object {$_.Name -like $Pattern+'*.csv' }| Sort-Object LastWriteTime -Descending | Select Name 
            foreach($file in $fileRead)
            {
                    $fileName=([String]$file.Name).Trim()
                    $tempPath=$FilePath+$fileName
                    if([System.IO.File]::Exists($tempPath)){
                        Remove-Item $tempPath -Force
                    }
        }
    }
}


Function Eg-GetCont(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Nickname,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$TstName
    )

    Process
    {
        $tstInputs=@($Nickname,$TstName)
	    $egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        if($tstInputs.Length -eq 2){   
            $arg1='-jar '+$egurkhaPath+'\lib\GetCont.jar'
            $val=$egurkhaPath+'\lib\'+$tstInputs[0]+$tstInputs[1]+'_GetCont.log'
            $strVal=$arg1+' '+$tstInputs
            $fpath=$egurkhaPath+'\JRE\bin\java.exe'
            $null=Start-Process -FilePath $fpath -ArgumentList $strVal -WindowStyle Hidden -RedirectStandardOutput $val -Wait -PassThru
            
        }
        return $val
    }
}


Function Eg-GetAzureEnv(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$UserName,
        [String]$subject
    )
    Process
    {
        if($subject -eq '' -or $subject -eq $null){
            $subject='O365_AzureEnvironment'
        }
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $usrDns=$UserName.Substring($UserName.LastIndexOf('.')+1)

        $azureEnv=''
        $tstIniPath=$egurkhaPath+'\agent\config\eg_tests.ini'
        $getAzureEnv=get-content -Path $tstIniPath
        $isFound=$false
        for($i=0;$i -lt $getAzureEnv.Length;$i++ ){
            if($getAzureEnv[$i].StartsWith('['+$subject)){ 
                $i++
                while($true){
                    try{
                        $azureEnvArr=$getAzureEnv[$i].Split('=')
                        if($usrDns -eq $azureEnvArr[0]){
                            $azureEnv=$azureEnvArr[1]
                            $isFound=$true
                            break;    
                        }
                    }catch{$isFound=$true;break;}
                    $i++  
                }
            }
        if($isFound){break;}
        }
        if($azureEnv -eq ''){
            $azureEnv='AzureCloud,https://outlook.office365.com/powershell-liveid/,smtp.office365.com,https://login.microsoftonline.com,O365Default' 
        }
        return $azureEnv
    }
}



Function Eg-ConvertTime
{
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Time
    )
    Process
    {
        if($Time -eq '' -or $Time -eq $null){
            return ''
        }
        [DateTime]$Time=$Time
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $path=$egurkhaPath+'\agent\SBO\SBODataFile.ini'
        try{$tests=Get-content -Path $path}catch{}
        if($tests -eq $null -or $tests -eq ""){
            if(!(Test-Path -Path $path )){ New-Item -ItemType file -Path $path }
            $text='[SBO_ConvertTimeZone]'
            Add-Content $path -Value $text
            $text=';Dateline Standard Time,UTC-11,Hawaiian Standard Time,Alaskan Standard Time,US Mountain Standard Time,Pacific Standard Time,Pacific Standard Time (Mexico),Central America Standard Time,     Canada Central Standard Time,Mountain Standard Time (Mexico),Mountain Standard Time,SA Pacific Standard Time,    Central Standard Time, Central Standard Time (Mexico),Venezuela Standard Time,Central Brazilian Standard Time,Pacific SA Standard Time,SA Western Standard Time,    Eastern Standard Time, Paraguay Standard Time,  US Eastern Standard Time,   SA Eastern Standard Time,Montevideo Standard Time,Bahia Standard Time,Argentina Standard Time,Atlantic Standard Time,E. South America Standard Time,Newfoundland Standard Time,    Mid-Atlantic Standard Time,UTC-02,Greenland Standard Time,Cape Verde Standard Time,UTC,Greenwich Standard Time,Azores Standard Time, Morocco Standard Time,W. Central Africa Standard Time,GMT Standard Time ,South Africa Standard Time,Namibia Standard Time,Egypt Standard Time,Libya Standard Time,Central Europe Standard Time,W. Europe Standard Time,Romance Standard Time,Central European Standard Time,Israel Standard Time,Jordan Standard Time,Arabic Standard Time, E. Africa Standard Time,Arab Standard Time,Kaliningrad Standard Time,Syria Standard Time, Middle East Standard Time,   GTB Standard Time ,Turkey Standard Time, FLE Standard Time ,E. Europe Standard Time,Iran Standard Time, Mauritius Standard Time,Georgian Standard Time,Caucasus Standard Time,Arabian Standard Time,   Russian Standard Time, Afghanistan Standard Time,     Pakistan Standard Time,West Asia Standard Time,Azerbaijan Standard Time,Sri Lanka Standard Time,India Standard Time,Nepal Standard Time,Ekaterinburg Standard Time,Bangladesh Standard Time,Central Asia Standard Time,Myanmar Standard Time,N. Central Asia Standard Time,SE Asia Standard Time,   W. Australia Standard Time,Taipei Standard Time,Ulaanbaatar Standard Time,China Standard Time,North Asia Standard Time,Singapore Standard Time,Korea Standard Time,Tokyo Standard Time,North Asia East Standard Time,AUS Central Standard Time,Cen. Australia Standard Time,Tasmania Standard Time,Yakutsk Standard Time,West Pacific Standard Time, E. Australia Standard Time,AUS Eastern Standard Time,Vladivostok Standard Time,Central Pacific Standard Time,     Fiji Standard Time,Magadan Standard Time,UTC+12,Tonga Standard Time,Kamchatka Standard Time,New Zealand Standard Time,Samoa Standard Time'
            $text | Add-Content $path
            $text='ConvertTimeZoneFrom=Pacific Standard Time'
            $text | Add-Content $path
            $text='ConvertTimeZoneTo='+( ([TimeZoneInfo]::Local | select ID).ID )
            $text | Add-Content $path
        }
        $toTimeZone=''
        $firstEntry=$false
        foreach($testsini in $tests){
            if($testsini -eq '[SBO_ConvertTimeZone]'){
                $firstEntry=$true
            }
            elseif($testsini -eq $null){
                $firstEntry=$false
            }
            if($firstEntry){
                if($testsini -ne '[SBO_ConvertTimeZone]' -and $testsini -cnotcontains ';'){
                    if($testsini.StartsWith("ConvertTimeZoneFrom")){
                        $fromTimeZone= $testsini.Split("=")[1]
                    }
                    if($testsini.StartsWith("ConvertTimeZoneTo")){
                        $toTimeZone= $testsini.Split("=")[1]
                    }
                }
            }
        }

        $ToTimeZoneObj  = [system.timezoneinfo]::GetSystemTimeZones() | Where-Object {$_.id -eq $toTimeZone}    
        $oFromTimeZone = [System.TimeZoneInfo]::FindSystemTimeZoneById($fromTimeZone)
        $oToTimeZone = [System.TimeZoneInfo]::FindSystemTimeZoneById($toTimeZone)
        $utc = [System.TimeZoneInfo]::ConvertTimeToUtc($Time, $oFromTimeZone)
        $newTime = [System.TimeZoneInfo]::ConvertTime($utc, $oToTimeZone)
        return $newTime
    }
}

Function Eg-GetDomain(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$userName,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Password,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$proxyUsr,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$proxyPass,
        [Parameter(Mandatory=$false, Position=5)]
        [boolean]$IsIntial,
        [Parameter(Mandatory=$false, Position=6)]
        [String]$Capabilities,
        [Parameter(Mandatory=$true, Position=7)]
        [String]$proxyserver,
        [Parameter(Mandatory=$false)]
        [String]$appDetails
    )
    Process
    {
        $Password=$Password.Replace("'","")
        $proxyPass=$proxyPass.Replace("'","")

        $azureVal=Eg-GetAzureEnv -UserName $userName
        $azureEnvArr=$azureVal.Split(',')
        $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
        if(!$proxyserver.Contains('none')){
            if(!$proxyserver.Contains('http')){$proxyserver='http://'+$proxyserver;}
            [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
            if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
                $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)	    
	            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
	            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
            }
        }

        if($appDetails -and $appDetails -ne 'none'){
            $appDetailsArr=($appDetails).ToString() -Split ("~!~")
            $clientId=$appDetailsArr[0].Trim()
            $tenantName=$appDetailsArr[1].Trim()
            $thumbPrint=$appDetailsArr[2].Trim()
            $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
            $measure=Get-AzureADDomain |select * 
            if($IsIntial){
                $azureEnv= $measure|where{$_.IsInitial -eq $IsIntial}|select Name
                return $azureEnv.Name
            }
            elseif($Capabilities -ne $null -and $Capabilities -ne ''){
                $azureEnv= $measure|where{$_.SupportedServices -ccontains $Capabilities}|select Name
                return $azureEnv.Name
            }
            else{
                $azureEnv= $measure|select Name
                return $azureEnv.Name
            }
        }else{
        	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
		    $measure=Get-MsolDomain |select * 
	        if($IsIntial){
        	    $azureEnv= $measure|where{$_.IsInitial -eq $IsIntial}|select Name
	            return $azureEnv.Name
        	}
	        elseif($Capabilities -ne $null -and $Capabilities -ne ''){
            		$azureEnv= $measure|where{$_.Capabilities -ccontains $Capabilities}|select Name
            		return $azureEnv.Name
	        }
        	else{
            		$azureEnv= $measure|select Name
            		return $azureEnv.Name
		    }
        }
    }
}

Function Eg-O365Dcr(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$EncStr
    )
    Process
    {
        $encArr=$EncStr.Split(':')
        $count=$encArr.Count
        $j=124
        $c=$count
        $decStr=''
        $i=$count-1
        for($rr=0;$rr -lt $c ;$rr++){
            $str=$encArr[$rr].ToString()
            [int]$num=''
            if ([int]$str -le 0){
                $str=$str.Substring(1)
                $num=(([int]$str) * -1)
            }else{
                $num=$str
            }
            [int]$x=$num
            $k=$j-$x+$i*3
            $i--
            $byt=[System.BitConverter]::GetBytes($k)
            $dStr1=[System.Text.Encoding]::UTF8.GetString($byt)    
            $decStr=$decStr+$dStr1[0]
        }
        $dstr=''
        for($i=$decStr.Length;$i -ge 0;$i--){
            $dstr=$dstr+$decStr[$i]
        }
        return $dstr
    }
}

function Get-GraphClientSecret(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$InitialDomain    
    )
    Process
    {
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        try{
            $msGraphDir=$egurkhaPath+"\agent\O365\MsGraph"
            $keyFileNam = '\GraphDetailsKey.dat'
            $unProtPath= $msGraphDir+'\GraphDetails.dat'
            $kvalue= Get-Content -Path $msGraphDir$keyFileNam
            $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
            $graphDtls=$msGraphDir+"\GraphDetails.txt"
            $GetInput = Get-Content -Path $graphDtls
        }catch{
            Write-Error -Message "File not found. The $GetInput location does not contain GraphDetails "
        }
        $flag=$false
        foreach($inp in $GetInput){
            if($inp.StartsWith('[') -and $inp -match $InitialDomain){
                $flag=$true
            }
            if($flag){
                if($inp.Contains("client_id")){
                    $appId =$inp.ToString().Substring($inp.IndexOf('~')+1)
                }
                if($inp.Contains("client_secret")){
                    $appSecret =$inp.ToString().Substring($inp.IndexOf('~')+1)
                    $flag=$false
                }
            }
        }
        $clntSecrtArr=@{}
        if($appId -ne $null -and $appId -ne ''){  
            $clntSecrtArr[0]=$appId.ToString().Trim()
            $clntSecrtArr[1]=$appSecret.ToString().Trim() 
            if([System.IO.File]::Exists($graphDtls)){
                Remove-Item -Path $graphDtls     
            }
        }
        return $clntSecrtArr
    }
}

function Check-WriteFile{
    [CmdletBinding()]
    Param(
       [Parameter(Mandatory=$true, Position=1)]
        [String]$rptPath,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$srchWrd,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$mTimInMin
    )
    Process
    {  
        #$rptPath='C:\eGurkha\agent\EXO\eGinnovations435'
        $leafPath=$rptPath+'\Ticks.log'
        $tic=(Get-Date).Ticks

        if(!(Test-Path -Path $rptPath)){
            $null=New-Item -ItemType directory -Path $rptPath
        }

        if(Test-Path $leafPath -PathType Leaf){
            $ticLines=Get-Content -Path $leafPath
            $notFind=$true
            foreach($line in $ticLines){
                if($line.StartsWith($srchWrd)){
                    $notFind=$false
                    $lstTic=[long]$line.Replace($srchWrd+'-','')
                    $lstTicks=(Get-Date $lstTic).Ticks
                    $lstTicks=$lstTicks+([System.TimeSpan]::FromMinutes($mTimInMin)).Ticks
                    $curTicks=(Get-Date).Ticks
                    if($curTicks -ge $lstTicks){
                        $replaceCnt=$srchWrd+'-'+$curTicks
                        (Get-Content $leafPath).replace($line, $replaceCnt) | Set-Content $leafPath -Force
                        return $true
                    }else{
                        return $false
                    }
                }
            }
            if($notFind){
                $srchWrd+'-'+$tic|Add-Content -Path $leafPath -Force
                return $true
            }
        }else{
            #$null=New-Item -ItemType File -Path $leafPath
            $srchWrd+'-'+$tic|Add-Content -Path $leafPath -Force
            return $true
        }
    }
}


Function Get-SuperSetNDomains(){
    [CmdletBinding()]
    Param(
    [Parameter(Mandatory=$true, Position=1)]
        [String]$username,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$password, 
        [Parameter(Mandatory=$true, Position=3)]
        [String]$rptName,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$proxyserverip,
        [Parameter(Mandatory=$true, Position=5)]
        [String]$proxyUsr,
        [Parameter(Mandatory=$true, Position=6)]
        [String]$proxyPass,
        [Parameter(Mandatory=$false)]
        [String]$lastwritTim,
        [Parameter(Mandatory=$false)]
        [String]$appDetails
    )
     process
    {
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $iniDir=$egurkhaPath+'\agent\config'
        $eg_AgentsIni=$iniDir+'\eg_agents.ini'
        $o365_DomainsIni=$iniDir+'\eg_0365Domains.ini'
        $o365_DomainsIni_tmp=$iniDir+'\eg_0365Domains_tmp.ini'

        $rptNamArr=$rptName.Split('_')
        $lockNam=$rptNamArr[0]
        $suffixNam='_'+$rptNamArr[1]
        $chkNam=$rptName

        $o365dmnsHash=@{}
        $eg_AgntIniLns=get-content -Path $eg_AgentsIni
        foreach($line in $eg_AgntIniLns){
            $cmpntChkStr=''
            if($line -match $suffixNam -and $line -like '*-Lookup_Domain*' -and $line -notlike '*-Lookup_Domain $unconfigured*'){ # $line -match '-Lookup_Domain'){
                $nickName=''
                $chkNum=$line.IndexOf('=-manual')
                if($chkNum -eq -1){
                    $chkNum=$line.IndexOf('=-auto')
                }
                $nickStr=$line.Substring(0,$chkNum)
                $nickName=$nickStr.Substring($nickStr.LastIndexOf(':')+1 )
                if($cmpntChkStr -notmatch $nickName){
                    $dmnStr=$line.Substring($line.IndexOf('Lookup_Domain '))
                    $dmnStr=$dmnStr.Replace('Lookup_Domain ','').Trim()
                    $inputDomains=$dmnStr.Substring(0,$dmnStr.IndexOf(' '))
                    $inputDomains=$inputDomains.Replace('|',',')
                    try{
                        $azureVal=Eg-GetAzureEnv -UserName $username
                        $azureEnvArr=$azureVal.Split(',')

                        $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $username, $(convertto-securestring $password -asplaintext -force)
                        if($proxyserverip -notmatch 'none'){
                            if($proxyserverip -notmatch 'http'){$proxyserverip='http://'+$proxyserverip}
	                        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
							if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
								$proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
								[System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred	
								[system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
							}
                        }
                        if($appDetails -and $appDetails -ne 'none'){
                            $appDetailsArr=($appDetails).ToString() -Split ("~!~")
                            $clientId=$appDetailsArr[0].Trim()
                            $tenantName=$appDetailsArr[1].Trim()
                            $thumbPrint=$appDetailsArr[2].Trim()
                            $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
                            $measures=Get-AzureADDomain |select * 
                            $supersetNam=$measures | where {$_.IsInitial -eq $true}
                            $sprsetNam=$supersetNam.Name.Replace('.onmicrosoft.com','')
                            if(!$o365dmnsHash.ContainsKey($nickName)){
                                $o365dmnsHash.Add($nickName,$inputDomains+'~'+$sprsetNam)
                            }
                        }else{
                            Connect-MsolService -Credential $credential -AzureEnvironment $azureEnvArr[0]
                            $measures=Get-MsolDomain |select *
                            $supersetNam=$measures | where {$_.IsInitial -eq $true}
                            $sprsetNam=$supersetNam.Name.Replace('.onmicrosoft.com','')
                            if(!$o365dmnsHash.ContainsKey($nickName)){
                                $o365dmnsHash.Add($nickName,$inputDomains+'~'+$sprsetNam)
                            }
                        }
                    }
                    catch{
                        continue
                    }
                    $cmpntChkStr+='~'+$nickNam
                }
            }
        }
        if($lastwritTim -ne $null -and $lastwritTim -ne ''){  
            $needToWrite=@()
            $needToWrite+='['+$lastwritTim+']'
            $cntArr= Get-Content -path $o365_DomainsIni
            for($i=1;$i -lt $cntArr.Length;$i++){
                if($o365dmnsHash[$chkNam] -ne $null -and $o365dmnsHash[$chkNam] -ne ''){
                    $needToWrite+=$chkNam+'~'+$o365dmnsHash[$chkNam]
                }else{
                    $needToWrite+=$cntArr[$i]
                }
            } 
            foreach($line in $needToWrite){
               $line |Add-Content -Path $o365_DomainsIni_tmp
            } 
            try{
                handleThreadLock -setLock -lockName $lockNam
            }catch{Throw "Failed to set lock!"}
 
            try{
                if([System.IO.File]::Exists($o365_DomainsIni_tmp) -eq 'True'){
                    if([System.IO.File]::Exists($o365_DomainsIni) -eq 'True'){
                        Remove-Item $o365_DomainsIni 
                    }
                    Rename-Item -Path $o365_DomainsIni_tmp -NewName 'eg_0365Domains.ini'  
                }   
            }finally{
                handleThreadLock -releaseLock
            }                   
        }
        return $o365dmnsHash
    }
}

function handleThreadLock(){
    Param(
        [switch]$setLock,
        [switch]$releaseLock,
        [string]$lockName,
        [int]$timeOut=600
    )
    if($setLock){
        #register a thread lock
        $script:threadLock = New-Object System.Threading.Mutex($false, $lockName)
        $waited = 0
        while($true){
            try{$lockState = $script:threadLock.WaitOne(1000)}catch{$lockState=$False}
            if($lockState){
                break
            }else{
                $waited+=1
                if($waited -gt $timeOut){
                    Throw "failed to get a thread within $timeOut seconds!"
                }
            }
        }
    }  
    if($releaseLock){
        #release a thread lock
        if($script:threadLock.WaitOne()){
            [void]$script:threadLock.ReleaseMutex()
        }
    }  
}

Function Eg-O635Domains(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$username,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$password,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$rptNam, 
        [Parameter(Mandatory=$true, Position=4)]
        [String]$proxyserverip,
        [Parameter(Mandatory=$true, Position=5)]
        [String]$proxyUsr,
        [Parameter(Mandatory=$true, Position=6)]
        [String]$proxyPass,
        [Parameter(Mandatory=$false)]
        [String]$appDetails
        
    )
    Process
    { 
        try{
            handleThreadLock -setLock -lockName $rptNam
        }catch{Throw "Failed to set lock!"}
        try{
            $o365DmnsHash=@{}
	    	$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
            $iniDir=$egurkhaPath+'\agent\config'
            $eg_AgentsIni=$iniDir+'\eg_agents.ini'
            $o365_DomainsIni=$iniDir+'\eg_0365Domains.ini'

            $lastWritTim=(Get-Item -Path $eg_AgentsIni).LastWriteTime.Ticks
            if(Test-Path $o365_DomainsIni -PathType Leaf){
                $dmnLines=get-content -Path $o365_DomainsIni
                $dmnLstWritTim=$dmnLines[0].ToString().Replace('[','')
                $dmnLstWritTim=$dmnLstWritTim.Replace(']','')
                if($dmnLstWritTim -ne $lastWritTim){
                    $o365DmnsHash= Get-SuperSetNDomains -username $username -password $password -rptName $rptNam -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass -lastwritTim $lastWritTim -appDetails $appDetails
                }else{
                    $arr=Get-Content -path $o365_DomainsIni
                    for($i=1;$i -lt $arr.Length;$i++ ){
                       $spltArr=$arr[$i].Split('~')
                       $o365DmnsHash.Add($spltArr[0],$spltArr[1]+'~'+$spltArr[2])
                    }
                }
            }
            else{
                $o365DmnsHash=Get-SuperSetNDomains -username $username -password $password -rptName $rptNam -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass -lastwritTim '' -appDetails $appDetails
                if($o365DmnsHash.Count -ne 0){
                    '['+$lastWritTim+']'|Add-Content -Path $o365_DomainsIni
                    foreach($key in $o365DmnsHash.Keys){
                       $key+'~'+$o365DmnsHash[$key]|Add-Content -Path $o365_DomainsIni
                    }
                }
            }
            return $o365DmnsHash
        }
        finally{
            handleThreadLock -releaseLock
        } 
    }
}

Function Eg-GetINIContent(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Path,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Subject,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$Key,
        [Parameter(Mandatory=$false, Position=4)]
        [String]$Type
    )
    Process
    {
        $res=''
        $isExist=$false
        if($Type -ne $null -and $Type -ne ''){
            $lines=get-content -Path $Path -Encoding $Type
        }else{
            $lines=get-content -Path $Path
        }
        foreach($line in $lines){
            if($isExist){
                if($line.StartsWith($Key)){
                    $res=($line.Split('=')[1]).ToString()
                    break;
                }
            }
            if($line.StartsWith('['+$Subject)){
                $isExist=$true
            }
        }
        return $res
    }
}

Function Domains-ReadFrmINI(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$ps1FileName,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$RptName,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$ComponentName,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$EncType
    )

    Process
    {
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $iniDir=$egurkhaPath+'\agent\O365'
        $teams_DomainIni=$iniDir+'\eg_O365Domains.ini'
        $ticksArr=@()
        if(Test-Path $teams_DomainIni -PathType Leaf){
            $tmDmnLns=get-content -Path $teams_DomainIni -Encoding $EncType
            $isRead=$false
            for($i=0;$i -lt $tmDmnLns.Length;$i++){
                if($isRead -and $tmDmnLns[$i].StartsWith($ps1FileName) -and $tmDmnLns[$i] -match $RptName){
                    $lstTickStr=$tmDmnLns[$i].Replace(($ps1FileName+'='),'')
                    $ticksArr=$lstTickStr.Split('~')
                    break;
                } 
                if($tmDmnLns[$i].StartsWith('['+$ComponentName)){
                    $isRead=$true
                }
            }
        }
        return $ticksArr
    }
}


Function Domains-WriteToINI(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$ps1FileName,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$RptNam,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$SfolderNam,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$ticks,
        [Parameter(Mandatory=$true, Position=5)]
        [String]$componentNam,
        [Parameter(Mandatory=$true, Position=6)]
        [String]$encTyp

    )

    Process
    {
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $iniDir=$egurkhaPath+'\agent\O365'
        $teams_DomainIni=$iniDir+'\eg_O365Domains.ini'
        $teams_DomainIni_tmp=$iniDir+'\eg_O365Domains_tmp.ini'

        if(!(Test-Path $teams_DomainIni -PathType Leaf)){
            $null=New-Item -ItemType File -Path $teams_DomainIni
        }

        $tmDmnLns=get-content -Path $teams_DomainIni -Encoding $encTyp
        $isRead=$false;$isFindCntnt=$false;$isChangFldr=$false;
        $cntnt=''
        for($i=0;$i -lt $tmDmnLns.Length;$i++){     
            if($isRead -and $tmDmnLns[$i].StartsWith($ps1FileName) -and $tmDmnLns[$i] -match $SfolderNam){
                $isFindCntnt=$true
                $inputStr=$tmDmnLns[$i].Replace(($ps1FileName+'='),'')
                $old_Rptnam=$inputStr.Split('~')[0]
                if($old_Rptnam.Length -ne 0){
                    if($old_Rptnam -match $RptNam){
                        $new_Rptnam=$old_Rptnam
                    }else{
                        $new_Rptnam=$old_Rptnam+'#'+$RptNam
                    } 
                }else{
                    $new_Rptnam=$RptNam
                }
                $cntnt=$ps1FileName+'='+$new_Rptnam+'~'+$SfolderNam+'~'+$ticks       
            }elseif($isRead -and $isFindCntnt -eq $false -and  $tmDmnLns[$i].StartsWith($ps1FileName) -and $tmDmnLns[$i] -notmatch $SfolderNam){
                $isFindCntnt=$true
                $addCFCntnt=$ps1FileName+'='+$RptNam+'~'+$SfolderNam+'~'+$ticks
                $addCFCntnt|Add-Content -Path $teams_DomainIni_tmp -Encoding $encTyp
                $cntnt=$tmDmnLns[$i]
            }else{
                $cntnt=$tmDmnLns[$i]
            } 
            if($isFindCntnt -eq $false -and $isRead -eq $true -and $tmDmnLns[$i].StartsWith("[")){
                $addCntnt=$ps1FileName+'='+$RptNam+'~'+$SfolderNam+'~'+$ticks
                $addCntnt|Set-Content -Path $teams_DomainIni_tmp -Encoding $encTyp
            }
            if($tmDmnLns[$i] -eq ('['+$componentNam+']')){
                $cntnt=$tmDmnLns[$i]
                $isRead=$true
            }
            $cntnt| Out-File $teams_DomainIni_tmp -Append -Encoding utf8
            if(!$isFindCntnt -and $i -eq $tmDmnLns.Length-1){
                $addCntnt=$ps1FileName+'='+$RptNam+'~'+$SfolderNam+'~'+$ticks
                $addCntnt | Add-Content -Path $teams_DomainIni_tmp -Encoding $encTyp
            }
        }
        if($isRead -eq $false){
            if($tmDmnLns.Length -eq 0){
                '['+$componentNam+']'|Add-Content -Path $teams_DomainIni -Encoding $encTyp
                $str=$ps1FileName+'='+$RptNam+'~'+$SfolderNam+'~'+$ticks
                $str|Add-Content -Path $teams_DomainIni -Encoding $encTyp
            }else{
                Get-Content $teams_DomainIni -Encoding $encTyp | Set-Content -Path $teams_DomainIni_tmp -Encoding $encTyp
                '['+$componentNam+']'|Add-Content -Path $teams_DomainIni_tmp
                $str=$ps1FileName+'='+$RptNam+'~'+$SfolderNam+'~'+$ticks
                $str|Add-Content -Path $teams_DomainIni_tmp -Encoding $encTyp
            }
        }

        #ThreadLock
        try{
            handleThreadLock -setLock -lockName $RptNam
        }catch{Throw "Failed to set lock!"}
        try{     
            if([System.IO.File]::Exists($teams_DomainIni_tmp) -eq 'True'){
                if([System.IO.File]::Exists($teams_DomainIni) -eq 'True'){
                    Remove-Item $teams_DomainIni 
                }
                Rename-Item -Path $teams_DomainIni_tmp -NewName 'eg_O365Domains.ini'  
            }           
        }finally{
            handleThreadLock -releaseLock
        }

    }
}

Function Domains-GetSuperset(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$UserName,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Password,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$ProxyServerIP,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$ProxyUser,
        [Parameter(Mandatory=$true, Position=5)]
        [String]$ProxyPassword,
        [Parameter(Mandatory=$false)]
        [String]$appDetails
    )

    Process
    {
        Try{
            $azureVal=Eg-GetAzureEnv -UserName $UserName
            $azureEnvArr=$azureVal.Split(',')
            $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $UserName, $(convertto-securestring $Password -asplaintext -force)
            if(!$ProxyServerIP.ToString().ToLower().Contains('none')){
                if($ProxyServerIP -notcontains 'http'){$proxyserver='http://'+$ProxyServerIP}else{$proxyserver=$ProxyServerIP}
                [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
            }
            if($ProxyUser -ne 'none' -and $ProxyPassword -ne 'none'){
	            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $ProxyUser, $(convertto-securestring $ProxyPassword -asplaintext -force)
	            [System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred	
	            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
            }
            if($appDetails -and $appDetails -ne 'none'){
                $appDetailsArr=($appDetails).ToString() -Split ("~!~")
                $clientId=$appDetailsArr[0].Trim()
                $tenantName=$appDetailsArr[1].Trim()
                $thumbPrint=$appDetailsArr[2].Trim()
                $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
                $measures=Get-AzureADDomain |select * 
                $supersetNam=$measures | where {$_.IsInitial -eq $true}
                $sprsetNam=$supersetNam.Name.Replace('.onmicrosoft.com','')
                return $sprsetNam
            }else{
                Connect-MsolService -Credential $credential -AzureEnvironment $azureEnvArr[0] -ErrorAction SilentlyContinue
                $measures=Get-MsolDomain -ErrorAction SilentlyContinue |select * 
                $supersetNam=$measures | where {$_.IsInitial -eq $true}
                $sprsetNam=$supersetNam.Name.Replace('.onmicrosoft.com','')
                return $sprsetNam
            }
        }
        Catch{
            return ''
        }
    }
}

Function Eg-ParseExact(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$DateStr,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$DateTimeFormat,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$TimeFormat,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$HourFrmt
        
    )
     Process
    {
        $dat=''
        if($DateStr.Length -gt 11){
	    	$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
            $langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
            $encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
            $am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
            $pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp
            if($TimeFormat -match 'tt' -and ($DateStr -notmatch $am_Format -and $DateStr -notmatch $pm_Format) -and $HourFrmt -ne 'none'){
                $DateStr=$DateStr.Trim()+' '+$HourFrmt
            }
        }
        $cultInfo=(Get-Culture).Name
        $dat=[DateTime]::ParseExact($DateStr,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
        return $dat
    }
}

function Eg-RemoveGraphcsvFiles(){
	[CmdletBinding()]
    Param(
        [String]$rmvPath
    )
    Process{
        Try{  
            $rmvFile = [System.IO.FileInfo]$rmvPath
            $rmvDir=$rmvFile.DirectoryName
            $srchNam=$rmvFile.BaseName -replace "[0-9]",""
            Get-ChildItem -Path $rmvDir |Where-Object {$_.Name -like $srchNam+'*.csv'}|ForEach-Object{
                $path=$rmvDir+'\'+$_.Name
                if([System.IO.File]::Exists($path)){
                    Remove-Item -Path $path
                }
            }
        }Catch{
            $excepMsg='[GetDatnKeyFiles] Exception Occured in -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
            Write-Host $excepMsg
        }
    }
}

Export-ModuleMember -Function Eg-InvokeGraphUrl
Export-ModuleMember -Function Eg-WriteFile
Export-ModuleMember -Function Eg-ReadFile
Export-ModuleMember -Function Eg-DeleteFiles
Export-ModuleMember -Function Eg-DeleteCsvFiles
Export-ModuleMember -Function Eg-GetCont
Export-ModuleMember -Function Eg-GetAzureEnv
Export-ModuleMember -Function Eg-GetDomain
Export-ModuleMember -Function Eg-ConvertTime
Export-ModuleMember -Function Eg-O365Dcr
#Export-ModuleMember -Function Get-GraphClientSecret
Export-ModuleMember -Function Eg-O635Domains
Export-ModuleMember -Function Get-SuperSetNDomains
Export-ModuleMember -Function Check-WriteFile
Export-ModuleMember -Function Eg-WriteLog
Export-ModuleMember -Function Eg-GetINIContent
Export-ModuleMember -Function Domains-ReadFrmINI
Export-ModuleMember -Function Domains-WriteToINI
Export-ModuleMember -Function Domains-GetSuperset
Export-ModuleMember -Function Eg-ParseExact
Export-ModuleMember -Function Eg-RemoveGraphcsvFiles

# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUsDneZ3HDXTVRD4ncvHfhgPo4
# QIWggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNiXIh9Q79xbM0zZ
# /GF268GR37T5MA0GCSqGSIb3DQEBAQUABIICAKQzTZ64rZqmDwBlIX0oy+Un4CAA
# D0M1Vqgq55h5uMbKHsOXquP3FlabsmAMq2Hh5sWruIO7p2WSRO/+H3xkBr8QNo7C
# Ej9PAJWfUeNg1FivFZvOXmYjaLBbnLQ6Dh5i27I47y6t+WwImGfJddeOu49pVexk
# tBLDIv57mnxf8o/+1iWuiC0krkpuvmLMjGmT9spSmDZKzFNLSdmD17US19EJJVui
# v5jdrqBe4+nRPqdXnwSGEl4NEyKKeWzKT3wVFOmQkQilNEj+Ui3G8lTpSaOe3lsW
# zYmLgJLISxJod0eOV1L9+/Z99eycn3iwDSz7n9/50BSaBEx190khq4p18lRrf+nn
# lytnWopwTIyLiXInmb9Jwzo5DMutGONsBVaOmIWy3RH8h59rhtf11FBbPWCiM3AL
# lMlE6PjO7MHslOw9vtiQBfBXVgKJClhskdJX4if8qPERsIg1Q0viEkq0Rlj2vw2Z
# WnuWSvvnOQqbG+jUSbB56+MRjmWBUl59tdeAoTS1x7N6V3As+t3b0cHc0wdUMP+q
# nDDUf2fTRrWA2JZL/P5gvJBdqTrna+Q0amfw+r+ixKuVq3gWF5wRwCOwrhtniZ4f
# h2M+29gTub+Q8Syjq0mSVWUrLD928cN9I2ubbiP5xQ+eMz+IrWFnXWEorpfW0xa5
# 0Cf7fY7qHgx/JS1toYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIzMDEyNDEyNDc1M1owLwYJ
# KoZIhvcNAQkEMSIEIPVqR4nOgQ9yZe7iP3v6vQdjNK8dNLDRFCWSIMgPyCXxMA0G
# CSqGSIb3DQEBAQUABIICALsi+RQHzAgMP7N0TitVoK0SRUv3EAt3xJjL4eHIIRhM
# uqpar46Meaojf+c1FZjFpEeO76D0wIvnufAEV1DQvFCmhs43T4S6UYZ5kLYs1Bg2
# u66fQszo6d2Qc/+8LGb0gtdgjjHZheW9FadDNZENLFtLxmdwBPINdhpWRbkAojh1
# pfiTR0+vWEnuL0J00JkcV9yMcCKQXyHR6fGfnhDp3ukXI6wAXLDYyYVvY1vOS9H1
# 5LCSqTqV1OEBNCxa0b3MWtNi5gpgEz4nt6MENq1UgPlCLJ4iOwf4lnPi+H4IGPiE
# brN3Mk1iTbrAuvQZoZTPFFKgOUD6kmE4JtAA42o5dAH+sK5OmBolhNnT1dq2m5Dh
# Z0uXX1eY4vUuNyl1LZLChAe1D775/QBVUR3DBjMqJyJfEBy/xbLM33nIGTJ9wgc9
# 68eH16LJsUMc/CEHioAnIc2lSU9cwl7lC5U9lOp7vpA74RqmZD+nuW2A5rInbjhd
# 0U14rX8lWmQAuaVz6rrgpMgmZ8/0cif8LgjJScCYZ4zk97Es/ZQUn+eZaOmlDmPS
# AOOue9ioXYdausS1lde4sAyVfkPxSuV//ZRV+2nQzU3/wkarUZRjKAH1a8p9Un9+
# 9ZkF9LTsCWlpYoHit6bsZDPoyvAWgoEHu0agI+qbiXunBNo3dOsYNdtmAH6i3Bol
# SIG # End signature block
