﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
Import-Module MsOnline -ea 0 -WarningAction SilentlyContinue

$TestInputs=$args
#<#
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$strgLimit=$TestInputs[5]
$readDat=[DateTime]$TestInputs[6]
$rptNam=$TestInputs[7]
$inactvDays=[int]$TestInputs[8]
$topnddNTestFreq=($TestInputs[9]).ToString().Split("#")
$rptTopNDD=[int]$topnddNTestFreq[0]
$testFrequency=[int]$topnddNTestFreq[1]
$o365_domain=$TestInputs[10]
$graphDetails=$TestInputs[11]
$appDetails=$TestInputs[12]

if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}

if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$rptPath=$egurkhaPath+'\agent\ODB\'+$rptNam
if(!(Test-Path -Path $rptPath )){
    $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$logPath=$rptPath+'\ODBSiteUsageDtls.log'
$isWriteLog=$false

$url = 'https://'+$o365_domain+'-admin.sharepoint.com'
if(!$proxyserver.ToString().ToLower().Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$toReadDat=$readDat.tostring(“yyyy-MM-dd”)

$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Method,
        [Parameter(Mandatory=$true, Position=3)]
        [String]$PropsVal,
        [Parameter(Mandatory=$true, Position=4)]
        [String]$filePath        
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()
        $header = @{
            'Authorization'=$authCode
        }
        $query = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method $Method -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$query = Invoke-RestMethod -Method $Method -Headers $header -Uri $Url
        $query=$query.Replace('ï»¿','')
        $query=$query.Replace(' ','')

        $resultarray = ConvertFrom-Csv -InputObject $query
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        $psobje=''
        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){   
           $reports.Usage[$i] |Sort-Object -Property $PropsVal -Descending |Export-Csv $filePath -Encoding $encTyp -Append -NoTypeInformation -Force
        }
    }
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$ODBUsageAccDtls=$rptPath+'\ODBSitUsageAccDtls'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $ODBUsageAccDtls
$ODBUsageAccCnts=$rptPath+'\ODBSitUsageAccCnts'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $ODBUsageAccCnts

$url1="https://graph.microsoft.com/v1.0/reports/getOneDriveUsageAccountDetail(period='D7')"
$url2="https://graph.microsoft.com/v1.0/reports/getOneDriveUsageAccountCounts(period='D7')"
Try{
    Eg-InvokeUrl -Url $url1 -Method 'Get' -PropsVal 'ReportDate' -filePath $ODBUsageAccDtls
    Eg-InvokeUrl -Url $url2 -Method 'Get' -PropsVal 'ReportDate' -filePath $ODBUsageAccCnts

    $usagAccDtlArr=Import-Csv $ODBUsageAccDtls -Encoding $encTyp
    $usagAccCntsArr=Import-Csv $ODBUsageAccCnts -Encoding $encTyp

    $accDtlsRptDat=$usagAccDtlArr | select ReportRefreshDate -First 1
    $accDtlsRptDat=($accDtlsRptDat.ReportRefreshDate)

    if([datetime]$accDtlsRptDat -ge [datetime]$toReadDat){
        Write-Host 'ReadedDate for the Date#'$accDtlsRptDat
        $ldate=($usagAccDtlArr |sort -Property LastActivityDate -Descending |Select-Object -First 1).LastActivityDate

        $timenow = [int][double]::Parse((Get-Date -UFormat %s))
        $SPOSiteDtls=$rptPath+'\ODBSPOSiteDtls'+$timenow+'.csv'
        Eg-RemoveGraphcsvFiles -rmvPath $SPOSiteDtls
        $MsolUsrDtls=$rptPath+'\ODBMsolUsrDtls'+$timenow+'.csv'
        Eg-RemoveGraphcsvFiles -rmvPath $MsolUsrDtls

		# ****ORPHANED SITES*****

        Eg-WriteLog -writString ('Entering ORPHANED SITES ....') -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)  
        if($appDetails -and $appDetails -ne 'none'){
            $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
        }else{
            Connect-MsolService -Credential $cred
        }
        Try{
            if($appDetails -and $appDetails -ne 'none'){
                Get-AzureADUser -All $True | Where-Object{$_.UserType -eq 'Member'} |Export-Csv $MsolUsrDtls -Encoding $encTyp -Append -NoTypeInformation -Force
	        }else{
                Get-MsolUser -All | Where-Object{$_.UserType -eq 'Member'} |Export-Csv $MsolUsrDtls -Encoding $encTyp -Append -NoTypeInformation -Force
            }
        }Catch{
            Eg-WriteLog -writString ('[ODBSiteUsageDtls] Exception occurred in Get MsolUser...'+$_.Exception.Message) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        }

        if($appDetails -and $appDetails -ne 'none'){
		    Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint
        }else{
            Connect-SPOService -Url $url -Credential $cred
        }
        Try{
            if($appDetails -and $appDetails -ne 'none'){
                Get-PnPTenantSite -IncludeOneDriveSites -Filter "Url -like '-my.sharepoint.com/personal/'"|select url,Owner | Export-Csv $SPOSiteDtls -Encoding $encTyp -Append -NoTypeInformation -Force
            }else{
                Get-SPOSite -IncludePersonalSite $true -Limit all -Filter "Url -like '-my.sharepoint.com/personal/'"|select url,Owner | Export-Csv $SPOSiteDtls -Encoding $encTyp -Append -NoTypeInformation -Force
            }
        }
        Catch{
            Eg-WriteLog -writString ('[ODBSiteUsageDtls] Exception occurred in Get SPOSite...'+$_.Exception.Message) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        }
        Eg-WriteLog -writString ('[ODBSiteUsageDtls] After Get SPOSite...') -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        [System.GC]::GetTotalMemory($true) | out-null

        $SPOSiteDtlArr=Import-Csv $SPOSiteDtls -Encoding $encTyp
        $MsolUsrDtlArr=Import-Csv $MsolUsrDtls -Encoding $encTyp

        $orphCnt=0
        Eg-WriteLog -writString ('[ODBSiteUsageDtls] MsolUsrDtlArr UserPrincipalName -->> '+$MsolUsrDtlArr.UserPrincipalName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog 
        foreach($sitDtl in $SPOSiteDtlArr){
            if($MsolUsrDtlArr.UserPrincipalName -notcontains $sitDtl.Owner){
                $orphanDD='OrphanedSites~'+"-"+'~!~'+"-"+'~!~'+"-"+'~!~'+"-"+'~!~'+"-"+'~!~'+"-"+'~!~'+"-"+'~!~'+$sitDtl.Url
                Eg-WriteLog -writString ('[ODBSiteUsageDtls] orphanDD -->> '+$orphanDD) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
                if($orphCnt -lt 50){
                    Write-Host $orphanDD
                }
                $orphCnt++
            }
        }
        if($orphCnt -eq 0){
            $orphCnt=-5
        }
        Eg-WriteLog -writString ('[ODBSiteUsageDtls] Orphaned sites count -->> '+$orphCnt) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $isWriteLog
	    [System.GC]::GetTotalMemory($true) | out-null

        # *************ORPHANED SITES - END**********

        $totalSites=0
        $activSites=0
        $usagAccCntsArr|foreach{if($_.ReportDate -eq $ldate){$totalSites=[int]$_.Total;$activSites=[int]$_.Active}}
        if($activSites -ge 0){$activSites=$activSites}else{$activSites=0}
        if($totalSites -ge 0){$totalSites=$totalSites}else{$totalSites=0}
        if($totalSites -gt 0){$activSitesPercent=[math]::Round((($activSites/$totalSites)*100),2)}else{$activSitesPercent=0}        

        $currDat=[DateTime](Get-Date)
        $chkDate=$currDat.AddDays(-$inactvDays)
        $toChkDat=$chkDate.tostring(“yyyy-MM-dd”)
        $inActivSites=0
        $sortInActvSitDtl=@()
        $usagAccDtlArr | foreach{if($_.IsDeleted -eq 'FALSE' -and $_.LastActivityDate -ne ""){if([datetime]$_.LastActivityDate -lt [datetime]$toChkDat){$inActivSites++;$sortInActvSitDtl+=$_}}}
        $sortInActvSitDtl|Sort-Object {$_.LastActivityDate -as [DateTime]} -Descending | Select-Object -First $rptTopNDD |foreach{
        $StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5)        
        $StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)
        if([long]$_."StorageUsed(Byte)" -ge 0){$StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5) }else{$StgUsd=0}        
        if([long]$_."StorageAllocated(Byte)" -ge 0){$StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)}else{$StgAllctd=0}
        $inActvSitesDD='InactiveSitesDD~'+$_.LastActivityDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$StgUsd+'~!~'+$StgAllctd+'~!~'+"-";Write-Host $inActvSitesDD;}
        if($inActivSites -eq 0) {$inActivSites=-5;}

        $sortUsagAccDtl=@()
        $usagAccDtlArr | foreach{if($_.FileCount -ne '' -and $_.IsDeleted -eq 'FALSE'){$sortUsagAccDtl+=$_}}
        $sortUsagAccDtl|Sort-Object {$_.FileCount -as [Int]} -Descending | Select-Object -First $rptTopNDD |foreach{$lstActDat='-';if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){$lstActDat=$_.LastActivityDate};$totFilesDD='TotalFilesDD~'+$lstActDat+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount;Write-Host $totFilesDD}
        $sortUsagAccDtl | Sort-Object {$_.ActiveFileCount -as [Int]} -Descending | Select-Object -First $rptTopNDD |foreach{$lstActDat='-';if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){$lstActDat=$_.LastActivityDate};$actFilesDD='ActivFilesDD~'+$lstActDat+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount;Write-Host $actFilesDD}
    
        [long]$strgUsed=0
        $usagAccDtlArr | foreach{if($_."StorageUsed(Byte)" -ne '' -and $_.IsDeleted -eq 'FALSE'){$strgUsed=$strgUsed+[long]$_."StorageUsed(Byte)"}}
        $sortUsagAccDtl | Sort-Object {$_."StorageUsed(Byte)" -as [long]} -Descending | Select-Object -First $rptTopNDD |foreach{$lstActDat='-';if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){$lstActDat=$_.LastActivityDate};
        $StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5)        
        $StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)
        if([long]$_."StorageUsed(Byte)" -ge 0){$StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5) }else{$StgUsd=0}        
        if([long]$_."StorageAllocated(Byte)" -ge 0){$StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)}else{$StgAllctd=0}
        if($StgUsd -ge 0 -and $StgAllctd -gt 0){$strgUsdPcnt=[math]::Round((($StgUsd/$StgAllctd)*100),2)}else{$strgUsdPcnt=0}
        $strgUsedDD='StrgUsedDD~'+$lstActDat+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+"-"+'~!~'+"-"+'~!~'+$StgUsd+'~!~'+$StgAllctd+'~!~'+"-"+'~!~'+$strgUsdPcnt;Write-Host $strgUsedDD}
        if([long]$strgUsed -ge 0){$strgUsedGB=[math]::Round(([long]$strgUsed/1073741824),2)}else{$strgUsedGB=0}

        [long]$strgAllocatd=0
        $usagAccDtlArr | foreach{if($_."StorageAllocated(Byte)" -ne '' -and $_.IsDeleted -eq 'FALSE'){$strgAllocatd=$strgAllocatd+[long]$_."StorageAllocated(Byte)"}}
        $sortUsagAccDtl | Sort-Object {$_."StorageAllocated(Byte)" -as [long]} -Descending | Select-Object -First $rptTopNDD |foreach{$lstActDat='-';if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){$lstActDat=$_.LastActivityDate};
        $StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5)        
        $StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)
        if([long]$_."StorageUsed(Byte)" -ge 0){$StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5) }else{$StgUsd=0}        
        if([long]$_."StorageAllocated(Byte)" -ge 0){$StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)}else{$StgAllctd=0}
        $strgUsedDD='StrgAllocatdDD~'+$lstActDat+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+"-"+'~!~'+"-"+'~!~'+$StgUsd+'~!~'+$StgAllctd;Write-Host $strgUsedDD}
        if([long]$strgAllocatd -ge 0){$strgAllocatdGB=[math]::Round(([long]$strgAllocatd/1073741824),2)}else{$strgAllocatdGB=0}
        
        if($strgUsedGB -ge 0 -and $strgAllocatdGB -gt 0){$strgUsedPercent=[math]::Round((($strgUsedGB/$strgAllocatdGB)*100),2)}else{$strgUsedPercent=0}
        
        $maxSiteCnts=0
        $sortMaxStrgUsed=@()
        $usagAccDtlArr | foreach{
            if($_."StorageAllocated(Byte)" -ne '' -and $_.IsDeleted -eq 'FALSE'){     
                if([long]$_."StorageUsed(Byte)" -ge 0 -and $_."StorageAllocated(Byte)" -gt 0){$percent=(($_."StorageUsed(Byte)"/$_."StorageAllocated(Byte)")*100)}else{$percent=0}                        
                if($percent -ge $strgLimit){
                        $maxSiteCnts++
                        $sortMaxStrgUsed+=$_
                    }
                }
        }
        $sortMaxStrgUsed | Sort-Object {$_."StorageUsed(Byte)" -as [long]} -Descending | Select-Object -First $rptTopNDD |foreach{$lstActDat='-';if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){$lstActDat=$_.LastActivityDate};
		$StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5)        
        $StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)
        if([long]$_."StorageUsed(Byte)" -ge 0){$StgUsd=[math]::Round(([long]$_."StorageUsed(Byte)"/1073741824),5) }else{$StgUsd=0}        
        if([long]$_."StorageAllocated(Byte)" -ge 0){$StgAllctd=[math]::Round(([long]$_."StorageAllocated(Byte)"/1073741824),2)}else{$StgAllctd=0}
        if($StgUsd -ge 0 -and $StgAllctd -gt 0 ){$strgprct = ($StgUsd/$StgAllctd)*100}else{$strgprct=0}
        
        $maxStrgUsedDD='MaxStorageUsedDD~'+$lstActDat+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+"-"+'~!~'+"-"+'~!~'+$StgUsd+'~!~'+$StgAllctd+'~!~'+'-'+'~!~'+[math]::Round($strgprct,2);Write-Host $maxStrgUsedDD}

        $usageMeasure='measures~'+$totalSites+'~'+$activSites+'~'+$activSitesPercent+'~'+$inActivSites+'~'+$strgUsedGB+'~'+$strgAllocatdGB+'~'+$strgUsedPercent+'~'+$maxSiteCnts+'~'+$orphCnt
        Write-Host $usageMeasure
    }
}Catch{
    $excepMsg=([string]$_.Exception)+($_.ScriptStackTrace)
    Write-Host 'Exception occurred -- '$excepMsg
}

if($SPOSiteDtls -and (Test-Path $SPOSiteDtls)){
    Remove-Item -Path $SPOSiteDtls
}
if($MsolUsrDtls -and (Test-Path $MsolUsrDtls)){
    Remove-Item -Path $MsolUsrDtls
}
if($ODBUsageAccDtls -and (Test-Path $ODBUsageAccDtls)){
    Remove-Item -Path $ODBUsageAccDtls
}
if($ODBUsageAccCnts -and (Test-Path $ODBUsageAccCnts)){
    Remove-Item -Path $ODBUsageAccCnts
}
[System.GC]::GetTotalMemory($true) | out-null


# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU4v4NOaq5t64sUfrzpwayWpER
# Y62ggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNzG6Qw3EvS3VVcg
# syusLF4D+WK1MA0GCSqGSIb3DQEBAQUABIICALq+KXodJLIiW0lDkL7wHmD/dLk9
# SDk3WI2v+1B10m4uVwqgNOpFMPkddlL8NK2L+rhBpXu6fnXYydNaNo9xi6XUycJQ
# NxBf2OtKhdO29zMwHdd2VImgAPA91VfH/wtKhDzuy/4sjFmH/SkABZtD2+V7kcy8
# 3HEmJigsQ0RY/l1QkhXeDN50xTJtXc+YVqVkP4H1+cxab3yZuGhstVvNjtz/K7/7
# wFuKDqbIGssBnwluPvfjeEV6EF2+AFIHvue9v2unvisTEfvCvsWBSst5F4Iaej93
# LVIh8DbWL/pTXQ6YR6fXw+jLQWMMLGpMM/uwtiJrWyxUCjCm6lDsCky2SVhFC9mv
# gToTyunpmOWxpUuOishuLTfTYzDDt1+n0ZRnrE1jk8P8/YgcV+8ZZs5KHEZnGpII
# pjveihNxP41SE6F5vuj2cUT069Qf5pQrgASgqyAz03wmbHEfhVMjvCAONlvXYen0
# Tq6ow+27oNUcZPJOKsZiRJnKnWyhvIuCPgyfXezBz/f0pVNxHgAVjd0ZFFMdlpRW
# fKBUGnRWsgpjO+dWtzkGHOH5D/0CNlkuAECpHnwjozr5SDAqXR8QXoiNXpJLaOf6
# S9g8aSpPQuIqvYrYjfTMPxX2A4gUAPtZJ+w4msaEviz/gVZxd5sV4amEG60J4rcA
# P0Or/KmkQVS5s/TMoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIzMDEyNDEyNDc0NVowLwYJ
# KoZIhvcNAQkEMSIEIOqTl15Cl2SdSlszvnDggMv2fMdU5a8OVBdWECXsEmgEMA0G
# CSqGSIb3DQEBAQUABIICAEIYRc+YRVFPugglIFOXsMijrZtK9tDRX1RgSaxXK9y7
# Q16M0PA6WwtYoK9M0sPHIRXp8wI4IhJGGnOmsbprwKRG2sOUkBGVc5I5Bh5oHfLj
# HGKijv8+ksoBTyyJaXS9OzPquDycR+NvUgt8vZ6qZDIGMlVCQJk5gRolAG/r0n1C
# OWjZpBW65S5K3pJeMsk4c1BACh2AZ+JF+NAksi0DugQN1sa/IdJ23Rhh4kKZ2N9x
# nFEMWQ7h76aW9Bql7Qz1BMl4+fxOSgDq9VWMVMSnuQIUjKpy1B9/5xDPiYrYM11W
# 3ksZx0NKI4jijJkbDauzOD7j9vsXkPMU9uEB2zq0MI+KMnt4sdD87WosI/UlkPmI
# nIQUttjrV5KFNCI4IE0xTvCK6TPmTddS51trnqOIzayKh/RmzcGmjGh2YWlpcGh4
# VUo0ias1aQL0vGl94WnG5VDugax/JRSHMZ51Kde8grvSVZEdq/X6Wf4L2yXD6Oxb
# JtTSvfKtQ83HN5eY7r6/Dzpwya3/N7bd1sdYW/qpFwrvubcnWvQ+G1YGx+I2Ybdi
# YP1Yl+tx+HZ2sEiPrSiriP7s81/mVdQkcKPBEEBIbaVRfBVXdO27LEK/H2VEIfnk
# nfvsOxGaHWf/NbFXXj7Z6lp2XRlQWyMbn43yCnMVcky/NF/d/knXWRM+74ciMjpX
# SIG # End signature block
