/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree.analysis;

import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.tree.AbstractInsnNode;
import com.eg.org.objectweb.asm.tree.FieldInsnNode;
import com.eg.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import com.eg.org.objectweb.asm.tree.LdcInsnNode;
import com.eg.org.objectweb.asm.tree.MethodInsnNode;
import com.eg.org.objectweb.asm.tree.analysis.Interpreter;
import com.eg.org.objectweb.asm.tree.analysis.SmallSet;
import com.eg.org.objectweb.asm.tree.analysis.SourceValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceInterpreter
extends Interpreter<SourceValue>
implements Opcodes {
    public SourceInterpreter() {
        super(589824);
        if (this.getClass() != SourceInterpreter.class) {
            throw new IllegalStateException();
        }
    }

    protected SourceInterpreter(int n2) {
        super(n2);
    }

    @Override
    public SourceValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new SourceValue(type == null ? 1 : type.getSize());
    }

    @Override
    public SourceValue newOperation(AbstractInsnNode abstractInsnNode) {
        int n2;
        switch (abstractInsnNode.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).cst;
                n2 = object instanceof Long || object instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                n2 = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return new SourceValue(n2, abstractInsnNode);
    }

    @Override
    public SourceValue copyOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        return new SourceValue(sourceValue.getSize(), abstractInsnNode);
    }

    @Override
    public SourceValue unaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        int n2;
        switch (abstractInsnNode.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                n2 = 2;
                break;
            }
            case 180: {
                n2 = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return new SourceValue(n2, abstractInsnNode);
    }

    @Override
    public SourceValue binaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
        int n2;
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return new SourceValue(n2, abstractInsnNode);
    }

    @Override
    public SourceValue ternaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2, SourceValue sourceValue3) {
        return new SourceValue(1, abstractInsnNode);
    }

    @Override
    public SourceValue naryOperation(AbstractInsnNode abstractInsnNode, List<? extends SourceValue> list) {
        int n2 = abstractInsnNode.getOpcode();
        int n3 = n2 == 197 ? 1 : (n2 == 186 ? Type.getReturnType(((InvokeDynamicInsnNode)abstractInsnNode).desc).getSize() : Type.getReturnType(((MethodInsnNode)abstractInsnNode).desc).getSize());
        return new SourceValue(n3, abstractInsnNode);
    }

    @Override
    public void returnOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
    }

    @Override
    public SourceValue merge(SourceValue sourceValue, SourceValue sourceValue2) {
        if (sourceValue.insns instanceof SmallSet && sourceValue2.insns instanceof SmallSet) {
            Set<AbstractInsnNode> set = ((SmallSet)sourceValue.insns).union((SmallSet)sourceValue2.insns);
            if (set == sourceValue.insns && sourceValue.size == sourceValue2.size) {
                return sourceValue;
            }
            return new SourceValue(Math.min(sourceValue.size, sourceValue2.size), set);
        }
        if (sourceValue.size != sourceValue2.size || !SourceInterpreter.containsAll(sourceValue.insns, sourceValue2.insns)) {
            HashSet<AbstractInsnNode> hashSet = new HashSet<AbstractInsnNode>();
            hashSet.addAll(sourceValue.insns);
            hashSet.addAll(sourceValue2.insns);
            return new SourceValue(Math.min(sourceValue.size, sourceValue2.size), hashSet);
        }
        return sourceValue;
    }

    private static <E> boolean containsAll(Set<E> set, Set<E> set2) {
        if (set.size() < set2.size()) {
            return false;
        }
        return set.containsAll(set2);
    }
}

