$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$scriptPath = $egurkhaPath+"\lib"
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
if(Test-Path -Path $GraphDir ){
    $tempLastWriteTime=(Get-Item $unProtPath).LastWriteTime
    $kvalue=Get-Content -Path $GraphDir$keyFileNam
    $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
    $iniFile=$GraphDir+"\GraphDetails.ini"
    $graphDetails=Get-Content -Path $iniFile
    Remove-Item $iniFile
    foreach($line in $graphDetails) {
        Write-Host $line
    }
    Write-Host 'LastWriteTime~'$tempLastWriteTime.tostring("MM/dd/yyyy HH:mm:ss")
}