const fs = require('fs');
const { exec } = require('child_process');

let logPath, cmd;

if (process.argv && process.argv.length) {
  process.argv.forEach(argv => {
    if (argv.indexOf("--log-path") > -1) {
      logPath = argv.split("=")[1];
    } else if (argv.indexOf("--cmd") > -1) {
      const tmp = argv.split("=").slice(1);
      cmd = tmp.join('=');
    }
  });
}
if (!cmd) return;

process._rawDebug("The command is going to run:", cmd);
process._rawDebug("Log file Path:", logPath);

exec(cmd, function (error, stdout) {
  if (!error && !stdout) return;
  const data = "Command: " + cmd + "\n" + (error && error + "\n" || "") + (stdout || "");

  if (!logPath) {
    if (error) console.error(error);
    if (stdout) console.log(stdout);
    return;
  }

  let existingLog = '';
  try {
    existingLog = fs.readFileSync(logPath, 'utf8');
  } catch (e) {
    console.error(e);
  }

  const logMsg = existingLog + '\n' + data;
  fs.writeFile(logPath, logMsg, e => {
    if (e) console.error(e);
  });
});