﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rName=$testargs[4]
$pageLimit=$testargs[5]
$appDetails=$testargs[6]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
$pageSize=5000
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$testINIPath=$egurkhaPath+'\agent\config\eg_tests.ini'
$spamEvnType=Eg-GetINIContent -Path $testINIPath -Subject 'SpamMalWareEventTypes' -Key 'SpamEventType' -Type $encTyp
$malwareEvnType=Eg-GetINIContent -Path $testINIPath -Subject 'SpamMalWareEventTypes' -Key 'MalwareEventType' -Type $encTyp
 
$RprtNameAndmTime=$rName.split("#")
$reportingname=$RprtNameAndmTime[0]
$mTime=$RprtNameAndmTime[1]
$prxyHostNport=$RprtNameAndmTime[2]
$proxyserverip='http://'+$prxyHostNport

if($spamEvnType){
    $spamEvnTypeArr = $spamEvnType.split("#")
}
if($malwareEvnType){
    $malwareEvnTypeArr = $malwareEvnType.split("#")
}
$eventTypes = $spamEvnTypeArr+$malwareEvnTypeArr

#--------------------------------------
$domainSpecific=$false
if($reportingname -match '_exd'){
    $domainSpecific=$true
    $alldomainnames=@()
    $dhash=@{}
    $dmnsPhash=Eg-O635Domains -username $userName -password $Password -rptNam $reportingname -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass -appDetails $appDetails
    $proctArr=$dmnsPhash[$reportingname].split('~')
    $dhash.Add('SupersetName',$proctArr[1])
    $dhash.Add($proctArr[0],$reportingname)
    $reportingname=$dhash['SupersetName']
    foreach($h in $dhash.Keys){
        if($h -ne 'SupersetName'){
            $alldomainnames+=$h
        }
    }
    $ds_MPTr_Key='';$ds_MPTr_fpth='';$ds_MPTr_nam='';
    $ds_MPMl_Key='';$ds_MPMl_fpth='';$ds_MPMl_nam='';
    $ds_MPSpm_Key='';$ds_MPSpm_fpth='';$ds_MPSpm_nam='';
    $ds_MPMsg_Key='';$ds_MPMsg_fpth='';$ds_MPMsg_nam='';
}
$rptPath='EXO/'+$reportingname
$chkwritPath=$egurkhaPath+'/agent/'+$rptPath
if($domainSpecific){ 
    $isWrite=Check-WriteFile -rptPath $chkwritPath -srchWrd 'EXOMailProtection' -mTimInMin $mTime
}
$isProceed=$false
if($isWrite){
    $isProceed=$true
}elseif($domainSpecific -eq $false){
    $isProceed=$true
}else{
    $isProceed=$false
}
#--------------------------------------

if($isProceed){
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $ManualThrottle=0
    [double]$ActiveThrottle=.25
    $ResetSeconds=870
    $WriteLog=$true
    $LogFile = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mailprotection.log"
    $LogFile1 = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mailprotection1.log"
    $isFrstTimLog=$true

    # Writes output to a log file with a time date stamp
    Function Write-Log {
	    Param ([string]$string)
	    [string]$date = Get-Date -Format G
        if ($WriteLog) {
           ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append }
        if($isFrstTimLog){     
            if ($WriteLog -eq $true){ #if flag is true 
                if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                    if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                        Remove-Item $LogFile1 
                    } 
                    Rename-Item $LogFile $LogFile1 
                }
            }
            $isFrstTimLog=$false
        }
    }

    Function Start-SleepWithProgress {
	    Param([int]$sleeptime)
	    For ($i=0;$i -le $sleeptime;$i++){
		    $timeleft = ($sleeptime - $i);
		    Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		    start-sleep 1
	    }
	    Write-Progress -Completed -Activity "Sleeping"
    }

    Function New-CleanO365Session {
        $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
        $i = 0
	    while (($Credential -eq $Null) -and ($i -lt 5)){
		    $script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		    $i++
	    }
	    if ($Credential -eq $null){
		    Write-log "[Error] - Failed to get credentials"
		    Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	    }
	    Write-Log "Removing all PS Sessions"
        $getSession=Get-PSSession -ErrorAction SilentlyContinue
        if($getSession -ne $null -and $getSession -ne ''){
	        Disconnect-ExchangeOnline -Confirm:$false
        }
	    [System.GC]::Collect()
	    Write-Log ("Sleeping 15 seconds for Session Tear Down")
	    Start-SleepWithProgress -SleepTime 15
	    $Error.Clear()
	
	    # Create the session
	    Write-Log "Creating new PS Session"
	    $sessionOption = New-PSSessionOption -SkipRevocationCheck
        if(!$proxyserverip.ToString().ToLower().Contains('none')){
            [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
	        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	            $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	        }
        }

	    # Check for an error while creating the session
	    if ($Error.Count -gt 0){
		    Write-Log "[ERROR] - Error while setting up session"
		    Write-log $Error
		    $ErrorCount++
		    if ($ErrorCount -gt 3){
			    Write-log "[ERROR] - Failed to setup session after multiple tries"
			    Write-log "[ERROR] - Aborting Script"
			    exit
		    }
		    Write-Log "Sleeping 60s so that issue can potentially be resolved"
		    Start-SleepWithProgress -sleeptime 60
		    New-CleanO365Session
	    }
	    else{
		    $ErrorCount = 0
	    }
	
	    # Connect the ExchangeOnline
        if($appDetails -and $appDetails -ne 'none'){
            Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
        }else{
            Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption
	    }
	    # Set the Start time for the current session
	    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
    }

    Function Test-O365Session {
	    $ObjectTime = Get-Date
	    $SessionInfo = $null
	    $SessionInfo = Get-PSSession
	    if ($SessionInfo -eq $null) { 
		    Write-Log "[ERROR] - No Session Found"
		    Write-log "Recreating Session"
		    New-CleanO365Session
	    }	
	    elseif ($SessionInfo.State -ne "Opened"){
		    Write-Log "[ERROR] - Session not in Open State"
		    Write-log ($SessionInfo | fl | Out-String )
		    Write-log "Recreating Session"
		    New-CleanO365Session
	    }
	    elseif (($ObjectTime - $SessionStartTime).totalseconds -gt $ResetSeconds){
		    Write-Log ("Session Has been active for greater than " + $ResetSeconds + " seconds" )
		    Write-Log "Rebuilding Connection"
		    [int]$DelayinSeconds = ((($ResetSeconds * $ActiveThrottle) / 2) - 15)
		    if ($DelayinSeconds -gt 0){
			    Write-Log ("Sleeping " + $DelayinSeconds + " addtional seconds to allow throttle recovery")
			    Start-SleepWithProgress -SleepTime $DelayinSeconds
		    }
		    else{
			    Write-Log ("Active Delay calculated to be " + ($DelayinSeconds + 15) + " seconds no addtional delay needed")
		    }
		    New-CleanO365Session
	    }
	    else {
	    }
	    if ($ManualThrottle -gt 0){
		    Write-log ("Sleeping " + $ManualThrottle + " milliseconds")
		    Start-Sleep -Milliseconds $ManualThrottle
	    }
    }

    Function Get-EstimatedTimeToCompletion {
	    param([int]$ProcessedCount)
	    $ProcessedCount++
	    if (($ProcessedCount % 100) -eq 0){
		    $CurrentDate = Get-Date
		    $AveragePerObject = (((($CurrentDate) - $ScriptStartTime).totalseconds) / $ProcessedCount)
		    Write-Log ("[STATS] - Total Number of Objects:     " + $ObjectCount)
		    Write-Log ("[STATS] - Number of Objects processed: " + $ProcessedCount)
		    Write-Log ("[STATS] - Average seconds per object:  " + $AveragePerObject)
		    Write-Log ("[STATS] - Estimated completion time:   " + $CurrentDate.addseconds((($ObjectCount - $ProcessedCount) * $AveragePerObject)))
	    }
	    return $ProcessedCount
    }


    $rptPath='EXO/'+$reportingname
    $MyDir=$egurkhaPath+'/agent/EXO/'+$reportingname
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    $isErrorOccur= $false

    $endDat = Get-Date
    $startDat = Get-Date -Hour 00 -Minute 00 -Second 00
    $startDat=$startDat.AddMinutes(-1440)
    $startingDat=$endDat.AddMinutes(-$mTime)

    $datTimNow = (Get-Date -Hour ((Get-Date).Hour) -Minute ((Get-Date).Minute) -Second 00).ToUniversalTime()
    $trnrulEdDate=$datTimNow.AddMinutes(-360)
    $trnrulStDate=$trnrulEdDate.AddMinutes(-$mTime)

    Set-StrictMode -Version 2
    $ErrorCount = 0
    New-CleanO365Session
    $ScriptStartTime = Get-Date 
     
    try{
        Test-O365Session
        $Error.Clear()
        #$ruledetail   = Get-MailDetailTransportRuleReport |select EventType,MessageSize,Direction,SenderAddress,RecipientAddress,Date,Domain,Subject,MessageId | Where-Object {$_.Date -gt $startDat} | export-csv $transportRules
        $rulePageval=1
        try{
            $Error.Clear()
            $transportRules = Eg-WriteFile -ComntRptPath $rptPath -FileName "transportrules" -keyFileName "ktransportrules" -EgPath $egurkhaPath
            $trnptflag=$true
            while($trnptflag){
	            $ruleCount=0
	            $ruleDetails=Get-MailDetailTransportRuleReport -StartDate $trnrulStDate -EndDate $trnrulEdDate -page $rulePageval -pagesize $pageSize |select EventType,MessageSize,Direction,SenderAddress,RecipientAddress,Date,Domain,Subject,MessageId,Action,TransportRule
                $ruleDetails|Export-Csv -Append  -LiteralPath $transportRules[1] -Encoding $encTyp
                try{$ruleCount=$ruleDetails.Count}catch{$ruleCount=0} 
                Test-O365Session
                if($ruleCount -lt $pageSize -or ($pageLimit -ne 'all' -and $rulePageval -eq [int]$pageLimit)){
                    $trnptflag=$false
                }
                $rulePageval++
            }
            [System.GC]::GetTotalMemory($true) | out-null
        }
        Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running   TransportRule Report : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true){ #-and (Get-Item $transportRules[1]).length -le 2kb
            if([System.IO.File]::Exists($transportRules[1]) -eq 'True'){
                write-Log (" Deleting file ErrorMessage while running  TransportRule Report  : "+$Error)  
                Remove-Item $transportRules[1]
            }
            $isErrorOccur=$false
        }else{
            $ds_MPTr_Key=$transportRules[0];$ds_MPTr_fpth=$transportRules[1];$ds_MPTr_nam=$transportRules[2];
            $null=Protect-File  $transportRules[1] -Algorithm AES -KeyAsPlainText $transportRules[0] -RemoveSource
        } 

	if($eventTypes){
            Test-O365Session
            $Error.Clear()
            $MalSpamPageval=1
            try{
                $Error.Clear()
                $timenow = [int][double]::Parse((Get-Date -UFormat %s))
                $dir=$egurkhaPath+'/agent/'+$rptPath
                $malSpamDetails = $dir + "\malwarespam"+$timenow +".csv"
                $malSpamflag=$true
                while($malSpamflag){
    	            $MalSpamCount=0
	    	        $MalSpamdata=Get-MailDetailATPReport -StartDate $startDat -EndDate $endDat -page $MalSpamPageval -pagesize $pageSize -EventType $eventTypes
		            $MalSpamdata|Export-Csv -Append  -LiteralPath $malSpamDetails -Encoding $encTyp
                    try{$MalSpamCount=$MalSpamdata.Count }catch{$MalSpamCount=0}
                    Test-O365Session
                    if($MalSpamCount -lt $pageSize -or ($pageLimit -ne 'all' -and $MalSpamPageval -eq [int]$pageLimit)){
                        $malSpamflag=$false
                    }
                    $MalSpamPageval++
                }
                [System.GC]::GetTotalMemory($true) | out-null
            }Catch{
                $ErrorMessage = $_.Exception.Message
                write-Log ("ErrorMessage while running  Malware Spam Report  : "+$ErrorMessage)   
                $isErrorOccur=$true
            }
            if($isErrorOccur -eq $true ){ #-and (Get-Item $malSpamDetails[1]).length -le 200
                if([System.IO.File]::Exists($malSpamDetails[1]) -eq 'True'){ 
                    write-Log (" Deleting File ErrorMessage while running  Malware Spam Report : "+$ErrorMessage)  
                    Remove-Item $malSpamDetails
                }
                $isErrorOccur=$false
            }else{
                try{    
                    $malSpamData = Import-csv $malSpamDetails
                    $malwareData = $malSpamData | Where-Object {$malwareEvnTypeArr -contains $_.EventType}
                    $spamData = $malSpamData | Where-Object {$spamEvnTypeArr -contains $_.EventType}
            
                    $malwareDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "malware" -keyFileName "kmalware" -EgPath $egurkhaPath
                    $malwareData | Export-Csv -Append  -LiteralPath $malwareDetails[1]
                    $ds_MPMl_Key=$malwareDetails[0];$ds_MPMl_fpth=$malwareDetails[1];$ds_MPMl_nam=$malwareDetails[2];
                    $null=Protect-File  $malwareDetails[1] -Algorithm AES -KeyAsPlainText $malwareDetails[0] -RemoveSource
                
                    $spamDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "spam" -keyFileName "kspam" -EgPath $egurkhaPath
                    $spamData | Export-Csv -Append  -LiteralPath $spamDetails[1]
                    $ds_MPSpm_Key=$spamDetails[0];$ds_MPSpm_fpth=$spamDetails[1];$ds_MPSpm_nam=$spamDetails[2];
                    $null=Protect-File  $spamDetails[1] -Algorithm AES -KeyAsPlainText $spamDetails[0] -RemoveSource
                    if([System.IO.File]::Exists($malSpamDetails[1]) -eq 'True'){
                        Remove-Item $malSpamDetails
                    }
                }Catch{
                    $ErrorMessage = $_.Exception.Message
                    write-Log ("ErrorMessage while running  Malware Spam Report  : "+$ErrorMessage)   
                    $isErrorOccur=$true
                } 
            }
        }

	<#
        Test-O365Session
        $Error.Clear()
        $MalwarePageval=1
        try{
            $Error.Clear()
            $malwareDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "malware" -keyFileName "kmalware" -EgPath $egurkhaPath
            $malwareflag=$true
            while($malwareflag){
	            $MalwareCount=0
		        $Malwaredata=Get-MailDetailMalwareReport -StartDate $startDat -EndDate $endDat -page $MalwarePageval -pagesize $pageSize |select Date,SenderAddress,RecipientAddress,MessageSize,Direction,EventType,MalwareName,FileName
		        $Malwaredata|Export-Csv -Append  -LiteralPath $malwareDetails[1] -Encoding $encTyp
                try{$MalwareCount=$Malwaredata.Count }catch{$MalwareCount=0}
                Test-O365Session
                if($MalwareCount -lt $pageSize -or ($pageLimit -ne 'all' -and $MalwarePageval -eq [int]$pageLimit)){
                    $malwareflag=$false
                }
                $MalwarePageval++
            }
            [System.GC]::GetTotalMemory($true) | out-null
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  Malware Report  : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true ){ #-and (Get-Item $malwareDetails[1]).length -le 200
            if([System.IO.File]::Exists($malwareDetails[1]) -eq 'True'){
                write-Log (" Deleting File ErrorMessage while running  Malware Report : "+$ErrorMessage)  
                Remove-Item $malwareDetails[1]
            }
            $isErrorOccur=$false
        }else{
            $ds_MPMl_Key=$malwareDetails[0];$ds_MPMl_fpth=$malwareDetails[1];$ds_MPMl_nam=$malwareDetails[2];
            $null=Protect-File  $malwareDetails[1] -Algorithm AES -KeyAsPlainText $malwareDetails[0] -RemoveSource
        }

        Test-O365Session
        $SpamPageval=1
        try{
            $Error.Clear()
            $spamDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "spam" -keyFileName "kspam" -EgPath $egurkhaPath
            $spmflag=$true
            while($spmflag){
	            $spamCount=0
		        $spamdata=Get-MailDetailSpamReport -StartDate $startDat -EndDate $endDat -page $SpamPageval -pagesize $pageSize |select -Property @{Name='Current Date';Expression={$endDat}},Date,SenderAddress,RecipientAddress,MessageSize,Direction,EventType,Subject,MessageTraceId,Domain,Organization,MessageId 
		        $spamdata|Export-Csv -Append  -LiteralPath $spamDetails[1] -Encoding $encTyp
		        try{$spamCount=$spamdata.Count}catch{$spamCount=0}
                Test-O365Session
                if($spamCount -lt $pageSize -or ($pageLimit -ne 'all' -and $SpamPageval -eq [int]$pageLimit)){
                    $spmflag=$false
                }
                $SpamPageval++
            }
            [System.GC]::GetTotalMemory($true) | out-null
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  spam Details : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true){ #-and (Get-Item $spamDetails[1]).length -le 2kb
            if([System.IO.File]::Exists($spamDetails[1]) -eq 'True'){
                write-Log ("Deleting file ErrorMessage while running   spam Details : "+$Error)  
                Remove-Item $spamDetails[1]
            } 
            $isErrorOccur=$false
        }else{
            $ds_MPSpm_Key=$spamDetails[0];$ds_MPSpm_fpth=$spamDetails[1];$ds_MPSpm_nam=$spamDetails[2];
            $null=Protect-File  $spamDetails[1] -Algorithm AES -KeyAsPlainText $spamDetails[0] -RemoveSource
        } 
	#>

        Test-O365Session
        $val=1
        try{
            $Error.Clear()
            $MsgTrace = Eg-WriteFile -ComntRptPath $rptPath -FileName "msgs" -keyFileName "kmsgs" -EgPath $egurkhaPath
            $msgflag=$true
            while($msgflag){
                $count=0
                $output=Get-MessageTrace -StartDate $startingDat -EndDate $endDat -page $val -pagesize $pageSize | select-object senderaddress ,RecipientAddress ,FromIP ,ToIP ,Size ,Status, Subject, Received
                $output | Export-Csv -Append  -LiteralPath $MsgTrace[1] -Encoding $encTyp
                try{$count=$output.Count}catch{$count=0}
                Test-O365Session
                if($count -lt $pageSize -or ($pageLimit -ne 'all' -and $val -eq [int]$pageLimit)){
                    $msgflag=$false
                }
                $val++
            }
            [System.GC]::GetTotalMemory($true) | out-null
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  Message Trace : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true){ #-and (Get-Item $MsgTrace[1]).length -le 2kb
            if([System.IO.File]::Exists($MsgTrace[1]) -eq 'True'){
                write-Log ("Deleting File ErrorMessage while running   Message Trace : "+$Error)  
                Remove-Item $MsgTrace[1]
            }
            $isErrorOccur=$false
        }else{
            $ds_MPMsg_Key=$MsgTrace[0];$ds_MPMsg_fpth=$MsgTrace[1];$ds_MPMsg_nam=$MsgTrace[2];
            $null=Protect-File  $MsgTrace[1] -Algorithm AES -KeyAsPlainText $MsgTrace[0] -RemoveSource
        } 
    }
    catch{
        $ErrorMessage = $_.Exception.Message
        $FailedItem = $_.Exception.ItemName
        write-log "ErrorMessage : " + $ErrorMessage   
        write-log "FailedItem : " + $FailedItem
    } 
    Write-Log "Script Complete Destroying PS Sessions"
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Disconnect-ExchangeOnline -Confirm:$false
    }
    [System.GC]::GetTotalMemory($true) | out-null
}

if($domainSpecific){
    #------------- 1.For Domain Specific - transportrules ----------------------
    if($ds_MPTr_fpth -ne ''){
        $mptrFilePth=$ds_MPTr_fpth -replace (".csv",".dat")   
        if((Get-Item -Path $mptrFilePth).Length -gt 2KB){
            $null=Unprotect-File $mptrFilePth -Algorithm AES -KeyAsPlainText $ds_MPTr_Key
            $tpRls= import-csv $ds_MPTr_fpth -Encoding $encTyp
            $trnam=$ds_MPTr_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$trnam
                foreach($tmpRes in $tpRls){
                    $chkAddres='';$addrs=$tmpRes.Domain
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.Domain -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append -Encoding $encTyp
                    }
                }
                if($isAddContent){
                    $knam=$trnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPTr_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPTr_Key -RemoveSource
                }
            }
        }
    }

    #------------- 2.For Domain Specific - malware ----------------------
    if($ds_MPMl_fpth -ne ''){
        $mpmlFilePth=$ds_MPMl_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpmlFilePth).Length -gt 200){
            $null=Unprotect-File $mpmlFilePth -Algorithm AES -KeyAsPlainText $ds_MPMl_Key
            $mwDtls= import-csv $ds_MPMl_fpth -Encoding $encTyp
            $mwnam=$ds_MPMl_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$mwnam
                foreach($tmpRes in $mwDtls){
                    $sendrChkAddres='';$addrs=$tmpRes.SenderAddress
                    if($addrs.Contains('@')){
                        $sendrChkAddres=$addrs.Split('@')[1]
                    }
                    $recpChkAddres='';$recpAddrs=$tmpRes.RecipientAddress
                    if($recpAddrs.Contains('@')){
                        $recpChkAddres=$recpAddrs.Split('@')[1]
                    }
                    
                    #if($tmpRes.SenderAddress -match $domain -or $tmpRes.RecipientAddress -match $domain){
                    if($domain -match $sendrChkAddres -or $domain -match $recpChkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append -Encoding $encTyp
                    }
                }
                if($isAddContent){
                    $knam=$mwnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPMl_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPMl_Key -RemoveSource
                }
            }
        }
    }

    #------------- 3.For Domain Specific - spam ----------------------
    if($ds_MPSpm_fpth -ne ''){
        $mpspmFilePth=$ds_MPSpm_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpspmFilePth).Length -gt 2KB){
            $null=Unprotect-File $mpspmFilePth -Algorithm AES -KeyAsPlainText $ds_MPSpm_Key
            $spmDtls= import-csv $ds_MPSpm_fpth -Encoding $encTyp
            $spmnam=$ds_MPSpm_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$spmnam
                foreach($tmpRes in $spmDtls){
                    $chkAddres='';$addrs=$tmpRes.Domain
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.Domain -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append -Encoding $encTyp
                    }
                }
                if($isAddContent){
                    $knam=$spmnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPSpm_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPSpm_Key -RemoveSource
                }
            }
        }
    }

    #------------- 4.For Domain Specific - msgs ----------------------
     if($ds_MPMsg_fpth -ne ''){
        $mpmsgFilePth=$ds_MPMsg_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpmsgFilePth).Length -gt 2KB){
            $null=Unprotect-File $mpmsgFilePth -Algorithm AES -KeyAsPlainText $ds_MPMsg_Key
            $mtDtls= import-csv $ds_MPMsg_fpth -Encoding $encTyp
            $mtnam=$ds_MPMsg_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$mtnam
                foreach($tmpRes in $mtDtls){
                    $sendrChkAddres='';$sendrAddrs=$tmpRes.SenderAddress
                    if($sendrAddrs.Contains('@')){
                        $sendrChkAddres=$sendrAddrs.Split('@')[1]
                    }
                    $recpChkAddres='';$recpAddrs=$tmpRes.RecipientAddress
                    if($recpAddrs.Contains('@')){
                        $recpChkAddres=$recpAddrs.Split('@')[1]
                    }
                    if($domain -match $sendrChkAddres -or $domain -match $recpChkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append -Encoding $encTyp
                    }
                }
                if($isAddContent){
                    $knam=$mtnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPMsg_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPMsg_Key -RemoveSource
                }
            }
        }
    }
}

$csvDir=$egurkhaPath+'/agent/EXO/'+$reportingname+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'transportrules'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'malware'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'spam'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'msgs'
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlcgYJKoZIhvcNAQcCoIIlYzCCJV8CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCAz/FWygXu0E9DZ
# wKGcPiuEw61pGel9lqKooDQ6H/Nho6CCHnQwggUwMIIEGKADAgECAhAECRgbX9W7
# ZnVTQ7VvlVAIMA0GCSqGSIb3DQEBCwUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNV
# BAMTG0RpZ2lDZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0xMzEwMjIxMjAwMDBa
# Fw0yODEwMjIxMjAwMDBaMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3
# DQEBAQUAA4IBDwAwggEKAoIBAQD407Mcfw4Rr2d3B9MLMUkZz9D7RZmxOttE9X/l
# qJ3bMtdx6nadBS63j/qSQ8Cl+YnUNxnXtqrwnIal2CWsDnkoOn7p0WfTxvspJ8fT
# eyOU5JEjlpB3gvmhhCNmElQzUHSxKCa7JGnCwlLyFGeKiUXULaGj6YgsIJWuHEqH
# CN8M9eJNYBi+qsSyrnAxZjNxPqxwoqvOf+l8y5Kh5TsxHM/q8grkV7tKtel05iv+
# bMt+dDk2DZDv5LVOpKnqagqrhPOsZ061xPeM0SAlI+sIZD5SlsHyDxL0xY4PwaLo
# LFH3c7y9hbFig3NBggfkOItqcyDQD2RzPJ6fpjOp/RnfJZPRAgMBAAGjggHNMIIB
# yTASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
# BggrBgEFBQcDAzB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
# Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHow
# eDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBPBgNVHSAESDBGMDgGCmCGSAGG/WwA
# AgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAK
# BghghkgBhv1sAzAdBgNVHQ4EFgQUWsS5eyoKo6XqcQPAYPkt9mV1DlgwHwYDVR0j
# BBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQELBQADggEBAD7s
# DVoks/Mi0RXILHwlKXaoHV0cLToaxO8wYdd+C2D9wz0PxK+L/e8q3yBVN7Dh9tGS
# dQ9RtG6ljlriXiSBThCk7j9xjmMOE0ut119EefM2FAaK95xGTlz/kLEbBw6RFfu6
# r7VRwo0kriTGxycqoSkoGjpxKAI8LpGjwCUR4pwUR6F6aGivm6dcIFzZcbEMj7uo
# +MUSaJ/PQMtARKUT8OZkDCUIQjKyNookAv4vcn4c10lFluhZHen6dGRrsutmQ9qz
# sIzV6Q3d9gEgzpkxYz0IGhizgZtPxpMQBvwHgfqL2vmCSfdibqFT+hKUGIUukpHq
# aGxEMrJmoecYpJpkUe8wggWNMIIEdaADAgECAhAOmxiO+dAt5+/bUOIIQBhaMA0G
# CSqGSIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNVBAMTG0RpZ2lDZXJ0
# IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAwMDBaFw0zMTExMDkyMzU5
# NTlaMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
# BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQg
# Um9vdCBHNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL/mkHNo3rvk
# XUo8MCIwaTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3EMB/zG6Q4FutWxpdt
# HauyefLKEdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iTcMKyunWZanMylNEQRBAu
# 34LzB4TmdDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsFxl7sWxq868nPzaw0
# QF+xembud8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclPXuU15zHL2pNe3I6PgNq2
# kZhAkHnDeMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJBMtfbBHMqbpEBfCFM
# 1LyuGwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFPObURWBf3JFxGj2T3wWmI
# dph2PVldQnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTvkpI6nj3cAORFJYm2mkQZ
# K37AlLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWMcCxBYKqxYxhElRp2Yn72
# gLD76GSmM9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls5Q5SUUd0viastkF13nqs
# X40/ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+xq4aLT8LWRV+dIPyh
# HsXAj6KxfgommfXkaS+YHS312amyHeUbAgMBAAGjggE6MIIBNjAPBgNVHRMBAf8E
# BTADAQH/MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwPTzAfBgNVHSMEGDAW
# gBRF66Kv9JLLgjEtUYunpyGd823IDzAOBgNVHQ8BAf8EBAMCAYYweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwRQYDVR0fBD4wPDA6oDigNoY0aHR0cDovL2NybDMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDARBgNVHSAE
# CjAIMAYGBFUdIAAwDQYJKoZIhvcNAQEMBQADggEBAHCgv0NcVec4X6CjdBs9thbX
# 979XB72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQTSnovLbc47/T/gLn4offy
# ct4kvFIDyE7QKt76LVbP+fT3rDB6mouyXtTP0UNEm0Mh65ZyoUi0mcudT6cGAxN3
# J0TU53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSwuKFWjuyk1T3osdz9HNj0
# d1pcVIxv76FQPfx2CWiEn2/K2yCNNWAcAgPLILCsWKAOQGPFmCLBsln1VWvPJ6ts
# ds5vIy30fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjDTZ9ztwGpn1eqXijiuZQw
# ggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUxMA0GCSqGSIb3DQEBCwUAMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAwMDAwWhcNMjQwNTI5MjM1OTU5
# WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEPMA0GA1UEBxMG
# SXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9ucywgSW5jLjEdMBsGA1UEAxMU
# ZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIK
# AoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDfAZHYpsPdplqB5IT6QbS0qQSx
# Didrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+YS+YrEJuIkVMKkqSZnixrkFl8
# 7uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V4g1eGBDbFnpOMQr6luGqZVe+
# vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPOSFlJl90K0a0S8Tmkt6xdJZ+n
# NR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8n8o1gCRQIvbeueHfz+ZrG1K9
# 16KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAkijRkSxTIMA2nskgiMx4/Ow4x
# jN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rkuy0ZBE1s42OmwIFMSBm7AR+R
# 05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+jx4PzUTlUNCqYmIZYqr+z2OF
# uRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMGlp7fHai/li+NjxmjxEXS1e/J
# LSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUeYAfqTTIUeZZgKhQA1sEHRhH+
# Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uGZeg8IFyjQQIDAQABo4IBxDCC
# AcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFPnI
# RJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggr
# BgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwSwYDVR0gBEQwQjA2Bglg
# hkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20v
# Q1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2MCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUHMAKGQmh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1cmVkSURDb2RlU2lnbmluZ0NB
# LmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQCUCOdwU+8srLBP
# /gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/KnELeD4StX3JFXz5ddILA5oon
# e/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5zmRFGm8WxDZdI20ztcvW0sOb
# qn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53w7pWG170nktocFWTeUhkAy0f
# oAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkoxV9ldaXJ8Px1navd6PpDW4A78
# 1u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5SsCr29MlpK8UxK9y2Qmb+jEt
# RxR0QZLfMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipeWzANBgkqhkiG9w0B
# AQsFADBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVk
# IFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYD
# VQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lD
# ZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBMIIC
# IjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUDxPKR
# N6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo+n3znIkLf50fng8zH1ATCyZz
# lm34V6gCff1DtITaEfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
# LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald68Dd5n12sy+iEZLRS8nZH
# 92GDGd1ftFQLIWhuNyG7QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRA
# p8ByxbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWHpo9OdhVVJnCYJn+g
# GkcgQ+NDY4B7dW4nJZCYOjgRs/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU
# 8lKVEStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/8KI8ykLcGEh/
# FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwj
# jVj33GHek/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKowSYI+RQQ
# EgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXiYKNYCQEoAA6EVO7O6V3IXjASvUae
# tdN2udIOa5kM0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8CAQAw
# HQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshvMB8GA1UdIwQYMBaAFOzX44LS
# cV1kTN8uZz/nupiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
# BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
# Z2ljZXJ0LmNvbTBBBggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0fBDwwOjA4oDagNIYy
# aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
# cmwwIAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEB
# CwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftw
# ig2qKWn8acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwIgqgWvalW
# zxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQm
# h2ySvZ180HAKfO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSumScb
# qyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7pp1yr8THwcFqcdnGE4AJxLaf
# zYeHJLtPo0m5d2aR8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
# Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6umAU+9Pzt4rUyt+8SVe+0K
# XzM5h0F4ejjpnOHdI/0dKNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm
# 8heZWcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVBtzrVFZgxtGIJDwq9
# gdkT/r+k0fNX2bwE+oLeMt8EifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8a
# pIUP/JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8/DCCBsIwggSq
# oAMCAQICEAVEr/OUnQg5pr/bP1/lYRYwDQYJKoZIhvcNAQELBQAwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
# MzA3MTQwMDAwMDBaFw0zNDEwMTMyMzU5NTlaMEgxCzAJBgNVBAYTAlVTMRcwFQYD
# VQQKEw5EaWdpQ2VydCwgSW5jLjEgMB4GA1UEAxMXRGlnaUNlcnQgVGltZXN0YW1w
# IDIwMjMwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCjU0WHHYOOW6w+
# VLMj4M+f1+XS512hDgncL0ijl3o7Kpxn3GIVWMGpkxGnzaqyat0QKYoeYmNp01ic
# NXG/OpfrlFCPHCDqx5o7L5Zm42nnaf5bw9YrIBzBl5S0pVCB8s/LB6YwaMqDQtr8
# fwkklKSCGtpqutg7yl3eGRiF+0XqDWFsnf5xXsQGmjzwxS55DxtmUuPI1j5f2kPT
# hPXQx/ZILV5FdZZ1/t0QoRuDwbjmUpW1R9d4KTlr4HhZl+NEK0rVlc7vCBfqgmRN
# /yPjyobutKQhZHDr1eWg2mOzLukF7qr2JPUdvJscsrdf3/Dudn0xmWVHVZ1KJC+s
# K5e+n+T9e3M+Mu5SNPvUu+vUoCw0m+PebmQZBzcBkQ8ctVHNqkxmg4hoYru8QRt4
# GW3k2Q/gWEH72LEs4VGvtK0VBhTqYggT02kefGRNnQ/fztFejKqrUBXJs8q818Q7
# aESjpTtC/XN97t0K/3k0EH6mXApYTAA+hWl1x4Nk1nXNjxJ2VqUk+tfEayG66B80
# mC866msBsPf7Kobse1I4qZgJoXGybHGvPrhvltXhEBP+YUcKjP7wtsfVx95sJPC/
# QoLKoHE9nJKTBLRpcCcNT7e1NtHJXwikcKPsCvERLmTgyyIryvEoEyFJUX4GZtM7
# vvrrkTjYUQfKlLfiUKHzOtOKg8tAewIDAQABo4IBizCCAYcwDgYDVR0PAQH/BAQD
# AgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
# KXaaL3WMaiCPnshvMB0GA1UdDgQWBBSltu8T5+/N0GSh1VapZTGj3tXjSTBaBgNV
# HR8EUzBRME+gTaBLhklodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRU
# cnVzdGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0EuY3JsMIGQBggrBgEF
# BQcBAQSBgzCBgDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# MFgGCCsGAQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqG
# SIb3DQEBCwUAA4ICAQCBGtbeoKm1mBe8cI1PijxonNgl/8ss5M3qXSKS7IwiAqm4
# z4Co2efjxe0mgopxLxjdTrbebNfhYJwr7e09SI64a7p8Xb3CYTdoSXej65CqEtcn
# hfOOHpLawkA4n13IoC4leCWdKgV6hCmYtld5j9smViuw86e9NwzYmHZPVrlSwrad
# OKmB521BXIxp0bkrxMZ7z5z6eOKTGnaiaXXTUOREEr4gDZ6pRND45Ul3CFohxbTP
# mJUaVLq5vMFpGbrPFvKDNzRusEEm3d5al08zjdSNd311RaGlWCZqA0Xe2VC1UIyv
# Vr1MxeFGxSjTredDAHDezJieGYkD6tSRN+9NUvPJYCHEVkft2hFLjDLDiOZY4rbb
# PvlfsELWj+MXkdGqwFXjhr+sJyxB0JozSqg21Llyln6XeThIX8rC3D0y33XWNmda
# ifj2p8flTzU8AL2+nCpseQHc2kTmOt44OwdeOVj0fHMxVaCAEcsUDH6uvP6k63ll
# qmjWIso765qCNVcoFstp8jKastLYOrixRoZruhf9xHdsFWyuq69zOuhJRrfVf8y2
# OMDY7Bz1tqG4QyzfTkx9HmhwwHcK1ALgXGC7KP845VJa1qwXIiNO9OzTF/tQa/8H
# dx9xl0RBybhG02wyfFgvZ0dl5Rtztpn5aywGRu9BHvDwX+Db2a2QgESvgBBBijGC
# BlQwggZQAgEBMIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0
# IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl6tv4
# NTEwDQYJYIZIAWUDBAIBBQCgfDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0B
# CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAv
# BgkqhkiG9w0BCQQxIgQginZphMqkq/zneBEwZKs1tlwa4GlNCLrcWP1I4+kZ+jQw
# DQYJKoZIhvcNAQEBBQAEggIAwJ1F5BpC/fLUL+0CGehrnEYqari0oT4fHoGMhK2a
# fM9PCJOuHewINHHShzFXR8o4xfIE6VmJq3DBNpRHCjVKZXBahfaSjUHUby4Ik1AJ
# NASVMwbtNwKgeLvZnWzcC3XBqh0fLh7d9RSiUgHsJwP9dNHgCy2wajkWVoLQKmcG
# t+4cSzA0F5mMre1T2l7VRNriqtMVg5ujKv7FmO2hBuGF+So9de0l7HEsJ6VxSgZx
# zAjRy67TfQMRDyZtNn6SAoaY95GQgWLkDI2W/3aaJVCqOcM3bbKIpNtbb0UCMqpP
# fjEHeLrLG5uWjHrhRQrQkT2M/RVGedt02WP0UX4Ikc8/cLO0jK0lUyUjOHs2TYPv
# VJZPdb0nXs2smaAiNhnFyKUlFgpPgA0APl7AHy+RmGs7AUi6pt63nPsYfGhIkSUQ
# 0XGAi97WwmKxvKZNNONXaZcoo+ceqPAeJKsKbIXoW1DB8lm1vpNL6r7xrqm+A332
# VSifp9as6cV+v0cCjto4xNt2y7JS4dkq/DwBnijgCppGNONY0noOyhEVO1Q9BmY6
# NXPD754b47DqIJsnxgXaiTspU+D2weGxiBfDuF0QUT/gOcgC43fRdk6NZT4jrACO
# +IyRJIfIgHoZCtkWO/pS2PSWX7hJtEcfpI2fRu+ESnF0zNHFo73MdM7vCOokiEHN
# MkWhggMgMIIDHAYJKoZIhvcNAQkGMYIDDTCCAwkCAQEwdzBjMQswCQYDVQQGEwJV
# UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRy
# dXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAFRK/zlJ0I
# Oaa/2z9f5WEWMA0GCWCGSAFlAwQCAQUAoGkwGAYJKoZIhvcNAQkDMQsGCSqGSIb3
# DQEHATAcBgkqhkiG9w0BCQUxDxcNMjMwODEwMDkxNjI0WjAvBgkqhkiG9w0BCQQx
# IgQg/vbma5OxiQoJifUrz6p1k60p+22qHijgotP6LnUYKfMwDQYJKoZIhvcNAQEB
# BQAEggIAZCDx2KkSqI4l53BN8NyGy8OHRMHqpbY60Atm3LW+8jZIx+SAziTFJCIr
# 1sT99VP7rWdIiYl73CYX2XlP/qJwOoZkI9AJZAmuHAzOpVBJ8HqpvrkdvTP1m8d7
# TD333uSigsLajHA3/nsHu1AxuHDCvOUz3YgqfSEKp9JA/vS4ZREo+jDnnPwN0ZIP
# FlgTL1NI+BbT1WNFfL5EWzSs8ETpovTu4Fl/MmSn/k8z7h0SNNolS6ZZ72Vh0lWJ
# s764e5JHqv2Ymd2oXPaxYfxCgO/ZKesZFkMWkeL+q76LKz8DAQiS8pOl5moSe4nR
# gkM2Hg1Zr+ONPGHjSY4JREPsXlel9GdheeQMCUsdYsjLf20Hkyvs/xeQ0EPnV4Ck
# jhK3kTeisnFSY8reScC+8x4Yy/sgifqWcosNSWDHFZi5qNOBf4lNgdQaHP9FzR7u
# bQpf1/JwDEO1dtdcQBE9TLqxN/+O1gDuRLKD/LrQdxypqfid+bFjeWbhXu4W2Jwy
# fzVLI4PVwZH2q1I9IdsS/JqWNsWJ9xmPBTmYRal6riA7VxfB6lb8JMw/Np+hBcru
# o9hdTwpGuaTI8HMuaiB6QO7LTDxXMqpq73+PYr61ytoTjk6/gA6kFMfYvJDG264Z
# esuY58p57Ukw3cs2JQ6Bvb1ujjfkXhz5IO4vUPcntW85COc+I8s=
# SIG # End signature block
