/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgDiscInfo;
import com.eg.EgExternalInfo;
import com.eg.EgInstallInfo;
import com.eg.EgServicesInfo;
import com.eg.EgSpecsInfo;
import com.eg.EgTesterInfo;
import com.eg.EgThresholdInfo;
import com.eg.EgUtils;
import com.eg.IniFile;
import com.eg.SmIniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class EgAggregateInfo {
    private static boolean isAgent = false;
    private static String entity = null;
    private static String aggregateFileName;
    private static String topoFileName;
    private static File aggregateFile;
    private static IniFile aggregateFilePtr;
    public static long lastModifiedTime;
    public static long lastSize;
    public static long newTime;
    public static long length;
    public static final String aggTest = "AGGREGATE_TEST";
    public static final String preDefinedAggTest = "PRE_DEFINED_AGGREGATE_TEST";
    public static final String aggFunction = "AGGREGATE_FUNCTION";
    public static final String groupFunction = "GROUP_FUNCTIONS";
    public static final String aggComponent = "AGGREGATE_COMPONENTS";
    public static final String compTypeMapping = "COMPONENT_TYPE_MAPPING";
    public static final String testInfoExclude = "AGGREGATE_TEST_INFOS_EXCLUDED";
    public static final String aggType = "AGGREGATE_TYPES";
    public static final String NO_AGGREGATE_SUPPORT_TYPES = "NO_AGGREGATE_SUPPORT_TYPES";
    public static final String columnNameMapping = "COLUMN_NAME_MAPPING";
    public static final String componentMetricView = "COMPONENT_METRIC_VIEW";
    public static final String siteSupport = "SITE_SUPPORT";
    public static final String compAssociation = "COMPONENT_ASSOCIATION";
    public static final String uiCompAssociation = "UI_COMPONENT_ASSOCIATION";
    public static final String siteAggregateTest = "SITE_AGGREGATE_TEST";
    public static final String set_zero_measure = "SET_ZERO_MEASURE";
    public static final String anchorComponent = "ANCHOR_COMPONENT";
    public static final String ANCHOR_COMPONENT_SETTINGS = "ANCHOR_COMPONENT_SETTINGS";
    public static final String COMPARISON = "COMPARISON";
    public static final String userdefinedTemplates = "USERDEFINED_TEMPLATES";
    public static String configDir;
    private static EgServicesInfo egser;
    private static EgSpecsInfo specs;
    public static Vector preDefinedAggregateTests;
    private static EgTesterInfo testerInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EgAggregateInfo(String string) {
        if (entity != null) return;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            if (entity != null) return;
            entity = string;
            if (string.equalsIgnoreCase("manager")) {
                configDir = EgConfigInfo.egMgrConfigDir;
                egser = new EgServicesInfo("manager");
                specs = new EgSpecsInfo("manager");
            } else {
                configDir = EgConfigInfo.egAgentConfigDir;
            }
            aggregateFileName = new String(configDir + "eg_aggregate.ini");
            topoFileName = new String(configDir + "eg_topology.ini");
            aggregateFile = new File(aggregateFileName);
            lastModifiedTime = this.lastModified();
            lastSize = this.lastSize();
            aggregateFilePtr = new IniFile(aggregateFileName);
            this.init();
            isAgent = entity.equalsIgnoreCase("agent");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public EgAggregateInfo() {
        this("agent");
    }

    public long lastModified() {
        if (isAgent) {
            return aggregateFile.lastModified();
        }
        return IniFile.getLastModified(aggregateFileName);
    }

    public long lastSize() {
        if (isAgent) {
            return aggregateFile.length();
        }
        return IniFile.getLastSize(aggregateFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        boolean bl = true;
        if (EgInstallInfo.isSuperManager && SmIniFile.modifyIniList.contains("eg_aggregate.ini")) {
            bl = false;
            SmIniFile.modifyIniList.remove("eg_aggregate.ini");
        }
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (bl && l == lastModifiedTime && l2 == length) {
            return false;
        }
        String string = aggComponent;
        synchronized (aggComponent) {
            newTime = this.lastModified();
            length = this.lastSize();
            if (bl && newTime == lastModifiedTime && lastSize == length) {
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return false;
            }
            lastModifiedTime = newTime;
            lastSize = length;
            aggregateFilePtr = new IniFile(aggregateFileName);
            preDefinedAggregateTests.clear();
            this.updatePreDefinedAggregateTests();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String string = aggComponent;
        synchronized (aggComponent) {
            if (aggregateFile == null) {
                aggregateFile = new File(aggregateFileName);
            }
            newTime = this.lastModified();
            length = this.lastSize();
            lastModifiedTime = newTime;
            lastSize = length;
            aggregateFilePtr = new IniFile(aggregateFileName);
            preDefinedAggregateTests.clear();
            this.updatePreDefinedAggregateTests();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getValue(String string, String string2) {
        return this.getValue(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String string, String string2, boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String string3 = null;
        String string4 = aggComponent;
        synchronized (aggComponent) {
            string3 = aggregateFilePtr.getValue(string, string2);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllValues(String string) {
        Vector vector = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getAllValues(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = aggComponent;
        synchronized (aggComponent) {
            bl = aggregateFilePtr.setValue(string, string2, string3);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubject(String string) {
        String string2 = aggComponent;
        synchronized (aggComponent) {
            aggregateFilePtr.deleteSubject(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValue(String string, String string2) {
        String string3 = aggComponent;
        synchronized (aggComponent) {
            aggregateFilePtr.deleteValue(string, string2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariables(String string) {
        this.checkForUpdate();
        String[] stringArray = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            stringArray = aggregateFilePtr.getVariables(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getVariables(String string, boolean bl) {
        this.checkForUpdate();
        Vector vector = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getVariables(string, true);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        String string = aggComponent;
        synchronized (aggComponent) {
            aggregateFilePtr.saveFile();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.init();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupFunctions() {
        this.checkForUpdate();
        Object[] objectArray = null;
        String[] stringArray = this.getVariables(groupFunction);
        Vector vector = null;
        String string = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getAllValues(groupFunction);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("Function")) continue;
                    String string2 = (String)vector.get(i);
                    Vector<String> vector2 = new Vector<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (string3.equals("pct")) continue;
                        vector2.add(string3);
                    }
                    objectArray = new String[vector2.size()];
                    vector2.copyInto(objectArray);
                    break;
                }
                if (objectArray != null && objectArray.length > 0) {
                    Arrays.sort(objectArray);
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestName(String string) {
        this.checkForUpdate();
        String string2 = null;
        String[] stringArray = this.getVariables(aggTest);
        Vector vector = null;
        String string3 = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getAllValues(aggTest);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(string)) continue;
                    string2 = (String)vector.get(i);
                    break;
                }
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getMeasurementsName(String string) {
        Vector<String> vector = null;
        this.checkForUpdate();
        String[] stringArray = this.getVariables(aggFunction);
        Vector vector2 = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector2 = aggregateFilePtr.getAllValues(aggFunction);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].startsWith(string + ":")) continue;
                    vector.add((String)vector2.get(i));
                }
            }
            return vector;
        }
    }

    public Double getMinValue(ArrayList arrayList) {
        double d = 0.0;
        int n = 0;
        if (n < arrayList.size()) {
            double d2 = (Double)arrayList.get(n);
            for (int i = n + 1; i < arrayList.size(); ++i) {
                double d3 = (Double)arrayList.get(n);
                if (!(d2 > d3)) continue;
                d2 = d3;
            }
            d = d2;
        }
        return new Double(d);
    }

    public Vector getServerTypeRelevantForTest(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = egser.getAllServerTypes();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = specs.isTestRelevantForServer(stringArray[i], string);
                if (!bl) continue;
                vector.add(stringArray[i]);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public boolean manageAggregateComponent(String string) {
        boolean bl = false;
        int n = string.indexOf(":");
        if (n > 0 && string.lastIndexOf(":") > n) {
            String[] stringArray = this.getVariables(aggComponent);
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string2 = stringArray[i];
                String string3 = "";
                if (!string2.startsWith("#Unmanage") || string2.lastIndexOf("#") <= 0 || (n2 = string2.indexOf("|")) < 0 || !string.equals(string3 = string2.substring(n2 + 1, string2.lastIndexOf("#")))) continue;
                String string4 = string2.substring(n2 + 1);
                this.setValue(aggComponent, string4, "associated");
                this.deleteValue(aggComponent, string2);
                bl = true;
            }
            this.saveFile();
        }
        return bl;
    }

    public List getComponentsForDb(String string, String string2, String string3, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list2 = new ArrayList();
        Vector vector = egser.getHostSysTest();
        boolean bl = vector.contains(string3);
        String string4 = string + ":" + string2;
        int n = list.size();
        if (list != null && n > 0) {
            String[] stringArray;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                stringArray = (String[])listIterator.next();
                boolean bl2 = specs.isTestRelevantForServer((String)stringArray, string3);
                if (bl2) continue;
                listIterator.remove();
            }
            if (list != null && list.size() > 0) {
                stringArray = this.getVariables(aggComponent);
                if (stringArray != null && stringArray.length > 0) {
                    String string5 = new String();
                    String string6 = new String();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string7 = stringArray[i];
                        if (!string7.startsWith(string4)) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string7, "#");
                        stringTokenizer.nextToken();
                        String string8 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string8, ":");
                        String string9 = stringTokenizer2.nextToken();
                        if (!list.contains(string9)) continue;
                        if (bl) {
                            string5 = stringTokenizer2.nextToken();
                            string6 = "NULL";
                        } else {
                            string5 = stringTokenizer2.nextToken();
                            string6 = stringTokenizer2.nextToken();
                        }
                        String string10 = string5 + ":" + string6;
                        arrayList.add(string10);
                    }
                }
                list2 = this.getCommaSepStrings(arrayList);
            }
        }
        return list2;
    }

    public List getCommaSepStrings(List list) {
        testerInfo.checkForUpdate();
        int n = EgTesterInfo.MAX_WORDS;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ++n3;
            String string = (String)list.get(i);
            stringBuffer.append("'");
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append(",");
            if (n3 != n && i != n2 - 1) continue;
            n3 = 0;
            String string2 = stringBuffer.toString();
            string2 = string2.substring(0, string2.length() - 1);
            arrayList.add(string2);
            stringBuffer = new StringBuffer();
        }
        return arrayList;
    }

    public static String[] allowedTestTypes() {
        return new String[]{"Custom", "Script/Batch File", "Sql Query", "Perfmon", "Snmp", "Jmx", "REST"};
    }

    public void setAggregateType(String string) {
        Vector vector = this.getAggregateTypes();
        if (vector != null) {
            if (!vector.contains(string)) {
                this.setValue(aggType, string, "yes");
            }
            this.saveFile();
        }
    }

    public Vector getAggregateTypes() {
        this.checkForUpdate();
        String[] stringArray = this.getVariables(aggType);
        if (stringArray == null || stringArray.length == 0) {
            return new Vector();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(stringArray));
        Vector vector = new Vector(treeSet);
        Collections.sort(vector);
        return vector;
    }

    public Vector getNoAggregateSupportTypes() {
        this.checkForUpdate();
        String[] stringArray = this.getVariables(NO_AGGREGATE_SUPPORT_TYPES);
        if (stringArray == null || stringArray.length == 0) {
            return new Vector();
        }
        List<String> list = Arrays.asList(stringArray);
        Vector<String> vector = new Vector<String>(list);
        Collections.sort(vector);
        return vector;
    }

    public Vector getValidAggregateTypes() {
        Vector vector = this.getAggregateTypes();
        String[] stringArray = new EgDiscInfo("manager").getServerTypes();
        if (vector == null || vector.size() == 0 || stringArray == null || stringArray.length == 0) {
            return new Vector();
        }
        Vector<String> vector2 = new Vector<String>(Arrays.asList(stringArray));
        for (int i = vector.size() - 1; i >= 0; --i) {
            String string = this.getValue(compTypeMapping, vector.get(i).toString(), false);
            if (string != null && (string = string.trim()).length() > 0 && !vector2.contains(string)) {
                vector.remove(i);
                continue;
            }
            if (vector2.contains(vector.get(i))) continue;
            vector.remove(i);
        }
        return vector;
    }

    public boolean isAggregateTest(String string) {
        boolean bl = false;
        String[] stringArray = this.getVariables(aggTest);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    public String getWrappedTest(String string) {
        this.checkForUpdate();
        String string2 = this.getValue(aggTest, string, false);
        return string2;
    }

    public String getWrapperType(String string) {
        String string2 = "";
        String string3 = "";
        String[] stringArray = this.getVariables(aggComponent);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("#");
            if (stringArray[i].startsWith("#Unmanage|") || n <= -1) continue;
            String string4 = stringArray[i].substring(0, n);
            int n2 = string4.indexOf(":");
            string2 = string4.substring(0, n2);
            string3 = string4.substring(n2 + 1);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return string2;
    }

    public ArrayList getAssociatedComponentTypes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariables(aggComponent);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3;
            if (!stringArray[i].startsWith(string) || arrayList.contains(string3 = (string2 = stringArray[i].substring(stringArray[i].indexOf(35) + 1, stringArray[i].length())).substring(0, string2.indexOf(58)))) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public List getFunctionsForMeasurement(String string, Hashtable hashtable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        Iterator iterator = hashtable.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals(string)) continue;
            string2 = (String)hashtable.get(string3);
            if (string2.indexOf("#") > -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public List getAggComp(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = this.getVariables(aggComponent);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = string.equals("TT");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = string + ":" + string2;
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "#");
                string5 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ":");
                stringTokenizer2.nextToken();
                string7 = stringTokenizer2.nextToken();
                string8 = stringTokenizer2.nextToken();
                string9 = string7 + ":" + string8;
                if (!string9.equals(string2)) continue;
                string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ":");
                stringTokenizer3.nextToken();
                string6 = stringTokenizer3.nextToken();
                arrayList.add(string6);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string10)) continue;
                string3 = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "#");
                stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer4 = new StringTokenizer(string4, ":");
                stringTokenizer4.nextToken();
                string6 = stringTokenizer4.nextToken();
                arrayList.add(string6);
            }
        }
        return arrayList;
    }

    public List getAggregateComponents(String string, String string2) {
        List list = new ArrayList();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = this.getVariables(testInfoExclude);
        if (stringArray == null || stringArray.length == 0) {
            return this.getAggComp("TT", string2);
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            string3 = stringArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "#");
            string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ":");
            stringTokenizer2.nextToken();
            string5 = stringTokenizer2.nextToken();
            string6 = stringTokenizer2.nextToken();
            string7 = stringTokenizer2.nextToken();
            string8 = string6 + ":" + string7;
            if (!string8.equals(string2)) continue;
            list = this.getAggComp(string5, string8);
            break;
        }
        if (list == null || list.size() == 0) {
            return this.getAggComp("TT", string2);
        }
        return list;
    }

    public List getComponentsInfo(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariables(testInfoExclude);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            string3 = stringArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "#");
            string4 = stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ":");
            stringTokenizer2.nextToken();
            string6 = stringTokenizer2.nextToken();
            string7 = stringTokenizer2.nextToken();
            string8 = stringTokenizer2.nextToken();
            string9 = string7 + ":" + string8;
            if (!string9.equals(string2)) continue;
            arrayList.add(string5);
        }
        return arrayList;
    }

    public long getMeasureFactor() {
        this.checkForUpdate();
        long l = 2L;
        String string = this.getValue(groupFunction, "Factor", false);
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 2L;
        }
        catch (Exception exception) {
            l = 2L;
        }
        return l;
    }

    public final List getMeasurePeriod() {
        this.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getValue(groupFunction, "MeasurePeriod", false);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public List getAssociatedComponent() {
        this.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariables(aggComponent);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ((string = string.substring(0, string.lastIndexOf(58))).startsWith("#Unmanage|")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List getAssociatedComponents(String string, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = null;
        if (!EgUtils.isNull(string) && !EgUtils.isNull(stringArray = this.getVariables(aggComponent))) {
            arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                int n = stringArray[i].lastIndexOf("#");
                if (n < 0 || (string2 = stringArray[i].substring(0, n)).startsWith("#Unmanage|")) continue;
                String string3 = stringArray[i].substring(n + 1);
                if (!string.equals(string2)) continue;
                if (bl) {
                    arrayList.add(string3);
                    continue;
                }
                int n2 = string3.indexOf(":");
                if (n2 < 0) continue;
                string3 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public List getAssociatedAggList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariables(aggComponent);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
            String string3 = stringTokenizer.nextToken();
            if (!string.equals(stringTokenizer.nextToken())) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String getAggregateType(String string) {
        this.checkForUpdate();
        String[] stringArray = this.getVariables(compTypeMapping);
        Vector vector = this.getAllValues(compTypeMapping);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)vector.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string.equals(string3)) continue;
                    return stringArray[i];
                }
            }
        }
        return null;
    }

    public String getRelatedAggregateTest(String string) {
        this.checkForUpdate();
        if (string != null && string.trim().length() > 0) {
            String[] stringArray = this.getVariables(aggTest);
            Vector vector = this.getAllValues(aggTest);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            String string2 = null;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = (String)vector.get(i);
                if (string2 == null || !string2.equals(string)) continue;
                string2 = stringArray[i];
                bl = true;
                break;
            }
            if (bl) {
                return string2;
            }
        }
        return null;
    }

    public String[] getRelatedAggregateTest(String string, boolean bl) {
        this.checkForUpdate();
        if (string != null && string.trim().length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.getVariables(aggTest);
            Vector vector = this.getAllValues(aggTest);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            String string2 = null;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = (String)vector.get(i);
                if (string2 == null || !string2.equals(string)) continue;
                string2 = stringArray[i];
                bl2 = true;
                arrayList.add(string2);
            }
            if (bl2) {
                return arrayList.toArray(new String[arrayList.size()]);
            }
        }
        return null;
    }

    public String getRelatedAggregateTest(String string, String string2) {
        this.checkForUpdate();
        if (string != null && string.trim().length() > 0) {
            ArrayList arrayList = specs.getEnabledTests(string2, false);
            String[] stringArray = this.getVariables(aggTest);
            Vector vector = this.getAllValues(aggTest);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            String string3 = null;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = (String)vector.get(i);
                if (string3 == null || !string3.equals(string) || arrayList == null || !arrayList.contains(stringArray[i])) continue;
                return stringArray[i];
            }
        }
        return null;
    }

    public boolean isComponentAvailableForAggServerType(String string) {
        boolean bl = false;
        String[] stringArray = this.getVariables(aggComponent);
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ArrayList getAllAggregateComponents(String string) {
        ArrayList<String> arrayList = null;
        String[] stringArray = this.getVariables(aggComponent);
        if (!EgUtils.isNull(stringArray)) {
            arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf("#"));
                if (!string2.startsWith(string) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        if (arrayList != null && arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public String getAggregateInformation(String string, String string2, String string3) {
        int n;
        String string4 = string3;
        if (string3 != null && string3.equals("testFreq")) {
            string3 = "mCount";
        }
        String string5 = "";
        string5 = string != null ? ((n = string.indexOf(":")) > -1 ? string.substring(0, n) : string) : string;
        String string6 = null;
        IniFile iniFile = new IniFile(configDir + "eg_agents.ini");
        String string7 = this.getAgentForAggComponent(string5);
        EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
        boolean bl = egSpecsInfo.isPortRelevantForTest(string2);
        String string8 = "";
        string8 = bl ? string2 + "::" + string : string2 + "::" + string5;
        String string9 = iniFile.getValue(string7, string8);
        if (string9 != null && !string9.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string9, "-");
            while (stringTokenizer.hasMoreTokens()) {
                String string10 = stringTokenizer.nextToken();
                if (string10 == null || !string10.startsWith(string3)) continue;
                int n2 = string10.indexOf(" ");
                if (n2 <= -1) break;
                string6 = string10.substring(n2 + 1, string10.length());
                int n3 = string6.indexOf(",");
                if (string3.equals("mCount") && n3 > -1) {
                    string6 = string4.equals("mCount") ? string6.substring(0, n3) : string6.substring(n3 + 1);
                }
                if (string6 == null) break;
                string6 = string6.trim();
                break;
            }
        }
        return string6;
    }

    public String getAgentForAggComponent(String string) {
        String string2 = null;
        IniFile iniFile = new IniFile(configDir + "eg_external.ini");
        if (string != null) {
            string2 = iniFile.getValue("Test_Mapping_Section", string);
        }
        return string2;
    }

    public String getMemberColumnName(String string, String string2) {
        int n;
        String string3;
        this.checkForUpdate();
        String string4 = null;
        if (!(string == null || string.equals("") || string2 == null || string2.equals("") || (string3 = this.getValue(columnNameMapping, string + ":" + string2, false)) == null || string3.equals("") || (n = string3.indexOf(":")) < 0)) {
            String string5 = string3.substring(0, n);
            String string6 = string3.substring(n + 1);
            EgDbInfo egDbInfo = new EgDbInfo("manager");
            string4 = egDbInfo.getColumnForMeasure(string5, string6);
        }
        return string4;
    }

    public List getUnmanagedAssociatedComponents(String string, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = null;
        if (!EgUtils.isNull(string) && !EgUtils.isNull(stringArray = this.getVariables(aggComponent))) {
            arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = stringArray[i].substring(0, stringArray[i].lastIndexOf("#"));
                String string4 = "#Unmanage|" + string + "#";
                if (!string2.startsWith(string4 = string4.trim())) continue;
                string3 = string3.substring(string3.indexOf("|") + 1);
                String string5 = stringArray[i].substring(stringArray[i].lastIndexOf("#") + 1);
                if (!string.equals(string3)) continue;
                if (bl) {
                    arrayList.add(string5);
                    continue;
                }
                int n = string5.indexOf(":");
                if (n < 0) continue;
                string5 = string5.substring(n + 1);
                string5 = string5.substring(0, n);
                arrayList.add(string5);
            }
        }
        return arrayList;
    }

    public ArrayList getAllUnmanagedAggregateComponents(String string) {
        ArrayList<String> arrayList = null;
        String[] stringArray = this.getVariables(aggComponent);
        if (!EgUtils.isNull(stringArray)) {
            arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].substring(0, stringArray[i].lastIndexOf("#"));
                String string3 = string2.substring(string2.indexOf("Agg"));
                if (!string2.startsWith("#Unmanage|") || !string3.equals(string)) continue;
                String string4 = stringArray[i].substring(stringArray[i].lastIndexOf("#") + 1);
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public String getView() {
        IniFile iniFile = new IniFile(configDir + "eg_ui.ini", false);
        return iniFile.getValue(componentMetricView, "AggregateComp");
    }

    public ArrayList getAggComponentsForMembers(ArrayList arrayList) {
        ArrayList arrayList2 = null;
        TreeSet treeSet = new TreeSet();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                List list = this.getAssociatedAggList(string);
                if (list == null || list.size() == 0) continue;
                treeSet.addAll(list);
            }
        }
        arrayList2 = new ArrayList(treeSet);
        return arrayList2;
    }

    public boolean isAggregateSiteSupported(String string) {
        String string2;
        this.checkForUpdate();
        boolean bl = false;
        int n = string.indexOf(":");
        if (n > 0 && string.lastIndexOf(":") > n && (string2 = this.getValue(siteSupport, string, false)) != null && string2.equalsIgnoreCase("yes")) {
            bl = true;
        }
        return bl;
    }

    public boolean isAggregateSite(String string) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            return false;
        }
        IniFile iniFile = new IniFile(topoFileName, false);
        String[] stringArray = iniFile.getVariables("AGG_SITE_MAP");
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public ArrayList getSiteSupportedAggregateComponents() {
        this.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariables(siteSupport);
        Vector vector = this.getAllValues(siteSupport);
        if (stringArray == null) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = (String)vector.get(i);
                if (string2 == null || !string2.equalsIgnoreCase("yes")) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public String getAllowedTabsForType() {
        IniFile iniFile = new IniFile(configDir + "eg_ui.ini", false);
        return iniFile.getValue("AGGREGATE_DASHBOARD", "COMPONENTTYPELINK");
    }

    public String getAllowedTabsForAggregates() {
        IniFile iniFile = new IniFile(configDir + "eg_ui.ini", false);
        return iniFile.getValue("AGGREGATE_DASHBOARD", "AGGREGATESLINK");
    }

    public String getAvailableTabs() {
        IniFile iniFile = new IniFile(configDir + "eg_ui.ini", false);
        return iniFile.getValue("AGGREGATE_DASHBOARD", "AVAILABLETABS");
    }

    public String getAllowedTabsForComponent() {
        IniFile iniFile = new IniFile(configDir + "eg_ui.ini", false);
        return iniFile.getValue("AGGREGATE_DASHBOARD", "COMPONENTLINK");
    }

    public static void main(String[] stringArray) {
    }

    public List getManagedComponents(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = this.getVariables(aggComponent);
        if (stringArray == null || stringArray.length == 0) {
            return this.getAggComp("TT", string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "#");
            String string2 = stringTokenizer.nextToken();
            if (!(string2 = string2.trim()).endsWith(string)) continue;
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.substring(string3.indexOf(":") + 1);
            arrayList.add(string4);
        }
        if (arrayList == null || arrayList.size() == 0) {
            return this.getAggComp("TT", string);
        }
        return arrayList;
    }

    public String getParameterValue(String string, String string2, String string3) {
        EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
        String string4 = string2.substring(0, string2.indexOf(":"));
        try {
            string2.substring(string2.indexOf(":") + 1, string2.lastIndexOf(":"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("EgAggregateInfo.getParameterValue component    " + string2);
        }
        int n = string2.indexOf(":");
        String string5 = string2.substring(n + 1, string2.lastIndexOf(":"));
        String string6 = string2.substring(n + 1, string2.length());
        List list = egExternalInfo.getAgentsFor(string, string4, string5);
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
        String string7 = null;
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            String string8;
            String[] stringArray = iniFile.getVariables((String)list.get(i));
            String string9 = string + ":" + string4 + ":" + string6;
            String string10 = string + ":" + string4 + ":" + string5;
            String string11 = string + "::" + string6;
            String string12 = string + "::" + string5;
            String string13 = "";
            List<String> list2 = Arrays.asList(stringArray);
            if (list2.contains(string9)) {
                string13 = string9;
            } else if (list2.contains(string10)) {
                string13 = string10;
            } else if (list2.contains(string11)) {
                string13 = string11;
            } else if (list2.contains(string12)) {
                string13 = string12;
            }
            if (string13.equalsIgnoreCase("") || (string8 = iniFile.getValue((String)list.get(i), string13)) == null || (string8 = string8.trim()).length() <= 0) continue;
            ArrayList arrayList = this.getParameterList(string8);
            String string14 = string3;
            if (string14.charAt(0) != '-') {
                string14 = "-" + string14;
            }
            if ((n2 = arrayList.indexOf(string14)) <= -1 || ++n2 >= arrayList.size()) continue;
            string7 = (String)arrayList.get(n2);
        }
        return string7;
    }

    private ArrayList getParameterList(String string) {
        String string2;
        String string3 = " -";
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = "";
        string = string.substring(string.indexOf("-"));
        int n = string.indexOf(string3);
        while (n != -1) {
            int n2;
            String string5;
            String string6 = string.substring(0, n);
            if (string6.trim().indexOf(" ") == -1) {
                string5 = string.substring(string6.length() + 1);
                string2 = string5.substring(0, string5.indexOf(string3));
                string6 = string6 + " " + string2;
                n = string6.length();
            }
            if (string6.indexOf("\"") != -1) {
                string5 = string.substring(n);
                string2 = string5.substring(0, string5.indexOf("\"") + 1);
                string6 = string6 + string2;
                int n3 = string6.indexOf(" ");
                String string7 = string6.substring(0, n3);
                String string8 = string6.substring(n3 + 1);
                arrayList.add(string7.trim());
                arrayList.add(string8.trim());
                String string9 = string5.substring(string5.indexOf("\"") + 1);
                string = string9.trim();
                if (string.length() == 0) {
                    n = -1;
                    continue;
                }
                n = string.indexOf(string3);
                continue;
            }
            if (string6.startsWith("- ")) {
                n2 = arrayList.indexOf(string4);
                string2 = (String)arrayList.get(n2 + 1);
                string2 = string2 + " " + string6;
                arrayList.remove(n2 + 1);
                arrayList.add(string2);
                string = string.substring(string6.length() + 1);
            } else {
                n2 = string6.indexOf(" ");
                string2 = string6.substring(0, n2);
                String string10 = string6.substring(n2 + 1);
                arrayList.add(string2.trim());
                arrayList.add(string10.trim());
                string4 = string2.trim();
                string = string.substring(n + 1);
            }
            n = string.indexOf(string3);
        }
        if (string.length() > 0) {
            if (string.startsWith("- ")) {
                int n4 = arrayList.indexOf(string4);
                String string11 = (String)arrayList.get(n4 + 1);
                string11 = string11 + " " + string;
                arrayList.remove(n4 + 1);
                arrayList.add(string11);
            } else {
                int n5 = string.indexOf(" ");
                String string12 = string.substring(0, n5);
                string2 = string.substring(n5 + 1);
                arrayList.add(string12.trim());
                arrayList.add(string2.trim());
            }
        }
        return arrayList;
    }

    public ArrayList getAllAggregateComponents() {
        ArrayList arrayList;
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(aggComponent);
        if (!EgUtils.isNull(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("#Unmanage|")) continue;
                String string = stringArray[i].substring(0, stringArray[i].indexOf("#"));
                treeSet.add(string);
            }
        }
        if ((arrayList = new ArrayList(treeSet)).size() > 1) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public ArrayList getComponentsBasedOnState() {
        ArrayList arrayList;
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(aggComponent);
        if (!EgUtils.isNull(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("#Unmanage|")) continue;
                String string = stringArray[i].substring(0, stringArray[i].indexOf("#"));
                treeSet.add(string);
            }
        }
        if ((arrayList = new ArrayList(treeSet)).size() > 1) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public String getDefaultAggregateComponent(String string, String string2, String string3) {
        ArrayList<String> arrayList = null;
        String[] stringArray = this.getVariables(compAssociation);
        if (!EgUtils.isNull(stringArray)) {
            String string4 = string3 + ":";
            String string5 = "#" + string + "#" + string2;
            arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string4) || !stringArray[i].endsWith(string5)) continue;
                arrayList.add(stringArray[i].substring(0, stringArray[i].indexOf("#")));
            }
        }
        if (arrayList != null && arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.get(0).toString();
        }
        return "";
    }

    public String[] getElementsOfAggregateComponent(String string) {
        String[] stringArray = this.getVariables(compAssociation);
        if (!EgUtils.isNull(stringArray)) {
            String string2 = string + "#";
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                String string3 = stringArray[i].substring(stringArray[i].indexOf("#") + 1);
                int n = string3.indexOf("#");
                if (n <= 0) break;
                String[] stringArray2 = new String[]{string3.substring(0, n), string3.substring(n + 1)};
                return stringArray2;
            }
        }
        return null;
    }

    public ArrayList getAggregateComponentsOfElement(String string, String string2) {
        String[] stringArray = this.getVariables(compAssociation);
        if (!EgUtils.isNull(stringArray)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = "#" + string + "#" + string2;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(string3)) continue;
                arrayList.add(stringArray[i].substring(0, stringArray[i].indexOf("#")));
            }
            return arrayList;
        }
        return null;
    }

    public ArrayList getUIComponentsOfElement(String string, String string2) {
        String[] stringArray = this.getVariables(uiCompAssociation);
        if (!EgUtils.isNull(stringArray)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = "#" + string + "#" + string2;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(string3)) continue;
                arrayList.add(stringArray[i].substring(0, stringArray[i].indexOf("#")));
            }
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAssociatedElementNames(String string) {
        String[] stringArray = this.getVariables(compAssociation);
        if (!EgUtils.isNull(stringArray)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "#" + string + "#";
            Vector vector = null;
            String string3 = aggComponent;
            synchronized (aggComponent) {
                vector = aggregateFilePtr.getAllValues(compAssociation);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4;
                    int n;
                    String string5;
                    if (stringArray[i].indexOf(string2) <= 0 || (string5 = (String)vector.get(i)) == null || (n = string5.indexOf("#")) <= 0 || arrayList.contains(string4 = string5.substring(n + 1))) continue;
                    arrayList.add(string4);
                }
                return arrayList;
            }
        }
        return null;
    }

    public ArrayList getComponentsOfAssociatedElement(String string) {
        String[] stringArray = this.getVariables(compAssociation);
        if (!EgUtils.isNull(stringArray)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "#" + string + "#";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(string2) <= 0) continue;
                arrayList.add(stringArray[i].substring(0, stringArray[i].indexOf("#")));
            }
            return arrayList;
        }
        return null;
    }

    public Vector getAggregateTests() {
        this.checkForUpdate();
        String[] stringArray = this.getVariables(aggTest);
        if (stringArray != null && stringArray.length > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(Arrays.asList(stringArray));
            return new Vector(treeSet);
        }
        return new Vector();
    }

    public Vector getPreDefinedAggregateTests() {
        this.checkForUpdate();
        return preDefinedAggregateTests;
    }

    private void updatePreDefinedAggregateTests() {
        String[] stringArray = this.getVariables(preDefinedAggTest);
        if (stringArray != null && stringArray.length > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(Arrays.asList(stringArray));
            preDefinedAggregateTests.addAll(treeSet);
        }
    }

    public ArrayList getMeasuresForTest(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        String string2 = this.getValue("MEASURES", string);
        if (string2 == null || string2.length() == 0) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
        if (stringTokenizer.countTokens() < 1) {
            return arrayList;
        }
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            n = string3.lastIndexOf(":");
            if (n < 0) continue;
            string4 = string3.substring(n + 1);
            Integer n2 = new Integer(Integer.parseInt(string4));
            arrayList.add(n2);
            hashtable.put(n2, string3);
        }
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n3 = (Integer)arrayList.get(i);
            string3 = (String)hashtable.get(n3);
            arrayList2.add(string3);
        }
        return arrayList2;
    }

    private int getNewTestIndex(String string, Vector vector, Vector vector2) {
        int n = 0;
        if (vector != null && vector.size() > 0 && vector2 != null && vector2.size() > 0 && vector2.contains(string)) {
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < vector2.size(); ++i) {
                if (!string.equals((String)vector2.get(i)) || (string3 = (String)vector.get(i)).endsWith("_ag")) continue;
                try {
                    if (string.endsWith("_ex")) {
                        int n3 = string3.lastIndexOf("_");
                        string3 = string3.substring(0, n3);
                        string2 = string3.substring(n3 + 1);
                    } else {
                        string2 = string3.substring(string3.indexOf("_") + 1, string3.lastIndexOf("_"));
                    }
                    if (string2.length() <= 0 || n >= (n2 = Integer.parseInt(string2))) continue;
                    n = n2;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayTestName(String string) {
        int n = 0;
        this.checkForUpdate();
        String string2 = aggComponent;
        synchronized (aggComponent) {
            Vector vector = aggregateFilePtr.getVariables(aggTest, true);
            Vector vector2 = aggregateFilePtr.getAllValues(aggTest);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            string2 = "";
            if (vector != null && !vector.isEmpty() && vector2 != null && !vector2.isEmpty()) {
                n = this.getNewTestIndex(string, vector, vector2);
                if (string.endsWith("_ex")) {
                    String string3 = string.substring(0, string.lastIndexOf("_"));
                    string2 = string3 + "_" + String.valueOf(++n) + "_agx";
                } else {
                    if (string.length() > 13) {
                        string = string.substring(0, 13);
                    }
                    string2 = string + "_" + String.valueOf(++n) + "_agx";
                }
                if (!vector.contains(string2)) {
                    vector.clear();
                    vector2.clear();
                } else {
                    string2 = "";
                }
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllTestTemplates() {
        this.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = aggComponent;
        synchronized (aggComponent) {
            String[] stringArray = aggregateFilePtr.getSubjects();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].endsWith("_Template")) continue;
                    arrayList.add(stringArray[i]);
                }
            }
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return arrayList;
        }
    }

    public ArrayList getDefaultEnbaledTemplates() {
        this.checkForUpdate();
        String[] stringArray = this.getVariables("DEFAULT_ENABLED_TEMPLATES");
        if (stringArray == null || stringArray.length == 0) {
            return new ArrayList();
        }
        Vector vector = this.getAllValues("DEFAULT_ENABLED_TEMPLATES");
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            string = (String)vector.get(i);
            if (string == null || !string.equals("true")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public ArrayList filteredTemplates(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = specs.getDefaultTestsForServer(string.substring(4));
        ArrayList arrayList2 = this.getAllTestTemplates();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = arrayList2.indexOf(string2 + "_Template");
                if (n <= -1) continue;
                arrayList.add(string2 + "_Template");
            }
        }
        return arrayList;
    }

    public ArrayList getValidTemplateTests(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = specs.getDefaultTestsForServer(string.substring(4));
        ArrayList arrayList2 = this.getAllTestTemplates();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = arrayList2.indexOf(string2 + "_Template");
                if (n <= -1) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public ArrayList getValidAggTests(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = specs.getDefaultTestsForServer(string.substring(4));
        if (stringArray != null && stringArray.length > 0) {
            List<String> list = Arrays.asList(stringArray);
            this.checkForUpdate();
            String string2 = null;
            String[] stringArray2 = this.getVariables(aggTest);
            Vector vector = this.getAllValues(aggTest);
            if (stringArray2 != null && stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    string2 = (String)vector.get(i);
                    if (!list.contains(string2)) continue;
                    arrayList.add(stringArray2[i]);
                }
            }
        }
        return arrayList;
    }

    public Hashtable getDisplayNames(ArrayList arrayList) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = this.getVariables("COMPONENT_TYPE_NICK_MAPPING");
        Vector vector = this.getAllValues("COMPONENT_TYPE_NICK_MAPPING");
        if (!EgUtils.isNull(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string2 = stringArray[i];
                if (!arrayList.contains(string2) || (string = (String)vector.get(i)) == null || (string = string.trim()).length() <= 0) continue;
                hashtable.put(string2, string);
            }
        }
        return hashtable;
    }

    public boolean isSingleComponentTypeAssociation() {
        this.checkForUpdate();
        boolean bl = false;
        String string = this.getValue("COMPONENT_TYPE_ASSOCIATION", "association", false);
        if (string != null && string.equals("single")) {
            bl = true;
        }
        return bl;
    }

    public boolean isSiteOrientedTest(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        this.checkForUpdate();
        String[] stringArray = this.getVariables(siteAggregateTest);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getWebSiteAggTests() {
        this.checkForUpdate();
        Vector vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = new Vector<String>();
        String string = aggComponent;
        synchronized (aggComponent) {
            int n;
            int n2;
            vector = aggregateFilePtr.getVariables(aggTest, true);
            vector2 = aggregateFilePtr.getAllValues(aggTest);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (vector != null && !vector.isEmpty() && vector2 != null && !vector2.isEmpty() && (n2 = vector.size()) == (n = vector2.size())) {
                String string2 = null;
                for (int i = 0; i < n; ++i) {
                    String string3;
                    string2 = (String)vector2.get(i);
                    if (!string2.trim().equals("WebSiteTest") || vector3.contains(string3 = (String)vector.get(i))) continue;
                    vector3.add(string3);
                }
            }
            return vector3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getWebSiteTransactionAggTests() {
        this.checkForUpdate();
        Vector vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = new Vector<String>();
        String string = aggComponent;
        synchronized (aggComponent) {
            int n;
            int n2;
            vector = aggregateFilePtr.getVariables(aggTest, true);
            vector2 = aggregateFilePtr.getAllValues(aggTest);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (vector != null && !vector.isEmpty() && vector2 != null && !vector2.isEmpty() && (n2 = vector.size()) == (n = vector2.size())) {
                String string2 = null;
                for (int i = 0; i < n; ++i) {
                    String string3;
                    string2 = (String)vector2.get(i);
                    if (!string2.trim().equals("WebSiteTransactionTest") || vector3.contains(string3 = (String)vector.get(i))) continue;
                    vector3.add(string3);
                }
            }
            return vector3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeLag() {
        long l = 1L;
        try {
            String string = this.getValue("TIMELAG", "TimeLag", true);
            l = Long.parseLong(string);
            return l;
        }
        catch (Exception exception) {
            l = 1L;
            return l;
        }
        finally {
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getZeroMeasures(String string) {
        this.checkForUpdate();
        Hashtable hashtable = new Hashtable();
        Vector vector = null;
        Vector vector2 = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            int n;
            int n2;
            vector = aggregateFilePtr.getVariables(set_zero_measure, true);
            vector2 = aggregateFilePtr.getAllValues(set_zero_measure);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (vector != null && !vector.isEmpty() && vector2 != null && !vector2.isEmpty() && (n2 = vector.size()) == (n = vector2.size())) {
                String string3 = null;
                String string4 = null;
                String string5 = this.getTestName(string);
                if (string5 == null || string5.trim().length() == 0) {
                    if (vector != null) {
                        vector.clear();
                    }
                    if (vector2 != null) {
                        vector2.clear();
                    }
                    return new Hashtable();
                }
                for (int i = 0; i < n; ++i) {
                    string3 = (String)vector.get(i);
                    string4 = (String)vector2.get(i);
                    if (string3 == null || (string3 = string3.trim()).length() <= 0 || !string3.startsWith(string5 + ":") || string4 == null || (string4 = string4.trim()).length() <= 0 || string4.indexOf("#") <= -1) continue;
                    int n3 = string4.indexOf("#");
                    String string6 = string4.substring(0, n3);
                    String string7 = string4.substring(0, n3);
                    if (string6.length() <= 0 || string7.length() <= 0) continue;
                    Vector<Double> vector3 = new Vector<Double>();
                    vector3.add(new Double(Double.parseDouble(string6)));
                    vector3.add(new Double(Double.parseDouble(string7)));
                    hashtable.put(string3, vector3);
                }
            }
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnchorComponent(String string, String string2, String string3) {
        this.checkForUpdate();
        String[] stringArray = null;
        String string4 = aggComponent;
        synchronized (aggComponent) {
            String string5;
            String string6;
            stringArray = aggregateFilePtr.getVariables(anchorComponent);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string6 = stringArray[i].trim();
                String string7 = string6.substring(0, string6.indexOf(":"));
                n = string6.indexOf("#");
                string5 = string6.substring(n + 1);
                if (!string7.equals(string3) || !string5.equalsIgnoreCase(string + "#" + string2)) continue;
                return string6.substring(0, n);
            }
            String string8 = null;
            string6 = aggComponent;
            synchronized (aggComponent) {
                stringArray = aggregateFilePtr.getVariables(compAssociation);
                // ** MonitorExit[var7_10] (shouldn't be in output)
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    string5 = stringArray[i];
                    String string9 = string5.substring(0, string5.indexOf(":"));
                    n = string5.indexOf("#");
                    String string10 = string5.substring(n + 1);
                    if (!string9.equals(string3) || !string10.equalsIgnoreCase(string + "#" + string2)) continue;
                    String string11 = string5.substring(0, n);
                    List list = this.getAssociatedComponents(string11, false);
                    int n3 = list.size();
                    if (anchorComponent == null) {
                        n2 = n3;
                        string8 = string11;
                        continue;
                    }
                    if (n2 >= n3) continue;
                    n2 = n3;
                    string8 = string11;
                }
                return string8;
            }
        }
    }

    public boolean isAutoAssociateComponentToAnchor() {
        this.checkForUpdate();
        String string = this.getValue(ANCHOR_COMPONENT_SETTINGS, "AutoAssociateComponent");
        return string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("y"));
    }

    public boolean showOnlyAnchorComponents() {
        this.checkForUpdate();
        String string = this.getValue(ANCHOR_COMPONENT_SETTINGS, "ShowOnlyAnchor");
        return string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("y"));
    }

    public Hashtable getAnchorComponentsOfElement(String string, String string2) {
        Hashtable<String, List> hashtable = new Hashtable<String, List>();
        String[] stringArray = this.getVariables(anchorComponent);
        if (!EgUtils.isNull(stringArray)) {
            string = string.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                List list;
                if (!stringArray[i].endsWith("#" + string + "#" + string2) || (list = this.getAssociatedComponents(string3 = stringArray[i].substring(0, stringArray[i].indexOf("#")), true)) == null || list.isEmpty()) continue;
                hashtable.put(string3, list);
            }
            return hashtable;
        }
        return null;
    }

    public Hashtable getUnmanagedAnchorComponentsOfElement(String string, String string2) {
        Hashtable<String, List> hashtable = new Hashtable<String, List>();
        String[] stringArray = this.getVariables(anchorComponent);
        if (!EgUtils.isNull(stringArray)) {
            string = string.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                List list;
                if (!stringArray[i].endsWith("#" + string + "#" + string2) || (list = this.getUnmanagedAssociatedComponents(string3 = stringArray[i].substring(0, stringArray[i].indexOf("#")), true)) == null || list.isEmpty()) continue;
                hashtable.put(string3, list);
            }
            return hashtable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String[] getColumnNamesForTest(String string) {
        Vector<String> vector;
        Vector<String> vector2;
        String string2 = this.getTestName(string);
        String[] stringArray = new EgDbInfo("manager").getColumnNamesForTest(string2);
        if (stringArray == null) return null;
        if (stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; i += 2) {
                arrayList.add(stringArray[i]);
            }
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        arrayList.clear();
        String string3 = string2 + "_Template";
        List<String> list = Arrays.asList(this.getVariables(userdefinedTemplates));
        if (list != null && list.size() > 0 && list.contains(string)) {
            vector2 = null;
            vector = aggComponent;
            // MONITORENTER : "AGGREGATE_COMPONENTS"
            vector2 = aggregateFilePtr.getValue(userdefinedTemplates, string);
            // MONITOREXIT : vector
            if (vector2 != null && string3.trim().length() > 0) {
                string3 = vector2 + "_Template";
            }
        }
        vector2 = null;
        vector = null;
        EgThresholdInfo egThresholdInfo = new EgThresholdInfo("manager");
        String[] stringArray2 = egThresholdInfo.getMeasurementsForTest(string2);
        if (string.endsWith("_ag")) {
            vector2 = new Vector(this.getVariables(string3, true));
            vector = new Vector<String>(this.getAllValues(string3));
        } else if (stringArray2 != null && stringArray2.length > 0) {
            vector2 = new Vector<String>();
            vector = new Vector();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4 = stringArray2[i];
                vector2.add(string2 + ":" + string4);
                vector.add(string + ":" + string4);
            }
        }
        if (vector2 == null) return null;
        if (vector == null) return null;
        if (vector2.size() <= 0) return null;
        if (vector2.size() != vector.size()) return null;
        Vector vector3 = (Vector)vector2.clone();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string5 = string2 + ":" + stringArray2[i];
            int n = vector3.indexOf(string5);
            if (n == -1) continue;
            vector3.set(n, stringArray[i]);
        }
        String[] stringArray3 = egThresholdInfo.getMeasurementsForTest(string);
        if (stringArray3 == null) return null;
        if (stringArray3.length <= 0) return null;
        int n = stringArray3.length;
        String[] stringArray4 = new String[n];
        System.out.println();
        System.out.println(string + " TEST:MEASURE >>> COLUMN NAME");
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                System.out.println();
                vector3.clear();
                return stringArray4;
            }
            String string6 = string + ":" + stringArray3[n2];
            int n3 = vector.indexOf(string6);
            if (n3 == -1) {
                return null;
            }
            stringArray4[n2] = (String)vector3.get(n3);
            System.out.println(string6 + " >>> " + stringArray4[n2]);
            ++n2;
        }
    }

    public Vector getQueries(String string, boolean bl) {
        return this.getQueries(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getQueries(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.getColumnNamesForTest(string);
        if (stringArray == null || stringArray.length == 0 || string.length() > 23) {
            return null;
        }
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        string2 = bl ? "DROP TABLE " + string + " CASCADE CONSTRAINTS" : "DROP TABLE " + string;
        vector.add(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string);
        stringBuffer.append("(");
        if (bl) {
            stringBuffer.append("TRGT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR2(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR2(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR2(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME DATE NOT NULL,");
        } else {
            stringBuffer.append("TRGT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME DATETIME NOT NULL,");
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuffer.append(stringArray[i] + " NUMBER(20,4) NOT NULL,");
                if (i + 1 == n) {
                    stringBuffer.append(stringArray[i] + "_ST VARCHAR2(32) NOT NULL");
                    continue;
                }
                stringBuffer.append(stringArray[i] + "_ST VARCHAR2(32) NOT NULL,");
                continue;
            }
            stringBuffer.append(stringArray[i] + " DECIMAL(20,4) NOT NULL,");
            if (i + 1 == n) {
                stringBuffer.append(stringArray[i] + "_ST VARCHAR(32) NOT NULL");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_ST VARCHAR(32) NOT NULL,");
        }
        stringBuffer.append(")");
        String string3 = stringBuffer.toString();
        if (bl2) {
            string3 = this.createPartitionforTestTableInOracleDb(string3, false);
        }
        vector.add(string3);
        stringBuffer.setLength(0);
        String string4 = "IDX_" + string;
        String string5 = "CREATE INDEX " + string4 + " ON " + string + "(MSMT_TIME)";
        vector.add(string5);
        String string6 = "PK_" + string;
        String string7 = "ALTER TABLE " + string + " ADD CONSTRAINT " + string6 + " PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME)";
        vector.add(string7);
        String string8 = null;
        string8 = bl ? "DROP TABLE " + string + "_TREND CASCADE CONSTRAINTS" : "DROP TABLE " + string + "_TREND";
        vector.add(string8);
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string + "_TREND(");
        if (bl) {
            stringBuffer.append("TRGT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR2(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR2(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR2(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME DATE NOT NULL,");
            stringBuffer.append("PERIOD VARCHAR2(32) NOT NULL,");
        } else {
            stringBuffer.append("TRGT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME DATETIME NOT NULL,");
            stringBuffer.append("PERIOD VARCHAR(32) NOT NULL,");
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuffer.append(stringArray[i] + "_MIN NUMBER(20,4) NOT NULL,");
                stringBuffer.append(stringArray[i] + "_MAX NUMBER(20,4) NOT NULL,");
                if (i + 1 == n) {
                    stringBuffer.append(stringArray[i] + "_STCNT VARCHAR2(32) NOT NULL");
                    continue;
                }
                stringBuffer.append(stringArray[i] + "_STCNT VARCHAR2(32) NOT NULL,");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_MIN DECIMAL(20,4) NOT NULL,");
            stringBuffer.append(stringArray[i] + "_MAX DECIMAL(20,4) NOT NULL,");
            if (i + 1 == n) {
                stringBuffer.append(stringArray[i] + "_STCNT VARCHAR(32) NOT NULL");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_STCNT VARCHAR(32) NOT NULL,");
        }
        stringBuffer.append(")");
        String string9 = stringBuffer.toString();
        vector.add(string9);
        stringBuffer.setLength(0);
        String string10 = "PK_" + string + "_TD";
        String string11 = "ALTER TABLE " + string + "_TREND ADD CONSTRAINT " + string10 + " PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD)";
        vector.add(string11);
        String string12 = null;
        string12 = bl ? "DROP TABLE " + string + "_THRESH CASCADE CONSTRAINTS" : "DROP TABLE " + string + "_THRESH";
        vector.add(string12);
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string + "_THRESH(");
        if (bl) {
            stringBuffer.append("TRGT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR2(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR2(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR2(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR2(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME_START DATE NOT NULL,");
            stringBuffer.append("MSMT_TIME_END DATE NOT NULL,");
        } else {
            stringBuffer.append("TRGT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("PORT_NO VARCHAR(32) NOT NULL,");
            stringBuffer.append("SITE_NAME VARCHAR(64) NOT NULL,");
            stringBuffer.append("INFO VARCHAR(128) NOT NULL,");
            stringBuffer.append("MSMT_HOST VARCHAR(32) NOT NULL,");
            stringBuffer.append("MSMT_TIME_START DATETIME NOT NULL,");
            stringBuffer.append("MSMT_TIME_END DATETIME NOT NULL,");
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuffer.append(stringArray[i] + "_MIN VARCHAR2(256) NOT NULL,");
                if (i + 1 == n) {
                    stringBuffer.append(stringArray[i] + "_MAX VARCHAR2(256) NOT NULL");
                    continue;
                }
                stringBuffer.append(stringArray[i] + "_MAX VARCHAR2(256) NOT NULL,");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_MIN VARCHAR(256) NOT NULL,");
            if (i + 1 == n) {
                stringBuffer.append(stringArray[i] + "_MAX VARCHAR(256) NOT NULL");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_MAX VARCHAR(256) NOT NULL,");
        }
        stringBuffer.append(")");
        String string13 = stringBuffer.toString();
        if (bl2) {
            string13 = this.createPartitionforTestTableInOracleDb(string13, true);
        }
        vector.add(string13);
        stringBuffer.setLength(0);
        String string14 = "PK_" + string + "_TH";
        String string15 = "ALTER TABLE " + string + "_THRESH ADD CONSTRAINT " + string14 + " PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START)";
        vector.add(string15);
        String string16 = "IDX_" + string + "_TH";
        String string17 = "CREATE INDEX " + string16 + " ON " + string + "_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END)";
        vector.add(string17);
        String string18 = "IDX_TH_" + string;
        String string19 = "CREATE INDEX " + string18 + " ON " + string + "_THRESH (MSMT_TIME_START)";
        vector.add(string19);
        String string20 = "IDX_TR_" + string;
        String string21 = "CREATE INDEX " + string20 + " ON " + string + "_TREND (MSMT_TIME,PERIOD)";
        vector.add(string21);
        try {
            String string22 = System.getProperty("file.separator");
            PrintWriter printWriter = null;
            if (bl) {
                String string23 = EgInstallInfo.getInstallDir() + string22 + "bin" + string22 + "database" + string22 + "Aggregate_Test_Query";
                String string24 = string23 + string22 + string + ".txt";
                File file = new File(string23);
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                printWriter = new PrintWriter(new FileWriter(string24, false));
            } else {
                String string25 = EgInstallInfo.getInstallDir() + string22 + "bin" + string22 + "database" + string22 + "mssql" + string22 + "Aggregate_Test_Query";
                String string26 = string25 + string22 + string + ".txt";
                File file = new File(string25);
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                printWriter = new PrintWriter(new FileWriter(string26, false));
            }
            printWriter.println(string2);
            printWriter.println();
            printWriter.println(string3);
            printWriter.println();
            printWriter.println(string5);
            printWriter.println();
            printWriter.println(string7);
            printWriter.println();
            printWriter.println(string8);
            printWriter.println();
            printWriter.println(string9);
            printWriter.println();
            printWriter.println(string11);
            printWriter.println();
            printWriter.println(string12);
            printWriter.println();
            printWriter.println(string13);
            printWriter.println();
            printWriter.println(string15);
            printWriter.println();
            printWriter.println(string17);
            printWriter.println();
            printWriter.println(string19);
            printWriter.println();
            printWriter.println(string21);
            printWriter.println();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            return vector;
        }
    }

    public String getMappedPredefinedAggTest(String string) {
        String[] stringArray = this.getVariables(preDefinedAggTest);
        if (stringArray != null && stringArray.length > 0) {
            Vector vector = this.getAllValues(preDefinedAggTest);
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = stringArray[i].trim();
                if (!vector.get(i).toString().equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public String getDetailsForComparison(String string, String string2) {
        String[] stringArray = this.getVariables(COMPARISON);
        if (stringArray != null && stringArray.length > 0) {
            String string3 = string + ":" + string2;
            Vector vector = this.getAllValues(COMPARISON);
            if (vector != null && vector != null && stringArray.length == vector.size()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].toString().equalsIgnoreCase(string3)) continue;
                    return (String)vector.get(i);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTestMeasureNames(String string) {
        Object object;
        this.checkForUpdate();
        Hashtable<String, Object> hashtable = null;
        String[] stringArray = this.getVariables(columnNameMapping);
        if (stringArray != null) {
            hashtable = new Hashtable<String, Object>();
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (!((String)object).startsWith(string + ":") || hashtable.contains(object)) continue;
                hashtable.put(((String)object).toUpperCase(), object);
            }
        }
        Hashtable hashtable2 = null;
        object = this.getVariables(aggFunction);
        Vector vector = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getAllValues(aggFunction);
            // ** MonitorExit[var7_8] (shouldn't be in output)
            if (object != null && ((Object)object).length > 0) {
                hashtable2 = new Hashtable();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    String string3;
                    Object object2 = object[i];
                    if (!((String)object2).startsWith(string + ":") || !hashtable.containsKey(string3 = ((String)object2).toUpperCase())) continue;
                    String string4 = (String)vector.get(i);
                    hashtable2.put(string4.substring(0, string4.indexOf(":")), hashtable.get(string3));
                }
            }
            return hashtable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAssociatedAggTests(String string) {
        ArrayList<String> arrayList = null;
        String[] stringArray = this.getVariables(aggTest);
        Vector vector = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector = this.getAllValues(aggTest);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (stringArray != null && stringArray.length > 0 && vector != null && !vector.isEmpty()) {
                arrayList = new ArrayList<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    String string3 = (String)vector.get(i);
                    if (!string3.equalsIgnoreCase(string)) continue;
                    arrayList.add(stringArray[i]);
                }
            }
            return arrayList;
        }
    }

    public String getTargetViolationByDescriptorsType() {
        String string = "ALL";
        try {
            string = this.getValue("TARGET_VIOLATION_BY_DESCRIPTORS", "Default", true);
            if (string == null || string.trim().length() == 0) {
                String string2 = "ALL";
                return string2;
            }
            if (string.trim().equalsIgnoreCase("LEAST")) {
                string = "LEAST";
            }
            string = "ALL";
            return string;
        }
        catch (Exception exception) {
            string = "ALL";
            return string;
        }
        finally {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getAggregateFunctions(String string) {
        Hashtable<String, String> hashtable = null;
        this.checkForUpdate();
        String[] stringArray = this.getVariables(aggFunction);
        Vector vector = null;
        String string2 = aggComponent;
        synchronized (aggComponent) {
            vector = aggregateFilePtr.getAllValues(aggFunction);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (!string3.startsWith(string + ":")) continue;
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, String>();
                    }
                    string3 = string3.substring(string3.indexOf(":") + 1);
                    String string4 = (String)vector.get(i);
                    string4 = string4.substring(string4.indexOf(":") + 1, string4.lastIndexOf(":")).trim();
                    hashtable.put(string3, string4);
                }
            }
            return hashtable;
        }
    }

    public Vector getAggThreshQueries(String string) {
        String[] stringArray = this.getColumnNamesForTest(string.substring(0, string.indexOf("_THRESH")));
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        string2 = "DROP TABLE " + string;
        vector.add(string2);
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string + "(");
        stringBuffer.append("TRGT_HOST VARCHAR(32) NOT NULL,");
        stringBuffer.append("PORT_NO VARCHAR(32) NOT NULL,");
        stringBuffer.append("SITE_NAME VARCHAR(64) NOT NULL,");
        stringBuffer.append("INFO VARCHAR(128) NOT NULL,");
        stringBuffer.append("MSMT_HOST VARCHAR(32) NOT NULL,");
        stringBuffer.append("MSMT_TIME_START DATETIME NOT NULL,");
        stringBuffer.append("MSMT_TIME_END DATETIME NOT NULL,");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i] + "_MIN VARCHAR(256) NOT NULL,");
            if (i + 1 == n) {
                stringBuffer.append(stringArray[i] + "_MAX VARCHAR(256) NOT NULL");
                continue;
            }
            stringBuffer.append(stringArray[i] + "_MAX VARCHAR(256) NOT NULL,");
        }
        stringBuffer.append(")");
        String string3 = stringBuffer.toString();
        vector.add(string3);
        stringBuffer.setLength(0);
        String string4 = "PK_" + string + "_TH";
        String string5 = "ALTER TABLE " + string + " ADD CONSTRAINT " + string4 + " PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START)";
        vector.add(string5);
        String string6 = "IDX_" + string + "_TH";
        String string7 = "CREATE INDEX " + string6 + " ON " + string + " (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END)";
        vector.add(string7);
        String string8 = "IDX_TH_" + string;
        String string9 = "CREATE INDEX " + string8 + " ON " + string + " (MSMT_TIME_START)";
        vector.add(string9);
        return vector;
    }

    private String createPartitionforTestTableInOracleDb(String string, boolean bl) {
        EgDateInfo egDateInfo = new EgDateInfo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
        Date date = egDateInfo.egetRealDate();
        String string2 = "";
        try {
            string2 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            System.err.println("invalid date Format");
            return string;
        }
        string = bl ? string + " PARTITION BY RANGE  (MSMT_TIME_START) INTERVAL(numtodsinterval(1, 'DAY')) (PARTITION p1 VALUES LESS THAN (TO_DATE('" + string2 + "', 'DD-MM-YYYY')))" : string + " PARTITION BY RANGE  (MSMT_TIME) INTERVAL(numtodsinterval(1, 'DAY')) (PARTITION p1 VALUES LESS THAN (TO_DATE('" + string2 + "', 'DD-MM-YYYY')))";
        return string;
    }

    static {
        configDir = null;
        egser = null;
        specs = null;
        preDefinedAggregateTests = new Vector();
        testerInfo = new EgTesterInfo("manager");
    }
}

