/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class EgDatabaseCreation
extends EgConfigInfo {
    static String entity = "setup_manager";
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    File file;
    Connection conn = null;
    Statement stmt = null;
    static String host;
    static String port;
    String url;
    String user;
    String password;
    String pathDir;
    String dbName;
    String domain;
    String ntlmV2;
    String fileName;
    String errorMsg = " ";
    static IniFile iniFile;
    static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray.length != 16) {
            System.out.println("Please pass 16 arguments  to execute ...");
            return;
        }
        if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-dbauser") && stringArray[6].equals("-dbapassword") && stringArray[8].equals("-filepath") && stringArray[10].equals("-driver") && stringArray[12].equals("-url") && stringArray[14].equals("-ntlmv2"))) {
            System.out.println("Usage:- java EgDatabaseCreation -host <hostname>  -port <portNo>  -dbauser <DbUser> -dbapassword <UserPasswd> -filepath <source path of SQL Files>  -driver <name of driver> -url <url> -ntlmv2 <true / false>");
            return;
        }
        File file = new File(stringArray[9]);
        if (!file.isFile()) {
            System.out.println("File  " + stringArray[9] + " is Not Found ");
            return;
        }
        EgDatabaseCreation egDatabaseCreation = new EgDatabaseCreation(stringArray);
        if (egDatabaseCreation.createDatabase()) {
            System.out.println("TRUE");
        } else {
            System.out.println(egDatabaseCreation.errorMsg);
        }
    }

    public EgDatabaseCreation(String[] stringArray) {
        System.setProperty("jsse.enableCBCProtection", "false");
        host = stringArray[1];
        port = stringArray[3];
        this.user = stringArray[5];
        int n = this.user.indexOf("\\");
        if (n < 0) {
            n = this.user.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.user.substring(0, n);
            this.user = this.user.substring(n + 1);
        }
        this.password = stringArray[7];
        this.fileName = stringArray[9];
        this.dbDriver = stringArray[11];
        this.url = stringArray[13];
        this.ntlmV2 = stringArray[15];
    }

    public void createSetupFile() {
        iniFile = new IniFile(this.fileName);
        iniDBFile = new IniFile(this.configInfo.getDbFile(), true);
    }

    public boolean createDatabase() {
        block8: {
            boolean bl = false;
            bl = this.connect();
            if (!bl) {
                return false;
            }
            try {
                this.stmt = this.conn.createStatement();
                if (this.fileName.indexOf("create_database") > -1) {
                    Vector vector = this.getData(this.fileName);
                    if (vector == null || vector.size() == 0) {
                        this.errorMsg = "No valid queries found";
                        return false;
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        String string = (String)vector.get(i);
                        try {
                            boolean bl2 = this.stmt.execute(string);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            this.errorMsg = sQLException.getMessage();
                            return false;
                        }
                    }
                    break block8;
                }
                this.errorMsg = "Create Database File not found";
                return false;
            }
            catch (Exception exception) {
                this.errorMsg = exception.getMessage();
                return false;
            }
        }
        this.closeConnection();
        return true;
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error when close the database connection..";
            return;
        }
    }

    boolean connect() {
        try {
            this.dbUrl = this.url;
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            if (this.domain == null || this.domain.equals("none")) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg = exception.getMessage();
            return false;
        }
        return true;
    }

    public Vector getData(String string) {
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        boolean bl = true;
        String string2 = " Null";
        String string3 = "";
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg = "/opt/egurkha/bin/create_database.sql file not Found ..";
            return null;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || (string3 = string3 + " " + string2).indexOf(";") == -1) continue;
                String string4 = string3.replace(';', ' ');
                vector.addElement(string4);
                string3 = "";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }
}

