/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class EgUserCreation {
    static String entity = "setup_manager";
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    File file;
    Connection conn = null;
    Statement stmt = null;
    static String host;
    static String sid;
    static String port;
    String url;
    String user;
    String password;
    String pathDir;
    String dbName;
    String ntlmV2;
    String fileName;
    String errorMsg = " ";
    static IniFile iniFile;
    static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;

    public static void main(String[] stringArray) {
        String string = "";
        System.setProperty("jsse.enableCBCProtection", "false");
        if (stringArray.length != 14) {
            System.out.println("Please pass 14 arguments to execute ...");
            return;
        }
        if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-dbauser") && stringArray[8].equals("-dbapassword") && stringArray[10].equals("-filepath") && stringArray[12].equals("-ntlmv2"))) {
            System.out.println("Usage:- java EgUserCreation -host <hostname>  -port <portNo> -sid<Database Instance Name> -dbauser <DbUser>  -dbapassword <UserPasswd> -filepath <source path of SQL Files> -ntlmv2 <true / false>");
            return;
        }
        sid = stringArray[5];
        File file = new File(stringArray[11]);
        if (!file.isFile()) {
            System.out.println("File  " + stringArray[11] + " is Not Found ");
            return;
        }
        EgUserCreation egUserCreation = new EgUserCreation(stringArray);
        if (!egUserCreation.createUser()) {
            System.out.println(egUserCreation.errorMsg);
        } else {
            System.out.println("TRUE");
        }
    }

    public EgUserCreation(String[] stringArray) {
        host = stringArray[1];
        port = stringArray[3];
        sid = stringArray[5];
        this.user = stringArray[7];
        this.password = stringArray[9];
        this.fileName = stringArray[11];
        this.ntlmV2 = stringArray[13];
        this.createSetupFile();
    }

    public void createSetupFile() {
        EgConfigInfo egConfigInfo = new EgConfigInfo("manager");
        iniFile = new IniFile(egConfigInfo.getSetupFile(), true);
        iniDBFile = new IniFile(egConfigInfo.getDbFile(), true);
    }

    public boolean getDatabaseInfo(Connection connection) {
        try {
            CallableStatement callableStatement = connection.prepareCall("sp_databases");
            callableStatement.executeQuery();
            ResultSet resultSet = callableStatement.executeQuery();
            boolean bl = false;
            while (resultSet.next()) {
                this.dbName = resultSet.getString("DATABASE_NAME");
                if (!this.dbName.startsWith("eGurkha")) continue;
                bl = true;
                break;
            }
            resultSet.close();
            callableStatement.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean createUser() {
        boolean bl = false;
        if (!this.connect()) {
            return false;
        }
        ResultSet resultSet = null;
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "select version from v$instance";
        String string3 = "select CDB from v$database";
        try {
            Object object;
            this.stmt = this.conn.createStatement();
            if (sid.equals("NULL")) {
                bl = this.getDatabaseInfo(this.conn);
            } else {
                resultSet = this.stmt.executeQuery(string2);
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                }
                resultSet.close();
                if (string == null || string.trim().length() == 0) {
                    bl2 = false;
                }
                if (bl2 = (string = string.toUpperCase()).startsWith("12.")) {
                    resultSet = this.stmt.executeQuery(string3);
                    while (resultSet.next()) {
                        object = resultSet.getString(1);
                        if (!((String)object).equalsIgnoreCase("yes")) continue;
                        bl3 = true;
                    }
                    resultSet.close();
                }
            }
            if (this.fileName.endsWith(".sql")) {
                object = this.getData(this.fileName);
                if (object == null || ((Vector)object).size() == 0) {
                    return false;
                }
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string4;
                    String string5 = (String)((Vector)object).get(i);
                    if (!bl && string5.trim().startsWith("drop database")) continue;
                    if (!sid.equals("NULL")) {
                        if (string5.startsWith("alter") && (!bl2 || !bl3 && string5.indexOf("container=") != -1)) continue;
                        if (string5.startsWith("create")) {
                            int n = string5.indexOf("=");
                            string4 = string5;
                            if (n != -1) {
                                string4 = string4.substring(0, n - 9);
                            }
                            if (!bl2) {
                                string5 = string4;
                            } else if (!bl3) {
                                string5 = string4;
                            }
                        }
                    }
                    try {
                        this.stmt.execute(string5);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        string4 = sQLException.toString();
                        if (string4.indexOf("User, group, or role") >= 0 && string4.indexOf("already exists in the current database") >= 0) continue;
                        this.errorMsg = "Error when sql queries are executed ..";
                        this.errorMsg = this.errorMsg + sQLException.getMessage();
                        SQLException sQLException2 = sQLException;
                        while ((sQLException2 = sQLException.getNextException()) != null) {
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.errorMsg = exception.getMessage();
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            return false;
        }
        this.closeConnection();
        return true;
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error closing  database connection..";
            return;
        }
    }

    public void getInfo() {
        this.dbDriver = iniDBFile.getValue("DB_PROPERTIES", "sql.driver");
        this.dbUrl = iniDBFile.getValue("DB_PROPERTIES", "sql.url");
    }

    boolean connect() {
        try {
            this.getInfo();
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            String string = "";
            int n = this.user.indexOf("\\");
            if (n < 0) {
                n = this.user.indexOf("/");
            }
            if (n < 0) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                string = this.user.substring(0, n);
                this.user = this.user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", string);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            this.errorMsg = exception.toString();
            this.errorMsg = this.errorMsg.indexOf("ORA-12514") >= 0 ? "Database connection failed due to invalid SID/SERVICENAME (ORA-12514)..." : (this.errorMsg.indexOf("ORA-12505") >= 0 ? "Database connection failed due to invalid SID/SERVICENAME (ORA-12505)..." : (this.errorMsg.indexOf("ORA-01017") >= 0 ? "Database connection failed due to invalid USERNAME/PASSWORD (ORA-01017) ..." : (this.errorMsg.indexOf("Cannot open database") >= 0 ? "Cannot open database or Database doesn't exist ..." : "Database connection failed ...")));
            return false;
        }
        return true;
    }

    public Vector getData(String string) {
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        boolean bl = true;
        String string2 = " Null";
        String string3 = "";
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg = "/opt/egurkha/bin/create_user.sql  file not Found ..";
            return null;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || (string3 = string3 + " " + string2).indexOf(";") == -1) continue;
                String string4 = string3.replace(';', ' ');
                string4 = string4.trim();
                vector.addElement(string4);
                string3 = "";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }
}

