/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JmxMBeanData {
    private MBeanServerConnection server = null;
    private String seperator = ">";

    public JmxMBeanData(MBeanServerConnection mBeanServerConnection, String string) {
        this.server = mBeanServerConnection;
        IniFile iniFile = null;
        iniFile = string.equals("manager") ? new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini") : new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        this.seperator = iniFile.getValue("ATTRIBUTE_SEPERATOR", "EgJmxTest");
    }

    private StringBuffer writeAttribute(StringBuffer stringBuffer, String string, ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo, Object object) {
        return this.write(stringBuffer, string, mBeanAttributeInfo.getName(), object);
    }

    private StringBuffer write(StringBuffer stringBuffer, String string, ObjectName objectName) {
        try {
            MBeanAttributeInfo[] mBeanAttributeInfoArray;
            MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName);
            stringBuffer.append(string).append("MBean: ").append(objectName).append("\n");
            String string2 = string + "   ";
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray = mBeanInfo.getAttributes()) {
                Object object = null;
                try {
                    object = this.server.getAttribute(objectName, mBeanAttributeInfo.getName());
                }
                catch (Exception exception) {
                    object = exception;
                }
                this.writeAttribute(stringBuffer, string2, objectName, mBeanAttributeInfo, object);
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer;
    }

    private String toString(String string, ObjectName objectName) throws IOException, JMException {
        return this.write(new StringBuffer(), string, objectName).toString();
    }

    public String toString(ObjectName objectName) throws IOException, JMException {
        return this.toString("", objectName);
    }

    private String display(String string, Object object) {
        return this.display("", string, object);
    }

    private String display(String string, String string2, Object object) {
        if (string2 == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        return this.write(stringBuffer, "", string2, object).toString();
    }

    private StringBuffer write(StringBuffer stringBuffer, String string, String string2, Object object) {
        if (object == null) {
            return this.writeSimple(stringBuffer, string, string2, null, true);
        }
        if (object.getClass().isArray()) {
            return this.writeArray(stringBuffer, string, string2, object);
        }
        if (object instanceof CompositeData) {
            return this.writeCompositeData(stringBuffer, string, string2, (CompositeData)object);
        }
        if (object instanceof TabularData) {
            return this.writeTabularData(stringBuffer, string, string2, (TabularData)object);
        }
        if (object instanceof Map) {
            return this.writeMap(stringBuffer, string, string2, (Map)object);
        }
        if (object instanceof Collection) {
            return this.writeArray(stringBuffer, string, string2, ((Collection)object).toArray());
        }
        return this.writeSimple(stringBuffer, string, string2, object, true);
    }

    private String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    private StringBuffer writeSimple(StringBuffer stringBuffer, String string, String string2, Object object, boolean bl) {
        stringBuffer.append(string).append(string2).append("=").append(this.toString(object));
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    private StringBuffer writeArray(StringBuffer stringBuffer, String string, String string2, Object object) {
        if (object == null) {
            return this.writeSimple(stringBuffer, string, string2, null, true);
        }
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            this.write(stringBuffer, string, string2 + "[" + i + "]", object2);
        }
        return stringBuffer;
    }

    private StringBuffer writeCompositeData(StringBuffer stringBuffer, String string, String string2, CompositeData compositeData) {
        if (compositeData == null) {
            return this.writeSimple(stringBuffer, string, string2, null, true);
        }
        String string3 = string + " ";
        Set<String> set = compositeData.getCompositeType().keySet();
        for (String string4 : set) {
            if (string4.equals("key")) {
                Object object = compositeData.get(string4);
                string4 = "";
                continue;
            }
            if (string4.equals("value")) {
                this.write(stringBuffer, string3, string2, compositeData.get(string4));
                continue;
            }
            this.write(stringBuffer, string3, string2 + this.seperator + string4, compositeData.get(string4));
        }
        return stringBuffer;
    }

    private StringBuffer writeTabularData(StringBuffer stringBuffer, String string, String string2, TabularData tabularData) {
        if (tabularData == null) {
            return this.writeSimple(stringBuffer, string, string2, null, true);
        }
        List<String> list = tabularData.getTabularType().getIndexNames();
        int n = list.size();
        for (Object obj : tabularData.keySet()) {
            Object[] objectArray = ((List)obj).toArray();
            StringBuilder stringBuilder = new StringBuilder(string2);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.seperator + objectArray[i]);
            }
            this.writeCompositeData(stringBuffer, string, stringBuilder.toString(), tabularData.get(objectArray));
            stringBuilder.append("\n");
        }
        return stringBuffer;
    }

    private StringBuffer writeMap(StringBuffer stringBuffer, String string, String string2, Map<Object, Object> map) {
        if (map == null) {
            return this.writeSimple(stringBuffer, string, string2, null, true);
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.write(stringBuffer, string, string2 + "[" + entry.getKey() + "]", entry.getValue());
        }
        return stringBuffer;
    }
}

