/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.EgTesterInfo;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLWebServerHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private int timeOut;
    public boolean status;
    public boolean done;
    public boolean isIIS = false;
    public boolean isApache = false;
    public boolean isNfuse = false;
    public boolean isWebLogic = false;
    public boolean isJRun = false;
    public boolean isXen = false;
    public boolean isXD = false;

    public SSLWebServerHelperThread(String string, int n, int n2) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = (int)((double)n2 * 0.9);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        this.cleanup();
        try {
            String string;
            BufferedReader bufferedReader;
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_6 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            URL uRL = new URL("https://" + this.hostIp + ":" + this.portNo);
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getHeaderField("Server");
            EgTesterInfo egTesterInfo = new EgTesterInfo("manager");
            int n = egTesterInfo.getWebServerDiscoveryContentSize();
            if (string2 != null) {
                if ((string2.indexOf("Microsoft") >= 0 || string2.indexOf("IIS") >= 0) && string2.indexOf("HTTPAPI") < 0) {
                    this.isIIS = true;
                } else if (string2.indexOf("Apache/") >= 0) {
                    this.isApache = true;
                } else if (string2.indexOf("WebLogic") >= 0) {
                    this.isWebLogic = true;
                } else if (string2.indexOf("Citrix") >= 0) {
                    this.isNfuse = true;
                } else if (string2.indexOf("JRun") >= 0) {
                    this.isJRun = true;
                }
            }
            int n2 = 0;
            if (!(this.isIIS || this.isApache || this.isWebLogic || this.isNfuse || this.isJRun)) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.indexOf("<address>Xapi Server</address>") < 0) continue;
                        this.isXen = true;
                        break;
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            } else if (!(!this.isIIS || this.isApache || this.isWebLogic || this.isNfuse || this.isJRun)) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.indexOf("/Citrix/DesktopWeb") < 0) continue;
                        this.isXD = true;
                        n2 += string.length();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n2 <= 0) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        n2 += string.length();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n2 < n) {
                this.status = false;
            }
            this.cleanup();
            this.done = true;
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sd = null;
    }
}

