/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.ApacheConfig;
import com.eg.EgConfigInfo;
import com.eg.IniFile;
import com.eg.TomcatConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SetupSmConfig
extends EgConfigInfo {
    public String errorMsg = null;
    public String egConfigFile = egMgrConfigDir + egSetupFile;
    IniFile configFile;
    int tomcatPort;
    int connectorPort;
    String serverName;
    String userName;
    String groupName;
    String serverPort;
    String javaPath;
    String isSsl;
    Process process = null;

    public static void main(String[] stringArray) {
        SetupSmConfig setupSmConfig = new SetupSmConfig();
        boolean bl = setupSmConfig.isFileExist();
        String string = " ";
        if (!bl) {
            string = "SetupSmConfig: File =" + setupSmConfig.egConfigFile + " not found ...";
            setupSmConfig.logToErrorFile("Manager SetUp:", string);
            System.out.println(string);
            return;
        }
        setupSmConfig.execute();
        if (setupSmConfig.errorMsg != null) {
            setupSmConfig.logToErrorFile("Error: ", setupSmConfig.errorMsg);
            System.out.println(setupSmConfig.errorMsg);
            return;
        }
    }

    public void execute() {
        this.errorMsg = null;
        this.getData();
        if (this.errorMsg != null) {
            return;
        }
        ApacheConfig apacheConfig = new ApacheConfig(this.serverName, this.userName, this.groupName, this.serverPort, this.connectorPort, this.isSsl);
        apacheConfig.execute();
        TomcatConfig tomcatConfig = new TomcatConfig(this.tomcatPort, this.connectorPort, this.javaPath, "false");
    }

    public boolean isFileExist() {
        File file = new File(this.egConfigFile);
        if (!file.exists()) {
            String string = "ManagerSetup : SetupSmConfig :File  " + this.egConfigFile + "  Not Found ";
            this.logToErrorFile("Error: ", string);
            return false;
        }
        return true;
    }

    public SetupSmConfig() {
        super("manager");
    }

    public void getData() {
        this.configFile = new IniFile(this.egConfigFile);
        this.serverPort = this.configFile.getValue("APACHE_SETTINGS", "apachePort");
        this.isSsl = this.configFile.getValue("APACHE_SETTINGS", "isSsl");
        this.serverName = this.configFile.getValue("SETTINGS", "EG_SERVER");
        String string = this.configFile.getValue("TOMCAT_SETTINGS", "tomcatPort");
        this.tomcatPort = Integer.parseInt(string);
        string = this.configFile.getValue("TOMCAT_SETTINGS", "connectorPort");
        this.connectorPort = Integer.parseInt(string);
        this.javaPath = this.configFile.getValue("TOMCAT_SETTINGS", "javaPath");
        this.userName = null;
        this.groupName = null;
        this.getConfigDetails();
        if (this.userName == null || this.groupName == null) {
            this.getApacheDetails();
        }
        if (this.userName == null || this.groupName == null) {
            this.errorMsg = "ManagerSetup : SetupSmConfig  Cannot get UserName and GroupName of installed egurkha manager";
        }
    }

    public void getApacheDetails() {
        BufferedReader[] bufferedReaderArray = this.executeProgram("ls  -ld /opt/egurkha/manager");
        if (bufferedReaderArray == null) {
            return;
        }
        if (this.process == null) {
            try {
                if (bufferedReaderArray[2] != null) {
                    bufferedReaderArray[2].close();
                }
                if (bufferedReaderArray[1] != null) {
                    bufferedReaderArray[1].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        String string = " ";
        String string2 = " ";
        try {
            while ((string = bufferedReaderArray[1].readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), " ");
                int n = stringTokenizer.countTokens();
                if (n < 4) continue;
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                this.userName = string2 = stringTokenizer.nextToken();
                this.groupName = string2 = stringTokenizer.nextToken();
            }
            if (bufferedReaderArray[2] != null) {
                bufferedReaderArray[2].close();
            }
            if (bufferedReaderArray[1] != null) {
                bufferedReaderArray[1].close();
            }
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getConfigDetails() {
        BufferedReader[] bufferedReaderArray = this.executeProgram("id");
        if (bufferedReaderArray == null) {
            return;
        }
        if (this.process == null) {
            try {
                if (bufferedReaderArray[2] != null) {
                    bufferedReaderArray[2].close();
                }
                if (bufferedReaderArray[1] != null) {
                    bufferedReaderArray[1].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        String string = " ";
        String string2 = " ";
        try {
            while ((string = bufferedReaderArray[1].readLine()) != null) {
                StringTokenizer stringTokenizer;
                int n;
                if (!(string = string.trim()).startsWith("uid") && !string.startsWith("gid") || (n = (stringTokenizer = new StringTokenizer(string, " ")).countTokens()) < 2) continue;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3;
                    string2 = stringTokenizer.nextToken();
                    if ((string2 = string2.trim()).startsWith("uid")) {
                        n3 = string2.indexOf("(");
                        n2 = string2.indexOf(")");
                        if (n3 != -1 && n2 != -1) {
                            this.userName = string2.substring(n3 + 1, n2);
                        }
                    }
                    if (!string2.startsWith("gid")) continue;
                    n3 = string2.indexOf("(");
                    n2 = string2.indexOf(")");
                    if (n3 == -1 || n2 == -1) continue;
                    this.groupName = string2.substring(n3 + 1, n2);
                }
            }
            if (bufferedReaderArray[2] != null) {
                bufferedReaderArray[2].close();
            }
            if (bufferedReaderArray[1] != null) {
                bufferedReaderArray[1].close();
            }
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedReader[] executeProgram(String string) {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader[] bufferedReaderArray = new BufferedReader[3];
        try {
            this.process = runtime.exec(string);
            bufferedReaderArray[2] = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

