Ext.Msg.cls='adminAlert';
Ext.Msg.layout = {
	type: 'anchor',
	pack:'center',
	align: 'center'
};

Ext.define('AgentStatus.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentStatusView'],
	requires:['AgentStatus.view.AgentStatusView','Ext.ux.data.PagingMemoryProxy'],
	refs:[
		{selector:'agentstatusview', ref:'agentstatusview'},
		{selector:'agentinformation', ref:'agentinformation'}
	],
	init:function(){
		ctrler = this;
		if(Ext.Array.contains(viewList,viewFrom))
		{
			this.buildMainData(sel_agent_type,selAgentStatus)
		}
		else
		{
			this.buildMainData('PremiumAgents','All')
		}
		this.control({
			'agentstatusview':
			{
				'afterrender': this.afterMainRender
			},
			'agentstatusview combo[id="agentType"]':
			{
				'select': this.agentTypeChange
			},
			'agentstatusview combo[id="agentStatus"]':
			{
				'select': this.agentStatusChange
			},
			'agentstatusview button[id="upgradeStatus"]':
			{
				'click':this.showUpgradeStatus
			},
			'agentstatusview button[id="restartAll"]':
			{
				'click':this.restartAllAgents
			},
			'agentstatusview button[id="agentSummary"]':
			{
				'click':this.agentSummaryList
			},
			'agentstatusview button[id="homeBack"]':
			{
				'click': this.goHome
			},
			'agentstatusview  button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
			'agentinformation button[id="backbutton"]':
			{
				'click': this.goBack
			},
			'agentinformation button[id="restartAgent"]':
			{
				'click': this.restartAgentFrmAgentInfo
			},
			'agentinformation button[id="resetAgent"]':
			{
				'click': this.resetAgentFrmAgentInfo
			},
			'agentinformation button[id="showLogs"]':
			{
				'click': this.showLogsFrmAgentInfo
			},
			'agentinformation button[id="StopAgent"]':
			{
				'click': this.stopAgentButton
			},
			'agentinformation button[id="showXmx"]':
			{
				'click': this.showXmxFrmAgentInfo
			},
			'agentstatusview button[id="RemoteControl"]':
			{
				'click': this.callMonitorRemoteControl
			}
		});
	},
	buildMainData: function(agentType,agentStatus)
	{
		if (from == 'AdminHome' || from == 'AgentAssign')
		{
			agentType = selAgentType;
			agentStatus = selAgentStatus;
		}
		
		Ext.Ajax.request(
		{
			url: 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus,
			method: 'POST',
			async:false,
			timeout: timeOut*1000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		jsonDataHolder = publicJSON;
	},
	afterMainRender: function()
	{
		totalCount = 0; //declared here
		var me = this;
		var agentType = publicJSON.agentType;
		var agentStatus = publicJSON.agentState;
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus;

		if (showAgentInformationView == 'true')
		{
			var debug = "no";
			Ext.getCmp('agentstatusviewport').removeAll();
			this.getController('AgentStatus.controller.AgentInfoCtrler').buildMainData(selectedAgentIP,debug,agentType,agentStatus);
			Ext.getCmp('agentstatusviewport').add({ xtype: 'agentinformation' });
			this.getController('AgentStatus.controller.AgentInfoCtrler').afterMainRender();
			Ext.getCmp('agentIP').setValue(selectedAgentIP);
		}
		else if (viewFrom == 'AgentInfo')
		{
			Ext.getCmp('agentstatusviewport').removeAll();
			this.getController('AgentStatus.controller.AgentInfoCtrler').buildMainData(selectedAgentIP,isDebugEnabled,sel_agent_type,agentStatus);
			Ext.getCmp('agentstatusviewport').add({ xtype: 'agentinformation' });
			this.getController('AgentStatus.controller.AgentInfoCtrler').afterMainRender();
			Ext.getCmp('agentIP').setValue(selectedAgentIP);
		}
		else
		{
			Ext.getCmp('agentType').getStore().loadRawData(publicJSON.agentTypes);
			Ext.getCmp('agentType').setValue(publicJSON.agentType);
			Ext.getCmp('agentStatus').getStore().loadRawData(publicJSON.agentStatus);
			Ext.getCmp('agentStatus').setValue(publicJSON.agentState);
			var noAgentsFound = publicJSON.noManagedHostsFound
			if (from == 'AdminHome')
			{
				noAgentsFound = !publicJSON.managedHostsFoundForSearch;
				Ext.getCmp('homeBack').show();
			}
			else if (from == 'AgentAssign')
			{
				var idx = backHref.indexOf('EgLicenseInfo.jsp');
				if(idx > -1)
				{
					Ext.getCmp('homeBack').show();
				}
			}
			else if (from == 'licenseoverview')
			{
				var idx = backHref.indexOf('EgLicenseInfo.jsp');
				if(idx > -1)
				{
					Ext.getCmp('homeBack').show();
				}
			}
			else
			{
				Ext.getCmp('homeBack').hide();
			}

			var getElObj = Ext.getCmp('agentStatusView').getEl();
			var getPanelObj = Ext.getCmp('resultpanel');
			getElObj.mask("Loading...","maskCenter");

			if ( publicJSON.enableSearch )
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('resultpanel').show();
				Ext.getCmp('resultpanel').removeAll();
				var allUsersDataArr = publicJSON.agentDetails;
				if ( !Ext.isEmpty(allUsersDataArr))
				{
					Ext.define('GridModel', {
						extend: 'Ext.data.Model',
						fields: [{name:'AgentIP',sortType:'asAgentIP'}, 'Installed', 'Status', 'Output', 'Restart', 'Logs', 'AssignedHosts','StopAgent', 'Xmx','isAgentShared','RemoteControl','IP_Address'],
					});
					 // create the Data Store
					var store = Ext.create('Ext.data.Store', {
						pageSize: 50,
						model: 'GridModel',
						proxy: {
							type:'pagingmemory',
							url: urlStr,
							reader: {
								type: 'json',
								root: 'agentDetails',
								totalProperty: 'totalProperty',
							},
							encodeFilters: function(filters) {
								return filters[0].value;
							}
						},
						data: allUsersDataArr,
						storeId: 'store',
						remoteFilter: true,
						remoteSort: true,
						simpleSortMode: true,
						autoLoad: true
					});

					getPanelObj.add({
						xtype: 'customgrid',
						ui:'newGridPanel whiteHeader',
						id:'agentInfoGrid',
						margin: 10,
						border:true,
						flex:1,
						//loadMask: true,
						scroll: true,
						height: 380,
						autoScroll: true,
						store: store,
						viewConfig: {
							forceFit: true,
							stripeRows : true
						},
						sortOnLoad: true,
						sorters: [{
							property: 'AgentIP',
							direction: 'ASC'
						}],
						dockedItems:[{
							xtype: 'pagingtoolbar',
							id:'pagingtoolbarid',
							store: store,
							dock: 'bottom',
							cls:'newPagination',
							displayInfo: true
						}],
						requires : [
							'Ext.ux.CheckColumn',
							'Ext.ux.RowExpander',
						],
						columns: [
							{
								text: agentIPNick,
								dataIndex: 'AgentIP',
								flex: 1,
								renderer : function(value, metaData, record, row, store, gridView) {
									var agentNick = value.substring(0,value.indexOf('~'));
									var installed = value.substring(value.indexOf('~')+1);
									var result = "";
									if (installed == 'Yes')
									{
										result = '<a class="eg_monlink" href="javascript:ctrler.showAgentInfo('+row+',\'agentInfoGrid\',\''+agentType+'\',\''+publicJSON.agentState+'\')">'+agentNick+'</a>';
									}
									else
									{
										result = agentNick;
									}
									return result;
								}
							},
							{
								text: installed,
								dataIndex: 'Installed',
								width: 80,
								renderer : function(value) {
									var result = "";
									if (value == "Yes")
									{
										result='<center><div class="iconAgentInstalled" data-qtip="Agent Installed" data-qclass="yellowTip"></div></center>'
									}
									else
									{
										result='<center><div class="iconAgentNotInstalled" data-qtip="Agent Not Installed" data-qclass="yellowTip"></div></center>'
									}
									return result;
								}
							},
							{
								text: status,
								dataIndex: 'Status',
								width: 90,
								renderer : function(value) {
									var result = "";
									if (value == "Running")
									{
										result = '<center><img src="/final/images/'+theme+'/agentRunning.gif" border="0" vspace="0" data-qtip="Agent Running" data-qclass="yellowTip" valign="middle"></center>';
									}
									else
									{
										result = '<center><img src="/final/images/'+theme+'/agentNotRunning.gif" border="0" vspace="0" data-qtip="Agent Not Running" data-qclass="yellowTip" valign="middle"></center>';
									}
									return result;
								}
							},
							{
								xtype: 'checkcolumn',
								text: opLog,
								dataIndex: 'Output',
								width: 190,
								listeners: {
									checkchange: function (column, row, checked) {
										var rowObj = Ext.getCmp('agentInfoGrid').getStore().getAt(row);
										var installed = rowObj.get('Installed');
										if (rowObj.get('Status')=='Running' && installed == 'Yes' && !ctrler.disableAgentDebug(rowObj.get('AgentIP')))
										{
											var is_agent_shared = rowObj.get('isAgentShared');
											if(is_agent_shared != null && is_agent_shared.indexOf('~true')>0)
											{
												if (checked)
												{
													rowObj.set('Output',false);
												}
												else
												{
													rowObj.set('Output',true);
												}
												return false;
											}
											else
											{
												ctrler.outputLoggingChange(checked,row,'agentInfoGrid');
											}
										}
										else
										{
											if (checked)
											{
												rowObj.set('Output',false);
											}
											else
											{
												rowObj.set('Output',true);
											}
											return false;
										}
									}
								},
								renderer:function(value, metaData, record)
								{
									var agentSharedValue = record.get('isAgentShared');
									var setDisableOutputLogging = agentSharedValue.substring(agentSharedValue.indexOf('~')+1);
									if(ctrler.disableAgentDebug(record.get('AgentIP')))
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										metaData.tdCls += ' '+'x-item-disabled';
										metaData.tdAttr = 'data-qtip= "' + 'Output logging has been manully enabled' + '" data-qclass="tipCls" data-qwidth=215';
										return ccObj;
									}
									if (setDisableOutputLogging == "true")
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										metaData.tdCls += ' '+'x-item-disabled';
										return ccObj;
										//return '<div class="custom-form-checkbox" style="margin:-5px 0 0 86px;padding:10px;"></div>';
									}
									else
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										return ccObj;
									}
								}
							},
							{
								text: logs,
								dataIndex: 'Logs',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									if (value == "Show")
									{
										result = '<center><a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><div class="iconData" data-qtip="Agent Logs" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result='<center><div class="iconData" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Logs" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: restart,
								dataIndex: 'Restart',
								width: 80,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var opt = value.substring(0,value.indexOf('~'));
									var nick = value.substring(value.indexOf('~')+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><div class="iconRestart"  data-qtip="Agent Restart" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconRestart"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Restart" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: stopAgent,
								dataIndex: 'StopAgent',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var opt = value.substring(0,value.indexOf('~'));
									var nick = value.substring(value.indexOf('~')+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.stopAgentButton('+row+',\'agentInfoGrid\');"><div class="iconStop"  data-qtip="Agent Stop" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconStop"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Stop Agent" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: xmx,
								dataIndex: 'Xmx',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									if (value == "Show")
									{
										result = '<center><a href="javascript:ctrler.showXmx('+row+',\'agentInfoGrid\');"><div class="iconSettings" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result='<center><div class="iconSettings" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text:assoHosts,
								dataIndex: 'AssignHostsLink',
								width: 125,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									result = "";
									var result = '<center><a href="javascript:ctrler.showAssignHosts('+row+',\'agentInfoGrid\');"><div class="iconShowAssociates"  data-qtip="Associate hosts" data-qclass="yellowTip"></div></a></center>';
									return result;
								}
							},
							{
								text: agentShared,
								dataIndex: 'isAgentShared',
								hidden: true,
								width: 125,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var isAgentShared = value.substring(0,value.indexOf('~'));
									var setDisableOutputLogging = value.substring(value.indexOf('~')+1);
									result = "";
									var result = '<center>'+isAgentShared+'</center>';
									return result;
								}
							},
							{
								text: remotecontrol,
								dataIndex: 'RemoteControl',
								width: 120,
								sortable: false,
								hidden:!publicJSON.showMonitorRC,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var idx = value.indexOf('~');
									var last_idx = value.lastIndexOf('~');
									var opt = value.substring(0,idx);
									var nick = value.substring(idx+1,last_idx);
									var mode = value.substring(last_idx+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.callMonitorRemoteControl('+row+',\'agentInfoGrid\',\''+mode+'\');"><div class="iconRemoteControl"  data-qtip="Remote Control" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconRemoteControl"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Remote Control" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							}
						],
						plugins: [
							{
								ptype: 'rowexpander',
								expandOnDblClick: false,
								id:'rowExp',
								rowBodyTpl : [
									'{[this.getRowView(values)]}',
									{
										getRowView : function(values)
										{
											var viewStr = '<div><p><i>Assigned hosts</i></p></div>';
											var agentNames = '<div style="padding-bottom:3px">'+values.AssignedHosts+'</div>';
											if (agentNames.indexOf('-') == 0)
											{
												viewStr += agentNames;
											}
											else
											{
												var vals = agentNames.split(',');
												var valsLen = vals.length;
												var rem = valsLen%3;
												if (rem != 0)
												{
													var tmp = 3 - rem;
													for (var t=0; t<tmp; t++)
													{
														agentNames +=', ';
													}
													vals = agentNames.split(',');
												}
												viewStr = '<div><p><i>Assigned hosts ('+valsLen+')</i></p></div>';
												viewStr += "<table border='0' width='100%' style='margin-bottom:6px'>";
												for (var v=0; v < vals.length; v=v+3)
												{
													viewStr += "<tr><td style='padding:2px'>"+vals[v]+"</td><td>"+vals[v+1]+"</td><td>"+vals[v+2]+"</td></tr>";
												}
												viewStr += "</table>";
											}
											return viewStr;
										}
									}
								]
							}
						],
						tbar: [
							{
								xtype:'displayfield',
								fieldLabel:numberOfAgents,
								labelSeparator: ' :',
								id:'totalAgents',
								height:20,
								labelWidth:150
							},
							{
								xtype:'tbfill',
							},
							{
								xtype: 'trigger',
								cls:'whitedropdown_search',
								trigger1Cls: 'x-form-clear-trigger',
								trigger2Cls: 'x-form-search-trigger',
								emptyText: 'Search',
								padding: '2 6 2 0',
								disabled:true,
								onTrigger1Click: function() {
									this.reset();
									ctrler.filterRecords();
								},
								onTrigger2Click: function() {
									ctrler.filterRecords();
								},
								listeners:{
									specialkey: function(field, e){
										if (e.getKey() == e.ENTER) {
											ctrler.filterRecords();
										}
									}
								},
								id: 'searchBox',
								itemId: 'searchTrigger',
								getTriggerMarkup: function() {
									var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
									// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									// trigger config objects that hold cls, handler, etc.
									// triggerCls is a synonym for trigger1Cls, so copy it.
									if (!me.trigger1Cls) {
										me.trigger1Cls = me.triggerCls;
									}
									// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
										if (i == 0)
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style + "display:none;",
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
										else
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style,
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
									}
									triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
									return Ext.DomHelper.markup(triggerConfigs);
								}
							}
						]
					});
					store.load();
				}

				var totalAgent = publicJSON.totalProperty;
				if (!Ext.isEmpty(totalAgent))
				{
					totalCount = totalAgent;
					Ext.getCmp('totalAgents').show();
					Ext.getCmp('totalAgents').setValue(totalAgent);
				}
				else
				{
					Ext.getCmp('totalAgents').hide();
				}

				if (isLimitedAdmin == "true")
				{
					Ext.getCmp('restartAll').hide();
				}
				else
				{
					Ext.getCmp('restartAll').show();
				}

				Ext.getCmp('saveCSV').show();
				if (publicJSON.enableSearch)
				{
					if (me.getAgentstatusview().down('#searchTrigger'))
					{
						me.getAgentstatusview().down('#searchTrigger').enable();
					}
					Ext.getCmp('totalAgents').enable();
				}

				if (publicJSON.agentType=='ExternalAgents' || publicJSON.agentType=='RemoteAgents')
				{
					Ext.getCmp('agentInfoGrid').columns[0].setVisible(true);
					if(isLimitedAdmin == "false")
					{
						Ext.getCmp('agentInfoGrid').columns[9].setVisible(true);
					}
				}
				else
				{
					Ext.getCmp('agentInfoGrid').columns[0].setVisible(false);
					Ext.getCmp('agentInfoGrid').columns[9].setVisible(false);
				}
			}
			else
			{
				Ext.getCmp('resultpanel').hide();
				Ext.getCmp('resultpanel').removeAll();
				if (me.getAgentstatusview().down('#searchTrigger'))
				{
					me.getAgentstatusview().down('#searchTrigger').disable();
				}

				Ext.getCmp('restartAll').hide();
				Ext.getCmp('saveCSV').disable();
			//	Ext.getCmp('totalAgents').hide();
				Ext.getCmp('NoUserAvailable').show();
			}
			getPanelObj.doLayout();
			getElObj.unmask();
		}
	},

	filterRecords: function()
	{
		var value = Ext.getCmp('searchBox').getValue();
		var store = Ext.getStore("store");
		store.clearFilter();
		totalRecords = 0;
		if (value == "" || value.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
			
			totalRecords = totalCount;			
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
			
			var searchList = new Array();
			var searchString = value.split(' ');
			for(var s=0;s<searchString.length;s++)
			{
				var str = searchString[s].trim();
				if(str != "")
					searchList.push(str);
			}
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var agentIp = item.get('AgentIP');
					if(doesExist(searchList,agentIp))
					{
						return true;
					}
				}
			});
			store.suspendEvents(true);
			store.filter(userFilter);
			store.resumeEvents();
		}
		if(totalRecords > 0)
		{
			Ext.getCmp('totalAgents').setValue(totalRecords);
			Ext.getCmp('totalAgents').show();
			Ext.getCmp('saveCSV').enable();
		}
		else
		{
			Ext.getCmp('totalAgents').hide();
			Ext.getCmp('saveCSV').disable();
			Ext.getCmp('agentInfoGrid').getView().emptyText = '<div class="egFlexCenterByColumnWise" style="height:98%"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noAgentsFound+'.</div></div>';
			Ext.getCmp('agentInfoGrid').getView().refresh();
		}
	},

	searchAgent: function()
	{
		var agentType = Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?search=true&agent='+agentType+'&status='+agentStatus;
		if (searchStr != '')
		{
			urlStr += '&hostname='+searchStr;
		}
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
       if (jsonDataHolder.search=='true')
		{
			var gridObj = Ext.getCmp('agentInfoGrid');
			//Setting the value of Number of agent field if Search result is true.
			var totalAgent=jsonDataHolder.totalNoAgent;
			Ext.getCmp('totalAgents').setValue(totalAgent);
			if (jsonDataHolder.managedHostsFoundForSearch)
			{
				if (isLimitedAdmin == "true")
				{
					Ext.getCmp('restartAll').hide();
				}
				else
				{
					Ext.getCmp('restartAll').show();
				}
				Ext.getCmp('saveCSV').show();
				Ext.getCmp('totalAgents').enable();
				gridObj.show();
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(jsonDataHolder.agentDetails);
				if (jsonDataHolder.agentType=='ExternalAgents' || jsonDataHolder.agentType=='RemoteAgents')
				{
					gridObj.columns[0].setVisible(true);
					if(isLimitedAdmin == "false")
					{
						gridObj.columns[9].setVisible(true);
					}
				}
				else
				{
					gridObj.columns[0].setVisible(false);
					gridObj.columns[9].setVisible(false);
				}
			}
			else 
			{
				Ext.getCmp('restartAll').hide();
				Ext.getCmp('saveCSV').hide();
				//Disabling the Total number of Agent field if Search result is false.
				Ext.getCmp('totalAgents').disable();
				gridObj.show();
				gridObj.getStore().removeAll();
				Ext.get('noAgentAlrtDiv').update(noAgentsFound+'.');
			}
		}
	},
	updateOutputLoging: function()
	{
		ctrler.buildGridOnChange(true);
	},
	buildGridOnChange: function(fromOutputlog)
	{
		var me = this;
		var agentType = Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus;
		
		var searchStr = '';
		if (!Ext.isEmpty(Ext.getCmp('searchBox')))
		{
			searchStr = Ext.getCmp('searchBox').getValue();
		}
		var getElObj = Ext.getCmp('agentStatusView').getEl();
		var getPanelObj = Ext.getCmp('resultpanel');
		getElObj.mask("Loading...","maskCenter");

		Ext.getCmp('resultpanel').hide();
		Ext.getCmp('NoUserAvailable').hide();

		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			//async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);

				//Ext.getCmp('agentType').getStore().loadRawData(jsonDataHolder.agentTypes);
				//Ext.getCmp('agentType').setValue(jsonDataHolder.agentType);
				//Ext.getCmp('agentStatus').getStore().loadRawData(jsonDataHolder.agentStatus);
				//Ext.getCmp('agentStatus').setValue(jsonDataHolder.agentState);
				//Setting the value for number of Agents field If Agents for Particular Agent Type is displayed.

				if (jsonDataHolder.enableSearch)
				{
					Ext.getCmp('saveCSV').enable();
					Ext.getCmp('resultpanel').show();
					Ext.getCmp('resultpanel').removeAll();
					Ext.getCmp('NoUserAvailable').hide();

					var allUsersDataArr = jsonDataHolder.agentDetails;
					if (!Ext.isEmpty(allUsersDataArr))
					{
						Ext.define('GridModel', {
							extend: 'Ext.data.Model',
							fields: [{name:'AgentIP',sortType:'asAgentIP'}, 'Installed', 'Status', 'Output', 'Restart', 'Logs', 'AssignedHosts','StopAgent', 'Xmx','isAgentShared','RemoteControl','IP_Address'],
						});

						 // create the Data Store
						var store = Ext.create('Ext.data.Store', {
							pageSize: 50,
							model: 'GridModel',
							proxy: {
								type:'pagingmemory',
								url: urlStr,
								reader: {
									type: 'json',
									root: 'agentDetails',
									totalProperty: 'totalProperty',
								},
								encodeFilters: function(filters) {
									return filters[0].value;
								}
							},
							data: allUsersDataArr,
							storeId: 'store',
							remoteFilter: true,
							remoteSort: true,
							simpleSortMode: true,
							autoLoad: true
						});

						getPanelObj.add({
							xtype: 'customgrid',
							ui:'newGridPanel whiteHeader',
							id:'agentInfoGrid',
							margin: 10,
							flex:1,
							border:true,
							//loadMask: true,
							scroll: true,
							height: 380,
							autoScroll: true,
							store: store,
							dockedItems:[{
								xtype: 'pagingtoolbar',
								id:'pagingtoolbarid',
								store: store,
								dock: 'bottom',
								cls:'newPagination',
								displayInfo: true
							}],
							requires : [
								'Ext.ux.CheckColumn',
								'Ext.ux.RowExpander',
							],
							plugins: [
								{
									ptype: 'rowexpander',
									expandOnDblClick: false,
									id:'rowExp',
									rowBodyTpl : [
									//	'<p><b>Assigned hosts</b><br>{AssignedHosts}</p>'
										'{[this.getRowView(values)]}',
										{
											getRowView : function(values)
											{
												var viewStr = '<div><p><i>Assigned hosts</i></p></div>';
												var agentNames = '<div style="padding-bottom:3px">'+values.AssignedHosts+'</div>';
												if (values.AssignedHosts=="- No assigned hosts found -")
												{
													viewStr += agentNames;
												}
												else
												{
													var vals = agentNames.split(',');
													var valsLen = vals.length;
													var rem = valsLen%3;
													if (rem != 0)
													{
														var tmp = 3 - rem;
														for (var t=0; t<tmp; t++)
														{
															agentNames +=', ';
														}
														vals = agentNames.split(',');
													}
													viewStr = '<div><p><i>Assigned hosts ('+valsLen+')</i></p></div>';
													viewStr += "<table border='0' width='100%' style='margin-bottom:6px'>";
													for (var v=0; v < vals.length; v=v+3)
													{
														viewStr += "<tr><td width='30%' style='padding:2px'>"+vals[v]+"</td><td width='30%'>"+vals[v+1]+"</td><td width='30%'>"+vals[v+2]+"</td></tr>";
													}
													viewStr += "</table>";
												}
												return viewStr;
											}
										}
									]
								}
							],
							columns: [
								{
									text: agentIPNick,
									dataIndex: 'AgentIP',
									flex: 1,
									renderer : function(value, metaData, record, row, store, gridView) {
										var agentNick = value.substring(0,value.indexOf('~'));
										var installed = value.substring(value.indexOf('~')+1);
										var result = "";
										if (installed == 'Yes')
										{
											result = '<a class="eg_monlink" href="javascript:ctrler.showAgentInfo('+row+',\'agentInfoGrid\',\''+agentType+'\',\''+agentStatus+'\')">'+agentNick+'</a>';
										}
										else
										{
											result = agentNick;
										}
										return result;
									}
								},
								{
									text: installed,
									dataIndex: 'Installed',
									width: 80,
									renderer : function(value) {
										var result = "";
										if (value == "Yes")
										{
											result='<center><div class="iconAgentInstalled" data-qtip="Agent Installed" data-qclass="yellowTip"></div></center>'
										}
										else
										{
											result='<center><div class="iconAgentNotInstalled" data-qtip="Agent Not Installed" data-qclass="yellowTip"></div></center>'
										}
										return result;
									}
								},
								{
									text: status,
									dataIndex: 'Status',
									width: 90,
									renderer : function(value) {
										var result = "";
										if (value == "Running")
										{
											result = '<center><img src="/final/images/'+theme+'/agentRunning.gif" border="0" vspace="0" data-qtip="Agent Running" data-qclass="yellowTip" valign="middle"></center>';
										}
										else
										{
											result = '<center><img src="/final/images/'+theme+'/agentNotRunning.gif" border="0" vspace="0" data-qtip="Agent Not Running" data-qclass="yellowTip" valign="middle"></center>';
										}
										return result;
									}
								},
								{
									xtype: 'checkcolumn',
									text: opLog,
									dataIndex: 'Output',
									width: 190,
									listeners: {
										checkchange: function (column, row, checked) {
											var rowObj = Ext.getCmp('agentInfoGrid').getStore().getAt(row);
											var installed = rowObj.get('Installed');
											if (rowObj.get('Status')=='Running' && installed == 'Yes' && !ctrler.disableAgentDebug(rowObj.get('AgentIP')))
											{
												var is_agent_shared = rowObj.get('isAgentShared');
												if(is_agent_shared != null && is_agent_shared.indexOf('~true')>0)
												{
													if (checked)
													{
														rowObj.set('Output',false);
													}
													else
													{
														rowObj.set('Output',true);
													}
													return false;
												}
												else
												{
													ctrler.outputLoggingChange(checked,row,'agentInfoGrid');
												}
											}
											else
											{
												if (checked)
												{
													rowObj.set('Output',false);
												}
												else
												{
													rowObj.set('Output',true);
												}
												return false;
											}
										}
									},
									renderer:function(value, metaData, record)
									{
										var agentSharedValue = record.get('isAgentShared');
										var setDisableOutputLogging = agentSharedValue.substring(agentSharedValue.indexOf('~')+1);
										if(ctrler.disableAgentDebug(record.get('AgentIP')))
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											metaData.tdCls += ' '+'x-item-disabled';
											metaData.tdAttr = 'data-qtip= "' + 'Output logging has been manully enabled' + '" data-qclass="tipCls" data-qwidth=215';
											return ccObj;
										}
										if (setDisableOutputLogging == "true")
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											metaData.tdCls += ' '+'x-item-disabled';
											return ccObj;
										}
										else
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											return ccObj;
										}
									}
								},
								{
									text: logs,
									dataIndex: 'Logs',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										if (value == "Show")
										{
											result = '<center><a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><div class="iconData" data-qtip="Agent Logs" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result='<center><div class="iconData" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Logs" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: restart,
									dataIndex: 'Restart',
									width: 80,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var opt = value.substring(0,value.indexOf('~'));
										var nick = value.substring(value.indexOf('~')+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><div class="iconRestart"  data-qtip="Agent Restart" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconRestart"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Restart" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: stopAgent,
									dataIndex: 'StopAgent',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var opt = value.substring(0,value.indexOf('~'));
										var nick = value.substring(value.indexOf('~')+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.stopAgentButton('+row+',\'agentInfoGrid\');"><div class="iconStop"  data-qtip="Agent Stop" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconStop"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Stop Agent" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: xmx,
									dataIndex: 'Xmx',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										if (value == "Show")
										{
											result = '<center><a href="javascript:ctrler.showXmx('+row+',\'agentInfoGrid\');"><div class="iconSettings" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result='<center><div class="iconSettings" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text:assoHosts,
									dataIndex: 'AssignHostsLink',
									width: 125,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										result = "";
										var result = '<center><a href="javascript:ctrler.showAssignHosts('+row+',\'agentInfoGrid\');"><div class="iconShowAssociates"  data-qtip="Associate hosts" data-qclass="yellowTip"></div></a></center>';
										return result;
									}
								},
								{
									text: agentShared,
									dataIndex: 'isAgentShared',
									hidden: true,
									width: 125,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var isAgentShared = value.substring(0,value.indexOf('~'));
										var setDisableOutputLogging = value.substring(value.indexOf('~')+1);
										result = "";
										var result = '<center>'+isAgentShared+'</center>';
										return result;
									}
								},
								{
									text: remotecontrol,
									dataIndex: 'RemoteControl',
									width: 120,
									sortable: false,
									hidden:!jsonDataHolder.showMonitorRC,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var idx = value.indexOf('~');
										var last_idx = value.lastIndexOf('~');
										var opt = value.substring(0,idx);
										var nick = value.substring(idx+1,last_idx);
										var mode = value.substring(last_idx+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.callMonitorRemoteControl('+row+',\'agentInfoGrid\',\''+mode+'\');"><div class="iconRemoteControl"  data-qtip="Remote Control" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconRemoteControl"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Remote Control" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								}
							],
							tbar: [
								{
									xtype:'displayfield',
									fieldLabel:numberOfAgents,
									labelSeparator: ' :',
									id:'totalAgents',
									height:20,
									labelWidth:150
								},
								{
									xtype:'tbfill',
								},
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									padding: '2 6 2 0',
									disabled:true,
									onTrigger1Click: function() {
										this.reset();
                    ctrler.filterRecords();
									},
									onTrigger2Click: function() {
										ctrler.filterRecords();
									},
									listeners:{
										specialkey: function(field, e){
											if (e.getKey() == e.ENTER) {
												ctrler.filterRecords();
											}
										}
									},
									id: 'searchBox',
									itemId: 'searchTrigger',
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							]
						});
						store.load();
					}
					if (isLimitedAdmin == "true")
					{
						Ext.getCmp('restartAll').hide();
					}
					else
					{
						Ext.getCmp('restartAll').show();
					}

					Ext.getCmp('saveCSV').show();
					if (jsonDataHolder.enableSearch)
					{
						if (me.getAgentstatusview().down('#searchTrigger'))
						{
							me.getAgentstatusview().down('#searchTrigger').enable();
						}
						Ext.getCmp('totalAgents').enable();
					}

					if (jsonDataHolder.agentType=='ExternalAgents' || jsonDataHolder.agentType=='RemoteAgents')
					{
						Ext.getCmp('agentInfoGrid').columns[0].setVisible(true);
						if(isLimitedAdmin == "false")
						{
							Ext.getCmp('agentInfoGrid').columns[9].setVisible(true);
						}
					}
					else
					{
						Ext.getCmp('agentInfoGrid').columns[0].setVisible(false);
						Ext.getCmp('agentInfoGrid').columns[9].setVisible(false);
					}
				}
				else
				{
					if (me.getAgentstatusview().down('#searchTrigger'))
					{
						me.getAgentstatusview().down('#searchTrigger').disable();
					}
					Ext.getCmp('restartAll').hide();
					Ext.getCmp('saveCSV').disable();
					Ext.getCmp('NoUserAvailable').show();
				}
				if(fromOutputlog && !Ext.isEmpty(searchStr))
				{
					Ext.getCmp('searchBox').setValue(searchStr);
					Ext.getCmp('totalAgents').setValue(totalRecords);
					ctrler.filterRecords();
				}
				else if (!Ext.isEmpty(Ext.getCmp('totalAgents')))
				{
					totalCount = jsonDataHolder.totalProperty;
					Ext.getCmp('totalAgents').setValue(totalCount);
				}
				getPanelObj.doLayout();
				getElObj.unmask();
			},
			failure : function(response)
			{
				getPanelObj.doLayout();
				getElObj.unmask();
			}
		});
	},
	agentTypeChange: function()
	{
		ctrler.buildGridOnChange(false);
	},
	agentStatusChange: function()
	{
		this.agentTypeChange();
	},
	showUpgradeStatus:function()
	{
		window.location.href="/final/admin/EgUpgradeStatus.jsp?fromPage=AgentStatus";
	},
	agentSummaryList:function()
	{
		var urlStr = "AgentStatus/data/EgAgentSummaryJson.jsp";
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				var resultJSON = Ext.decode(jsonText);
				Ext.widget("window",
				{
					extend:'Ext.window.Window',
					alias:'widget.agentSummaryWindow',
					title :'Agent Summary',
					id:'agentSummaryWindow',
					width: 800,
					minHeight: 200,
					layout: 'fit',
					padding : '5 10 10 10',
					modal : true,
					border : false,
					ghost: false,
					scroll:true,
					autoScroll:true,
					closeAction : 'destroy',
					listeners: 
					{
						'destroy' : function() 
						{
							var agentType = Ext.getCmp('agentType').getValue();
							var agentStatus = Ext.getCmp('agentStatus').getValue();
							var urlStr = 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus;
							Ext.Ajax.request(
							{
								url: urlStr,
								method: 'POST',
								async:false
							});
						}
					},
					items:[
					{
						xtype: 'customgrid',
						border:true,
						id:'agentSummaryGrid',
						ui:'newGridPanel whiteHeader',
						layout: 
						{
							type: 'vbox',
							align: 'stretch'
						},
						flex: 1,
						store: new Ext.data.Store(
						{
							fields: ['AgentType','TotalAgents','Running','NotRunning'],
							data: []
						}),
						tbar: [
						{
							xtype:'displayfield',
							fieldLabel:numberOfAgents,
							labelSeparator:' :',
							id:'totalSummaryAgents',
							height:20,
							labelWidth: 140
						},
						{
							xtype: 'tbfill'
						},
						{
							xtype:'button',
							id: 'saveCSVAgenUsage',
							iconCls:'iconCsv',
							margin: '0 5 0 0',
							height:20,
							padding: 0,
							style:
							{
								background:'none',border:'0px'
							},
							listeners:
							{
								afterrender:function()
								{
									Ext.create("Ext.tip.ToolTip",
									{
										target:this.id,
										anchor:"top",
										cls:"yellowTip",
										trackMouse:true,
										html:"CSV"
									});
								}
							},
							onClick:
							{
								fn:function()
								{
									var urlStr = "AgentStatus/data/EgAgentSummaryJson.jsp";
									Ext.Ajax.request(
									{
										url: urlStr,
										method: 'POST',
										async:false
									});
									window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+"en_US";
								}
							}
						}],
						columns:[
						{
							text: 'Agent Type',
							dataIndex: 'AgentType',
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							flex: 1.25
						},
						{
							text: 'Total Agents',
							dataIndex: 'TotalAgents',
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							flex: 1
						},
						{
							text: 'Running',
							dataIndex: 'Running',
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							flex: 1
						},
						{
							text: 'Not Running',
							dataIndex: 'NotRunning',
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							flex: 1
						}]
					}]
				}).show().center();
				Ext.getCmp('agentSummaryGrid').getStore().loadRawData(resultJSON.agentsSummaryStore);
				Ext.getCmp('totalSummaryAgents').setValue(resultJSON.agentsSummaryCount);
			}
		});
	},
	restartAllAgents:function()
	{
		Ext.Msg.show({
			title: restartAll,
			msg: confirmMsg3,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var urlStr = "AgentStatus/data/EgAllAgentsRestartJson.jsp";
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							
							if (resultJSON.ResultAlert)
							{
								Ext.Msg.show({
									title:resultJSON.ResultTitle,
									msg:resultJSON.ResultMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
						}
					});
				}
			}
		});
	},
	restartAgent: function(row,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		Ext.Msg.show({
			title: restartAgent,
			msg: confirmMsg1+" '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'This process will take few minutes. Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/EgAgentRestartJson.jsp?mode=main&agentIp="+encodeURI(agentNick)+"&agentOs=";
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function( response )
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	showAgentInfo : function(row,gridID,agentType,agentState)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var output = obj.get('Output');
		var isAgentShared = obj.get('isAgentShared');
		isAgentShared = isAgentShared.substring(0,isAgentShared.indexOf('~'));
		var debug = "no";
		if (output)
		{
			debug = "yes";
		}
		Ext.getCmp('agentstatusviewport').removeAll();
		Ext.getCmp('agentstatusviewport').add({
			xtype: 'agentinformation'
		});
		this.getController('AgentStatus.controller.AgentInfoCtrler').buildMainData(agentNick,debug,agentType,agentState);
		this.getController('AgentStatus.controller.AgentInfoCtrler').afterMainRender(isAgentShared); 
	},
	goBack : function()
	{
		if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/AdvanceSearch.jsp";
		}
		else
		{
			resetView();
			var agentType = Ext.isEmpty(publicJSON.agentType) ? sel_agent_type : publicJSON.agentType;
			var agentState = Ext.isEmpty(publicJSON.agentState) ? selAgentStatus : publicJSON.agentState;
			Ext.getCmp('agentstatusviewport').removeAll();
			this.getController('AgentStatus.controller.Main').buildMainData(agentType,agentState);
			Ext.getCmp('agentstatusviewport').add(
				{
					xtype: 'agentstatusview'
				});
			this.getController('AgentStatus.controller.Main').afterMainRender();
		}
	},
	goHome : function()
	{
		window.location.href = backHref;
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage;
	},
	restartAgentFrmAgentInfo : function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		Ext.Msg.show({
			title: restartAgent,
			msg: confirmMsg1+" '"+publicJSON.AgentIP+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/EgAgentRestartJson.jsp?mode=info&agentIp="+encodeURI(publicJSON.AgentIP)+"&agentOs="+publicJSON.OS;
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	resetAgentFrmAgentInfo : function()
	{
		var urlStr = "AgentStatus/data/EgagentinfopJson.jsp?agentIp="+encodeURI(publicJSON.AgentIP);
		Ext.Ajax.request({
			url: urlStr,
			method: 'POST',
			timeout: timeOut*1000,
			success: function( response )
			{
				var jsonText = response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if (resultJSON.ResultAlert)
				{
					Ext.Msg.show({
						title:resultJSON.ResultTitle,
						msg:resultJSON.ResultMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
			}
		});
	},
	showLogsFrmAgentInfo:function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title:pageTitle2,
				msg:agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/EgAgentLogView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug+'&showAgentInformationView=true&agentType='+selAgentType;
		}
		else
		{
			window.location.href="/final/admin/EgAgentLogView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug+"&agentType="+publicJSON.agentType+"&viewFrom=AgentInfo&agentStatus="+publicJSON.agentState;
		}
	},
	showLogs:function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var agentType= Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		window.location.href="/final/admin/EgAgentLogView.jsp?viewFrom=AgentLog&componentName="+encodeURI(agentNick)+"&agentType="+agentType+"&agentStatus="+agentStatus;
	},
	showXmxFrmAgentInfo:function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title:pageTitle2,
				msg:agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/EgAgentXmxView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug+'&showAgentInformationView=true';
		}
		else
		{
			window.location.href="/final/admin/EgAgentXmxView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug;
		}
	},
	showXmx:function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var agentType= Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		window.location.href="/final/admin/EgAgentXmxView.jsp?viewFrom=AgentXmx&componentName="+encodeURI(agentNick)+"&agentType="+agentType+"&agentStatus="+agentStatus;
	},
	showAssignHosts: function(rowIdx,gridID)
	{
		var agentType = Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));

		if (agentType=='RemoteAgents')
		{
			window.location.href="/final/admin/EgRemoteAgents.jsp?from=AgentStatus&fromAssignRem=true&eagent="+agentNick+'&agentState='+agentStatus;
		}
		else
		{
			window.location.href="/final/admin/EgExternalAgents.jsp?from=AgentStatus&fromAssignExt=true&eagent="+agentNick+'&agentState='+agentStatus;
		}
	},
	outputLoggingChange: function(checked, rowIdx, gridID)
	{
		var grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var agentType = jsonDataHolder.agentType;
		var agentIP = row.get('IP_Address');
		var outputNeeded = "No";
		if (checked)
		{
			outputNeeded = "Yes";
		}
		var me = this;
		Ext.Msg.show({
			title: agentLogEnable,
			msg: confirmMsg2+"   '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var loadingMsg = loadingMsg1 +' '+ plsWait;
					if (checked)
					{
						loadingMsg = loadingMsg2 +' '+ plsWait;
					}
					var urlStr = "AgentStatus/data/changeAgentOutputFileJson.jsp?agentID="+encodeURI(agentNick)+"&s_output="+outputNeeded+"&agentType="+agentType+"&agent_ip_address="+agentIP;
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: loadingMsg});
					tmpMask.show();
					me.getAgentstatusview().submit({
						url: urlStr,
						method: 'POST',
						timeout: timeOut,
						success: function(form, action)
						{
							tmpMask.hide();
							var jsonText = action.response.responseText;
							var resultJSON = Ext.decode(jsonText);
							if(resultJSON.ResultAlert)
							{
								Ext.Msg.show({
									title:resultJSON.ResultTitle,
									msg:resultJSON.ResultMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function(response) 
									{
										if(response == 'ok')
										{
											var searchStr = Ext.getCmp('searchBox').getValue();
											me.updateOutputLoging();
										}
									}
								});
							}
						},
						failure: function(form, action)
						{
							 tmpMask.hide();
						}
					});
				}
				else if (response == 'no' || response == 'cancel')
				{
					if (checked)
					{
						row.set('Output',false);
					}
					else
					{
						row.set('Output',true);
					}
				}
			}
		});
	},
	stopAgentButton : function(row,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		Ext.Msg.show({
			title: stopAgent,
			msg: confirmMsg_stop+" '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/stopAgentJson.jsp?agentIp="+encodeURI(agentNick);
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:stopAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:stopAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	callMonitorRemoteControl:function(row,gridID,mode)
	{
		var agent_type = Ext.getCmp('agentType').getValue();
		var agent_Status = Ext.getCmp('agentStatus').getValue();
		var grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
			msg : "Agent (" + agentNick + ") is changing to control mode. Please wait for few minutes."
		});
		rcLoadMask.show();
		Ext.Ajax.request({
			url : "AgentStatus/data/controlMode.jsp?agentIP="+encodeURI(agentNick),
			method : 'POST',
			timeout:timeOut*1000,
			scope:this,
			success: function(response)
			{
				rcLoadMask.hide();
				var jsonData=Ext.decode(response.responseText);
				if(jsonData.agentStatus=='CONTROL_MODE')
				{
					window.location.href='/final/admin/remoteControl.jsp?agentIP='+encodeURI(agentNick)+'&agentMode=CONTROL_MODE&agent_type='+agent_type+'&agentStatus='+agent_Status;
				}
				else
				{
					Ext.Msg.show({
						title:'Remote Control',
						msg:'Please try again.',
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
			},
			failure: function(response)
			{
				rcLoadMask.hide();
				Ext.Msg.show({
					title:'Remote Control',
					msg:'Please try again.',
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
			}
		});
	},
	disableAgentDebug: function(ip)
	{
		ip = ip.indexOf("~Yes") >-1 ? ip.substring(0,ip.indexOf("~Yes")) : ip;
		var disableIPList = publicJSON.disabledIpList;
		if(!Ext.isEmpty(disableIPList) && Ext.Array.contains(disableIPList,ip))
		{
			return true;
		}
		return false;
	}
});

Ext.apply(Ext.data.SortTypes, {
	asAgentIP : function (agentIP) {
		var nickname = agentIP.split("~")[0];
		return nickname.toUpperCase() + nickname.toLowerCase();
	}
});

function doesExist(searchList,agentIp)
{
	for(var i=0;i<searchList.length;i++)
	{
		var searchStr = searchList[i];
		if(agentIp.indexOf(searchStr) !=-1 || agentIp.toLowerCase().indexOf(searchStr.toLowerCase()) !=-1)
		{
			totalRecords ++;
			return true;
		}
	}
	return false;
}



