Ext.define('AssetManagement.controller.Main', {
extend: 'Ext.app.Controller',
requires:['AssetManagement.view.AssetConfiguration', 'utilities.CustomGrid', 'AssetManagement.view.FileUploadForm', 'AssetManagement.view.FileUpload','AssetManagement.view.Print','AssetManagement.view.DownloadUtils','AssetManagement.view.Main'],
views:['AssetManagement.view.AssetConfiguration', 'utilities.CustomGrid', 'AssetManagement.view.FileUploadForm', 'AssetManagement.view.FileUpload','AssetManagement.view.Print','AssetManagement.view.DownloadUtils','AssetManagement.view.AssetList','AssetManagement.view.AssetListColumnConfig','AssetManagement.view.Main','AssetManagement.view.AssetMenu'],
refs:[
		{
		ref:'assetConfiguration',
		selector:'assetConfiguration'
		},
		{
		ref:'fileuploadform',
		selector:'fileuploadform'
		},
		{
		ref:'fileupload',
		selector:'fileupload'
		},
		{
		ref:'downloadutils',
		selector:'downloadutils'
		},
		{
		ref:'assetList',
		selector:'assetList'
		},
		{
		ref:'assetListColumn',
		selector:'assetListColumn'
		},
		{
		ref:'main',
		selector:'main'
		},
		{
		ref:'assetmenu',
		selector:'assetmenu'
		}
],
init: function() {
		this.control({
			'assetmenu tabpanel[id="assetTabDashPanel"]' : {
				tabchange : this.clickDashboardPanelFun
			},
			'assetmenu tabpanel[id="assetTabDashPanel"]' : {
				'afterrender' : this.hideButtonFun
			},
			'assetConfiguration tabpanel[id="assetTabpanel"]' : {
				tabchange : this.clickAssetTabPanelFun
			},
			'assetConfiguration button[action="SaveConfiguration"]' : {
				click : this.SaveConfigurationFun,
				//'boxready': this.afterMainRender
			},
			'assetmenu button[id="saveIconTool"]':
			{
				'click' : this.saveFile
			},
			'assetConfiguration combo[id="assetType"]':
			{
				'select' : this.onSelectAssetType
			},
			'assetConfiguration' : {
				'afterrender': this.afterConfigPanelRendered
			},
			'assetConfiguration combo[id=componenttype]' : {
				select : this.onSelectComboValues
			},
			'assetConfiguration combo[id=componentname]' : {
				select : this.changeDetails
			},
			'fileupload button[action="fileUploadAction"]' : {
				click : this.assetFileUploadFun
			},
			'assetConfiguration button[id="backButton"]':
			{
				'click':this.goBackFromAssetConfig
			},
			'assetConfiguration button[id="assetView"]':
			{
				'click':this.assetView
			},
			'assetList button[id="reportBackButton"]':
			{
				'click':this.goBackFromAssetList
			},
			'assetList' : {
				'afterrender': this.afterAssetListPanelRendered
			},
			'assetList combo[id=asset_Type]' : {
				select : this.assetListTypeChange
			},
			'assetList combo[id=component_type]' : {
				select : this.assetListCompTypeChange
			},
			'assetList button[id="getAssetBtn"]':
			{
				'click':this.getAssetDetails
			},
			'assetList button[id="setupColumn"]':
			{
				'click':this.getSetupColumnWindow
			},
			'assetListColumn' : {
				'afterrender': this.afterAssetListColumnRender
			},
			'assetListColumn button[id="saveAsstColumnBtn"]': {
				'click': this.saveAsstGridColumns
			},
			'assetList button[id="panelinsidetoggleDown"]': {
                'click': this.toggleFormDown
            },
			'assetList button[id="panelinsidetoggleUP"]': {
                'click': this.toggleFormUP
            },
			'main button[id="assetConfigBtn"]': {
                'click': this.getAssetConfigView
            },
			'main button[id="assetReportBtn"]': {
                'click': this.getAssetReportView
            },
			'assetmenu button[id="reportSaveAsPdfToolBtn"]':
			{
				'click' : this.saveReportAsPdfToolBtn
			},
			
		});
	},
hideButtonFun:function(){
	Ext.getCmp('importToolBtn').hide();
	Ext.getCmp('excelToolBtn').hide();
	Ext.getCmp('saveIconTool').hide();
},
clickDashboardPanelFun:function(){
	if(Ext.getCmp('assetTabDashPanel').getActiveTab().id == 'home')
	{	
		Ext.Ajax.request({
				url: '/final/admin/AssetManagement/data/EgAssetDashboard.jsp',
				scope: this,
				method : 'POST',
				success: function(response)
				{
					jsonData = Ext.decode(response.responseText);
					var viewPort = Ext.getCmp('assetmgmtViewPort');
					viewPort.removeAll();
					viewPort.add({
						xtype:'assetmenu',
						margin: 10,
						itemData:jsonData
					});
				}
			});
	}
},
clickAssetTabPanelFun:function(){
	if(Ext.getCmp('assetTabpanel').getActiveTab().id == 'softwareList'){
		Ext.getCmp('footerSaveBar').hide();
	} else{
		Ext.getCmp('footerSaveBar').show();
	}
},
saveReportAsPdfToolBtn:function(){
		var queryString1 = 'action=EgAssetListPDFDownload';
		Ext.Ajax.request({
		url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
		method: "POST",
		params: queryString1
		});
		
		var s_qryString="/final/servlet/com.eg.EgPdfDownloadC";
		var erUtils =  Ext.widget('downloadutils');
		erUtils.savePDF(s_qryString);

		
},
toggleFormDown:function(obj)
{
	Ext.getCmp('panelinsidetoggleUP').show();
	Ext.getCmp('panelinsidetoggleDown').hide();

	var reportDetailsContainer = Ext.getCmp('reportDetailsContainer');
	if (reportDetailsContainer.isHidden())
	{
		reportDetailsContainer.show();
		Ext.getCmp('selectionDetails').hide();
	}
	else
	{
		reportDetailsContainer.hide();
		Ext.getCmp('selectionDetails').show();
	}
},
toggleFormUP:function(obj)
{
	Ext.getCmp('panelinsidetoggleUP').hide();
	Ext.getCmp('panelinsidetoggleDown').show();

	var reportDetailsContainer = Ext.getCmp('reportDetailsContainer');
	if (reportDetailsContainer.isHidden())
	{
		reportDetailsContainer.show();
		Ext.getCmp('selectionDetails').hide();
	}
	else
	{
		reportDetailsContainer.hide();
		Ext.getCmp('selectionDetails').show();
	}
},
saveFile:function(){
		var queryString1 = 'action=EgAssetPDFDownload';
		Ext.Ajax.request({
		url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
		method: "POST",
		params: queryString1
		});
		var s_qryString="/final/servlet/com.eg.EgPdfDownloadC";
		var erUtils =  Ext.widget('downloadutils');
		erUtils.savePDF(s_qryString);
},
getAssetConfigView : function(){
	var curViewPort=  Ext.getCmp('assetmgmtViewPort');
	curViewPort.removeAll();
	curViewPort.add({
			xtype: "assetConfiguration",

	});
	curViewPort.doLayout();
	var params = 'action=loadAssetType';
	Ext.Ajax.request({
		url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
		method: "POST",
		params: params ,
		success: function (response) {
				var c = response.responseText;
				var jsonData = Ext.decode(c);
				var assetTypeValues=jsonData['ASSET_TYPE'];
				var compTypeValues=jsonData['COMP_TYPE'];
				var compNameValues=jsonData['COMP_NAME'];
				var assetStateValues=jsonData['ASSET_STATE'];
				var assetLocationValues=jsonData['ASSET_LOCAION'];
				var businessServicesValues=jsonData['BUSINESS_SERVICE'];
				Ext.getCmp('assetType').getStore().loadRawData(assetTypeValues);
				Ext.getCmp('assetType').setValue('-1');
				Ext.getCmp('componenttype').getStore().loadRawData(compTypeValues);
				Ext.getCmp('componenttype').setValue('-1');
				Ext.getCmp('componentname').getStore().loadRawData(compNameValues);
				Ext.getCmp('componentname').setValue('-1');
		}
	});
},
getAssetReportView : function(){
	var curViewPort=  Ext.getCmp('assetmgmtViewPort');
	curViewPort.removeAll();
	curViewPort.add({
			xtype: "assetList",

	});
	curViewPort.doLayout();
},
goBackFromAssetList : function(){
	window.location.href ="/final/admin/EgAssetInfo.jsp";
},
getSetupColumnWindow : function(){
	
	var curViewPort=  Ext.getCmp('assetmgmtViewPort');
	var setUpColumbObj = Ext.getCmp('setupColumn'),
	setUpColumbObjX = setUpColumbObj.el.getX(),
	setUpColumbObjY = setUpColumbObj.el.getY();
	
	var win = Ext.widget('assetListColumn', {
					});
					if (win != null) {
						win.setTitle(setupColumnTitle);
						win.showAt([setUpColumbObjX-768,setUpColumbObjY+14]);
					}
	
},
afterAssetListPanelRendered : function(){
	var params = 'action=loadAssetType';
	//Ext.getCmp('assetList').getHeader().setVisible(false);
	Ext.Ajax.request({
			url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
			method: "POST",
			params: params ,
			success: function (response) {
						var c = response.responseText;
						jsonData = Ext.decode(c);
						var assetTypeValues=jsonData['ASSET_TYPE'];
						var compTypeValues=jsonData['COMP_TYPE'];
						var compNameValues=jsonData['COMP_NAME'];
						var assetStateValues=jsonData['ASSET_STATE'];
						var assetLocationValues=jsonData['ASSET_LOCAION'];
						var businessServicesValues=jsonData['BUSINESS_SERVICE'];
						Ext.getCmp('asset_Type').getStore().loadRawData(assetTypeValues);
						Ext.getCmp('asset_Type').setValue('-1');
						Ext.getCmp('component_type').getStore().loadRawData(compTypeValues);
						Ext.getCmp('component_type').setValue('-1');
						Ext.getCmp('component_name').getStore().loadRawData(compNameValues);
						Ext.getCmp('component_name').setValue('-1');
						Ext.getCmp('assetStateList').getStore().loadRawData(assetStateValues);
						Ext.getCmp('assetStateList').setValue('-1');
						Ext.getCmp('assetLocationList').getStore().loadRawData(assetLocationValues);
						Ext.getCmp('assetLocationList').setValue('-1');
						Ext.getCmp('businessServices').getStore().loadRawData(businessServicesValues);
						Ext.getCmp('businessServices').setValue('-1');
			}
	})
},
assetListTypeChange : function(){
		var assetType=Ext.getCmp('asset_Type').getValue();
		if(assetType=='-1')
			return;
		var params = 'action=loadCompType&assetType='+assetType;
		Ext.Ajax.request({
				url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
				method: "POST",
				params: params ,
				success: function (response) {
							var c = response.responseText;
							jsonData = Ext.decode(c);
							var compTypeValues=jsonData['COMP_TYPE'];
							var compNameValues=jsonData['COMP_NAME'];
							var assetStateValues=jsonData['ASSET_STATE'];
							var assetLocationValues=jsonData['ASSET_LOCAION'];
							var businessServicesValues=jsonData['BUSINESS_SERVICE'];
							Ext.getCmp('component_type').getStore().loadRawData(compTypeValues);
							Ext.getCmp('component_type').setValue('-1');
							Ext.getCmp('component_name').getStore().loadRawData(compNameValues);
							Ext.getCmp('component_name').setValue('-1');
							Ext.getCmp('assetStateList').getStore().loadRawData(assetStateValues);
							Ext.getCmp('assetStateList').setValue('-1');
							Ext.getCmp('assetLocationList').getStore().loadRawData(assetLocationValues);
							Ext.getCmp('assetLocationList').setValue('-1');
							Ext.getCmp('businessServices').getStore().loadRawData(businessServicesValues);
							Ext.getCmp('businessServices').setValue('-1');
				}
		})
	},
assetListCompTypeChange : function(){
		var compType=Ext.getCmp('component_type').getValue();
		if(compType=='-1')
			return;
		var params = 'action=loadCompName&compType='+compType;
		Ext.Ajax.request({
				url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
				method: "POST",
				params: params ,
				success: function (response) {
							var c = response.responseText;
							jsonData = Ext.decode(c);
							var compNameValues=jsonData['COMP_NAME'];
							var assetStateValues=jsonData['ASSET_STATE'];
							var assetLocationValues=jsonData['ASSET_LOCAION'];
							var businessServicesValues=jsonData['BUSINESS_SERVICE'];
							Ext.getCmp('component_name').getStore().loadRawData(compNameValues);
							Ext.getCmp('component_name').setValue('allcomponents');
							Ext.getCmp('assetStateList').getStore().loadRawData(assetStateValues);
							Ext.getCmp('assetStateList').setValue('allstates');
							Ext.getCmp('assetLocationList').getStore().loadRawData(assetLocationValues);
							Ext.getCmp('assetLocationList').setValue('alllocation');
							Ext.getCmp('businessServices').getStore().loadRawData(businessServicesValues);
							Ext.getCmp('businessServices').setValue('allbusiness');
				}
		})
	},
getAssetDetails : function(){
		var assetType=Ext.getCmp('asset_Type').getValue();
		var compType=Ext.getCmp('component_type').getValue();
		var compName=Ext.getCmp('component_name').getValue();
		var assetStateList=Ext.getCmp('assetStateList').getValue();
		var assetLocationList=Ext.getCmp('assetLocationList').getValue();
		var businessServices=Ext.getCmp('businessServices').getValue();
		var compsForTooltip=Ext.getCmp('component_name').getValue();
		if(compName==null || compName=='-1' || compName=='')
		{
			Ext.Msg.show({
				title: assetAlertTitle,
				msg: compoNameLbl,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
			});
			return;
		}
		if(compName=='allcomponents')
		{
			compName='';
			compsForTooltip='';
			var compNameStore=Ext.getCmp('component_name').getStore();
			
			var  compNameStoreCount = compNameStore.getCount();
			for ( var i = 0; i < compNameStoreCount; i++) {
				var tempCompName = compNameStore.getAt(i).get('valueField');
				if(tempCompName!='allcomponents')
					compName=compName+','+tempCompName;
			}
			if (compName != null && compName.indexOf(",") == 0) {
					compName = compName.substring(1);
				}
		}
		if(assetStateList=='allstates')
		{
			assetStateList='';
		}
		if(assetLocationList=='alllocation')
		{
			assetLocationList='';
		}
		if(businessServices=='allbusiness')
		{
			businessServices='';
		}
		Ext.getCmp('assetDataGridContainer').show();
		var myMask = new Ext.LoadMask(Ext.getCmp("assetDataGridContainer"), {
			msg:"Loading ...",
		});
		myMask.show();
		var params = 'action=getAssetData&compType='+encodeURIComponent(compType)+'&assetType='+encodeURIComponent(assetType)+'&compName='+encodeURIComponent(compName)+'&assetStateList='+encodeURIComponent(assetStateList)+'&assetLocationList='+encodeURIComponent(assetLocationList)+'&businessServices='+encodeURIComponent(businessServices)+'&compsForTooltip='+encodeURIComponent(compsForTooltip);
		Ext.Ajax.request({
				url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
				method: "POST",
				params: params ,
				success: function (response) {
							
							Ext.getCmp('panelinsidetoggleDown').show();
							Ext.getCmp('panelinsidetoggleUP').hide();

							var selectionDetailsObj = Ext.getCmp('selectionDetails');
							selectionDetailsObj.show();
							

							Ext.getCmp('reportDetailsContainer').hide();

							var c = response.responseText;
							jsonData = Ext.decode(c);
							
							var gridCols = jsonData['AssetGridData']['gridCols'];
							var gridData = jsonData['AssetGridData']['gridData'];
							var assetSelectionList = jsonData['AssetFilterData'];

							//$('#assetTypeTooltip').html(assetSelectionList.assetTypeTooltip);

							$('#select_assetType').html(assetSelectionList.assetType);
							$('#select_assetType').attr('data-qtip',assetSelectionList.assetTypeTooltip);
							$('#select_compType').html(assetSelectionList.componentType);
							$('#select_compType').attr('data-qtip',assetSelectionList.componentTypeTooltip);
							$('#select_compName').html(assetSelectionList.componentName);
							$('#select_compName').attr('data-qtip',assetSelectionList.componentNameTooltip);
							$('#select_assetStateList').html(assetSelectionList.assetStates);
							$('#select_assetStateList').attr('data-qtip',assetSelectionList.assetStatesTooltip);
							$('#select_assetLocationList').html(assetSelectionList.assetLocations);
							$('#select_assetLocationList').attr('data-qtip',assetSelectionList.assetLocationsTooltip);
							$('#select_businessServices').html(assetSelectionList.businessServices);
							$('#select_businessServices').attr('data-qtip',assetSelectionList.businessServicesTooltip);

							selectionDetailsObj.doLayout();
		
							var colsArr = [];
							var fields2Store = [];
							var filtersArr = [];
							for ( var colVal in gridCols) {
								var colName = gridCols[colVal].toString();
								fields2Store.push({
									name : colName,
									type : 'string'
								});
								colsArr
									.push({
										header : colName,
										dataIndex : colName,
										sortable: false,
										minWidth:150
									});
							}
							var gridObj = Ext.getCmp('assetGrid');
							
							gridObj.getStore().removeAll();

							var storeVal1 = Ext.create('Ext.data.Store',{
								fields:fields2Store,
								data:gridData,
								pageSize:1,
								proxy: {
									type: 'ajax',
									url: '/final/admin/AssetManagement/data/EgAssetListConfig.jsp?'+params,
									reader: {
									  type: 'json',
									  root: 'AssetGridData',
									  page:'page',
									  start:'start',
									  limit:'limit',
									  totalProperty: 'totalCount'
									}
								},
								selModel: {
								 selType: 'cellmodel'
								}

							});
							var pagingToolBar = Ext.getCmp('pagingToolBar',{
								store:storeVal1
							});
							gridObj.reconfigure(storeVal1,colsArr);
							myMask.hide();
							//Ext.getCmp('assetList').getHeader().setVisible(true);
							Ext.getCmp('reportSaveAsExcelToolBtn').show();
							Ext.getCmp('reportSaveAsPdfToolBtn').show();
							if(storeVal1.data.length == 0)
							{
								Ext.getCmp('reportSaveAsExcelToolBtn').hide();
								Ext.getCmp('reportSaveAsPdfToolBtn').hide();
							}
							
				}
		})
	},
			
afterAssetListColumnRender : function(){
	var params = 'action=loadAssetColumns';
	Ext.Ajax.request({
			url: "/final/admin/AssetManagement/data/EgAssetColumnConfig.jsp",
			method: "POST",
			params: params ,
			success: function (response) {
						var c = response.responseText;
						jsonData = Ext.decode(c);
						var assetColumns=jsonData['AssetColumns'];
						var assetColObj=Ext.getCmp('assetDetailsColumn');
						var tempCheckBoxArr=[];
						var checkBoxObj={
								xtype: 'checkboxgroup',
								columns: 4,
								labelSeparator:'',
								cls: 'checkbt',
								id: 'assetGridColumns',
								//vertical: true,
								items:assetColumns
							};
						assetColObj.removeAll();
						assetColObj.add(checkBoxObj);
			}
	})
},
saveAsstGridColumns : function(){
	var assetGridCols='';
	var selectedSuccessValues = Ext.getCmp('assetGridColumns').getChecked();               
	for(var i=0;i<selectedSuccessValues.length;i++)
	{
		assetGridCols=assetGridCols+','+selectedSuccessValues[i].inputValue
	} 
	if (assetGridCols != null && assetGridCols.indexOf(",") == 0) {
				assetGridCols = assetGridCols.substring(1);
	}
	var params = 'action=saveAssetGridColumns&assetGridCols='+encodeURIComponent(assetGridCols);
	Ext.Ajax.request({
			url: "/final/admin/AssetManagement/data/EgAssetColumnConfig.jsp",
			method: "POST",
			params: params ,
			success: function (response) {
						var c = response.responseText;
						jsonData = Ext.decode(c);
						Ext.Msg.show({
							title: assetAlertTitle,
							msg: assetColConfigAlert,
							buttons: Ext.MessageBox.OK,
							fn : function(btn)
							{
								Ext.getCmp('assetListColConf').close();
								var compName=Ext.getCmp('component_name').getValue();
								if(compName!=null && compName[0]!='-1' && compName!='')
								{
									Ext.getCmp('getAssetBtn').fireEvent('click',Ext.getCmp('getAssetBtn'));
								}
							}
						});
			}
	})
},
afterConfigPanelRendered : function(){
	var params = 'action=loadAssetType';
	Ext.Ajax.request({
		url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
		method: "POST",
		params: params ,
		success: function (response) {
				var c = response.responseText;
				var jsonData = Ext.decode(c);
				var assetTypeValues=jsonData['ASSET_TYPE'];
				var compTypeValues=jsonData['COMP_TYPE'];
				var compNameValues=jsonData['COMP_NAME'];
				var assetStateValues=jsonData['ASSET_STATE'];
				var assetLocationValues=jsonData['ASSET_LOCAION'];
				var businessServicesValues=jsonData['BUSINESS_SERVICE'];
				Ext.getCmp('assetType').getStore().loadRawData(assetTypeValues);
				Ext.getCmp('assetType').setValue('-1');
				Ext.getCmp('componenttype').getStore().loadRawData(compTypeValues);
				Ext.getCmp('componenttype').setValue('-1');
				Ext.getCmp('componentname').getStore().loadRawData(compNameValues);
				Ext.getCmp('componentname').setValue('-1');
		}
	});
},
onSelectAssetType:function(){
	var assetType=Ext.getCmp('assetType').getValue();
		if(assetType=='-1')
			return;
		var params = 'action=loadCompType&assetType='+assetType;
		Ext.Ajax.request({
				url: "/final/admin/AssetManagement/data/EgAssetListConfig.jsp",
				method: "POST",
				params: params ,
				success: function (response) {
							var c = response.responseText;
							jsonData = Ext.decode(c);
							var compTypeValues=jsonData['COMP_TYPE'];
							var compNameValues=jsonData['COMP_NAME'];
							var assetStateValues=jsonData['ASSET_STATE'];
							var assetLocationValues=jsonData['ASSET_LOCAION'];
							var businessServicesValues=jsonData['BUSINESS_SERVICE'];
							Ext.getCmp('componenttype').getStore().loadRawData(compTypeValues);
							Ext.getCmp('componenttype').setValue('-1');
							Ext.getCmp('componentname').getStore().loadRawData(compNameValues);
							Ext.getCmp('componentname').setValue('-1');
				}
		})
		
},
onSelectComboValues : function(){
		var compName=""; 
		var selectedCompType=Ext.getCmp('componenttype').getValue();
		if(selectedCompType!="-1")
		{

		var paramsForRc = 'C=true&F=getComponentsForType&P0={' + selectedCompType + '}&calljson=true';
		var arrComp=new Array();

		Ext.Ajax.request({
		url: '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
		method: 'POST',

		params: paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
		scope: this,
		success: function (response) {

			var jsonText = response.responseText;
			var jsonData = Ext.decode(jsonText);
			var  jsonArr=new Array();
			if (jsonText != null && jsonText != '') {
					jsonArr = jsonData['compOptsJson'];
					var componentCombo = Ext.getCmp('componentname');
					componentCombo.getStore().loadRawData(jsonData['compOptsJson']);
					compName=jsonData['compOptsJson'][0]['valueField'];
					componentCombo.setValue(jsonData['compOptsJson'][0]['valueField']);
					this.changeDetails(compName);
			}
		},
		failure: function () {
			//console.log("request component failure");
		}
	});
		}
		else{
			var CompTyNameValues =  publicAssetJson['COMPNAME_VAL'];
			Ext.getCmp('componentname').getStore().loadRawData(CompTyNameValues);
			Ext.getCmp('componentname').setValue(TypeCmpVals['COMPNAME_VAL'][0]['valueField']);
		}
	},
changeDetails : function(compName)  // For fetching the details while changing the component type or component name.
{
	var me=this;
	
		saved = null;
		var resultObj=Ext.getCmp('customContainer');
		resultObj.removeAll();
		customFields=0;
		var selectedCompType=Ext.getCmp('componenttype').getValue();
		var selectedCompName="";
		if(compName == null || compName =="" || compName == 'undefined')
		{
			selectedCompName=Ext.getCmp('componentname').getValue();
		}
		else
		{
			if(typeof compName=='object')
				selectedCompName= compName.getValue();
			else
				selectedCompName= compName;
		}
		if(selectedCompName.indexOf(":") == -1)
		{
			selectedCompName=selectedCompName+":NULL";
		}
		var serverType=selectedCompType;
		var serverName=selectedCompName;
		var queryString1 ='serverType='+serverType+'&serverName='+serverName;
		Ext.Ajax.request({
		url: "/final/admin/AssetManagement/data/EgAssetConfiguration.jsp",
		method: "POST",
		params: queryString1 ,
		success: function (response) {
			if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					if (Ext.get('loadmask'))
					{
						Ext.get('loadmask').remove();
					}
					var c = response.responseText;
					jsonText = Ext.decode(c);
					Ext.getCmp('checkbox1').hide();
					Ext.getCmp('multiSelectAsset').hide();
					Ext.getCmp('SimilarLabel').hide();
					screenLabels = jsonText['SCREEN_LABELS'];
					assetFields = jsonText['ASSET_FIELDS'];
					assetTypeFields = jsonText['ASSET_TYPE_FIELDS'];
					publicAssetJson = jsonText['COMBO_VALUES'];
					selectedValues =  jsonText['SELECTED_VALUES'];
					var curViewPort=  Ext.getCmp('assetmgmtViewPort');
					Ext.getCmp('componenttype').setFieldLabel(screenLabels['COMPTYPELABEL']);
					Ext.getCmp('componentname').setFieldLabel(screenLabels['COMPNAMELABEL']);
					var assetTypeValues = publicAssetJson['ASSET_TYPE'];
					Ext.getCmp('assetType').getStore().loadRawData(assetTypeValues);
					Ext.getCmp('assetType').setValue(selectedValues['selected_AssetType']);
					//Ext.getCmp('assetType').fireEvent('select',Ext.getCmp('assetType'));
					me.loadAssetFields();
					confEnabled = jsonText['CONF_ENABLED'];
					displayMessage = jsonText['DISPLAY_MSG'];
					var CompTyNameValues = publicAssetJson['COMPTYPE_VAL'];
					var tempArr=[];
					var assetType = Ext.getCmp('assetType').getValue();
					for(var j=0;j<CompTyNameValues.length;j++){
						var compObj=CompTyNameValues[j];
						if(assetType==compObj['serverCategory'])
						{
							tempArr.push(compObj);
						}
					}
					var selectedValue = selectedValues['Selected_CmpType'];
					Ext.getCmp('componenttype').getStore().loadRawData(tempArr);
					Ext.getCmp('componenttype').setValue(selectedValue);

					var CompTyNameValues = publicAssetJson['COMPNAME_VAL'];
					var selectedValue = selectedValues['Selected_Comp'];
					Ext.getCmp('componentname').getStore().loadRawData(CompTyNameValues);
					Ext.getCmp('componentname').setValue(selectedValue);
					if(publicAssetJson['ApplyAll_Server']!=null)
					{
						var checkBoxObj = Ext.getCmp('checkbox1');
						checkBoxObj.show();
						if(checkBoxObj.checked == true)
							checkBoxObj.setValue(false);
						var CompTyNameValues = publicAssetJson['ApplyAll_Server'];
						Ext.getCmp('multiSelectAsset').getStore().loadRawData(CompTyNameValues);
					}
					var customAttribute =  selectedValues['CUSTOM_ATTRIBUTES'];
					if(customAttribute!=null && customAttribute!="undefined")
					{
						for(var i = 0; i < customAttribute.length; i++)
						{
							var colName = customAttribute[i]['CustomDisplay'];
							var colValue = customAttribute[i]['CustomValue'];
							me.createCustomData(colName,colValue);
							//customFieldCnt++;
						}
					}
			}
		}
	});
	
},
loadAssetFields : function(){
	var customContainer = Ext.getCmp("CustomFieldContainer");
	if(customContainer!=null){
		customContainer.hide();
	}
	Ext.getCmp("form3").hide();
	var maskObj = Ext.getCmp("form2");
	maskObj.setHeight(Ext.getBody().getHeight()-300);
	maskObj.show();
	var myMask = new Ext.LoadMask(Ext.getCmp("form2"), {
		msg:"Loading ...",
	});
	myMask.show();
	var tempArr=[{valueField: "-1", displayField: compoTypeLbl}];
	var assetType = Ext.getCmp('assetType').getValue();
	setTimeout(function(){
		Ext.getCmp('assetTabpanel').getComponent('assetDetail').tab.hide();
		Ext.getCmp("assetDetail").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('techDetails').tab.hide();
		Ext.getCmp("techDetails").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('software').tab.hide();
		Ext.getCmp("software").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('ups').tab.hide();
		Ext.getCmp("ups").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('cloud').tab.hide();
		Ext.getCmp("cloud").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('aws').tab.hide();
		Ext.getCmp("aws").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('misc').tab.hide();
		Ext.getCmp("misc").removeAll();
		Ext.getCmp('assetTabpanel').getComponent('softwareList').tab.hide();
		Ext.getCmp("softwareList").removeAll();
		var typeFields = assetTypeFields[assetType];
		var compType = Ext.getCmp("componenttype").getValue();
		for(var i=0;i<typeFields.length;i++){
			var filedName = typeFields[i];
			if(filedName == "General"){
				loadAssetDetailsUI();
				Ext.getCmp("assetDetail").show();
				Ext.getCmp('assetTabpanel').getComponent('assetDetail').tab.show();
				Ext.getCmp('assetTabpanel').setActiveTab(0);
			}
			else if(filedName == "Misc"){
				loadMiscUI();
			}
			else if(filedName == "Technical"){
				loadTechnicalUI(filedName);
			}
			else if(filedName == "Software"){
				loadSoftwareUI();
			}
			else if(filedName == "Hardware"){
				loadTechnicalUI(filedName);
			}
			else if(filedName == "Network"){
				loadTechnicalUI(filedName);
			}
			else if(filedName == "UPS"){
				loadUPSUI();
			}
			else if(filedName == "Cloud"){
				loadCloudUI();
			}
			else if(filedName == "AWS"){
				if(compType.indexOf("AWS")>-1){
					loadAWSUI();
				}
			}
		}
		if(customContainer!=null){
			customContainer.show();
		}
		myMask.destroy();
		maskObj.hide();
		if(Ext.getCmp('customContainer').items.length>0){
			Ext.getCmp('customContainer').tab.show();
			Ext.getCmp('addCustomFieldBtn').hide();
		} else{
			Ext.getCmp('addCustomFieldBtn').show();
			Ext.getCmp('customContainer').tab.hide();
		}


		Ext.getCmp("form3").show();
	},1000);
},
createCustomData : function(colName,colValue){

	var resultObj=Ext.getCmp('customContainer');
	resultObj.show();
	var tmpId = 'CustomNameField_'+customFieldCnt;
	var tmpId2 = 'CustomValueField_'+customFieldCnt;
	var conId = "customFieldCnt_"+customFieldCnt;
	 
	if(customFields < 5)
	{
	resultObj.add(
		{
		xtype:'container',
		id:conId,
		layout: 'hbox',
		//margin: 5,
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				name : tmpId,
				cls: 'textbox',
				fieldLabel:customAttributeDisplayLbl,
				labelAlign: 'top',
				labelSeparator: ' ',
				value:colName,
				columnWidth: 0.4,width: 230,
				margin: '0 0 0 0'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				name : tmpId2,
				cls: 'textbox',
				fieldLabel: customAttributeValueLbl,
				labelAlign: 'top',
				value:colValue,
				labelSeparator: ' ',
				columnWidth: 0.4,width: 230,
				margin: '0 0 0 20'
			},{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 5',
				items : [
				{
					xtype : 'button',
					id:'removeIcon_'+customFieldCnt,
					containerIDVal : customFieldCnt,
					iconCls : 'iconMinus',
					style: {
						background: "none",
						border: "0px"
					},
					handler: function()
					{
						removeCustomField(this.containerIDVal);
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:removeLbl
							});
						}
					}
				},
				{
					xtype : 'button',
					iconCls : 'iconPlus',
					style: {
						background: "none",
						border: "0px"
					},
					handler: function()
					{
						createCustomData();
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"Add"
							});
						}
					}
				}]
			}]
		});
		customFieldCnt++;
	customFields++;
	resultObj.doLayout();
	
	}
	else
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: fieldsMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation'
		});
	}
},

SaveConfigurationFun: function()
{
	var assetName = "";
	var assetNameObj=Ext.getCmp('assetName');
	if(assetNameObj!=null && assetNameObj!="undefined")
		assetName = assetNameObj.getValue().trim();
	var assetDescription = "";
	var assetDescObj=Ext.getCmp('assetDescription');
	if(assetDescObj!=null && assetDescObj!="undefined")
		assetDescription = assetDescObj.getValue();
	var assetType = "";
	var assetTypeObj = Ext.getCmp('assetType')
	if(assetTypeObj!=null && assetTypeObj!="undefined")
		assetType = assetTypeObj.getValue();
	var assetState = "";
	var assetStateObj = Ext.getCmp('assetState');
	if(assetStateObj!=null && assetStateObj!="undefined")
		assetState = assetStateObj.getValue();
	var hostIP = "";
	var hostIPObj = Ext.getCmp('hostIP');
	if(hostIPObj!=null && hostIPObj!="undefined")
		hostIP = hostIPObj.getValue();
	var macAddress = "";
	var macAddressObj = Ext.getCmp('mac_address');
	if(macAddressObj!=null && macAddressObj!="undefined")
		macAddress = macAddressObj.getValue().trim();
	var os = "";
	var osObj = Ext.getCmp('os');
	if(osObj!=null && osObj!="undefined")
		os = osObj.getValue();
	var osVersion = "";
	var osVersionObj = Ext.getCmp('os_version');
	if(osVersionObj!=null && osVersionObj!="undefined")
		osVersion = osVersionObj.getValue();
	var memory = "";
	var memoryObj = Ext.getCmp('memory');
	if(memoryObj!=null && memoryObj!="undefined")
		memory = memoryObj.getValue();
	var diskSpace = "";
	var diskSpaceObj = Ext.getCmp('diskSpace');
	if(diskSpaceObj!=null && diskSpaceObj!="undefined")
		diskSpace = diskSpaceObj.getValue();
	var cpuSpeed = "";
	var cpuSpeedObj = Ext.getCmp('cpu_speed');
	if(cpuSpeedObj!=null && cpuSpeedObj!="undefined")
		cpuSpeed = cpuSpeedObj.getValue();
	var cpuCoreCount = "";
	var cpuCoreCountObj = Ext.getCmp('cpu_coreCount');
	if(cpuCoreCountObj!=null && cpuCoreCountObj!="undefined")
		cpuCoreCount = cpuCoreCountObj.getValue();
	var uuid = "";
	var uuidObj = Ext.getCmp('uuid');
	if(uuidObj!=null && uuidObj!="undefined")
		uuid = uuidObj.getValue();
	var manufacturer = "";
	var manufacturerObj = Ext.getCmp('manufacturer');
	if(manufacturerObj!=null && manufacturerObj!="undefined")
		manufacturer = manufacturerObj.getValue();
	var serialNumber = "";
	var serialNumberObj = Ext.getCmp('serialNumber');
	if(serialNumberObj!=null && serialNumberObj!="undefined")
		serialNumber = serialNumberObj.getValue();
	var asmExpirydateVal = "";
	var asmExpirydateObj = Ext.getCmp('asmExpiryDate');
	if(asmExpirydateObj!=null && asmExpirydateObj!="undefined")
		asmExpirydateVal = Ext.Date.dateFormat(asmExpirydateObj.getValue(), assetDfltDateFrmt);
	var owner = "";
	var ownerObj = Ext.getCmp('user');
	if(ownerObj!=null && ownerObj!="undefined")
		owner = ownerObj.getValue();
	var supportGroup = "";
	var supportGroupObj = Ext.getCmp('supportGroup');
	if(supportGroupObj!=null && supportGroupObj!="undefined")
		supportGroup = supportGroupObj.getValue();
	var osServicePack = "";
	var osServicePackObj = Ext.getCmp('os_servicePack');
	if(osServicePackObj!=null && osServicePackObj!="undefined")
		osServicePack = osServicePackObj.getValue();
	var assetLocation = "";
	//var assetLocationObj = Ext.getCmp('assetLocation');
	var assetLocationObj = Ext.getCmp('location');
	if(assetLocationObj!=null && assetLocationObj!="undefined")
		assetLocation = assetLocationObj.getValue();
	var businessImpact = "";
	var businessImpactObj = Ext.getCmp('businessImpact');
	if(businessImpactObj!=null && businessImpactObj!="undefined")
		businessImpact = businessImpactObj.getValue();
	var email = "";
	//var emailObj = Ext.getCmp('email');
	var emailObj = Ext.getCmp('emailAddress');
	if(emailObj!=null && emailObj!="undefined")
		email = emailObj.getValue().trim();
	var businessService = "";
	var businessServiceObj = Ext.getCmp('businessService');
	if(businessServiceObj!=null && businessServiceObj!="undefined")
		businessService = businessServiceObj.getValue();
	var phnumber = "";
	var phnumberObj = Ext.getCmp('phoneNumber');
	if(phnumberObj!=null && phnumberObj!="undefined")
		phnumber = phnumberObj.getValue().trim();
	var product = "";
	var productObj = Ext.getCmp('product');
	if(productObj!=null && productObj!="undefined")
		product = productObj.getValue().trim();
	var vendor = "";
	var vendorObj = Ext.getCmp('vendor');
	if(vendorObj!=null && vendorObj!="undefined")
		vendor = vendorObj.getValue().trim();
	var cost = "";
	var costObj = Ext.getCmp('cost');
	if(costObj!=null && costObj!="undefined")
		cost = costObj.getValue().trim();
	var licenseKey = "";
	var licenseKeyObj = Ext.getCmp('licenseKey');
	if(licenseKeyObj!=null && licenseKeyObj!="undefined")
		licenseKey = licenseKeyObj.getValue().trim();
	var installationDate = "";
	var installDateObj = Ext.getCmp('installationDate');
	if(installDateObj!=null && installDateObj!="undefined")
		installationDate = Ext.Date.dateFormat(installDateObj.getValue(), assetDfltDateFrmt);
	var licenseType = "";
	var licenseTypeObj = Ext.getCmp('licenseType');
	if(licenseTypeObj!=null && licenseTypeObj!="undefined")
		licenseType = licenseTypeObj.getValue().trim();
	var licenseExpirydate = "";
	var licenseExpirydateObj = Ext.getCmp('licenseExpirydate');
	if(licenseExpirydateObj!=null && licenseExpirydateObj!="undefined")
		licenseExpirydate = licenseExpirydateObj.getValue();
	var licenseSerialNumber = "";
	var licenseSerialNumberObj = Ext.getCmp('licenseSerialNumber');
	if(licenseSerialNumberObj!=null && licenseSerialNumberObj!="undefined")
		licenseSerialNumber = licenseSerialNumberObj.getValue();
	var version = "";
	var versionObj = Ext.getCmp('version');
	if(versionObj!=null && versionObj!="undefined")
		version = versionObj.getValue().trim();
	var domain = "";
	var domainObj = Ext.getCmp('domain');
	if(domainObj!=null && domainObj!="undefined")
		domain = domainObj.getValue().trim();
	var installedMachine = "";
	var installedMachineObj = Ext.getCmp('installedMachine');
	if(installedMachineObj!=null && installedMachineObj!="undefined")
		installedMachine = installedMachineObj.getValue().trim();
	var installationPath = "";
	var installationPathObj = Ext.getCmp('installationPath')
	if(installationPathObj!=null && installationPathObj!="undefined")	
		installationPath = installationPathObj.getValue().trim();
	var warranty = "";
	var warrantyObj = Ext.getCmp('warranty');
	if(warrantyObj!=null && warrantyObj!="undefined")
		//warranty = warrantyObj.getValue().trim();
		warranty = Ext.Date.dateFormat(warrantyObj.getValue(), assetDfltDateFrmt);
	var acquisitionDate = "";
	var acquisitionDateObj = Ext.getCmp('acquisitionDate');
	if(acquisitionDateObj!=null && acquisitionDateObj!="undefined")
		acquisitionDate = Ext.Date.dateFormat(acquisitionDateObj.getValue(), assetDfltDateFrmt);
	var bandwidth = "";
	var bandwidthObj = Ext.getCmp('bandwidth');
	if(bandwidthObj!=null && bandwidthObj!="undefined")
		bandwidth = bandwidthObj.getValue().trim();
	var networkRange = "";
	var networkRangeObj = Ext.getCmp('networkRange');
	if(networkRangeObj!=null && networkRangeObj!="undefined")
		networkRange = networkRangeObj.getValue().trim();
	var batteryStatus = "";
	var batteryStatusObj = Ext.getCmp('batteryStatus');
	if(batteryStatusObj!=null && batteryStatusObj!="undefined")
		batteryStatus = batteryStatusObj.getValue().trim();
	var batteryVoltage = "";
	var batteryVoltageObj = Ext.getCmp('batteryVoltage');
	if(batteryVoltageObj!=null && batteryVoltageObj!="undefined")
		batteryVoltage = batteryVoltageObj.getValue().trim();
	var batteryCurrent = "";
	var batteryCurrentObj = Ext.getCmp('batteryCurrent');
	if(batteryCurrentObj!=null && batteryCurrentObj!="undefined")
		batteryCurrent = batteryCurrentObj.getValue().trim();
	var firmware = "";
	var firmwareObj = Ext.getCmp('firmware');
	if(firmwareObj!=null && firmwareObj!="undefined")
		firmware = firmwareObj.getValue().trim();
	var firmwareVersion = "";
	var firmwareVersionObj = Ext.getCmp('firmwareVersion');
	if(firmwareVersionObj!=null && firmwareVersionObj!="undefined")
		firmwareVersion = firmwareVersionObj.getValue().trim();
	var subnetMask = "";
	var subnetMaskObj = Ext.getCmp('subnetMask');
	if(subnetMaskObj!=null && subnetMaskObj!="undefined")
		subnetMask = subnetMaskObj.getValue().trim();
	var lastAuditDate = "";
	var lastAuditDateObj = Ext.getCmp('lastAuditDate');
	if(lastAuditDateObj!=null && lastAuditDateObj!="undefined")
		lastAuditDate = Ext.Date.dateFormat(lastAuditDateObj.getValue(), assetDfltDateFrmt);
	var account = "";
	var accountObj = Ext.getCmp('account');
	if(accountObj!=null && accountObj!="undefined")
		account = accountObj.getValue().trim();
	var region = "";
	var regionObj = Ext.getCmp('region');
	if(regionObj!=null && regionObj!="undefined")
		region = regionObj.getValue().trim();
	var availabilityZone = "";
	var availabilityZoneObj = Ext.getCmp('availabilityZone');
	if(availabilityZoneObj!=null && availabilityZoneObj!="undefined")
		availabilityZone = availabilityZoneObj.getValue().trim();
	var applyForAllServerType = null;
	var applyAll =  Ext.getCmp("checkbox1").checked;
	var neverExpire = "";
	var neverExpireObj = Ext.getCmp('never');
	if(neverExpireObj!=null && neverExpireObj!="undefined")
		neverExpire = neverExpireObj.getValue();
	var licenseExpdate = "";
	var licenseExpdateObj = Ext.getCmp('hiddenLicenseExpdate');
	if(licenseExpdateObj!=null && licenseExpdateObj!="undefined")
		licenseExpdate = licenseExpdateObj.getValue();
	var notAllowedSplCharacters = '\'';

	if(neverExpire == true)
	{
		licenseExpirydate = licenseExpdate;
	}
	else{
		if(licenseExpirydate)
		{
			licenseExpirydate = Ext.Date.dateFormat(licenseExpirydate, assetDfltDateFrmt);
		}
	}
	//asmExpirydateVal = Ext.Date.dateFormat(asmExpirydate, assetDfltDateFrmt);
	var customColNameAndVaues = "";
	var customArray = "";  
	for(var i = 0; i < customFieldCnt; i++)
	{
		if(Ext.getCmp('CustomNameField_'+i)!=null )
		{

			if(isDoubleByteMgr == "false")
			{
				if(!this.validateSingleByte((Ext.getCmp('CustomNameField_'+i).getValue()).trim()))
				{
					Ext.Msg.show({
					title: assetAlertTitle,
					msg: 'CustomNameField '+doubleByteEntry,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation',
					fn : function(btn)
					{
						Ext.getCmp('CustomNameField_'+i).focus(true);
					}

					});
					return;
				}
				else if(!this.validateSingleByte((Ext.getCmp('CustomValueField_'+i).getValue())))
				{
					Ext.Msg.show({
					title: assetAlertTitle,
					msg: 'CustomValueField '+doubleByteEntry,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation',
					fn : function(btn)
					{
						Ext.getCmp('CustomValueField_'+i).focus(true);
					}

					});
					return;
				}
				
			}

			if(Ext.getCmp('CustomNameField_'+i).getValue().length == 0){
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: customDisplayMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn)
				{
					Ext.getCmp('CustomNameField_'+i).focus(true);
				}
				});
				return;
			}
			else if(this.isValidColumnName((Ext.getCmp('CustomNameField_'+i).getValue()).trim())==false){
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: assetMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn)
				{
					Ext.getCmp('CustomNameField_'+i).focus(true);
				}

				});
				return;
			}
			else if(Ext.getCmp('CustomValueField_'+i).getValue().length==0)
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: customAttributeValueMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn)
				{
					Ext.getCmp('CustomValueField_'+i).focus(true);
				}
				});
				return;
			}
			else if(this.validateFieldvalue('CustomValueField_'+i, Ext.getCmp('CustomValueField_'+i).getValue(), 256, "\'") == false)
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: assetMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn) {
						Ext.getCmp('CustomValueField_'+i).focus(true);
					}
				});
				return;
			}
			
			else
			{
				customArray += Ext.getCmp('CustomNameField_'+i).getValue();
				customArray +='~@~';
				customColNameAndVaues += (Ext.getCmp('CustomNameField_'+i).getValue()).trim();
				customColNameAndVaues +='~@~';
				customColNameAndVaues += Ext.getCmp('CustomValueField_'+i).getValue();
				customColNameAndVaues +='#~#';
			}
		}
	}
	if(customColNameAndVaues.lastIndexOf("#~#") > -1 )
	{
		customColNameAndVaues = customColNameAndVaues.substring(0,customColNameAndVaues.lastIndexOf("#~#"));
	}
	if(this.checkduplicateValue(customArray))
	{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: duplicateCustomDisplayMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
		});
		return ;
	}
	if(applyAll == true)
	{
		Ext.getCmp('multiSelectAsset').show();
		applyAll ="on";
		applyForAllServerType = Ext.getCmp('multiSelectAsset').getValue();
		if(applyForAllServerType==null || applyForAllServerType=='')
		{
			/*applyForAllServerType = Ext.getCmp('multiSelectAsset').getValue();
			}
			else if(Ext.getCmp('multiSelectAsset').getValue() == 0)
			{*/
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: 'Please choose atleast one server of the same name',
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
			return;
		}
	}
	else{
		applyAll ="null";
	}
	var businessImpact = Ext.getCmp('businessImpact').getValue();
	var assetState = Ext.getCmp('assetState').getValue();
	var componenttype = Ext.getCmp('componenttype').getValue();
	if(componenttype==null || componenttype=="" || componenttype=="-1"){
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: compoTypeLbl,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation'
		});
		return;
	}
	var componentname = Ext.getCmp('componentname').getValue();
	if(componentname==null || componentname=="" || componentname=="-1" ){
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: compoNameLbl,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation'
		});
		return;
	}
	var emailReg =/^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
	var emailResult;
	if(email!='')
	{
		emailResult = emailReg.test(email);
	}

	if(isDoubleByteMgr == "false")
	{
		var fieldName = this.checkDoubleByte(assetName,assetDescription,assetType,assetLocation,os,manufacturer,owner,supportGroup,businessService);
		if( fieldName != "" )
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: fieldName + " " + doubleByteEntry,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation',
			fn : function(btn){
					Ext.getCmp(fieldName).focus(true);
				}
			});
			return;
		}
	}

	var memorypattern = /^[0-9]+(\.[0-9]+)?(KB|MB|GB|TB|PB|EB|ZB|YB| KB| MB| GB| TB| PB| EB| ZB| YB)$/;
	if(memory!=null && memory!='')
	{
		if(!memorypattern.test(memory))
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: invalidMemory,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}

	if(diskSpace!=null && diskSpace!='')
	{
		if(!memorypattern.test(diskSpace))
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: invalidDiskSpace,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}

	var cpuSpeedpattern = /^[0-9]+(\.[0-9]+)?(MHz|GHz| MHz| GHz)$/;
	if(cpuSpeed!=null && cpuSpeed!='')
	{
		if(!cpuSpeedpattern.test(cpuSpeed))
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: invalidCPUSpeed,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}
	var numbers = /^[-+]?[0-9]+(\.[0-9]+)?$/;
	if(cost!=null && cost!='')
	{
		if(!numbers.test(cost))
		{
		  Ext.Msg.show({
			title: assetAlertTitle,
			msg: invalidCost,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
		if(cost.length > 11)
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: costLengthMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}
	var phnumbers = /^[0-9 ]+$/;
	if(phnumber!=null && phnumber!='')
	{
		if(!phnumbers.test(phnumber))
		{
		  Ext.Msg.show({
			title: assetAlertTitle,
			msg: numericalMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
		if(phnumber.length < 5)
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: phnumberLengthMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}
	if(cpuCoreCount!=null && cpuCoreCount!='')
	{
		if(!phnumbers.test(cpuCoreCount))
		{
		  Ext.Msg.show({
			title: assetAlertTitle,
			msg: cpuCoreCountnumericalMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		  return false;
		}
	}
	if (assetName.length == 0)
	{
		Ext.Msg.show({
			title: assetAlertTitle,
			msg: emptyAssetNameMsg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
	} else if( this.validateFieldvalue('assetName', assetName, 32, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('assetName').focus(true);
			}
		});
	} else if(this.validateFieldvalue('assetDescription', assetDescription, 1024, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('assetDescription').focus(true);
			}
		});
	} else if(this.validateFieldvalue('assetType', assetType, 32, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('assetType').focus(true);
			}
		});
	} else if(this.validateFieldvalue('assetLocation', 32, assetLocation, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('assetLocation').focus(true);
			}
		});
	} else if((this.validateIpOrHName(hostIP)) == false)
	{
	
	} else if(this.validateFieldvalue('macAddress', macAddress, 32, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('macAddress').focus(true);
			}
		});
	} else if(this.validateFieldvalue('os', os, 256, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn) {
				Ext.getCmp('os').focus(true);
			}
		});
	} /**else if(this.checksplcharforOS(os) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('os').focus(true);
			}
		});
	} **/else if(this.validateFieldvalue('manufacturer', manufacturer, 32, notAllowedSplCharacters)==false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('manufacturer').focus(true);
			}
		});
	} else if(this.validateFieldvalue('serialNumber', serialNumber, 32, notAllowedSplCharacters)==false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn) {
				Ext.getCmp('serialNumber').focus(true);
			}
		});
	} 
	else if(this.validateFieldvalue('licenseSerialNumber', licenseSerialNumber, 32, notAllowedSplCharacters)==false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn) {
				Ext.getCmp('licenseserialNumber').focus(true);
			}
		});
	} 
	else if(this.validateFieldvalue('user', owner, 128, notAllowedSplCharacters)==false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('user').focus(true);
			}
		});
	}	else if(this.validateFieldvalue('supportGroup', supportGroup, 128, notAllowedSplCharacters)==false) 
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('supportGroup').focus(true);
			}
		});
	} else if(emailResult == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: emailMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn) {
				//Ext.getCmp('email').focus(true);
			}
		});
	}
	else if(this.validateFieldvalue('phoneNumber', phnumber, 32, notAllowedSplCharacters )==false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn)
			{
				Ext.getCmp('phnumber').focus(true);
			}
		});
	} else if(this.validateFieldvalue('cost', cost, 32, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn)
			{
				Ext.getCmp('phnumber').focus(true);
			}
		});

	} else if(this.validateFieldvalue('businessService', businessService, 128, notAllowedSplCharacters) == false)
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: assetMsg,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation',
		fn : function(btn){
				Ext.getCmp('businessService').focus(true);
			}
		});
	}	else
	{
		var myMask = new Ext.LoadMask(Ext.getCmp("assetmgmtViewPort"), {
			msg:"Loading ...",
		});
		myMask.show();
		componenttype = filterEncode(componenttype);
		componentname = filterEncode(componentname);
		assetName = filterEncode(assetName);
		assetType = filterEncode(assetType);
		assetLocation = filterEncode(assetLocation);
		macAddress = filterEncode(macAddress);
		manufacturer = filterEncode(manufacturer);
		supportGroup = filterEncode(supportGroup);
		businessImpact = filterEncode(businessImpact);
		assetDescription = filterEncode(assetDescription);
		hostIP = filterEncode(hostIP);
		assetState = filterEncode(assetState);
		os = filterEncode(os);
		owner = filterEncode(owner);
		businessService = filterEncode(businessService);
		phnumber = filterEncode(phnumber);
		email = filterEncode(email);
		licenseExpirydate = filterEncode(licenseExpirydate);
		asmExpirydateVal = filterEncode(asmExpirydateVal);
		serialNumber = filterEncode(serialNumber);
		licenseSerialNumber = filterEncode(licenseSerialNumber);
		osVersion = filterEncode(osVersion);
		memory = filterEncode(memory);
		diskSpace = filterEncode(diskSpace);
		cpuSpeed = filterEncode(cpuSpeed);
		cpuCoreCount = filterEncode(cpuCoreCount);
		uuid = filterEncode(uuid);
		osServicePack = filterEncode(osServicePack);
		product = filterEncode(product);
		vendor = filterEncode(vendor);
		cost = filterEncode(cost);
		licenseKey = filterEncode(licenseKey);
		installationDate = filterEncode(installationDate);
		licenseType = filterEncode(licenseType);
		version = filterEncode(version);
		domain = filterEncode(domain);
		installedMachine = filterEncode(installedMachine);
		installationPath = filterEncode(installationPath);
		warranty = filterEncode(warranty);
		acquisitionDate = filterEncode(acquisitionDate);
		bandwidth = filterEncode(bandwidth);
		networkRange = filterEncode(networkRange);
		batteryStatus = filterEncode(batteryStatus);
		batteryVoltage = filterEncode(batteryVoltage);
		batteryCurrent = filterEncode(batteryCurrent);
		firmware = filterEncode(firmware);
		firmwareVersion = filterEncode(firmwareVersion);
		subnetMask = filterEncode(subnetMask);
		lastAuditDate = filterEncode(lastAuditDate);
		account = filterEncode(account);
		region = filterEncode(region);
		availabilityZone = filterEncode(availabilityZone);
		applyAll = filterEncode(applyAll);
		customColNameAndVaues = filterEncode(customColNameAndVaues);
		params="serverType="+encodeURIComponent(componenttype)+"&serverName="+encodeURIComponent(componentname+"") +
		"&AssetName="+encodeURIComponent(assetName)+"&AssetType="+encodeURIComponent(assetType)+"&AssetLocation="+encodeURIComponent(assetLocation)+"&MacAddr="+encodeURIComponent(macAddress)+"&Manufacturer="+encodeURIComponent(manufacturer)
		+"&SupprtGroups="+encodeURIComponent(supportGroup)+"&BusinessImpact="+encodeURIComponent(businessImpact)+"&AssetDescription="+encodeURIComponent(assetDescription)+"&IpAddr="+encodeURIComponent(hostIP)
		+"&AssetState="+encodeURIComponent(assetState)+"&OperatingSys="+encodeURIComponent(os)+"&OwnerForAsset="+encodeURIComponent(owner)+"&BusinessServc="+encodeURIComponent(businessService)
		+"&AssetPhNo="+encodeURIComponent(phnumber)+"&AssetEmailAddr="+encodeURIComponent(email)+"&LiceDate="+encodeURIComponent(licenseExpirydate)+"&ASMDate="+encodeURIComponent(asmExpirydateVal)
		+"&AssetSerialNum="+encodeURIComponent(serialNumber)+"&AssetLicenseSerialNum="+encodeURIComponent(licenseSerialNumber)
		+"&osVersion="+encodeURIComponent(osVersion)+"&memory="+encodeURIComponent(memory)+"&diskSpace="+encodeURIComponent(diskSpace)
		+"&cpuSpeed="+encodeURIComponent(cpuSpeed)+"&cpuCoreCount="+encodeURIComponent(cpuCoreCount)+"&uuid="+encodeURIComponent(uuid)
		+"&osServicePack="+encodeURIComponent(osServicePack)+"&product="+encodeURIComponent(product)+"&vendor="+encodeURIComponent(vendor)
		+"&cost="+encodeURIComponent(cost)+"&licenseKey="+encodeURIComponent(licenseKey)
		+"&installationDate="+encodeURIComponent(installationDate)+"&licenseType="+encodeURIComponent(licenseType)+"&version="+encodeURIComponent(version)
		+"&domain="+encodeURIComponent(domain)+"&installedMachine="+encodeURIComponent(installedMachine)+"&installationPath="+encodeURIComponent(installationPath)
		+"&warranty="+encodeURIComponent(warranty)+"&acquisitionDate="+encodeURIComponent(acquisitionDate)+"&bandwidth="+encodeURIComponent(bandwidth)
		+"&networkRange="+encodeURIComponent(networkRange)+"&batteryStatus="+encodeURIComponent(batteryStatus)+"&batteryVoltage="+encodeURIComponent(batteryVoltage)
		+"&batteryCurrent="+encodeURIComponent(batteryCurrent)+"&firmware="+encodeURIComponent(firmware)+"&firmwareVersion="+encodeURIComponent(firmwareVersion)
		+"&subnetMask="+encodeURIComponent(subnetMask)+"&lastAuditDate="+encodeURIComponent(lastAuditDate)+"&account="+encodeURIComponent(account)
		+"&region="+encodeURIComponent(region)+"&availabilityZone="+encodeURIComponent(availabilityZone)
		+"&applyAll="+encodeURIComponent(applyAll)+"&customColVaues="+encodeURIComponent(customColNameAndVaues)+"&applyForAllServerType="+applyForAllServerType+"&assetAction=update&com.eg.CSRF_NONCE="+csrfToken;
		Ext.Ajax.request({
					url: "/final/admin/AssetManagement/data/EgAssetConfigp.jsp",
					method: "POST",
					params: params ,
					success: function (response) {
						myMask.hide();
						Ext.Msg.show({
							title: assetAlertTitle,
							msg: assetConfigSavedAlert,
							buttons: Ext.MessageBox.OK,
							fn : function(btn)
							{
							}
						});
					}
			})
		
	}
},
validateSingleByte : function(input) //For checking single byte emails.
{
	for(var i=0; i<input.length; i++)
	{
		var charValue = input.charCodeAt(i);
		if(charValue > 255)
		return false;
	}
	return true;
},
checkDoubleByte : function(assetName,assetDescription,assetType,assetLocation,os,manufacturer,owner,supportGroup,businessService)
{
	var fieldName = "";
	if(!this.validateSingleByte(assetName))
	{
		fieldName = 'assetName';
	}
	else if(!this.validateSingleByte(assetDescription))
	{
		fieldName = 'assetDescription';
	}
	else if(!this.validateSingleByte(assetType))
	{
		fieldName='assetType';
	}
	else if(!this.validateSingleByte(assetLocation))
	{
		fieldName = 'assetLocation';
	}
	else if(!this.validateSingleByte(os))
	{
		fieldName = 'os';
	}
	else if(!this.validateSingleByte(manufacturer))
	{
		fieldName = 'manufacturer';
	}
	else if(!this.validateSingleByte(owner))
	{
		fieldName = 'owner';
	}
	else if(!this.validateSingleByte(supportGroup))
	{
		fieldName = 'supportGroup';
	}
	else if(!this.validateSingleByte(businessService))
	{
		fieldName = 'businessService';
	}
	return fieldName;
},
isValidColumnName: function (fieldName) //For avoiding special character, white space and first chracter as digit in column name.
{
	var splChar = "`~!@#$%^&*()+-={}|[]\:;\"'<>?,./";
	var digit = "0987654321";
	var check_char;
	var check_dig;
	for (var i = 0; i < fieldName.length; i++) {
		check_char = splChar.indexOf(fieldName.charAt(i));
		check_dig = digit.indexOf(fieldName.charAt(0));
		//Returns value 1 if the special character listed in splChar is found
		if (check_char >= 0) {
			assetMsg = validNameMsg;
			return false;
		}
		if (check_dig >= 0) {
			assetMsg = validNameMsg;
			return false;
		}
	}
	
	if (isOracleDB=="true") {
		if(fieldName.length > 30){
				assetMsg = maxlength30Msg;
				return false;
		}
	}
	else{
		if(fieldName.length > 128){
				assetMsg = maxlength128Msg;
				return false;
		}
	}
	return true;
},
isValidFieldValue: function (val) //For avoiding special character, white space and first chracter as digit in column name.
{
	var splChar = "`~!@#$%^&*()+-={}|[]\:;\"'<>?,/";
	var digit ="0987654321_.";
	var check_char;
	var check_dig;
	for (var i = 0; i < val.length; i++) {
		check_char = splChar.indexOf(val.charAt(i));
		check_dig = digit.indexOf(val.charAt(0));
		//Returns value 1 if the special character listed in splChar is found
		if (check_char >= 0) {
			assetMsg=specialCharMsg;

			return false;
		}
		if (check_dig >= 0) {
			assetMsg = 'First character should be alphabet';
			return false;
		}
	}
	return true;
},
checksplchar: function (val, splChar) //For avoiding special character, white space and first chracter as digit in column name.
{
	var digit = ".";
	var check_char;
	var check_dig;
	for (var i = 0; i < val.length; i++) {
		check_char = splChar.indexOf(val.charAt(i));
		check_dig = digit.indexOf(val.charAt(0));
		//Returns value 1 if the special character listed in splChar is found
		if (check_char >= 0) {
			assetMsg=specialCharMsg;
			return false;
		}
		if (check_dig >= 0) {
			assetMsg = "First character should not start with '.' ";
			return false;
		}
	}
	return true;
},
checksplcharforMac: function (val) //For Checking generic MAC address
{
	var regex = /^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/;
	if(val.length > 0){
		if (regex.test(val) == false) {
			assetMsg = "Invalid MAC Address";
			return false;
		}
	}
	return true;
},
checksplcharforPhone: function (val) //For Checking generic phone number
{

	var regex1  = /^[+0-9() -]{5,32}$/;
	if(val.length > 0){
		if (regex1.test(val) == false) {
			assetMsg = "Invalid Phone Number";

			return false;
		}
	}
	return true;
},

checksplcharforOS: function (val) //For Checking generic Host IP or Name
{

	var regex1  = /^[0-9a-zA-Z -.]*$/;
	if(val.length > 0){
		if (regex1.test(val) == false) {
			assetMsg = invalidOSMsg;

			return false;
		}
	}
	return true;
},
checksplcharforSerialNumber: function (val) //For Checking generic Host IP or Name
{

	var regex1  = /^[0-9a-zA-Z-]*$/;
	if(val.length > 0){
		if (regex1.test(val) == false) {
			assetMsg = invalidSerialNoMsg;

			return false;
		}
	}
	return true;
},
checksplcharforLicenseSerialNumber: function (val) //For Checking generic Host IP or Name
{

	var regex1  = /^[0-9a-zA-Z-]*$/;
	if(val.length > 0){
		if (regex1.test(val) == false) {
			assetMsg = invalidLicenseSerialNoMsg;

			return false;
		}
	}
	return true;
},
checkduplicateValue : function (field) // For checking duplicates in custom attribute display.
{
	var str='';
	str = field;
	var n = str.split("~@~");
	var j;
	var k;
	for(j=0; j<n.length; j++)
	{
		for(k = j + 1; k < n.length; k++)
		{
			if(n[j].toLowerCase() == n[k].toLowerCase())
			{
				return true;
			}
		}
	}
	return false;
},
validateIpOrHName : function (fieldvalue) // For Checking for IP address or host name is valid or not.
{
	var s_val = fieldvalue;
	var dot_count = 0;
	var ishostName= false;
	var isIpv6 = false;
	var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	if(s_val.indexOf(":")>-1)
		isIpv6=true;
	if(isIpv6)
	{
		result = checkIPv6(s_val);
		return result;
	}
	else
	{
		for(var m=0; m<s_val.length; m++)
		{
			check_char = alpha.indexOf(s_val.charAt(m))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				ishostName=true;
			}
		}
		if(!ishostName)
		{
			for(var k=0;k < s_val.length;k++)
			{
				if(s_val.charAt(k) == '.' && s_val.charAt(k + 1) == '.')
				{
					Ext.Msg.show({
					title: assetAlertTitle,
					msg: dotMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation',
					fn : function(btn){
						Ext.getCmp('hostIP').focus(true);
						}
					});
				return false;
				}
				else
				{
					continue;
				}
			}
			for(var i=0; i < s_val.length;i++)
			{
				if(s_val.charAt(i) == '.')
				{
					dot_count = dot_count + 1;
				}
				else
				{
					continue;
				}
			}
			if(s_val.length>0&&dot_count != 3)
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: invalidIPMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn){
					Ext.getCmp('hostIP').focus(true);
					}
				});
			return false;
			}
			if(s_val.charAt(0) == '.' || s_val.charAt(s_val.length - 1) == '.')
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: IPDotMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn){
					Ext.getCmp('hostIP').focus(true);
					}
				});
			return false;
			}
		}
		for(var j = 0; j < s_val.length; j++)
		{
			if(s_val.charAt(j) == ' ')
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg: spaceMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn){
					Ext.getCmp('hostIP').focus(true);
					}
				});
				return false;
			}
		}
		var splChar = "`~!@#$%^&*()_+={}[]|\\:;\"\'<>,?\/";
		for(var k=0; k<s_val.length; k++)
		{
			check_char = splChar.indexOf(s_val.charAt(k))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 1)
			{
				Ext.Msg.show({
				title: assetAlertTitle,
				msg:specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation',
				fn : function(btn){
					Ext.getCmp('hostIP').focus(true);
				}

				});
				return false;
			}
		}
		if(s_val.indexOf('.') > -1 && dot_count > 2)
		{
			var number_bet_dots = s_val.split('.');
			for(var l=0;l < number_bet_dots.length;l++)
			{
				if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
				{
					Ext.Msg.show({
					title: assetAlertTitle,
					msg: dotBetweenMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation',
					fn : function(btn){
					Ext.getCmp('hostIP').focus(true);
				}
					});
					return false;
				}
			}
		}
		return true;
	}
},
validateFieldvalueLength:function(fieldvalue, maxlength){ //checking validation for length
	var s_val = fieldvalue;
	var isvalid = true;
	if (s_val.length > maxlength){
		assetMsg = maxlength32Msg;
		isvalid = false;
		return isvalid;
	}
return isvalid;
},
validateFieldvalue : function (id, val, maxLength, splChar) // checking validation for length and spacial characters
{
	var s_val = val;
	var isvalid = true;
	if (s_val.length > maxLength){  //length checking ...

	if(maxLength == 32){
		assetMsg = maxlength32Msg;
	
	}else if(maxLength == 256){
	assetMsg = maxlength256Msg;

	}else if(maxLength == 1024){
	assetMsg = maxlength1024Msg;
	}
	return false;
	}
	else if(this.checksplchar(s_val, splChar) == false){ //spl char checking ....
	
	return false;
	}
	return isvalid;
},
validateMacAddress: function(val, maxLength) {
	var m_val = val;
	
	if ( m_val.length > maxLength ){
		if(maxLength == 32){
			assetMsg = maxlength32Msg;
	
		}else if(maxLength == 256){
			assetMsg = maxlength256Msg;
		}else if(maxLength == 1024){
			assetMsg = maxlength1024Msg;
		}
			
		return false;
	}
	else if(this.checksplcharforMac(m_val) == false){ //for checking generic MAC address

		return false;
	}
	return true;
},
validatePhoneNo: function(val, maxLength)
	{
	var p_val = val;
	if (p_val.length > maxLength){
		if(maxLength == 32){
			assetMsg = maxlength32Msg;
		}else if(maxLength == 256){
			assetMsg = maxlength256Msg;
		}else if(maxLength == 1024){
			assetMsg = maxlength1024Msg;
		}
	return false;
	} else if(this.checksplcharforPhone(p_val)==false){ //for checking generic Phone Number

		return false;
	}
	return true;
},
assetFileUploadFun: function()
{
	Ext.getCmp('fileUpload').setHeight(150);
	Ext.getCmp('fileUpload').setAutoScroll(false);

	var uploadAssetObj = Ext.getCmp('FILE_0').getValue();
	if ( uploadAssetObj != null && uploadAssetObj != '' && uploadAssetObj != undefined && uploadAssetObj != 'undefined' )
	{
		var getFileName = uploadAssetObj;
		getFileName = getFileName.substring( getFileName.lastIndexOf('.') + 1 );
		if ( getFileName == 'csv' || getFileName == 'xls' || getFileName == 'xlsx')
		{
			url = "/final/admin/AssetManagement/data/EgAssetConfigUploadJSON.jsp";
			var assetForm = this.getFileuploadform().getForm();
			//var assetForm = Ext.getCmp('fileUploadForm').getForm();
			if (assetForm.isValid())
			{
				assetForm.submit(
				{
					url : "/final/admin/AssetManagement/data/EgAssetConfigUploadJSON.jsp?com.eg.CSRF_NONCE="+csrfToken,
					scope:this,
					//async : true,
					waitMsg : 'Upload in progress please wait',
					method : 'POST',
				//	enctype : 'multipart/form-data',
					success: function (form, action)
					{
						var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
						var alertTextMsg = jsonText['Msg'];
						var alertTextSuccessMsg = jsonText['Success_Msg'];
						var ErrMsgsJson = jsonText['ErrMsgsJson'];
						if (!Ext.isEmpty(jsonText))
						{
							if(!Ext.isEmpty(ErrMsgsJson))
							{
								Ext.Msg.show({
								title: fileUploadAlertTitle,
								msg: importErrorLbl,
								icon: 'iconInformation',
								buttons: Ext.Msg.OK
							});
							this.showErrors(ErrMsgsJson);
							return;
							}
							else if(!Ext.isEmpty(alertTextSuccessMsg))
							{
								Ext.Msg.show({
								title: fileUploadindTitle,
								msg: alertTextSuccessMsg,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
								});
								Ext.getCmp('fileUpload').destroy();
							}
							else if (!Ext.isEmpty(alertTextMsg))
							{
								Ext.Msg.show({
								title: fileUploadAlertTitle,
								msg: alertTextMsg,
								icon: 'iconInformation',
								buttons: Ext.Msg.OK

								});
							return;
						}}
					},
					failure:function (form, action)
					{
						alert('Failure Notice');
					}
				});
			}
		}
		else
		{
			Ext.Msg.show({
			title: assetAlertTitle,
			msg: selectValidxlsFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	}
	else
	{
		Ext.Msg.show({
		title: assetAlertTitle,
		msg: selectAssetInfoFile,
		buttons: Ext.MessageBox.OK,
		icon: 'iconInformation'
		});
	}
},
showErrors:function(ErrMsgsJson){

	Ext.getCmp('fileUpload').setHeight(300);
	Ext.getCmp('fileUpload').setAutoScroll(true);

	Ext.create('Ext.data.Store', {
				storeId: 'storeId',
				fields: ['CmpName', 'FieldName', 'FieldErrMsg'],
				data: ErrMsgsJson,
				proxy: {
						type: 'memory',
						reader:{
							type: 'json',
							root: 'items'
						}
				}
			});

	var errMsgsGrid = Ext.create('utilities.CustomGrid',
					{
						title: 'Errors',
						alias: 'widget.ErrWindow2',
						cls: 'gridSkin',
						scroll:true,
						autoScroll: true,
						overflowY:'auto',
						overflowX:'auto',

						store: Ext.data.StoreManager.lookup('storeId'),
						columns: [
									{
									text: 'Component Name',
									dataIndex: 'CmpName',
									flex: 1
									},
									{
									text: 'Field Name',
									dataIndex: 'FieldName',
									flex: 1
									},
									{
									text: 'Error',
									dataIndex: 'FieldErrMsg',
									flex: 1
									},
						],
						width: 650,
					});
	var listOfErrorsObj = Ext.getCmp('listOfErrors');
	listOfErrorsObj.removeAll();
	listOfErrorsObj.add(errMsgsGrid);
	listOfErrorsObj.doLayout();
},
noExpiryChange:function()
{
	var licenseExpirydate = Ext.getCmp('licenseExpirydate');
	var hiddenLicenseExpdate = Ext.getCmp('hiddenLicenseExpdate');

	var validity = Ext.getCmp('never').getValue();
	if(validity == true)
	{	
		licenseExpirydate.setValue("");
		licenseExpirydate.setDisabled(true);
		licenseExpirydate.labelEl.setOpacity(1);

		hiddenLicenseExpdate.setValue(noExpiryDateDfltVal);
	}
	else
	{	
		licenseExpirydate.setDisabled(false);
		hiddenLicenseExpdate.setValue("");
	}
},
assetFileImportFun: function()
{
	Ext.widget('fileupload').show();
},
goBackFromAssetConfig: function()
{
	window.location.href ="/final/admin/EgAssetInfo.jsp";
}
});
function getComponent(fieldName,fieldType,fieldLabel){
	var component;
	if(fieldType=="Textfield"){
		var maxLen=32;
		
		if(fieldName!=null && (fieldName=='user' || fieldName=='supportGroup' || fieldName=='businessService'))
		{
			maxLen=128;
		}
		else if(fieldName!=null && fieldName=='emailAddress')
		{
			maxLen=64;
		}
		else if(fieldName!=null && (fieldName=='installationPath'))
		{
			maxLen=512;
		}
		
		component ={
			xtype:'textfield',
			fieldLabel :fieldLabel,
			id:fieldName,
			name:fieldName,
			cls:'textbox',
			maxLength:maxLen,
			enforceMaxLength:true
		}
	}
	else if(fieldType == "Combo"){
		component ={
			xtype : 'combo',
				fieldLabel : fieldLabel,
				editable : false,
				name : fieldName,
				id:fieldName,
				cls : 'dropdown',
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				store : new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				listeners : {
				}
		}
	}
	else if(fieldType == "Datefield"){
		component ={
				xtype:'datefield',
				labelSeparator:'',
				labelAlign:'top',
				labelWidth:200,
				fieldLabel:fieldLabel,
				name:fieldName,
				id:fieldName,
				disabled:false,
				format:userDateFormat,
				cls:'datepicker',
				dataArray:'null',
				editable:false,
				value:''
		}
	}
	else if(fieldType == "Textarea"){
		component ={
				xtype:'textareafield',
				fieldLabel :fieldLabel,
				id:fieldName,
				cls:'text-area',
				name:fieldName,
				maxLength:1024,
				enforceMaxLength:true
		}
	}
	return component;
}
function loadAssetDetailsUI(){
	loadUIComp("General","assetDetail");
	var CompTyNameValues = publicAssetJson['ACESS_STATE'];
	Ext.getCmp('assetState').getStore().loadRawData(CompTyNameValues);
	var sel_stat =selectedValues['Selected_state'];
	if(sel_stat != null && sel_stat != "")
		Ext.getCmp('assetState').setValue(sel_stat);
	else
		Ext.getCmp('assetState').setValue(publicAssetJson['ACESS_STATE'][0]['valueField']);

	if(selectedValues['Asset_Name']!=null)
	{
		var tmpObj = Ext.getCmp('assetName');
		if(tmpObj != null && tmpObj!="undefined")
			tmpObj.setValue(selectedValues['Asset_Name']);
	}
	if(selectedValues['Asset_description']!=null)
	{
		var tmpObj = Ext.getCmp('assetDescription');
		if(tmpObj != null && tmpObj!="undefined")
			tmpObj.setValue(selectedValues['Asset_description']);
	}
	Ext.getCmp('assetType').show();
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		Ext.getCmp('assetState').setValue(publicAssetJson['ACESS_STATE'][0]['valueField']);
		Ext.getCmp('assetName').reset();
		Ext.getCmp('assetDescription').reset();
	}
}
function loadTechnicalUI(filedName){
	if(filedName == "Hardware"){
		loadUIComp("Hardware","techDetails");
	}
	else if(filedName == "Network"){
		loadUIComp("Network","techDetails");
	}
	else {
		loadUIComp("Technical","techDetails");
	}
	if(selectedValues['Asset_ipAddess']!=null)
	{
		var tmpObj = Ext.getCmp('hostIP');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_ipAddess']);
	}
	if(selectedValues['Asset_macAddr']!=null)
	{
		var tmpObj = Ext.getCmp('mac_address');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_macAddr']);
	}
	if(selectedValues['Asset_OS']!=null)
	{
		var tmpObj = Ext.getCmp('os');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_OS']);
	}
	if(selectedValues['os_version']!=null)
	{
		var tmpObj = Ext.getCmp('os_version');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['os_version']);
	}
	if(selectedValues['os_servicePack']!=null)
	{
		var tmpObj = Ext.getCmp('os_servicePack');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['os_servicePack']);
	}
	if(selectedValues['memory']!=null)
	{
		var tmpObj = Ext.getCmp('memory');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['memory']);
	}
	if(selectedValues['disk_space']!=null)
	{
		var tmpObj = Ext.getCmp('diskSpace');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['disk_space']);
	}
	if(selectedValues['cpu_speed']!=null)
	{
		var tmpObj = Ext.getCmp('cpu_speed');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['cpu_speed']);
	}
	if(selectedValues['cpu_coreCount']!=null)
	{
		var tmpObj = Ext.getCmp('cpu_coreCount');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['cpu_coreCount']);
	}
	if(selectedValues['uuid']!=null)
	{
		var tmpObj = Ext.getCmp('uuid');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['uuid']);
	}
	if(selectedValues['Asset_manufacturer']!=null)
	{
		var tmpObj = Ext.getCmp('manufacturer');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_manufacturer']);
	}
	if(selectedValues['Asset_serialNum']!=null)
	{
		var tmpObj = Ext.getCmp('serialNumber');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_serialNum']);
	}
	if(selectedValues['Asset_ASMExpDate']!=null)
	{
		var tmpObj = Ext.getCmp('asmExpiryDate');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_ASMExpDate']);
	}
	if(selectedValues['warranty']!=null)
	{
		var tmpObj = Ext.getCmp('warranty');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['warranty']);
	}
	if(selectedValues['acquisition_date']!=null)
	{
		var tmpObj = Ext.getCmp('acquisitionDate');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['acquisition_date']);
	}
	if(selectedValues['cpu_speed']!=null)
	{
		var tmpObj = Ext.getCmp('cpu_speed');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['cpu_speed']);
	}
	if(selectedValues['firmware']!=null)
	{
		var tmpObj = Ext.getCmp('firmware');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['firmware']);
	}
	if(selectedValues['firmware_version']!=null)
	{
		var tmpObj = Ext.getCmp('firmwareVersion');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['firmware_version']);
	}
	if(selectedValues['subnet_mask']!=null)
	{
		var tmpObj = Ext.getCmp('subnetMask');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['subnet_mask']);
	}
	if(selectedValues['bandwidth']!=null)
	{
		var tmpObj = Ext.getCmp('bandwidth');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['bandwidth']);
	}
	if(selectedValues['network_range']!=null)
	{
		var tmpObj = Ext.getCmp('networkRange');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['network_range']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		if(filedName == "Hardware"){
		//loadUIComp("Hardware","techDetails");
		var techInfo = assetFields['Hardware'];
			for(var i=0;i<techInfo.length;i++){
				var item = techInfo[i];
				var fieldName = item['fieldName'];
				Ext.getCmp(fieldName).reset();
			}
		}
		else if(filedName == "Network"){
			//loadUIComp("Network","techDetails");
			var techInfo = assetFields['Network'];
			for(var i=0;i<techInfo.length;i++){
				var item = techInfo[i];
				var fieldName = item['fieldName'];
				Ext.getCmp(fieldName).reset();
			}
		}
		else {
			var techInfo = assetFields['Technical'];
			for(var i=0;i<techInfo.length;i++){
				var item = techInfo[i];
				var fieldName = item['fieldName'];
				Ext.getCmp(fieldName).reset();
			}
			
		}
	}
	
	Ext.getCmp('assetTabpanel').getComponent('techDetails').tab.show();
	Ext.getCmp('techDetails').show();
	Ext.getCmp('assetTabpanel').setActiveTab(0);
}
function loadSoftwareUI(){
	loadUIComp("Software","software");
	Ext.getCmp('software').add({
		xtype:'container',
		layout: {
			type: 'hbox',
			align:'left'
		},
		//width:420,
		width:230,
		items:[
		{
			xtype:'datefield',

			labelSeparator:'',
			labelAlign:'top',
			//margin:'0 5 10 0',
			width: 140,
			labelWidth:200,
			fieldLabel:licenseExpirydateLbl,
			name:'licenseExpirydate',
			id:'licenseExpirydate',
			disabled:false,
			format:userDateFormat,
			cls:'datepicker',
			dataArray:'null',
			editable:false,
			value:''

		},
		{
			xtype : 'hiddenfield',
			name : 'hiddenLicenseExpdate',
			id : 'hiddenLicenseExpdate'
		},
		{
			xtype: 'checkbox',
			boxLabel: noExpiryLbl,
			checked: false,
			margin:'21 0 0 10',
			cls: 'checkbt',
			name : 'never',
			id : 'never',
			listeners:{
							change: function(newValue, oldValue, eOpts ){
								var licenseExpirydate = Ext.getCmp('licenseExpirydate');
								var hiddenLicenseExpdate = Ext.getCmp('hiddenLicenseExpdate');

								var validity = Ext.getCmp('never').getValue();
								if(validity == true)
								{	
									licenseExpirydate.setValue("");
									licenseExpirydate.setDisabled(true);
									hiddenLicenseExpdate.setValue(noExpiryDateDfltVal);
								}
								else
								{	
									licenseExpirydate.setDisabled(false);
									hiddenLicenseExpdate.setValue("");
								}
							}
			}
		}
		]
	});
	var Licens_No_expry = selectedValues['Licens_No_expry'];
	if(Licens_No_expry == noExpiryDateDfltVal)//checking  Never expiry date 
	{
		Ext.getCmp("never").setValue(true);
	} else
	{
		if(selectedValues['Asset_licnsExpDate']!=null)
		{
			var tmpObj = Ext.getCmp('licenseExpirydate');
			if(tmpObj != null && tmpObj != "undefined")
				tmpObj.setValue(selectedValues['Asset_licnsExpDate']);
		}
	}
	if(selectedValues['product']!=null)
	{
		var tmpObj = Ext.getCmp('product');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['product']);
	}
	if(selectedValues['vendor']!=null)
	{
		var tmpObj = Ext.getCmp('vendor');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['vendor']);
	}
	if(selectedValues['version']!=null)
	{
		var tmpObj = Ext.getCmp('version');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['version']);
	}
	if(selectedValues['domain']!=null)
	{
		var tmpObj = Ext.getCmp('domain');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['domain']);
	}
	if(selectedValues['cost']!=null)
	{
		var tmpObj = Ext.getCmp('cost');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['cost']);
	}
	if(selectedValues['installation_date']!=null)
	{
		var tmpObj = Ext.getCmp('installationDate');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['installation_date']);
	}
	if(selectedValues['license_key']!=null)
	{
		var tmpObj = Ext.getCmp('licenseKey');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['license_key']);
	}
	if(selectedValues['license_type']!=null)
	{
		var tmpObj = Ext.getCmp('licenseType');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['license_type']);
	}
	if(selectedValues['Asset_licnsSerialNum']!=null)
	{
		var tmpObj = Ext.getCmp('licenseSerialNumber');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_licnsSerialNum']);
	}
	if(selectedValues['installed_machine']!=null)
	{
		var tmpObj = Ext.getCmp('installedMachine');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['installed_machine']);
	}
	if(selectedValues['installation_path']!=null)
	{
		var tmpObj = Ext.getCmp('installationPath');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['installation_path']);
	}
	if(selectedValues['warranty']!=null)
	{
		var tmpObj = Ext.getCmp('warranty');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['warranty']);
	}
	if(selectedValues['acquisition_date']!=null)
	{
		var tmpObj = Ext.getCmp('acquisitionDate');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['acquisition_date']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		var techInfo = assetFields['Software'];
		for(var i=0;i<techInfo.length;i++){
			var item = techInfo[i];
			var fieldName = item['fieldName'];
			Ext.getCmp(fieldName).reset();
		}
		Ext.getCmp('licenseExpirydate').reset();
	}
	//Ext.getCmp('software').show();
	Ext.getCmp('assetTabpanel').getComponent('software').tab.show();
	if(confEnabled && (displayMessage != "")){
		Ext.getCmp('softwareList').add({
		xtype:'label',
		html : displayMessage
		});
		Ext.getCmp('assetTabpanel').getComponent('softwareList').tab.show();
	}
}

function loadUIComp(fieldName,compName){
	Ext.getCmp(compName).removeAll();
	var techInfo = assetFields[fieldName];
	for(var i=0;i<techInfo.length;i++){
		var item = techInfo[i];
		var fieldName = item['fieldName'];
		var fieldType = item['fieldType'];
		var fieldLabel = item['fieldLabel'];
		Ext.getCmp(compName).add(getComponent(fieldName,fieldType,fieldLabel));
	}
}

function loadUPSUI(){
	loadUIComp("UPS","ups");
	if(selectedValues['Asset_ipAddess']!=null)
	{
		var tmpObj = Ext.getCmp('hostIP');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_ipAddess']);
	}
	if(selectedValues['battery_status']!=null)
	{
		var tmpObj = Ext.getCmp('batteryStatus');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['battery_status']);
	}
	if(selectedValues['battery_voltage']!=null)
	{
		var tmpObj = Ext.getCmp('batteryVoltage');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['battery_voltage']);
	}
	if(selectedValues['battery_current']!=null)
	{
		var tmpObj = Ext.getCmp('batteryCurrent');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['battery_current']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		var techInfo = assetFields['UPS'];
		for(var i=0;i<techInfo.length;i++){
			var item = techInfo[i];
			var fieldName = item['fieldName'];
			Ext.getCmp(fieldName).reset();
		}
	}
	//Ext.getCmp('ups').show();
	Ext.getCmp('assetTabpanel').getComponent('ups').tab.show();
}

function loadCloudUI(){
	loadUIComp("Cloud","cloud");
	if(selectedValues['cost']!=null)
	{
		var tmpObj = Ext.getCmp('cost');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['cost']);
	}
	if(selectedValues['last_auditDate']!=null)
	{
		var tmpObj = Ext.getCmp('lastAuditDate');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['last_auditDate']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		var techInfo = assetFields['Cloud'];
		for(var i=0;i<techInfo.length;i++){
			var item = techInfo[i];
			var fieldName = item['fieldName'];
			Ext.getCmp(fieldName).reset();
		}
	}
	//Ext.getCmp('cloud').show();
	Ext.getCmp('assetTabpanel').getComponent('cloud').tab.show();
}
function loadAWSUI(){
	loadUIComp("AWS","aws");
	if(selectedValues['account']!=null)
	{
		var tmpObj = Ext.getCmp('account');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['account']);
	}
	if(selectedValues['region']!=null)
	{
		var tmpObj = Ext.getCmp('region');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['region']);
	}
	if(selectedValues['availability_zone']!=null)
	{
		var tmpObj = Ext.getCmp('availabilityZone');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['availability_zone']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		var techInfo = assetFields['AWS'];
		for(var i=0;i<techInfo.length;i++){
			var item = techInfo[i];
			var fieldName = item['fieldName'];
			Ext.getCmp(fieldName).reset();
		}
	}
	//Ext.getCmp('aws').show();
	Ext.getCmp('assetTabpanel').getComponent('aws').tab.show();
}
function loadMiscUI(){
	loadUIComp("Misc","misc");
	//Ext.getCmp('misc').setTitle(screenLabels['misc']);
	var CompTyNameValues = publicAssetJson['BUSINESS_IMPACT'];
	Ext.getCmp('businessImpact').getStore().loadRawData(CompTyNameValues);
	var buss_imp=selectedValues['Selected_BusinessImpact'];
	if(buss_imp != null && buss_imp != "")
		Ext.getCmp('businessImpact').setValue(buss_imp);
	else
		Ext.getCmp('businessImpact').setValue(publicAssetJson['BUSINESS_IMPACT'][0]['valueField']);
	if(selectedValues['Asset_Owner']!=null)
	{
		var tmpObj = Ext.getCmp('user');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_Owner']);
	}
	if(selectedValues['Asset_suppotGroup']!=null)
	{
		var tmpObj = Ext.getCmp('supportGroup');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_suppotGroup']);
	}
	if(selectedValues['location']!=null)
	{
		var tmpObj = Ext.getCmp('location');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['location']);
	}
	if(selectedValues['Asset_emailAddr']!=null)
	{
		var tmpObj = Ext.getCmp('emailAddress');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_emailAddr']);
	}
	if(selectedValues['Asset_businessService']!=null)
	{
		var tmpObj = Ext.getCmp('businessService');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_businessService']);
	}
	if(selectedValues['Asset_phNo']!=null)
	{
		var tmpObj = Ext.getCmp('phoneNumber');
		if(tmpObj != null && tmpObj != "undefined")
			tmpObj.setValue(selectedValues['Asset_phNo']);
	}
	var com_type=Ext.getCmp('componenttype').getValue();
	if(com_type==-1)
	{
		var techInfo = assetFields['Misc'];
		for(var i=0;i<techInfo.length;i++){
			var item = techInfo[i];
			var fieldName = item['fieldName'];
			Ext.getCmp(fieldName).reset();
		}
		Ext.getCmp('businessImpact').setValue(publicAssetJson['BUSINESS_IMPACT'][0]['valueField']);
	}
	//Ext.getCmp('misc').show();
	Ext.getCmp('assetTabpanel').getComponent('misc').tab.show();
}

function removeCustomField(containerID){
	var customContainer = Ext.getCmp('customFieldCnt_'+containerID);
	customContainer.destroy();
	customFields--;
	if(customFields=='0')
	{
		Ext.getCmp('addCustomFieldBtn').show()
		Ext.getCmp('assetTabpanel').getComponent('customContainer').tab.hide();
		Ext.getCmp('assetTabpanel').setActiveTab(0);
	}
}
function checkForSameLabel(arry)
{
	for ( var i = 0; i < arry.length ; i++)
	{
		var firstName = arry[i].toLowerCase();
		for ( var j = i+1; j < arry.length ; j++)
		{
			var scndName = arry[j].toLowerCase();
			if ( firstName == scndName)
			{
				return true;
			}
		}
	}
	return false;
}
function checkIPv6(s_val)
{
	/** IPv6 Validation Starts
	 * 
	 */
	
	if(!checkspecialnomess(s_val,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
	{
		return false;
	}
	if(!checkspace(s_val))
	{
		return false;
	}
	var regD1= /[\.]{2,}/;
	var regD2= /(^(\.){1,})|((\.){1,}$)/gi;
	var regD3= /(\.\:){1,}|(\:\.){1,}/;
	if(s_val.match(regD1) != null || s_val.match(regD3) != null  )
	{
		return false;
	}
	
	if(s_val.match(regD2) != null)
	{
		return false;
	}
	var reg1= /[\:]{2,}/g;
	var reg1Res = s_val.match(reg1); 
	
	if( reg1Res != null &&  reg1Res != "::" )
	{
		return false;
	}
	
	var regCntRes = s_val.split(":");
	var regColonLen = regCntRes.length;
	regColonLen--;
	var strV4, strV6;
	strV6 = s_val;
	
	if( regCntRes.length <= 7 && s_val.indexOf(".") != -1 )
	{
		var regDRes = s_val.split(".");
		var regDLength = regDRes.length;
		regDLength--;
		
		strV4 = s_val.substring((s_val.lastIndexOf(":")+1));
		strV6 = s_val.substring(0,(s_val.lastIndexOf(":")));
		
		var regIp4 = /[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}((\/){1}[0-9]{1,3})*$/gi;
		regIp4Res = s_val.match(regIp4);
			
		if(regIp4Res  == null || regIp4Res != strV4 )
		{
			return false;
		}
		if(strV6.indexOf(".") != -1)
		{
			return false;
		}
		if((regDLength > 3) || (regDLength != 3))
		{
			return false;
		}
		var arr = strV4.split("/");
		strV4 = arr[0];
		var number_bet_dots = strV4.split('.');

		for(var l=0;l < number_bet_dots.length;l++)
		{
			if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
			{
				return false;
			}
		}
	}
	else if((regColonLen > 7)||(reg1Res != "::")&&(regColonLen<7))
	{
		return false;
	}
	
	var arr = strV6.split("/");
	strV6 = arr[0];
	
	var regPartRes2 = "";
	var regPart = /^(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1}((\:){1,2}[a-z0-9]{0,4}){1,})|(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1})$/gi;
	var regPartRes1 = strV6.match(regPart);
	regPart = /^[a-f0-9]{0,4}$/gi;
	
	if(strV6.indexOf(":") == -1)
	{
		regPartRes2 = strV6.match(regPart);
	}
	if( ( (regPartRes1 == null) || (regPartRes1 != strV6) ) && (regPartRes2 != strV6) )
	{
		return false;
	}

	var regC = /(::){0,1}([a-f0-9(::)(\.)]*[\:]{1})+[a-f(::)(\.)0-9]*((\/){0,1}[0-9]{1,3})*/ig; // Right 1
	var regCRes = s_val.match(regC);

	if( regCRes == null ||  regCRes != s_val )
	{
		return false;
	}
	return true;	
}
function checkspecialnomess(field,s_spl)
{
	if(typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}
function checkspace(field)
{
	var s_val;
	if(typeof(field)=='object')
	{
		s_val = field.value;
	}
	else
	{
		s_val = field;
	}
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			return false;
		}
	}
	return true;
}
function filterEncode(text)
{
		var filterEncodeChar = ['[',']','(',')','=','&','%','\'',';','\\','\'','"'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|ampsnd|','|per|','|squot|','|scol|','|slash|','|squot|','|dqt|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
}



